/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AdditionalVariant;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.ivy.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyConfigurationHelper;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;

public class RealisedIvyModuleResolveMetadata
extends AbstractRealisedModuleComponentResolveMetadata
implements IvyModuleResolveMetadata {
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private final ImmutableList<IvyDependencyDescriptor> dependencies;
    private final ImmutableList<Artifact> artifactDefinitions;
    private final ImmutableList<Exclude> excludes;
    private final ImmutableMap<NamespaceId, String> extraAttributes;
    private final DefaultIvyModuleResolveMetadata metadata;
    private final String branch;
    private Optional<ImmutableList<? extends ConfigurationMetadata>> derivedVariants;

    public static RealisedIvyModuleResolveMetadata transform(DefaultIvyModuleResolveMetadata metadata) {
        VariantMetadataRules variantMetadataRules = metadata.getVariantMetadataRules();
        ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> variants = LazyToRealisedModuleComponentResolveMetadataHelper.realiseVariants(metadata, variantMetadataRules, (ImmutableList<? extends ComponentVariant>)metadata.getVariants());
        Map<String, ConfigurationMetadata> configurations = RealisedIvyModuleResolveMetadata.realiseConfigurations(metadata, variantMetadataRules);
        if (variants.isEmpty()) {
            RealisedIvyModuleResolveMetadata.addVariantsFromRules(metadata, configurations, variantMetadataRules);
        }
        return new RealisedIvyModuleResolveMetadata(metadata, variants, configurations);
    }

    private static Map<String, ConfigurationMetadata> realiseConfigurations(DefaultIvyModuleResolveMetadata metadata, VariantMetadataRules variantMetadataRules) {
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)metadata.getConfigurationNames().size());
        for (String configurationName : metadata.getConfigurationNames()) {
            configurations.put(configurationName, RealisedIvyModuleResolveMetadata.applyRules(metadata, variantMetadataRules, configurationName));
        }
        return configurations;
    }

    private static void addVariantsFromRules(DefaultIvyModuleResolveMetadata componentMetadata, Map<String, ConfigurationMetadata> declaredConfigurations, VariantMetadataRules variantMetadataRules) {
        List<AdditionalVariant> additionalVariants = variantMetadataRules.getAdditionalVariants();
        if (additionalVariants.isEmpty()) {
            return;
        }
        for (AdditionalVariant additionalVariant : additionalVariants) {
            ImmutableList excludes;
            ImmutableList artifacts;
            Object dependencies;
            ImmutableCapabilities capabilities;
            ImmutableAttributes attributes;
            String name = additionalVariant.getName();
            String baseName = additionalVariant.getBase();
            ModuleConfigurationMetadata baseConf = (ModuleConfigurationMetadata)declaredConfigurations.get(baseName);
            if (baseConf == null) {
                attributes = componentMetadata.getAttributes();
                capabilities = ImmutableCapabilities.EMPTY;
                dependencies = ImmutableList.of();
                artifacts = ImmutableList.of();
                excludes = ImmutableList.of();
            } else {
                attributes = baseConf.getAttributes();
                capabilities = (ImmutableCapabilities)baseConf.getCapabilities();
                dependencies = (List)Cast.uncheckedCast(baseConf.getDependencies());
                artifacts = (ImmutableList)Cast.uncheckedCast(baseConf.getArtifacts());
                excludes = (ImmutableList)Cast.uncheckedCast(baseConf.getExcludes());
            }
            if (baseName == null || baseConf != null) {
                declaredConfigurations.put(name, RealisedIvyModuleResolveMetadata.applyRules(componentMetadata.getId(), name, variantMetadataRules, attributes, capabilities, (ImmutableList<? extends ModuleComponentArtifactMetadata>)artifacts, (ImmutableList<ExcludeMetadata>)excludes, true, true, (ImmutableSet<String>)ImmutableSet.of(), null, (List<ModuleDependencyMetadata>)dependencies, true));
                continue;
            }
            if (additionalVariant.isLenient()) continue;
            throw new InvalidUserDataException("Configuration '" + baseName + "' not defined in module " + componentMetadata.getId().getDisplayName());
        }
    }

    private static RealisedConfigurationMetadata applyRules(DefaultIvyModuleResolveMetadata metadata, VariantMetadataRules variantMetadataRules, String configurationName) {
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
        IvyConfigurationHelper configurationHelper = new IvyConfigurationHelper(metadata.getArtifactDefinitions(), new IdentityHashMap<Artifact, ModuleComponentArtifactMetadata>(), metadata.getExcludes(), metadata.getDependencies(), metadata.getId());
        ImmutableSet<String> hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
        ImmutableList<ExcludeMetadata> excludes = configurationHelper.filterExcludes(hierarchy);
        ImmutableList<ModuleComponentArtifactMetadata> artifacts = configurationHelper.filterArtifacts(configurationName, (Collection<String>)hierarchy);
        return RealisedIvyModuleResolveMetadata.applyRules(metadata.getId(), configurationName, variantMetadataRules, metadata.getAttributes(), ImmutableCapabilities.EMPTY, artifacts, excludes, configuration.isTransitive(), configuration.isVisible(), hierarchy, configurationHelper, null, false);
    }

    private static RealisedConfigurationMetadata applyRules(ModuleComponentIdentifier id, String configurationName, VariantMetadataRules variantMetadataRules, ImmutableAttributes attributes, ImmutableCapabilities capabilities, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, ImmutableList<ExcludeMetadata> excludes, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, IvyConfigurationHelper configurationHelper, @Nullable List<ModuleDependencyMetadata> dependenciesOverride, boolean addedByRule) {
        AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata variant = new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(configurationName);
        ImmutableAttributes variantAttributes = variantMetadataRules.applyVariantAttributeRules(variant, (AttributeContainerInternal)attributes);
        CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, capabilities);
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifactsMetadata = variantMetadataRules.applyVariantFilesMetadataRulesToArtifacts(variant, artifacts, id);
        return RealisedIvyModuleResolveMetadata.createConfiguration(id, configurationName, transitive, visible, hierarchy, artifactsMetadata, excludes, variantAttributes, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()), variantMetadataRules, configurationHelper, dependenciesOverride, addedByRule);
    }

    private RealisedIvyModuleResolveMetadata(RealisedIvyModuleResolveMetadata metadata, List<IvyDependencyDescriptor> dependencies, Map<String, ConfigurationMetadata> transformedConfigurations) {
        super((AbstractModuleComponentResolveMetadata)metadata, (ImmutableList<? extends ComponentVariant>)metadata.getVariants(), transformedConfigurations);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.branch = metadata.getBranch();
        this.artifactDefinitions = metadata.getArtifactDefinitions();
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.excludes = metadata.getExcludes();
        this.extraAttributes = metadata.getExtraAttributes();
        this.metadata = metadata.metadata;
    }

    private RealisedIvyModuleResolveMetadata(RealisedIvyModuleResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        super(metadata, sources, derivationStrategy);
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.branch = metadata.branch;
        this.artifactDefinitions = metadata.artifactDefinitions;
        this.dependencies = metadata.dependencies;
        this.excludes = metadata.excludes;
        this.extraAttributes = metadata.extraAttributes;
        this.metadata = metadata.metadata;
    }

    RealisedIvyModuleResolveMetadata(DefaultIvyModuleResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants, Map<String, ConfigurationMetadata> configurations) {
        super((AbstractModuleComponentResolveMetadata)metadata, variants, configurations);
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.branch = metadata.getBranch();
        this.artifactDefinitions = metadata.getArtifactDefinitions();
        this.dependencies = metadata.getDependencies();
        this.excludes = metadata.getExcludes();
        this.extraAttributes = metadata.getExtraAttributes();
        this.metadata = metadata;
    }

    private static RealisedConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes componentLevelAttributes, ImmutableCapabilities capabilities, VariantMetadataRules variantMetadataRules, IvyConfigurationHelper configurationHelper, List<ModuleDependencyMetadata> dependenciesFromRule, boolean addedByRule) {
        RealisedConfigurationMetadata configuration = new RealisedConfigurationMetadata(componentId, name, transitive, visible, hierarchy, artifacts, excludes, componentLevelAttributes, capabilities, false, addedByRule);
        List<ModuleDependencyMetadata> dependencyMetadata = configurationHelper != null ? configurationHelper.filterDependencies(configuration) : dependenciesFromRule;
        configuration.setDependencies((List<ModuleDependencyMetadata>)ImmutableList.copyOf(variantMetadataRules.applyDependencyMetadataRules(new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(name), dependencyMetadata)));
        return configuration;
    }

    @Override
    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        this.derivedVariants = this.derivedVariants == null && this.getConfigurationNames().size() != this.configurationDefinitions.size() ? Optional.of(this.allConfigurationsThatAreVariants()) : Optional.absent();
        return this.derivedVariants;
    }

    private ImmutableList<? extends ConfigurationMetadata> allConfigurationsThatAreVariants() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String potentialVariantName : this.getConfigurationNames()) {
            if (this.configurationDefinitions.containsKey((Object)potentialVariantName)) continue;
            builder.add((Object)this.getConfiguration(potentialVariantName));
        }
        return builder.build();
    }

    @Override
    public MutableIvyModuleResolveMetadata asMutable() {
        return this.metadata.asMutable();
    }

    @Override
    public RealisedIvyModuleResolveMetadata withSources(ModuleSources sources) {
        return new RealisedIvyModuleResolveMetadata(this, sources, this.getVariantDerivationStrategy());
    }

    @Override
    public ModuleComponentResolveMetadata withDerivationStrategy(VariantDerivationStrategy derivationStrategy) {
        if (this.getVariantDerivationStrategy() == derivationStrategy) {
            return this;
        }
        return new RealisedIvyModuleResolveMetadata(this, this.getSources(), derivationStrategy);
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    public ImmutableList<Artifact> getArtifactDefinitions() {
        return this.artifactDefinitions;
    }

    @Override
    public ImmutableList<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public ImmutableMap<NamespaceId, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @Override
    public IvyModuleResolveMetadata withDynamicConstraintVersions() {
        ImmutableList<IvyDependencyDescriptor> descriptors = this.getDependencies();
        if (descriptors.isEmpty()) {
            return this;
        }
        HashMap transformedDescriptors = Maps.newHashMapWithExpectedSize((int)descriptors.size());
        for (IvyDependencyDescriptor dependency : descriptors) {
            ModuleComponentSelector selector = dependency.getSelector();
            String dynamicConstraintVersion = dependency.getDynamicConstraintVersion();
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), dynamicConstraintVersion);
            transformedDescriptors.put(dependency, dependency.withRequested(newSelector));
        }
        return this.withDependencies(transformedDescriptors);
    }

    @Override
    public ImmutableList<IvyDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    private IvyModuleResolveMetadata withDependencies(Map<IvyDependencyDescriptor, IvyDependencyDescriptor> transformed) {
        ImmutableList transformedDescriptors = ImmutableList.copyOf(transformed.values());
        Set<String> configurationNames = this.getConfigurationNames();
        HashMap transformedConfigurations = Maps.newHashMapWithExpectedSize((int)configurationNames.size());
        for (String name : configurationNames) {
            RealisedConfigurationMetadata configuration = (RealisedConfigurationMetadata)this.getConfiguration(name);
            List<? extends ModuleDependencyMetadata> dependencies = configuration.getDependencies();
            ImmutableList.Builder transformedConfigurationDependencies = ImmutableList.builder();
            for (DependencyMetadata dependencyMetadata : dependencies) {
                if (dependencyMetadata instanceof ConfigurationBoundExternalDependencyMetadata) {
                    transformedConfigurationDependencies.add((Object)((ConfigurationBoundExternalDependencyMetadata)dependencyMetadata).withDescriptor(transformed.get(((ConfigurationBoundExternalDependencyMetadata)dependencyMetadata).getDependencyDescriptor())));
                    continue;
                }
                transformedConfigurationDependencies.add((Object)((ModuleDependencyMetadata)dependencyMetadata));
            }
            transformedConfigurations.put(name, configuration.withDependencies((ImmutableList<ModuleDependencyMetadata>)transformedConfigurationDependencies.build()));
        }
        return new RealisedIvyModuleResolveMetadata(this, (List<IvyDependencyDescriptor>)transformedDescriptors, (Map<String, ConfigurationMetadata>)transformedConfigurations);
    }
}

