/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.DocumentValidatorFactory;
import com.adobe.epubcheck.opf.ValidationContext;
import java.io.File;
import java.io.IOException;

public class EpubCheckFactory
implements DocumentValidatorFactory {
    private static final EpubCheckFactory instance = new EpubCheckFactory();

    public static EpubCheckFactory getInstance() {
        return instance;
    }

    @Override
    public DocumentValidator newInstance(ValidationContext context) {
        if (context.path.startsWith("http://") || context.path.startsWith("https://")) {
            try {
                return new EpubCheck(context.resourceProvider.getInputStream(context.path), context.report, context.path, context.profile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new EpubCheck(new File(context.path), context.report, context.profile);
    }
}

