/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GOST28147;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.GOST28147GenParameterSpec;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;

final class ProvGOST28147
extends AlgorithmProvider {
    private static final String PREFIX = ProvGOST28147.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class, GOST28147ParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            return new ParametersCreator(){

                public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                    if (algorithmParameterSpec instanceof IvParameterSpec) {
                        if (Utils.isAuthMode(parameters.getAlgorithm())) {
                            return ((GOST28147.AuthParameters)parameters).withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
                        }
                        return ((GOST28147.Parameters)parameters).withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
                    }
                    if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                        GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
                        if (Utils.isAuthMode(parameters.getAlgorithm())) {
                            return ((GOST28147.AuthParameters)((GOST28147.AuthParameters)parameters).withIV(gOST28147ParameterSpec.getIV())).withSBox(gOST28147ParameterSpec.getSBox());
                        }
                        return ((GOST28147.Parameters)parameters).withIV(gOST28147ParameterSpec.getIV()).withSBox(gOST28147ParameterSpec.getSBox());
                    }
                    ParametersWithIV parametersWithIV = (ParametersWithIV)parameters;
                    if (bl && parametersWithIV.getAlgorithm().requiresAlgorithmParameters()) {
                        return parametersWithIV.withIV(secureRandom);
                    }
                    return parametersWithIV;
                }
            };
        }
    };

    ProvGOST28147() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.GOST28147", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, GOST28147.ECBwithPKCS7, GOST28147.ECB, GOST28147.ECBwithISO10126_2, GOST28147.ECBwithISO7816_4, GOST28147.ECBwithTBC, GOST28147.ECBwithX923, GOST28147.CBC, GOST28147.CBCwithPKCS7, GOST28147.CBCwithISO10126_2, GOST28147.CBCwithISO7816_4, GOST28147.CBCwithTBC, GOST28147.CBCwithX923, GOST28147.CBCwithCS1, GOST28147.CBCwithCS2, GOST28147.CBCwithCS3, GOST28147.CTR, GOST28147.CFB8, GOST28147.CFB64, GOST28147.OFB, GOST28147.EAX, GOST28147.GCFB, GOST28147.GOFB).withGeneralOperators(ProvGOST28147.this.generalParametersCreatorProvider, new GOST28147.OperatorFactory(), new GOST28147.AEADOperatorFactory()).withParameters(ProvGOST28147.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.GOST", "GOST28147");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.GOST-28147", "GOST28147");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", CryptoProObjectIdentifiers.gostR28147_gcfb, PREFIX + "$GCFB", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, GOST28147.GCFB).withGeneralOperators(ProvGOST28147.this.generalParametersCreatorProvider, new GOST28147.OperatorFactory(), null).withParameters(ProvGOST28147.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.GOST28147", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "GOST28147", 256, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new GOST28147.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.GOST28147", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.GOST28147", PREFIX + "$AlgParamGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParamGen(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.GOST28147", PREFIX + "$GOST28147KFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("GOST28147", GOST28147.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n != 256) {
                            throw new InvalidKeySpecException("Provided key data wrong size for GOST28147");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "GOST28147", CryptoProObjectIdentifiers.gostR28147_gcfb);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.GOST28147MAC", PREFIX + "$Mac", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(GOST28147.MAC, (MACOperatorFactory)new GOST28147.MACOperatorFactory(), new AuthParametersCreator(GOST28147.MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        private ASN1ObjectIdentifier sBox;

        public AlgParamGen(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, 0);
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof GOST28147GenParameterSpec) {
                String string = ((GOST28147GenParameterSpec)algorithmParameterSpec).getSBoxName();
                try {
                    this.sBox = GOST28147.getSBoxOID(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidAlgorithmParameterException("Name " + string + " does not map to a GOST28147 parameter set");
                }
            } else {
                throw new InvalidAlgorithmParameterException("GOST28147 requires a GOST28147GenParameterSpec for initialization");
            }
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[8];
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("GOST28147", this.fipsProvider);
                if (this.sBox == null) {
                    algorithmParameters.init(new IvParameterSpec(byArray));
                } else {
                    algorithmParameters.init(new GOST28147ParameterSpec(this.sBox, byArray));
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage(), exception);
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private ASN1ObjectIdentifier sBox = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        private byte[] iv;

        protected byte[] localGetEncoded() throws IOException {
            return new GOST28147Parameters(this.iv, this.sBox).getEncoded();
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            if (clazz == GOST28147ParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new GOST28147ParameterSpec(this.sBox, this.iv);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                this.iv = ((GOST28147ParameterSpec)algorithmParameterSpec).getIV();
                try {
                    this.sBox = GOST28147.getSBoxOID(((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidParameterSpecException(illegalArgumentException.getMessage());
                }
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
        }

        protected void localInit(byte[] byArray) throws IOException {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(byArray);
            if (aSN1Primitive instanceof ASN1OctetString) {
                this.iv = ASN1OctetString.getInstance(aSN1Primitive).getOctets();
            } else if (aSN1Primitive instanceof ASN1Sequence) {
                GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Primitive);
                this.sBox = gOST28147Parameters.getEncryptionParamSet();
                this.iv = gOST28147Parameters.getIV();
            } else {
                throw new IOException("Unable to recognize parameters");
            }
        }

        protected String engineToString() {
            return "IV Parameters";
        }
    }
}

