/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table;

import com.almworks.dup.util.EventListener;
import com.almworks.dup.util.TypedKey;
import com.almworks.tracker.eapi.alpha.AddCollectionAcceptor;
import com.almworks.tracker.eapi.alpha.ArtifactCollectionConfigurationManager;
import com.almworks.tracker.eapi.alpha.ArtifactCollectionMonitor;
import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoEvent;
import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracker.eapi.alpha.CollectionUpdateEvent;
import com.almworks.tracker.eapi.alpha.FindArtifactAcceptor;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.collections.CollectionsCache;
import com.almworks.tracklink.findusages.FindUtils;
import com.almworks.tracklink.toolwindow.table.PluginBaseComponents;
import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.Log;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.almworks.util.detach.DetachComposite;
import org.almworks.util.detach.Lifespan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueTableController {
    private static final String COLLECTION_ELEM = "collection";
    private static final String ID_ATTR = "id";
    private static final String COLLAPSED_NODES_ELEM = "ExpandedNodes";
    private static final String COLLAPSED_NODE_ELEM = "ExpandedNode";
    private final DetachComposite myLifespan = new DetachComposite();
    private final IssueTableModel myModel;
    private final PluginBaseComponents myBaseComponents;
    private final AddCollectionAcceptor myCollectionAcceptor = new AddCollectionAcceptor(){

        public void acceptAddCollection(CollectionData collectionData) {
            IssueTableController.this.onCollectionAttached(collectionData);
            Utils.toFront(IssueTableController.this.myBaseComponents.getProject());
        }
    };
    private final EventListener<CollectionUpdateEvent> myCollectionUpdateListener = new EventListener<CollectionUpdateEvent>(){

        public void onEvent(CollectionUpdateEvent event) {
            IssueTableController.this.onCollectionChanged(event);
        }
    };
    private final EventListener<ArtifactInfoEvent> myArtifactInfoEventListener = new EventListener<ArtifactInfoEvent>(){

        public void onEvent(ArtifactInfoEvent event) {
            IssueTableController.this.onArtifactInfoChanged(event.getArtifactInfo());
        }
    };
    private final FindArtifactAcceptor myFindArtifactAcceptor = new FindArtifactAcceptor(){

        public void acceptFindArtifacts(Collection<String> urls) {
            if (urls == null || urls.isEmpty()) {
                return;
            }
            Utils.toFront(IssueTableController.this.myBaseComponents.getProject());
            FindUtils.findUsages(IssueTableController.this.myBaseComponents.getProject(), urls.toArray(new String[urls.size()]));
        }
    };

    public IssueTableController(IssueTableModel model, PluginBaseComponents baseComponents) {
        this.myModel = model;
        this.myBaseComponents = baseComponents;
    }

    private void onArtifactInfoChanged(ArtifactInfo info) {
        this.myModel.updateArtifactInfo(info);
    }

    public IssueTableModel getModel() {
        return this.myModel;
    }

    public void init() {
        TrackerConnector connector = this.myBaseComponents.getConnector();
        if (connector == null) {
            assert (false) : this;
            return;
        }
        ArtifactInfoCache cache = this.myBaseComponents.getArtifactInfoCache();
        if (cache == null) {
            assert (false) : this;
            return;
        }
        ArtifactCollectionMonitor monitor = connector.getArtifactCollectionMonitor();
        monitor.events().addListener((Lifespan)this.myLifespan, CollectionUpdateEvent.class, this.myCollectionUpdateListener);
        ArtifactCollectionConfigurationManager collectionManager = connector.getArtifactCollectionConfigurationManager();
        collectionManager.registerAddCollectionAcceptor((Lifespan)this.myLifespan, this.myCollectionAcceptor);
        cache.listenArtifactInfo((Lifespan)this.myLifespan, this.myArtifactInfoEventListener);
        connector.getFindArtifactManager().registerFindArtifactAcceptor((Lifespan)this.myLifespan, this.myFindArtifactAcceptor);
    }

    protected void detach() {
        this.myLifespan.detach();
    }

    private ArtifactCollectionRow onCollectionAttached(CollectionData data) {
        CollectionsCache collectionsCache = this.myBaseComponents.getCollectionsCache();
        collectionsCache.store(data, Collections.EMPTY_LIST);
        if (this.myModel.hasCollection(data.getCollectionId())) {
            return (ArtifactCollectionRow)this.myModel.getCollection(data.getCollectionId());
        }
        ArtifactCollectionRow newCollection = new ArtifactCollectionRow(data, this, this.myModel);
        this.myModel.addCollection(newCollection, data.getCollectionId());
        this.myModel.fireTableDataChanged();
        Lifespan lifespan = newCollection.getLifespan();
        TrackerConnector connector = this.myBaseComponents.getConnector();
        if (connector != null) {
            connector.getArtifactCollectionMonitor().watchCollection((Object)this, lifespan, data.getCollectionId());
        }
        return newCollection;
    }

    public void onCollectionChanged(CollectionUpdateEvent event) {
        ArtifactInfoCache cache = this.myBaseComponents.getArtifactInfoCache();
        CollectionsCache collectionsCache = this.myBaseComponents.getCollectionsCache();
        CollectionData collectionData = event.getCollectionData();
        String collectionId = event.getCollectionData().getCollectionId();
        if (collectionData.isValid()) {
            if (this.myModel.hasCollection(collectionId)) {
                ArtifactCollectionRow collection = (ArtifactCollectionRow)this.myModel.getCollection(collectionId);
                Collection urls = event.getArtifactUrls();
                collectionsCache.store(collectionData, urls);
                collection.onUpdate(collectionData, urls, cache);
            } else {
                Log.warn("new collection come first in onCollectionAttached");
            }
        } else if (this.myModel.hasCollection(collectionId)) {
            this.removeCollection(collectionId);
        } else {
            Log.warn("new collection come first in onCollectionAttached");
        }
    }

    public void removeCollection(String id) {
        ArtifactCollectionRow collection = (ArtifactCollectionRow)this.myModel.removeCollectionFromMap(id);
        assert (collection != null) : "Nothing to remove";
        ArtifactInfoCache cache = this.myBaseComponents.getArtifactInfoCache();
        CollectionsCache collectionsCache = this.myBaseComponents.getCollectionsCache();
        collectionsCache.forgetCollection(id);
        collection.onUpdate(null, Collections.<String>emptyList(), cache);
        collection.detach();
    }

    public void getState() {
        CollectionsCache collectionsCache = this.myBaseComponents.getCollectionsCache();
        this.myModel.storeState(collectionsCache);
    }

    public void loadState(IssueTableModel loadedModel) {
        CollectionsCache collectionsCache = this.myBaseComponents.getCollectionsCache();
        for (String id : loadedModel.myModelBeanOrderedList) {
            Boolean exp;
            if (!StringUtil.isEmpty((String)id)) {
                Pair<CollectionData, ? extends Set<String>> pair = collectionsCache.restore(id);
                if (pair == null) {
                    HashMap<TypedKey, String> props = new HashMap<TypedKey, String>();
                    props.put(CollectionData.COLLECTION_NAME, "favorites".equalsIgnoreCase(id) ? "Favorites" : "(Unknown)");
                    this.addData(new CollectionData(id, false, props), new HashSet<String>());
                } else {
                    this.addData((CollectionData)pair.getFirst(), (Set)pair.getSecond());
                }
            }
            this.myModel.setArtifactCollectionExpand(id, (exp = loadedModel.myModelBean.get(id)) == null ? false : exp);
        }
    }

    private void addData(CollectionData data, Set<String> urls) {
        ArtifactInfoCache cache = this.myBaseComponents.getArtifactInfoCache();
        if (cache == null) {
            assert (false) : this;
            return;
        }
        ArtifactCollectionRow collectionNode = this.onCollectionAttached(data);
        collectionNode.onUpdate(data, urls, cache);
    }

    public PluginBaseComponents getBaseComponents() {
        return this.myBaseComponents;
    }
}

