/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerBlobInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerBlobOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;

public final class SQLServerBlob
implements Blob,
Serializable {
    private byte[] bData;
    private SQLServerConnection con;

    public SQLServerBlob(SQLServerConnection sQLServerConnection, byte[] byArray) {
        this.con = sQLServerConnection;
        this.bData = byArray;
    }

    public InputStream getBinaryStream() throws SQLServerException {
        if (null == this.bData) {
            return null;
        }
        return new SQLServerBlobInputStream(this);
    }

    public byte[] getBytes(long l, int n) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if ((null == this.bData || 0 == this.bData.length) && 1L == l && n >= 0) {
            return new byte[0];
        }
        if (null == this.bData || l <= 0L || l > (long)this.bData.length) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        int n2 = n;
        if (--l + (long)n > (long)this.bData.length) {
            n2 = this.bData.length - (int)l;
        }
        objectArray = new byte[n2];
        System.arraycopy(this.bData, (int)l, objectArray, 0, n2);
        return objectArray;
    }

    public long length() throws SQLServerException {
        if (null == this.bData) {
            return 0L;
        }
        return this.bData.length;
    }

    public long position(Blob blob, long l) throws SQLServerException {
        try {
            if (null == blob || 0L == blob.length()) {
                return -1L;
            }
            return this.position(blob.getBytes(1L, (int)blob.length()), l);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, null, sQLException.toString(), null, true);
            return 0L;
        }
    }

    public long position(byte[] byArray, long l) throws SQLServerException {
        if (l <= 0L) {
            return -1L;
        }
        if (null == this.bData || 0 == this.bData.length) {
            return -1L;
        }
        if (null == byArray || 0 == byArray.length) {
            return -1L;
        }
        if (--l >= (long)this.bData.length) {
            return -1L;
        }
        int n = byArray.length;
        if (n > this.bData.length) {
            return -1L;
        }
        int n2 = this.bData.length - n;
        for (int i = (int)l; i <= n2; ++i) {
            boolean bl = true;
            for (int j = 0; j < n; ++j) {
                if (this.bData[i + j] == byArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    public void truncate(long l) throws SQLException {
        Object object;
        if (null == this.bData || (long)this.bData.length <= l) {
            return;
        }
        if (l < 0L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        object = new byte[(int)l];
        System.arraycopy(this.bData, 0, object, 0, (int)l);
        this.bData = object;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return new SQLServerBlobOutputStream(this, l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (null == byArray) {
            return 0;
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        Object[] objectArray;
        Object object;
        int n3;
        if (null == byArray || 0 == byArray.length) {
            return 0;
        }
        if (0 == n2) {
            return 0;
        }
        int n4 = n3 = null == this.bData ? 0 : this.bData.length;
        if (l <= 0L || l > (long)(n3 + 1)) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n < 0 || n >= byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (--l + (long)n2 >= (long)n3) {
            object = new byte[(int)(l + (long)n2)];
            if (n3 > 0) {
                System.arraycopy(this.bData, 0, object, 0, (int)l);
            }
            System.arraycopy(byArray, n, object, (int)l, n2);
            this.bData = (byte[])object;
        } else {
            System.arraycopy(byArray, n, this.bData, (int)l, n2);
        }
        return n2;
    }

    int read(int n, byte[] byArray, int n2, int n3) {
        int n4;
        if (null == byArray) {
            return 0;
        }
        if (n2 < 0 || n2 >= byArray.length) {
            return 0;
        }
        if (n3 <= 0) {
            return 0;
        }
        int n5 = n4 = null == this.bData ? 0 : this.bData.length;
        if (0 == n4) {
            return 0;
        }
        if (n < 0 || n >= n4) {
            return 0;
        }
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        if (n + n3 > n4) {
            n3 = n4 - n;
        }
        System.arraycopy(this.bData, n, byArray, n2, n3);
        return n3;
    }
}

