/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class StreamError
extends LispError {
    private final Throwable cause;
    private static final Primitive STREAM_ERROR_STREAM = new Primitive("stream-error-stream", "condition"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof StreamError) {
                return ((StreamError)arg).getStream();
            }
            return Lisp.type_error(arg, Symbol.STREAM_ERROR);
        }
    };

    protected StreamError(LispClass cls) {
        super(cls);
        this.cause = null;
    }

    public StreamError(String message) {
        super(StandardClass.STREAM_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.setStream(Lisp.NIL);
        this.cause = null;
    }

    public StreamError(Stream stream) {
        super(StandardClass.STREAM_ERROR);
        this.setStream(stream != null ? stream : Lisp.NIL);
        this.cause = null;
    }

    public StreamError(String message, Stream stream) {
        super(StandardClass.STREAM_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.setStream(stream != null ? stream : Lisp.NIL);
        this.cause = null;
    }

    public StreamError(LispObject initArgs) {
        super(StandardClass.STREAM_ERROR);
        this.initialize(initArgs);
        this.cause = null;
    }

    @Override
    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.STREAM) {
                this.setStream(initArgs.car());
                break;
            }
            initArgs = initArgs.cdr();
        }
    }

    public StreamError(Stream stream, String message) {
        super(StandardClass.STREAM_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.setStream(stream != null ? stream : Lisp.NIL);
        this.cause = null;
    }

    public StreamError(Stream stream, Throwable cause) {
        super(StandardClass.STREAM_ERROR);
        this.setStream(stream != null ? stream : Lisp.NIL);
        String message = cause.getMessage();
        this.setFormatControl(message != null ? message.replaceAll("~", "~~") : cause.toString().replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.cause = cause;
    }

    public final LispObject getStream() {
        return this.getInstanceSlotValue(Symbol.STREAM);
    }

    protected final void setStream(LispObject stream) {
        this.setInstanceSlotValue(Symbol.STREAM, stream);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.STREAM_ERROR;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.STREAM_ERROR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.STREAM_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.STREAM_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public String getMessage() {
        String s;
        if (this.cause != null && (s = this.cause.getMessage()) != null && s.length() > 0) {
            return s;
        }
        return null;
    }
}

