# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Getting Things GNOME! - a personal organizer for the GNOME desktop
# Copyright (c) 2008-2013 - Lionel Dricot & Bertrand Rousseau
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.
# -----------------------------------------------------------------------------
"""Various information about GTG. Should be updated for every release.

Contains the information displayed in GTG's Credits."""

from GTG import _

NAME = "Getting Things GNOME!"
URL = "http://gtgnome.net"
HELP_URI = "help:gtg"
TRANSLATE_URL = "https://translations.launchpad.net/gtg"
REPORT_BUG_URL = "https://bugs.launchpad.net/gtg/+filebug"
EMAIL = "gtg-contributors@lists.launchpad.net"
VERSION = '0.3.1'

SHORT_DESCRIPTION = \
    _('GTG is a personal tasks and TODO-list items organizer for the GNOME.')

# CREDITS
AUTHORS = ["Main developers:",
           "\tLionel Dricot <ploum@ploum.net>",
           "\tBertrand Rousseau <bertrand.rousseau@gmail.com>",
           "\tPaulo Cabido <paulo.cabido@gmail.com>",
           "\tLuca Invernizzi <invernizzi.l@gmail.com>",
           "\tKevin Mehall <km@kevinmehall.net>",
           "\tLuca Falavigna <dktrkranz@debian.org>",
           "\tIzidor Matušov <izidor.matusov@gmail.com>",
           "\tNimit Shah <nimit.svnit@gmail.com>",
           "\tParin Porecha <parinporecha@gmail.com>",
           "Contributors:",
           "\tAbdul Rauf <abdulraufhaseeb@gmail.com>",
           "\tAbhiram <abhiram.ampabathina@gmail.com>",
           "\tAlayn Gortazar <zutoin@gmail.com>",
           "\tAlan Gomes <alangalvino@gmail.com>",
           "\tAnant Gupta <anant718@hotmail.com>",
           "\tAndrew Starr-Bochicchio <andrewsomething@ubuntu.com>",
           "\tAntonio Roquentin <antonio.roquentin@sfr.fr>",
           "\tAntons Rebguns <arebgun@gmail.com>",
           "\tBen Dowling <ben.m.dowling@gmail.com>",
           "\tBrian Kennedy <ekspiulo@gmail.com>",
           "\tBryce Harrington <bryce@bryceharrington.org>",
           "\tCarl Chenet <chaica@ohmytux.com>",
           "\tChenxiong Qi <qcxhome@gmail.com>",
           "\tChris Johnston <chrisjohnston@ubuntu.com>",
           "\tCodee <kmhpfoss@gmail.com>",
           "\tDaniel Neel <dneelyep@gmail.com>",
           "\tdAnjou <mail@danjou.de>",
           "\tDavid Planella <david.planella@jabber.org>",
           "\tDmDr <cardioexp@gmail.com>",
           "\tErin McLaughlin <emclaughlin1215@gmail.com>",
           "\tFabiano Fidencio <fabiano@fidencio.org>",
           "\tFabio Prina <fabio@nimsh.com>",
           "\tFrançois",
           "\tGérôme Fournier",
           "\thuxuan <i@huxuan.org>",
           "\tIvan Evtukhovich <evtuhovich@gmail.com>",
           "\tJean-François Fortin Tam <nekohayo@gmail.com>",
           "\tJeff Oliver <kaiserfro@gmail.com>",
           "\tJérôme Guelfucci <jerome.guelfucci@gmail.com>",
           "\tJoão Ascenso <joaoricardoascenso@gmail.com>",
           "\tJonathan Barnoud <jonathan@barnoud.net>",
           "\tJonathan Lange <jml@mumak.net>",
           "\tKalle Persson <kalle@kallepersson.se>",
           "\tKees Cook <kees@ubuntu.com>",
           "\tkpytang",
           "\tMadhumitha Viswanathan <madhuvishy@gmail.com>",
           "\tMarcos Lenharo",
           "\tMarko Kevac <marko@kevac.org>",
           "\tMarta Maria Casetti <mmcasetti@gmail.com>",
           "\tMatthew Rasmus <tareth.ml@gmail.com>",
           "\tMichael Vogt <michael.vogt@ubuntu.com>",
           "\tNicolas Maître <nimai@skynet.be>",
           "\tPaul Kishimoto <mail@paul.kishimoto.name>",
           "\tRichard Klein <kleinric@gmail.com>",
           "\tSaurabh Anand <saurabhanandiit@gmail.com>",
           "\tSebastian Dyroff <sebastian@dyroff.org>",
           "\tSong Yangyu <flyfy1@gmail.com>",
           "\tStefan Handschuh",
           "\tSteve Scheel <nmu.sscheel@gmail.com>",
           "\tThibault Fevry <ThibaultFevry@gmail.com>",
           "\tTom Kadwill <tomkadwill@gmail.com>",
           "\tViktor Nagy <viktor.nagy@toolpart.hu>",
           "\tVolodymyr Floreskul <exufer@gmail.com>",
           "\tWolter Hellmund <wolterh6@gmail.com>",
           "\tZach Shepherd <eightball1989@gmail.com>",
           "\tZimin Huang <ienjoycoding@gmail.com>"]

ARTISTS = ["Kalle Persson <kalle@kallepersson.se>",
           "Bertrand Rousseau <bertrand.rousseau@gmail.com>"]
ARTISTS.sort()
TRANSLATORS = \
    """
    Afrikaans:Arthur Rilke, Walter Leibbrandt, Wesley Channon

    Albanian: Vilson Gjeci

    Arabic: Ahmed Kotb, Ali AlNoaimi, Anas Almzoghy, Basher Aobasher,
    Islam Alshaikh, Kaïs Bejaoui

    Asturian: Xuacu Saturio, ivarela

    Basque: Asier Iturralde Sarasola, Oier Mees

    Belarusian: Egor Kuryanovich, Iryna Nikanchuk

    Bengali: XFACT, nasir khan saikat

    Brazilian: AdirKuhn, André Gondim, Belenos Govannnon, Daniel Tiecher,
    Davi da Silva Böger, Djavan Fagundes, Douglas Santos, Enrico Nicoletto,
    Frederico Lopes, João Cruz Jr, João Santana, NeLaS, Nilton, Rafael Neri,
    Teylo Laundos Aguiar, Waldir Leoncio, andre felix

    Bulgarian: Damyan Ivanov, Svetoslav Stefanov, i.raynov

    Catalan: Adolfo Jayme Barrientos, Carles Sala, David Planella,
    Juanma Hernández, Marc Recasens, Radina Matic, Siegfried Gevatter,
    anna marti

    Chinese (simplified): Ang Gao, Anthony Fok, Eleanor Chen, Harold.luo,
    Heling Yao, Joseph Lew, Kyle WANG, Wylmer Wang, Xuan Hu, chars, 百草谷居士,
    somebodykiss

    Chinese (traditional): Andrew Liu, Anthony Fok, Po-Jen Hsu, Rex Tsai,
    Toomore, extraymond@gmail.com

    Croatian: Saša Teković, gogo

    Czech: David Kovář, Dominik Janků, Jakub Kozisek, Jan Hrdina, Konki,
    Kuvaly [LCT], Ladislav Prskavec, Mailo, Martin Rotter, Martin Volf,
    Marv-CZ, Milos-kroulik-3, Roman Horník, Tadeáš Pařík, Viktor

    Danish: Aputsiaq Niels Janussen, Ask Hjorth Larsen, Gamayun, Mogens Isager,
    Peter Skov, mkjeldsen

    Dutch: Emilien Klein, Foppe Benedictus, Hanssen, Heureka, Lionel Dricot,
    Lucas Vieites, Nathan, Pieter J. Kersten (EduSense BV)Rachid,
    Reinout van Schouwen, Tino Meinen, klap-in, puccha, rob

    English (Canada): Itai Molenaar, Ken Sharp, Luca Falavigna, Paul Kishimoto

    English (United Kingdom): Alexandre COLLIGNON, Alfredo Hernández,
    Anthony Harrington, Bruce Cowan, Cyril, Jonathon Hodges, Lionel Dricot,
    Luca Invernizzi, Michael Keppler, Olly Betts, Philipp Kleinhenz,
    Robert Readman, Sid Roberts, ascenseur, lopho, Luca Falavigna

    Finnish: Heikki Mattila, Jussi Tiira, Mika Tapojärvi

    French: AkaiKen, Alexandre COLLIGNON, Bertrand Rousseau, Bruno Veilleux,
    Cyril, David Coeurjolly, Dominick Rivard, Emilien Klein, FrancoisSchoubben,
    François, Greizgh, Jibec, Lionel Dricot, Maxime Veroone, Nicolas Delvaux,
    Perniflosse, Philippe Le Toquin, Pititjo, Ptitphysik, Quentin Pagès,
    Rafik Ouerchefani, Raphaël, Sid Roberts, Simon Leblanc, Stanislas Michalak,
    Thibault Févry, Timothee Bernard, Yves Masson, bsaleil, gaetanpralong,
    sebz, Alexandre Germain, François Vogelweith, Jonathan Fromentin,
    Loic Dreux, Nicolas Gaulard-Querol, Sebastien Moran, Sylvie Gallet,
    thomas.citharet@gmail.com

    Galician: Dario, Fran Diéguez, Jorge Álvarez, Miguel Anxo Bouzada, keko

    Georgian: Giorgi Jvaridze

    German: Abb, Alexandre COLLIGNON, Christoph-M. Lehmann, Daniel Dietrich,
    Daniel Winzen, Fabian Affolter, Gerfried Fuchs, Henry78, Izidor Matušov,
    Jan, Jens Maucher, Jonas Endersch, Marcel Stimberg, Michael Keppler,
    Philip Stewart, Raphael J. Schmid, Scott, Seraphyn, Thomas Pitlik,
    Tim Bordemann, gerber, schulz3000, brylli, Michael Odaischi,
    Florian Bäuerle, Borim

    Greek: Fotis Tsamis, George Chronis, Stathis Iosifidis

    Hebrew: Erik, Yaron

    Hindi: Abdul Rauf, Nimit Shah

    Hungarian: András Kárász, Crcsz Tibcr, Gabor Kelemen, Gergely Szarka,
    Krasznecz Zoltán, Muszela Balázs

    Icelandic: Baldur, Palmar Thorsteinsson, Samúel Jón Gunnarsson

    Indonesian: Andika Triwidada, Wayan Sudiarnata

    Interlingua: Emilio Sepulveda

    Italian: Antonio Roquentin, Claudio Arseni, Dario Bertini,
    Davide Alberelli, Dennis Anfossi, Fabio Marconi, Francesco de Virgilio,
    Gianfranco, Luca Falavigna, Luca Invernizzi, Milo Casagrande, Radina Matic
    , jollyr0ger

    Japanese: 9APPAT3CH, Chris Harrington, Hideki Yamane, Hiroshi Tagawa

    Korean: khmirage

    Lithuanian: Algimantas Margevičius, Mantas Kriaučiūnas, Rytis Ūsalis,
    aurisc4, jaro

    Lojabn: David Futcher

    Low German: Michael Odaischi, brylli

    Malagasy: Thierry Andriamirado

    Malay: Ibrahim Elias, abuyop, itiknila, melayubuntu

    Norwegian Bokmal: Gamlerik, Runar Ingebrigtsen, Terje Andre Arnøy, Øystein

    Occitan (post 1500): Cédric VALMARY (Tot en òc)

    Persian: Sepehr Lajevardi

    Polish: Jakub Kołakowski, Konrad, Piotr Hałas, Piotr Strębski, Radek Puła,
    Tomasz 'Zen' Napierala, Tomasz Maciejewski, btomasz, szczym, tomlee,
    Witek M., Xevaquor, Tomasz Woźniak

    Portuguese: Emanuel Ângelo, Joel Patrão, Paulo Cabido, raul_pereira

    Romanian: Adi Roiban, Jibec, Lucian Adrian Grijincu, Ovidiu

    Russian: A. S. Popov, Alexander Semyonov, Alexey Ivanov, Alexey Kostyuk,
    Alexey Nedilko, Andrej Surkov, DmDr, Dmitry "Divius" Tantsur,
    Eugene Sysmanov, Nergal, Nikita Putko, Oleg Koptev, Peter Romov, Serfer,
    Vadim Barsukov, Yevgeny Sysmanov, Yuriy Vidineev, a220, dueMiR, maxzda,
    mrk, wiz, Олег Малахов

    Serbian: Miloš Mandarić, Игор Миловановић, Мирослав Николић, Саша Петровић

    Sinhalese: ජීවන්ත ලේකම්වසම්

    Slovak: Izidor Matušov, Milan Slovák, Slavko

    Slovenian: Andrej Znidarsic, Igor2x, grofaty

    Spanish: Adolfo Jayme Barrientos, Alberto Caso, Carlos Alberto Ospina,
    Christopher, Denis Fuenzalida, DiegoJ, Grillo, Javier García Díaz,
    Javier Jardón, Javier Suárez, Jorge González, Jose R. Megia, Lionel Dricot,
    Marcello Nicolas Manso, Nicolás M. Zahlut, Nukeador, Radina Matic,
    Rafael Soler - Domatix, Sergio Redondo, Xuacu Saturio, ixzus, n_alex,
    perriman

    Swedish: Christian Widell, Daniel Nylander, David Bengtsson,
    Erik Piehl Sylvén, Kalle Persson, Maxim Andersson, Nikke, Petri Rosenström,
    jens persson

    Telugu: Arjuna Rao Chavala,     వీవెన్ (Veeven)

    Thai: NullZer0, SiraNokyoongtong

    Turkish: Aean, Ali KIBICI, Baris Ata, Emre Ayca, Murat Gunes,
    Onur ALTINTAŞI, Yiğit Ateş, Volkan Gezer

    Ukrainian: Alex Chmyr, Gontsa, Pavel Druzyak, alex, dueMiR, yvadim

    Urdu: Abdul Rauf
    """

DOCUMENTERS = ["Radina Matic <radina.matic@gmail.com>"]
