/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class MediaQuery
extends AbstractDatatype {
    public static final MediaQuery THE_INSTANCE = new MediaQuery();
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");
    private static final Set<String> LENGTH_UNITS = new HashSet<String>();
    private static final Set<String> MEDIA_TYPES;
    private static final Set<String> OLD_MEDIA_TYPES;
    private static final Set<String> OLD_MEDIA_FEATURES;
    private static final Map<String, ValueType> FEATURES_TO_VALUE_TYPES;
    private static final Map<String, ValueType> NONSTANDARD_FEATURES_TO_VALUE_TYPES;

    protected MediaQuery() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        List<String> warnings = new ArrayList<String>();
        List<AbstractDatatype.CharSequenceWithOffset> queries = this.split(literal, ',');
        for (AbstractDatatype.CharSequenceWithOffset query : queries) {
            warnings = this.checkQuery(query.getSequence(), query.getOffset(), warnings);
        }
        if (!warnings.isEmpty() && WARN) {
            StringBuilder sb = new StringBuilder();
            for (String s : warnings) {
                sb.append(s).append(" ");
            }
            throw this.newDatatypeException(sb.toString().trim(), WARN);
        }
    }

    private List<String> checkQuery(CharSequence query, int offset, List<String> warnings) throws DatatypeException {
        int unmatchedParen = -1;
        int unmatchedCalcParen = -1;
        boolean zero = true;
        String type = null;
        String feature = null;
        ValueType valueExpectation = null;
        query = MediaQuery.toAsciiLowerCase(query);
        StringBuilder sb = new StringBuilder();
        State state = State.INITIAL_WS;
        block57: for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            switch (state) {
                case INITIAL_WS: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('(' == c) {
                        state = State.OPEN_PAREN_SEEN;
                        continue block57;
                    }
                    if ('o' == c || 'n' == c) {
                        sb.append(c);
                        state = State.IN_ONLY_OR_NOT;
                        continue block57;
                    }
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        state = State.IN_MEDIA_TYPE;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected \u201c(\u201d or letter at start of a media query part but saw ", c, " instead.");
                }
                case IN_ONLY_OR_NOT: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c)) {
                        kw = sb.toString();
                        sb.setLength(0);
                        if ("only".equals(kw)) {
                            if (this.isMediaCondition()) {
                                throw this.newDatatypeException(offset + i, "Expected a CSS media condition (not a CSS media type) but saw \u201conly\u201d instead.");
                            }
                            state = State.WS_BEFORE_MEDIA_TYPE;
                            continue block57;
                        }
                        if ("not".equals(kw)) {
                            if (this.isMediaCondition()) {
                                state = State.WS_BEFORE_MEDIA_FEATURE;
                                continue block57;
                            }
                            state = State.WS_BEFORE_MEDIA_TYPE;
                            continue block57;
                        }
                        throw this.newDatatypeException(offset + i, "Expected \u201conly\u201d or \u201cnot\u201d but saw \u201c" + kw + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_MEDIA_TYPE: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        state = State.IN_MEDIA_TYPE;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_MEDIA_FEATURE: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('(' == c) {
                        state = State.OPEN_PAREN_SEEN;
                        continue block57;
                    }
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        state = State.IN_MEDIA_TYPE;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected \u201c(\u201d or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case IN_MEDIA_TYPE: {
                    if ('a' <= c && 'z' >= c || c == '-') {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c)) {
                        type = sb.toString();
                        sb.setLength(0);
                        if (this.isMediaCondition()) {
                            this.errNotMediaCondition(type);
                        }
                        if (this.isMediaType(type)) {
                            state = State.WS_BEFORE_AND;
                            continue block57;
                        }
                        if (this.isOldMediaType(type)) {
                            throw this.newDatatypeException(offset + i, "Deprecated media type \u201c" + type + "\u201d. For guidance, see the Media Types section in the current Media Queries specification.");
                        }
                        throw this.newDatatypeException(offset + i, "Expected a CSS media type but saw \u201c" + type + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, hyphen or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_AND: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('a' == c) {
                        sb.append(c);
                        state = State.IN_AND;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected whitespace or \u201cand\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_AND: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c)) {
                        kw = sb.toString();
                        sb.setLength(0);
                        if ("and".equals(kw)) {
                            state = State.WS_BEFORE_EXPRESSION;
                            continue block57;
                        }
                        throw this.newDatatypeException(offset + i, "Expected \u201cand\u201d but saw \u201c" + kw + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_EXPRESSION: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('(' == c) {
                        state = State.OPEN_PAREN_SEEN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected \u201c(\u201d or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case OPEN_PAREN_SEEN: {
                    if (this.isWhitespace(c)) continue block57;
                    if ('(' == c) {
                        ++unmatchedParen;
                        continue block57;
                    }
                    if ('-' == c || 'a' <= c && 'z' >= c) {
                        sb.append(c);
                        state = State.IN_MEDIA_FEATURE;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter at start of a media feature part but saw \u201c" + c + "\u201d instead.");
                }
                case IN_MEDIA_FEATURE: {
                    String kw;
                    if ('a' <= c && 'z' >= c || c == '-') {
                        sb.append(c);
                        continue block57;
                    }
                    if (c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!this.isMediaCondition()) {
                            this.checkApplicability(offset + i, kw, type, warnings);
                        }
                        this.checkIfValueRequired(offset + i, kw);
                        state = State.AFTER_CLOSE_PAREN;
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ':') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!this.isMediaCondition()) {
                            this.checkApplicability(offset + i, kw, type, warnings);
                        }
                        feature = kw;
                        ValueType valueType = valueExpectation = this.valueExpectationFor(kw) != null ? this.valueExpectationFor(kw) : this.nonstandardValueExpectationFor(kw);
                        if (valueExpectation != null) {
                            if (c == ':') {
                                state = State.WS_BEFORE_VALUE;
                                continue block57;
                            }
                            state = State.WS_BEFORE_COLON;
                            continue block57;
                        }
                        throw this.newDatatypeException(offset + i, "Expected a CSS media feature but saw \u201c" + kw + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, hyphen, colon or whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_COLON: {
                    if (this.isWhitespace(c)) continue block57;
                    if (':' == c) {
                        state = State.WS_BEFORE_VALUE;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected whitespace or colon but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_VALUE: {
                    if (this.isWhitespace(c)) continue block57;
                    zero = true;
                    switch (valueExpectation) {
                        case SCAN: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_SCAN;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                        case ORIENTATION: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_ORIENTATION;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                        case ONEORZERO: {
                            if (c == '0' || c == '1') {
                                sb.append(c);
                                state = State.IN_VALUE_ONEORZERO;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected \u201c0\u201d or \u201c1\u201d as \u201c" + feature + "\u201d value but found \u201c" + c + "\u201d instead.");
                        }
                        case HOVER: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_HOVER;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                        case ANYHOVER: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_ANYHOVER;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                        case POINTER: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_POINTER;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                        case ANYPOINTER: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_ANYPOINTER;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter but saw \u201c" + c + "\u201d instead.");
                        }
                    }
                    if ('1' <= c && '9' >= c) {
                        zero = false;
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    if ('0' == c) {
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    if ('+' == c) {
                        state = State.IN_VALUE_BEFORE_DIGITS;
                        continue block57;
                    }
                    if ('.' == c && valueExpectation == ValueType.LENGTH) {
                        state = State.IN_VALUE_DIGITS_AFTER_DOT;
                        continue block57;
                    }
                    if ('c' == c) {
                        state = State.BEFORE_CALC_OPEN_PAREN;
                        continue block57;
                    }
                    if (valueExpectation == ValueType.LENGTH) {
                        throw this.newDatatypeException(offset + i, "Expected a digit, a dot or a plus sign but saw \u201c" + c + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected a digit or a plus sign but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_SCAN: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!"progressive".equals(kw) && !"interlace".equals(kw)) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cprogressive\u201d or \u201cinterlace\u201d as the scan mode value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_ORIENTATION: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!"portrait".equals(kw) && !"landscape".equals(kw)) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cportrait\u201d or \u201clandscape\u201d as the \u201corientation\u201d value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_ONEORZERO: {
                    if (this.isWhitespace(c) || c == ')') {
                        sb.setLength(0);
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    sb.append(c);
                    String kw = sb.toString();
                    throw this.newDatatypeException(offset + i, "Expected \u201c0\u201d or \u201c1\u201d as \u201c" + feature + "\u201d value but saw \u201c" + kw + "\u201d instead.");
                }
                case IN_VALUE_HOVER: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!"none".equals(kw) && !"hover".equals(kw)) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cnone\u201d or \u201chover\u201d as the \u201chover\u201d value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_ANYHOVER: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!"none".equals(kw) && !"hover".equals(kw)) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cnone\u201d or \u201chover\u201d as the \u201cany-hover\u201d value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_POINTER: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!("none".equals(kw) || "coarse".equals(kw) || "fine".equals(kw))) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cnone\u201d or \u201ccoarse\u201d or \u201cfine\u201d as the \u201cpointer\u201d value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_ANYPOINTER: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (!("none".equals(kw) || "coarse".equals(kw) || "fine".equals(kw))) {
                            throw this.newDatatypeException(offset + i, "Expected \u201cnone\u201d or \u201ccoarse\u201d or \u201cfine\u201d as the \u201cany-pointer\u201d value but saw \u201c" + kw + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_BEFORE_DIGITS: {
                    if ('0' == c) {
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    if ('1' <= c && '9' >= c) {
                        zero = false;
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    switch (valueExpectation) {
                        case LENGTH: 
                        case RESOLUTION: {
                            if ('.' == c) {
                                state = State.IN_VALUE_DIGITS_AFTER_DOT;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a dot or a digit but saw \u201c" + c + "\u201d instead.");
                        }
                        case INTEGER: 
                        case RATIO: {
                            throw this.newDatatypeException(offset + i, "Expected a digit but saw \u201c" + c + "\u201d instead.");
                        }
                    }
                    throw new RuntimeException("Impossible state.");
                }
                case IN_VALUE_DIGITS: {
                    if ('0' == c) continue block57;
                    if ('1' <= c && '9' >= c) {
                        zero = false;
                        continue block57;
                    }
                    switch (valueExpectation) {
                        case LENGTH: 
                        case RESOLUTION: {
                            if ('.' == c) {
                                state = State.IN_VALUE_DIGITS_AFTER_DOT;
                                continue block57;
                            }
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_UNIT;
                                continue block57;
                            }
                            if (this.isWhitespace(c) || c == ')') {
                                if (!zero) {
                                    if (valueExpectation == ValueType.LENGTH) {
                                        throw this.newDatatypeException(offset + i, "Non-zero lengths require a unit.");
                                    }
                                    throw this.newDatatypeException(offset + i, "Non-zero resolutions require a unit.");
                                }
                                if (c == ')') {
                                    state = State.AFTER_CLOSE_PAREN;
                                    continue block57;
                                }
                                state = State.WS_BEFORE_CLOSE_PAREN;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter, a dot or a digit but saw \u201c" + c + "\u201d instead.");
                        }
                        case INTEGER: {
                            if (c == ')') {
                                state = State.AFTER_CLOSE_PAREN;
                                continue block57;
                            }
                            if (this.isWhitespace(c)) {
                                state = State.WS_BEFORE_CLOSE_PAREN;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a digit, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                        }
                        case NONZEROINTEGER: {
                            if (c == ')') {
                                if (zero) {
                                    throw this.newDatatypeException(offset + i, "Expected a non-zero positive integer.");
                                }
                                state = State.AFTER_CLOSE_PAREN;
                                continue block57;
                            }
                            if (this.isWhitespace(c)) {
                                state = State.WS_BEFORE_CLOSE_PAREN;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a digit, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                        }
                        case RATIO: {
                            if (this.isWhitespace(c)) continue block57;
                            if (c == '/') {
                                if (zero) {
                                    throw this.newDatatypeException(offset + i, "Expected non-zero positive integer in ratio value.");
                                }
                                valueExpectation = ValueType.NONZEROINTEGER;
                                state = State.RATIO_SECOND_INTEGER_START;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a digit, whitespace or \u201c/\u201d for " + feature + " value but saw \u201c" + c + "\u201d instead.");
                        }
                        default: {
                            throw new RuntimeException("Impossible state.");
                        }
                    }
                }
                case BEFORE_CALC_OPEN_PAREN: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if ('(' == c) {
                        unmatchedCalcParen = 1;
                        kw = sb.toString();
                        sb.setLength(0);
                        if ("alc".equals(kw)) {
                            state = State.IN_CALC;
                            continue block57;
                        }
                        throw this.newDatatypeException(offset + i, "Expected \u201ccalc\u201d but saw \u201c" + kw + "\u201d instead.");
                    }
                    throw this.newDatatypeException(offset + i, "Expected \u201ccalc\u201d but saw \u201c" + c + "\u201d instead.");
                }
                case IN_CALC: {
                    if (')' == c) {
                        if (unmatchedCalcParen == 1) {
                            unmatchedCalcParen = -1;
                            state = State.WS_BEFORE_CLOSE_PAREN;
                            continue block57;
                        }
                        --unmatchedCalcParen;
                        continue block57;
                    }
                    if ('(' != c) continue block57;
                    ++unmatchedCalcParen;
                    continue block57;
                }
                case IN_VALUE_DIGITS_AFTER_DOT: {
                    if ('0' == c) {
                        state = State.IN_VALUE_DIGITS_AFTER_DOT_TRAIL;
                        continue block57;
                    }
                    if ('1' <= c && '9' >= c) {
                        state = State.IN_VALUE_DIGITS_AFTER_DOT_TRAIL;
                        zero = false;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a digit but saw \u201c" + c + "\u201d instead.");
                }
                case IN_VALUE_DIGITS_AFTER_DOT_TRAIL: {
                    if ('0' == c) continue block57;
                    if ('1' <= c && '9' >= c) {
                        zero = false;
                        continue block57;
                    }
                    switch (valueExpectation) {
                        case LENGTH: 
                        case RESOLUTION: {
                            if ('a' <= c && 'z' >= c) {
                                sb.append(c);
                                state = State.IN_VALUE_UNIT;
                                continue block57;
                            }
                            if (this.isWhitespace(c) || c == ')') {
                                if (!zero) {
                                    if (valueExpectation == ValueType.LENGTH) {
                                        throw this.newDatatypeException(offset + i, "Non-zero lengths require a unit.");
                                    }
                                    throw this.newDatatypeException(offset + i, "Non-zero resolutions require a unit.");
                                }
                                if (c == ')') {
                                    state = State.AFTER_CLOSE_PAREN;
                                    continue block57;
                                }
                                state = State.WS_BEFORE_CLOSE_PAREN;
                                continue block57;
                            }
                            throw this.newDatatypeException(offset + i, "Expected a letter, a digit, whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                        }
                    }
                    throw new RuntimeException("Impossible state.");
                }
                case IN_VALUE_UNIT: {
                    String kw;
                    if ('a' <= c && 'z' >= c) {
                        sb.append(c);
                        continue block57;
                    }
                    if (this.isWhitespace(c) || c == ')') {
                        kw = sb.toString();
                        sb.setLength(0);
                        if (valueExpectation == ValueType.LENGTH) {
                            if (!this.isLengthUnit(kw)) {
                                throw this.newDatatypeException(offset + i, "Expected a length unit but saw \u201c" + c + "\u201d instead.");
                            }
                        } else if (!("dpi".equals(kw) || "dpcm".equals(kw) || "dppx".equals(kw) || "x".equals(kw))) {
                            throw this.newDatatypeException(offset + i, "Expected a resolution unit but saw \u201c" + c + "\u201d instead.");
                        }
                        if (c == ')') {
                            state = State.AFTER_CLOSE_PAREN;
                            continue block57;
                        }
                        state = State.WS_BEFORE_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a letter, a dot or a digit but saw \u201c" + c + "\u201d instead.");
                }
                case RATIO_SECOND_INTEGER_START: {
                    valueExpectation = ValueType.NONZEROINTEGER;
                    if (this.isWhitespace(c)) continue block57;
                    if ('1' <= c && '9' >= c) {
                        zero = false;
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    if ('0' == c) {
                        zero = true;
                        state = State.IN_VALUE_DIGITS;
                        continue block57;
                    }
                    if ('+' == c) {
                        state = State.IN_VALUE_BEFORE_DIGITS;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected a digit, whitespace or a plus sign for " + feature + " value but saw \u201c" + c + "\u201d instead.");
                }
                case AFTER_CLOSE_PAREN: {
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_AND;
                        continue block57;
                    }
                    if (')' == c) {
                        if (unmatchedParen == 1) {
                            unmatchedParen = -1;
                            continue block57;
                        }
                        --unmatchedParen;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected whitespace but saw \u201c" + c + "\u201d instead.");
                }
                case WS_BEFORE_CLOSE_PAREN: {
                    if (this.isWhitespace(c)) continue block57;
                    if (c == ')') {
                        state = State.AFTER_CLOSE_PAREN;
                        continue block57;
                    }
                    throw this.newDatatypeException(offset + i, "Expected whitespace or \u201c)\u201d but saw \u201c" + c + "\u201d instead.");
                }
            }
        }
        switch (state) {
            case WS_BEFORE_AND: 
            case AFTER_CLOSE_PAREN: {
                return warnings;
            }
            case IN_MEDIA_TYPE: {
                String kw = sb.toString();
                sb.setLength(0);
                if (this.isMediaCondition()) {
                    this.errNotMediaCondition(kw);
                }
                if (this.isMediaType(kw)) {
                    return warnings;
                }
                if (this.isOldMediaType(kw)) {
                    throw this.newDatatypeException("Deprecated media type \u201c" + kw + "\u201d. For guidance, see the Media Types section in the current Media Queries specification.");
                }
                throw this.newDatatypeException("Expected a CSS media type but the query ended.");
            }
        }
        throw this.newDatatypeException("Media query ended prematurely.");
    }

    private boolean isMediaFeature(String feature) {
        return FEATURES_TO_VALUE_TYPES.containsKey(feature);
    }

    private boolean isOldMediaFeature(String type) {
        return OLD_MEDIA_FEATURES.contains(type);
    }

    private ValueType valueExpectationFor(String feature) {
        return FEATURES_TO_VALUE_TYPES.get(feature);
    }

    private ValueType nonstandardValueExpectationFor(String feature) {
        return NONSTANDARD_FEATURES_TO_VALUE_TYPES.get(feature);
    }

    private boolean isMediaType(String type) {
        return MEDIA_TYPES.contains(type);
    }

    private boolean isOldMediaType(String type) {
        return OLD_MEDIA_TYPES.contains(type);
    }

    private boolean isLengthUnit(String unit) {
        return LENGTH_UNITS.contains(unit);
    }

    private List<String> checkApplicability(int index, String feature, String type, List<String> warnings) throws DatatypeException {
        if (!this.isMediaType(type)) {
            return warnings;
        }
        if (this.isOldMediaFeature(feature)) {
            throw this.newDatatypeException(index, "Deprecated media feature \u201c" + feature + "\u201d. For guidance, see the Deprecated Media Features section in the current Media Queries specification.");
        }
        if (!this.isMediaFeature(feature)) {
            throw this.newDatatypeException(index, "Expected a CSS media feature but saw \u201c" + feature + "\u201d instead.");
        }
        switch (MediaType.toCaps(type)) {
            case SPEECH: {
                warnings.add("The media feature \u201c" + feature + "\u201d is not applicable to the media type \u201cspeech\u201d.");
                return warnings;
            }
        }
        return warnings;
    }

    private void errNotMediaCondition(String type) throws DatatypeException {
        if (this.isMediaType(type) || this.isOldMediaType(type)) {
            throw this.newDatatypeException("Expected a CSS media condition but saw CSS media type ", type, " instead.");
        }
        throw this.newDatatypeException("Expected a CSS media condition but saw ", type, " instead.");
    }

    private void checkIfValueRequired(int index, String feature) throws DatatypeException {
        if (feature.startsWith("min-") || feature.startsWith("max-")) {
            throw this.newDatatypeException(index, "Expected a value for the media feature \u201c" + feature + "\u201d.");
        }
    }

    protected boolean isMediaCondition() {
        return false;
    }

    @Override
    public String getName() {
        return "media query";
    }

    static {
        LENGTH_UNITS.add("em");
        LENGTH_UNITS.add("ex");
        LENGTH_UNITS.add("px");
        LENGTH_UNITS.add("gd");
        LENGTH_UNITS.add("rem");
        LENGTH_UNITS.add("vw");
        LENGTH_UNITS.add("vh");
        LENGTH_UNITS.add("vm");
        LENGTH_UNITS.add("ch");
        LENGTH_UNITS.add("in");
        LENGTH_UNITS.add("cm");
        LENGTH_UNITS.add("mm");
        LENGTH_UNITS.add("pt");
        LENGTH_UNITS.add("pc");
        MEDIA_TYPES = new HashSet<String>();
        MEDIA_TYPES.add("all");
        MEDIA_TYPES.add("print");
        MEDIA_TYPES.add("screen");
        MEDIA_TYPES.add("speech");
        OLD_MEDIA_TYPES = new HashSet<String>();
        OLD_MEDIA_TYPES.add("aural");
        OLD_MEDIA_TYPES.add("braille");
        OLD_MEDIA_TYPES.add("embossed");
        OLD_MEDIA_TYPES.add("handheld");
        OLD_MEDIA_TYPES.add("projection");
        OLD_MEDIA_TYPES.add("tty");
        OLD_MEDIA_TYPES.add("tv");
        OLD_MEDIA_FEATURES = new HashSet<String>();
        OLD_MEDIA_FEATURES.add("device-width");
        OLD_MEDIA_FEATURES.add("min-device-width");
        OLD_MEDIA_FEATURES.add("max-device-width");
        OLD_MEDIA_FEATURES.add("device-height");
        OLD_MEDIA_FEATURES.add("min-device-height");
        OLD_MEDIA_FEATURES.add("max-device-height");
        OLD_MEDIA_FEATURES.add("device-aspect-ratio");
        OLD_MEDIA_FEATURES.add("min-device-aspect-ratio");
        OLD_MEDIA_FEATURES.add("max-device-aspect-ratio");
        FEATURES_TO_VALUE_TYPES = new HashMap<String, ValueType>();
        FEATURES_TO_VALUE_TYPES.put("width", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("min-width", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("max-width", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("height", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("min-height", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("max-height", ValueType.LENGTH);
        FEATURES_TO_VALUE_TYPES.put("aspect-ratio", ValueType.RATIO);
        FEATURES_TO_VALUE_TYPES.put("min-aspect-ratio", ValueType.RATIO);
        FEATURES_TO_VALUE_TYPES.put("max-aspect-ratio", ValueType.RATIO);
        FEATURES_TO_VALUE_TYPES.put("color", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("min-color", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("max-color", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("color-index", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("min-color-index", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("max-color-index", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("monochrome", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("min-monochrome", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("max-monochrome", ValueType.INTEGER);
        FEATURES_TO_VALUE_TYPES.put("resolution", ValueType.RESOLUTION);
        FEATURES_TO_VALUE_TYPES.put("min-resolution", ValueType.RESOLUTION);
        FEATURES_TO_VALUE_TYPES.put("max-resolution", ValueType.RESOLUTION);
        FEATURES_TO_VALUE_TYPES.put("scan", ValueType.SCAN);
        FEATURES_TO_VALUE_TYPES.put("orientation", ValueType.ORIENTATION);
        FEATURES_TO_VALUE_TYPES.put("grid", ValueType.ONEORZERO);
        FEATURES_TO_VALUE_TYPES.put("hover", ValueType.HOVER);
        FEATURES_TO_VALUE_TYPES.put("any-hover", ValueType.ANYHOVER);
        FEATURES_TO_VALUE_TYPES.put("pointer", ValueType.POINTER);
        FEATURES_TO_VALUE_TYPES.put("any-pointer", ValueType.ANYPOINTER);
        NONSTANDARD_FEATURES_TO_VALUE_TYPES = new HashMap<String, ValueType>();
        NONSTANDARD_FEATURES_TO_VALUE_TYPES.put("-webkit-min-device-pixel-ratio", ValueType.INTEGER);
    }

    private static enum MediaType {
        ALL,
        PRINT,
        SCREEN,
        SPEECH,
        INVALID;


        private static MediaType toCaps(String str) {
            try {
                return MediaType.valueOf(AbstractDatatype.toAsciiUpperCase(str));
            }
            catch (Exception ex) {
                return INVALID;
            }
        }
    }

    private static enum ValueType {
        LENGTH,
        RATIO,
        INTEGER,
        RESOLUTION,
        SCAN,
        ORIENTATION,
        NONZEROINTEGER,
        ONEORZERO,
        HOVER,
        ANYHOVER,
        POINTER,
        ANYPOINTER;

    }

    private static enum State {
        INITIAL_WS,
        OPEN_PAREN_SEEN,
        IN_ONLY_OR_NOT,
        IN_MEDIA_TYPE,
        IN_MEDIA_FEATURE,
        WS_BEFORE_MEDIA_TYPE,
        WS_BEFORE_MEDIA_FEATURE,
        WS_BEFORE_AND,
        IN_AND,
        WS_BEFORE_EXPRESSION,
        WS_BEFORE_COLON,
        WS_BEFORE_VALUE,
        IN_VALUE_DIGITS,
        BEFORE_CALC_OPEN_PAREN,
        IN_CALC,
        IN_VALUE_SCAN,
        IN_VALUE_ORIENTATION,
        WS_BEFORE_CLOSE_PAREN,
        IN_VALUE_UNIT,
        IN_VALUE_DIGITS_AFTER_DOT,
        RATIO_SECOND_INTEGER_START,
        IN_VALUE_BEFORE_DIGITS,
        IN_VALUE_DIGITS_AFTER_DOT_TRAIL,
        AFTER_CLOSE_PAREN,
        IN_VALUE_ONEORZERO,
        IN_VALUE_HOVER,
        IN_VALUE_ANYHOVER,
        IN_VALUE_POINTER,
        IN_VALUE_ANYPOINTER;

    }
}

