/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.model.Command;

public class NoranProtocolEncoder
extends BaseProtocolEncoder {
    private ByteBuf encodeContent(String content) {
        ByteBuf buf = Unpooled.buffer((int)68);
        buf.writeCharSequence((CharSequence)"\r\n*KW", StandardCharsets.US_ASCII);
        buf.writeByte(0);
        buf.writeShortLE(buf.capacity());
        buf.writeShortLE(2);
        buf.writeInt(0);
        buf.writeShortLE(0);
        buf.writeBytes(content.getBytes(StandardCharsets.US_ASCII));
        buf.writerIndex(buf.writerIndex() + 50 - content.length());
        buf.writeCharSequence((CharSequence)"\r\n", StandardCharsets.US_ASCII);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "positionSingle": {
                return this.encodeContent("*KW,000,000,000000#");
            }
            case "positionPeriodic": {
                int interval = command.getInteger("frequency");
                return this.encodeContent("*KW,000,002,000000," + interval + "#");
            }
            case "positionStop": {
                return this.encodeContent("*KW,000,002,000000,0#");
            }
            case "engineStop": {
                return this.encodeContent("*KW,000,007,000000,0#");
            }
            case "engineResume": {
                return this.encodeContent("*KW,000,007,000000,1#");
            }
        }
        return null;
    }
}

