/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class GoSafeProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*GS").number("d+,").number("(d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([^#]*)#?").compile();
    private static final Pattern PATTERN_OLD = new PatternBuilder().text("*GS").number("d+,").number("(d+),").text("GPS:").number("(dd)(dd)(dd);").number("d;").optional().expression("([AV]);").number("([NS])(d+.d+);").number("([EW])(d+.d+);").number("(d+)?;").number("(d+);").number("(d+.?d*)").optional().number("(dd)(dd)(dd)").any().compile();

    public GoSafeProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeFragment(Position position, String fragment) {
        int dataIndex = fragment.indexOf(58);
        int index = 0;
        String[] values = fragment.length() == dataIndex + 1 ? new String[]{} : fragment.substring(dataIndex + 1).split(";");
        switch (fragment.substring(0, dataIndex)) {
            case "GPS": {
                position.setValid(values[index++].equals("A"));
                position.set("sat", Integer.parseInt(values[index++]));
                position.setLatitude(Double.parseDouble(values[index].substring(1)));
                if (values[index++].charAt(0) == 'S') {
                    position.setLatitude(-position.getLatitude());
                }
                position.setLongitude(Double.parseDouble(values[index].substring(1)));
                if (values[index++].charAt(0) == 'W') {
                    position.setLongitude(-position.getLongitude());
                }
                if (!values[index++].isEmpty()) {
                    position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(values[index - 1])));
                }
                position.setCourse(Integer.parseInt(values[index++]));
                if (index < values.length) {
                    position.setAltitude(Integer.parseInt(values[index++]));
                }
                if (index < values.length) {
                    position.set("hdop", Double.parseDouble(values[index++]));
                }
                if (index >= values.length) break;
                position.set("vdop", Double.parseDouble(values[index++]));
                break;
            }
            case "GSM": {
                ++index;
                int n = ++index;
                int n2 = ++index;
                int n3 = ++index;
                int n4 = ++index;
                int n5 = ++index;
                ++index;
                position.setNetwork(new Network(CellTower.from(Integer.parseInt(values[n]), Integer.parseInt(values[n2]), Integer.parseInt(values[n3], 16), Integer.parseInt(values[n4], 16), Integer.parseInt(values[n5]))));
                break;
            }
            case "COT": {
                if (index < values.length) {
                    position.set("odometer", Long.parseLong(values[index++]));
                }
                if (index >= values.length) break;
                String[] hours = values[index].split("-");
                position.set("hours", (Integer.parseInt(hours[0]) * 3600 + (hours.length > 1 ? Integer.parseInt(hours[1]) * 60 : 0) + (hours.length > 2 ? Integer.parseInt(hours[2]) : 0)) * 1000);
                break;
            }
            case "ADC": {
                position.set("power", Double.parseDouble(values[index++]));
                if (index < values.length) {
                    position.set("battery", Double.parseDouble(values[index++]));
                }
                if (index < values.length) {
                    position.set("adc1", Double.parseDouble(values[index++]));
                }
                if (index >= values.length) break;
                position.set("adc2", Double.parseDouble(values[index++]));
                break;
            }
            case "DTT": {
                position.set("status", Integer.parseInt(values[index++], 16));
                if (!values[index++].isEmpty()) {
                    int io = Integer.parseInt(values[index - 1], 16);
                    position.set("ignition", BitUtil.check(io, 0));
                    position.set("in1", BitUtil.check(io, 1));
                    position.set("in2", BitUtil.check(io, 2));
                    position.set("in3", BitUtil.check(io, 3));
                    position.set("in4", BitUtil.check(io, 4));
                    position.set("out1", BitUtil.check(io, 5));
                    position.set("out2", BitUtil.check(io, 6));
                    position.set("out3", BitUtil.check(io, 7));
                }
                position.set("geofence", values[index++] + values[index++]);
                position.set("eventStatus", values[index++]);
                if (index >= values.length) break;
                position.set("packetType", values[index++]);
                break;
            }
            case "ETD": {
                position.set("eventData", values[index++]);
                break;
            }
            case "OBD": {
                position.set("obd", values[index++]);
                break;
            }
            case "TAG": {
                position.set("tagData", values[index++]);
                break;
            }
            case "IWD": {
                if (index >= values.length || !values[index + 1].equals("0")) break;
                position.set("driverUniqueId", values[index + 2]);
                break;
            }
        }
    }

    private Object decodeData(DeviceSession deviceSession, Date time, String data) {
        LinkedList<Position> positions = new LinkedList<Position>();
        Position position = null;
        int index = 0;
        String[] fragments = data.split(",");
        while (index < fragments.length) {
            if (fragments[index].isEmpty() || Character.isDigit(fragments[index].charAt(0))) {
                if (position != null) {
                    positions.add(position);
                }
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setTime(time);
                if (fragments[index++].isEmpty()) continue;
                position.set("event", Integer.parseInt(fragments[index - 1]));
                continue;
            }
            this.decodeFragment(position, fragments[index++]);
        }
        if (position != null) {
            positions.add(position);
        }
        return positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("1234", remoteAddress));
        }
        String sentence = (String)msg;
        Pattern pattern = PATTERN;
        if (sentence.startsWith("*GS02")) {
            pattern = PATTERN_OLD;
        }
        if (!(parser = new Parser(pattern, (String)msg)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        if (pattern == PATTERN_OLD) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setValid(parser.next().equals("A"));
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.setCourse(parser.nextDouble(0.0));
            position.set("hdop", parser.next());
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
            return position;
        }
        Date time = new Date();
        if (parser.hasNext(6)) {
            time = parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY);
        }
        return this.decodeData(deviceSession, time, parser.next());
    }
}

