/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) * dmat4x2(1.81lf, -1.16lf, -0.87lf, -1.52lf, 0.81lf, 0.25lf, 0.65lf, -1.51lf)) => dvec4(1.2109999999999999lf, 1.911lf, -0.381lf, 1.7469999999999999lf)
 * (dvec2(-0.1lf, -1.2lf) * dmat4x2(1.93lf, 0.49lf, -1.63lf, 0.27lf, 0.29lf, 0.14lf, 1.6lf, 0.94lf)) => dvec4(-0.781lf, -0.161lf, -0.197lf, -1.2879999999999998lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat4x2(1.81lf, -1.16lf, -0.87lf, -1.52lf, 0.81lf, 0.25lf, 0.65lf, -1.51lf)) => dvec4(-1.317lf, -0.3642lf, -0.2202lf, -0.9978lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat4x2(1.93lf, 0.49lf, -1.63lf, 0.27lf, 0.29lf, 0.14lf, 1.6lf, 0.94lf)) => dvec4(-0.5753999999999999lf, 0.8141999999999999lf, -0.05459999999999998lf, -0.22080000000000005lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat4x2(1.81lf, -1.16lf, -0.87lf, -1.52lf, 0.81lf, 0.25lf, 0.65lf, -1.51lf)), dvec4(1.2109999999999999lf, 1.911lf, -0.381lf, 1.7469999999999999lf)) <= 2.883680287410517e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat4x2(1.93lf, 0.49lf, -1.63lf, 0.27lf, 0.29lf, 0.14lf, 1.6lf, 0.94lf)), dvec4(-0.781lf, -0.161lf, -0.197lf, -1.2879999999999998lf)) <= 1.5276239720559508e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat4x2(1.81lf, -1.16lf, -0.87lf, -1.52lf, 0.81lf, 0.25lf, 0.65lf, -1.51lf)), dvec4(-1.317lf, -0.3642lf, -0.2202lf, -0.9978lf)) <= 1.7062307932984918e-05lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat4x2(1.93lf, 0.49lf, -1.63lf, 0.27lf, 0.29lf, 0.14lf, 1.6lf, 0.94lf)), dvec4(-0.5753999999999999lf, 0.8141999999999999lf, -0.05459999999999998lf, -0.22080000000000005lf)) <= 1.0226145901560371e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
