/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf + dvec2(-0.1lf, -1.2lf)) => dvec2(-0.1lf, -1.2lf)
 * (0.0lf + dvec2(-0.42lf, 0.48lf)) => dvec2(-0.42lf, 0.48lf)
 * (-1.3333333333333333lf + dvec2(-0.1lf, -1.2lf)) => dvec2(-1.4333333333333333lf, -2.533333333333333lf)
 * (-1.3333333333333333lf + dvec2(-0.42lf, 0.48lf)) => dvec2(-1.7533333333333332lf, -0.8533333333333333lf)
 * (0.85lf + dvec2(-0.1lf, -1.2lf)) => dvec2(0.75lf, -0.35lf)
 * (0.85lf + dvec2(-0.42lf, 0.48lf)) => dvec2(0.43lf, 1.33lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf + dvec2(-0.1lf, -1.2lf)), dvec2(-0.1lf, -1.2lf)) <= 1.2041594578792297e-05lf ? 1 : -1] array0;
  double[distance((0.0lf + dvec2(-0.42lf, 0.48lf)), dvec2(-0.42lf, 0.48lf)) <= 6.378087487640791e-06lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf + dvec2(-0.1lf, -1.2lf)), dvec2(-1.4333333333333333lf, -2.533333333333333lf)) <= 2.9107081994288303e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf + dvec2(-0.42lf, 0.48lf)), dvec2(-1.7533333333333332lf, -0.8533333333333333lf)) <= 1.9499629626112275e-05lf ? 1 : -1] array3;
  double[distance((0.85lf + dvec2(-0.1lf, -1.2lf)), dvec2(0.75lf, -0.35lf)) <= 8.276472678623425e-06lf ? 1 : -1] array4;
  double[distance((0.85lf + dvec2(-0.42lf, 0.48lf)), dvec2(0.43lf, 1.33lf)) <= 1.397783960417346e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
