/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import javax.servlet.SessionCookieConfig;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.DefaultSessionManager;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.ServletHandler;

public class ServletSessionManager
implements SessionManager {
    private final SessionManager defaultManager = DefaultSessionManager.instance();
    private String sessionCookieName = "JSESSIONID";

    public static SessionManager instance() {
        return LazyHolder.INSTANCE;
    }

    private ServletSessionManager() {
    }

    @Override
    public Session getSession(Request request, String requestedSessionId) {
        return this.defaultManager.getSession(request, requestedSessionId);
    }

    @Override
    public Session createSession(Request request) {
        return this.defaultManager.createSession(request);
    }

    @Override
    public String changeSessionId(Request request, Session session) {
        return this.defaultManager.changeSessionId(request, session);
    }

    @Override
    public void configureSessionCookie(Request request, Cookie cookie) {
        this.defaultManager.configureSessionCookie(request, cookie);
        HttpServletRequestImpl servletRequest = ServletHandler.getServletRequest(request);
        assert (servletRequest != null);
        SessionCookieConfig cookieConfig = servletRequest.getContextImpl().getSessionCookieConfig();
        if (cookieConfig.getDomain() != null) {
            cookie.setDomain(cookieConfig.getDomain());
        }
        if (cookieConfig.getPath() != null) {
            cookie.setPath(cookieConfig.getPath());
        }
        if (cookieConfig.getComment() != null) {
            cookie.setVersion(1);
            cookie.setComment(cookieConfig.getComment());
        }
        cookie.setSecure(cookieConfig.isSecure());
        cookie.setHttpOnly(cookieConfig.isHttpOnly());
        cookie.setMaxAge(cookieConfig.getMaxAge());
    }

    @Override
    public void setSessionCookieName(String name) {
        if (name != null && !name.isEmpty()) {
            this.sessionCookieName = name;
        }
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    private static class LazyHolder {
        private static final ServletSessionManager INSTANCE = new ServletSessionManager();

        private LazyHolder() {
        }
    }
}

