/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.compliance.HardwareRule;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Property;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class CheckGroupSoftwareTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(CheckGroupSoftwareTask.class);
    private DeviceGroup deviceGroup;

    public CheckGroupSoftwareTask() {
    }

    public CheckGroupSoftwareTask(DeviceGroup group, String comments, String author) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group software compliance and hardware support check";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CheckGroupSoftwareTask task = (CheckGroupSoftwareTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting check software compliance and hardware support status task for group {}.", (Object)this.deviceGroup.getId());
        this.trace(String.format("Check software compliance task for group %s.", this.deviceGroup.getName()));
        try (Session session = Database.getSession();){
            logger.debug("Retrieving the software rules");
            List softwareRules = session.createCriteria(SoftwareRule.class).addOrder(Property.forName("priority").asc()).list();
            logger.debug("Retrieving the hardware rules");
            List hardwareRules = session.createCriteria(HardwareRule.class).list();
            session.beginTransaction();
            ScrollableResults devices = session.createQuery("select d from DeviceGroup g join g.cachedDevices d where g.id = :id").setLong("id", this.deviceGroup.getId()).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
            while (devices.next()) {
                Device device = (Device)devices.get(0);
                device.setSoftwareLevel(SoftwareRule.ConformanceLevel.UNKNOWN);
                for (Object rule : softwareRules) {
                    ((SoftwareRule)rule).check(device);
                    if (device.getSoftwareLevel() == SoftwareRule.ConformanceLevel.UNKNOWN) continue;
                    break;
                }
                device.resetEoX();
                for (Object rule : hardwareRules) {
                    ((HardwareRule)rule).check(device);
                }
                session.save(device);
                session.flush();
                session.evict(device);
            }
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("CheckGroupSoftware_%d", this.getDeviceGroup().getId()));
    }
}

