/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Transient;
import javax.script.ScriptException;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Snmp;
import onl.netfishers.netshot.device.access.Ssh;
import onl.netfishers.netshot.device.access.Telnet;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSshAccount;
import onl.netfishers.netshot.device.credentials.DeviceSshKeyAccount;
import onl.netfishers.netshot.device.credentials.DeviceTelnetAccount;
import onl.netfishers.netshot.work.TaskLogger;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CliScript {
    private static Logger logger = LoggerFactory.getLogger(CliScript.class);
    protected transient List<String> jsLog = new ArrayList<String>();
    protected transient List<String> cliLog;

    protected CliScript(boolean cliLogging) {
        if (cliLogging) {
            this.cliLog = new ArrayList<String>();
        }
    }

    @Transient
    public String getPlainJsLog() {
        StringBuffer buffer = new StringBuffer();
        for (String log : this.jsLog) {
            buffer.append(log);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Transient
    public String getPlainCliLog() {
        if (this.cliLog == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (String log : this.cliLog) {
            buffer.append(log);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Transient
    public List<String> getJsLog() {
        return this.jsLog;
    }

    protected TaskLogger getJsLogger() {
        return new TaskLogger(){

            @Override
            public void warn(String message) {
                CliScript.this.jsLog.add(String.format("[DEBUG] %s", message));
            }

            @Override
            public void trace(String message) {
                CliScript.this.jsLog.add(String.format("[TRACE] %s", message));
            }

            @Override
            public void info(String message) {
                CliScript.this.jsLog.add(String.format("[INFO] %s", message));
            }

            @Override
            public void error(String message) {
                CliScript.this.jsLog.add(String.format("[ERROR] %s", message));
            }

            @Override
            public void debug(String message) {
                CliScript.this.jsLog.add(String.format("[DEBUG] %s", message));
            }
        };
    }

    protected TaskLogger getCliLogger() {
        if (this.cliLog == null) {
            return null;
        }
        return new TaskLogger(){

            @Override
            public void warn(String message) {
                CliScript.this.cliLog.add(message);
            }

            @Override
            public void trace(String message) {
                CliScript.this.cliLog.add(message);
            }

            @Override
            public void info(String message) {
                CliScript.this.cliLog.add(message);
            }

            @Override
            public void error(String message) {
                CliScript.this.cliLog.add(message);
            }

            @Override
            public void debug(String message) {
                CliScript.this.cliLog.add(message);
            }
        };
    }

    protected abstract void run(Session var1, Device var2, Cli var3, Snmp var4, DeviceDriver.DriverProtocol var5, DeviceCredentialSet var6) throws Device.InvalidCredentialsException, IOException, ScriptException, Device.MissingDeviceDriverException;

    public void connectRun(Session session, Device device) throws IOException, Device.MissingDeviceDriverException, Device.InvalidCredentialsException, ScriptException, Device.MissingDeviceDriverException {
        this.connectRun(session, device, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectRun(Session session, Device device, Set<DeviceCredentialSet> oneTimeCredentialSets) throws IOException, Device.MissingDeviceDriverException, Device.InvalidCredentialsException, ScriptException, Device.MissingDeviceDriverException {
        Cli cli;
        Set<DeviceCredentialSet> credentialSets;
        DeviceDriver deviceDriver = device.getDeviceDriver();
        boolean sshOpened = deviceDriver.getProtocols().contains((Object)DeviceDriver.DriverProtocol.SSH);
        boolean telnetOpened = deviceDriver.getProtocols().contains((Object)DeviceDriver.DriverProtocol.TELNET);
        boolean snmpWorth = deviceDriver.getProtocols().contains((Object)DeviceDriver.DriverProtocol.SNMP);
        TaskLogger taskLogger = this.getJsLogger();
        Network4Address address = device.getConnectAddress();
        if (address == null) {
            address = device.getMgmtAddress();
        }
        if ((credentialSets = oneTimeCredentialSets) == null) {
            credentialSets = device.getCredentialSets();
        }
        if (device.getSpecificCredentialSet() != null) {
            credentialSets = new HashSet<DeviceCredentialSet>();
            credentialSets.add(device.getSpecificCredentialSet());
        }
        int sshPort = device.getSshPort();
        int telnetPort = device.getTelnetPort();
        if (sshOpened) {
            for (DeviceCredentialSet credentialSet : credentialSets) {
                if (!(credentialSet instanceof DeviceSshAccount)) continue;
                cli = credentialSet instanceof DeviceSshKeyAccount ? new Ssh(address, sshPort, ((DeviceSshKeyAccount)credentialSet).getUsername(), ((DeviceSshKeyAccount)credentialSet).getPublicKey(), ((DeviceSshKeyAccount)credentialSet).getPrivateKey(), ((DeviceSshKeyAccount)credentialSet).getPassword(), taskLogger) : new Ssh(address, sshPort, ((DeviceSshAccount)credentialSet).getUsername(), ((DeviceSshAccount)credentialSet).getPassword(), taskLogger);
                try {
                    cli.connect();
                    this.run(session, device, cli, null, DeviceDriver.DriverProtocol.SSH, (DeviceCliAccount)credentialSet);
                    return;
                }
                catch (Device.InvalidCredentialsException e) {
                    taskLogger.warn(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()));
                }
                catch (ScriptException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn("Unable to open an SSH connection to {}:{}.", address.getIp(), sshPort, e);
                    if (e.getMessage().contains("Auth fail")) {
                        taskLogger.warn(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()));
                        continue;
                    }
                    taskLogger.warn("Unable to open an SSH socket to the device.");
                    sshOpened = false;
                    break;
                }
                finally {
                    cli.disconnect();
                }
            }
        }
        if (telnetOpened) {
            for (DeviceCredentialSet credentialSet : credentialSets) {
                if (!(credentialSet instanceof DeviceTelnetAccount)) continue;
                cli = new Telnet(address, telnetPort, taskLogger);
                try {
                    cli.connect();
                    this.run(session, device, cli, null, DeviceDriver.DriverProtocol.TELNET, (DeviceCliAccount)credentialSet);
                    return;
                }
                catch (Device.InvalidCredentialsException e) {
                    taskLogger.warn(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()));
                }
                catch (ScriptException e) {
                    throw e;
                }
                catch (IOException e) {
                    logger.warn("Unable to open a Telnet connection to {}:{}.", address.getIp(), telnetPort, e);
                    taskLogger.warn("Unable to open a Telnet socket to the device.");
                    telnetOpened = false;
                    break;
                }
                finally {
                    cli.disconnect();
                }
            }
        }
        if (snmpWorth) {
            for (DeviceCredentialSet credentialSet : credentialSets) {
                if (!(credentialSet instanceof DeviceSnmpCommunity)) continue;
                Snmp poller = new Snmp(address, (DeviceSnmpCommunity)credentialSet);
                try {
                    block68: {
                        try {
                            poller.getAsString("1.3.6.1.2.1.1.3.0");
                        }
                        catch (IOException e1) {
                            if (e1.getMessage().contains("noSuchObject")) break block68;
                            throw e1;
                        }
                    }
                    this.run(session, device, null, poller, DeviceDriver.DriverProtocol.SNMP, credentialSet);
                    return;
                }
                catch (IOException e) {
                    logger.warn("Unable to poll {} using SNMP credential set {}", (Object)address.getIp(), (Object)credentialSet.getName());
                    taskLogger.warn("Unable to poll " + address.getIp() + " using SNMP credential set " + credentialSet.getName());
                }
                finally {
                    poller.stop();
                }
            }
        }
        if (device.isAutoTryCredentials() && (sshOpened || telnetOpened || snmpWorth)) {
            Iterator<DeviceCredentialSet> ci;
            Cli cli2;
            List<DeviceCredentialSet> globalCredentialSets = device.getAutoCredentialSetList(session);
            if (sshOpened) {
                for (DeviceCredentialSet credentialSet : globalCredentialSets) {
                    if (!(credentialSet instanceof DeviceSshAccount)) continue;
                    taskLogger.trace(String.format("Will try SSH credentials %s.", credentialSet.getName()));
                    cli2 = credentialSet instanceof DeviceSshKeyAccount ? new Ssh(address, sshPort, ((DeviceSshKeyAccount)credentialSet).getUsername(), ((DeviceSshKeyAccount)credentialSet).getPublicKey(), ((DeviceSshKeyAccount)credentialSet).getPrivateKey(), ((DeviceSshKeyAccount)credentialSet).getPassword(), taskLogger) : new Ssh(address, sshPort, ((DeviceSshAccount)credentialSet).getUsername(), ((DeviceSshAccount)credentialSet).getPassword(), taskLogger);
                    try {
                        cli2.connect();
                        this.run(session, device, cli2, null, DeviceDriver.DriverProtocol.SSH, (DeviceCliAccount)credentialSet);
                        ci = credentialSets.iterator();
                        while (ci.hasNext()) {
                            DeviceCredentialSet c = ci.next();
                            if (!(c instanceof DeviceCliAccount)) continue;
                            ci.remove();
                        }
                        credentialSets.add(credentialSet);
                        return;
                    }
                    catch (Device.InvalidCredentialsException e) {
                        taskLogger.warn(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()));
                    }
                    catch (ScriptException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to open an SSH connection to {}:{}.", address.getIp(), sshPort, e);
                        if (e.getMessage().contains("Auth fail") || e.getMessage().contains("authentication failure")) {
                            taskLogger.warn(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()));
                            continue;
                        }
                        taskLogger.warn("Unable to open an SSH socket to the device.");
                        break;
                    }
                    finally {
                        cli2.disconnect();
                    }
                }
            }
            if (telnetOpened) {
                for (DeviceCredentialSet credentialSet : globalCredentialSets) {
                    if (!(credentialSet instanceof DeviceTelnetAccount)) continue;
                    taskLogger.trace(String.format("Will try Telnet credentials %s.", credentialSet.getName()));
                    cli2 = new Telnet(address, telnetPort, taskLogger);
                    try {
                        cli2.connect();
                        this.run(session, device, cli2, null, DeviceDriver.DriverProtocol.TELNET, (DeviceCliAccount)credentialSet);
                        ci = credentialSets.iterator();
                        while (ci.hasNext()) {
                            DeviceCredentialSet c = ci.next();
                            if (!(c instanceof DeviceCliAccount)) continue;
                            ci.remove();
                        }
                        credentialSets.add(credentialSet);
                        return;
                    }
                    catch (Device.InvalidCredentialsException e) {
                        taskLogger.warn(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()));
                    }
                    catch (ScriptException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to open a Telnet connection to {}:{}.", address.getIp(), telnetPort, e);
                        taskLogger.warn("Unable to open a Telnet socket to the device.");
                        telnetOpened = false;
                        break;
                    }
                    finally {
                        cli2.disconnect();
                    }
                }
            }
            if (snmpWorth) {
                for (DeviceCredentialSet credentialSet : globalCredentialSets) {
                    if (!(credentialSet instanceof DeviceSnmpCommunity)) continue;
                    taskLogger.trace(String.format("Will try SNMP credentials %s.", credentialSet.getName()));
                    Snmp poller = new Snmp(address, (DeviceSnmpCommunity)credentialSet);
                    try {
                        block69: {
                            try {
                                poller.getAsString("1.3.6.1.2.1.1.3.0");
                            }
                            catch (IOException e1) {
                                if (e1.getMessage().contains("noSuchObject")) break block69;
                                throw e1;
                            }
                        }
                        this.run(session, device, null, poller, DeviceDriver.DriverProtocol.SNMP, credentialSet);
                        ci = credentialSets.iterator();
                        while (ci.hasNext()) {
                            DeviceCredentialSet c = ci.next();
                            if (!(c instanceof DeviceSnmpCommunity)) continue;
                            ci.remove();
                        }
                        credentialSets.add(credentialSet);
                        return;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to poll {} using SNMP credential set {}", (Object)address.getIp(), (Object)credentialSet.getName());
                        taskLogger.warn("Unable to poll " + address.getIp() + " using SNMP credential set " + credentialSet.getName());
                        break;
                    }
                    finally {
                        poller.stop();
                    }
                }
            }
        }
        if (!sshOpened && !telnetOpened) {
            throw new IOException("Couldn't open either SSH or Telnet socket with the device.");
        }
        throw new Device.InvalidCredentialsException("Couldn't find valid credentials.");
    }
}

