/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.collector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.collector.Collector;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.NetworkAddress;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TftpServer
extends Collector {
    private int udpPort = 69;
    private TFTP tftp;
    private Set<TftpTransfer> transfers = new HashSet<TftpTransfer>();
    private static Logger logger = LoggerFactory.getLogger(TftpServer.class);
    private static TftpServer nsTftpServer = null;
    private static boolean running = false;

    public static boolean isRunning() {
        return running;
    }

    public static void init() {
        if (Netshot.getConfig("netshot.tftpserver.disabled", "true").equals("true")) {
            logger.warn("The TFTP server is disabled.");
            return;
        }
        nsTftpServer = new TftpServer();
        nsTftpServer.start();
    }

    public static TftpServer getServer() {
        return nsTftpServer;
    }

    public TftpServer() {
        this.setName("TFTP Server");
        this.setDaemon(true);
        String port = Netshot.getConfig("netshot.tftpserver.port");
        if (port != null) {
            this.udpPort = Integer.parseInt(port);
        }
        this.tftp = new TFTP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.tftp.setDefaultTimeout(0);
            this.tftp.open(this.udpPort);
            logger.debug("Now listening for TFTP packets on UDP port {}.", (Object)this.udpPort);
            running = true;
            while (true) {
                try {
                    TFTPPacket packet;
                    while (!((packet = this.tftp.receive()) instanceof TFTPWriteRequestPacket)) {
                    }
                    TFTPWriteRequestPacket requestPacket = (TFTPWriteRequestPacket)packet;
                    Set<TftpTransfer> set = this.transfers;
                    synchronized (set) {
                        Iterator<TftpTransfer> transferIterator = this.transfers.iterator();
                        while (transferIterator.hasNext()) {
                            TftpTransfer transfer = transferIterator.next();
                            if (transfer.getStatus() != TftpTransfer.Status.PREPARED) {
                                transferIterator.remove();
                                continue;
                            }
                            if (!transfer.match(requestPacket)) continue;
                            transfer.setRequestPacket(requestPacket);
                        }
                        continue;
                    }
                }
                catch (Exception packet) {
                    continue;
                }
                break;
            }
        }
        catch (SocketException e) {
            logger.error("Couldn't start the TFTP server");
            running = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult(TftpTransfer transfer) throws TftpTransferException {
        try {
            transfer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (transfer.getStatus() == TftpTransfer.Status.TIMEDOUT) {
            throw new TftpTransferTimeoutException();
        }
        Set<TftpTransfer> set = this.transfers;
        synchronized (set) {
            this.transfers.remove(transfer);
        }
        return transfer.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TftpTransfer prepareTransfer(Network4Address source, String fileName, int timeout) {
        TftpTransfer transfer = new TftpTransfer(source, fileName, timeout);
        Set<TftpTransfer> set = this.transfers;
        synchronized (set) {
            this.transfers.add(transfer);
        }
        transfer.start();
        return transfer;
    }

    public static class TftpTransfer
    extends Thread {
        Network4Address source;
        String fileName;
        int threadTimeout;
        int receiveTimeout;
        long startTime = System.currentTimeMillis();
        private Status status = Status.PREPARED;
        private TFTPWriteRequestPacket requestPacket = null;
        OutputStream buffer = new ByteArrayOutputStream();
        TFTP tftp;

        public TftpTransfer(Network4Address source, String fileName, int timeout) {
            this.source = source;
            this.fileName = fileName;
            this.threadTimeout = timeout;
            this.receiveTimeout = timeout / 10;
        }

        public void setRequestPacket(TFTPWriteRequestPacket requestPacket) {
            this.requestPacket = requestPacket;
        }

        private TFTPPacket getPacket() throws InterruptedIOException, SocketException, IOException, TFTPPacketException {
            long maxTime = System.currentTimeMillis() + (long)(this.receiveTimeout * 1000);
            do {
                TFTPPacket packet;
                if (!(packet = this.tftp.bufferedReceive()).getAddress().equals(this.requestPacket.getAddress()) || packet.getPort() != this.requestPacket.getPort()) continue;
                return packet;
            } while (System.currentTimeMillis() <= maxTime);
            throw new SocketTimeoutException();
        }

        private String getData() {
            return this.buffer.toString();
        }

        private boolean checkTimeout() {
            if (System.currentTimeMillis() > this.startTime + (long)(this.threadTimeout * 1000)) {
                this.status = Status.TIMEDOUT;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            while (this.requestPacket == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.status = Status.ERROR;
                    return;
                }
                if (!this.checkTimeout()) continue;
                return;
            }
            this.status = Status.RUNNING;
            this.tftp = new TFTP();
            this.tftp.beginBufferedOps();
            this.tftp.setDefaultTimeout(this.receiveTimeout * 1000);
            try {
                this.tftp.open();
            }
            catch (SocketException e) {
                this.status = Status.ERROR;
                return;
            }
            TFTPPacket packet = this.requestPacket;
            TFTPAckPacket ackPacket = new TFTPAckPacket(packet.getAddress(), packet.getPort(), 0);
            while (packet instanceof TFTPWriteRequestPacket) {
                try {
                    this.tftp.bufferedSend(ackPacket);
                    packet = this.getPacket();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.checkTimeout()) continue;
                return;
            }
            int lastBlock = 0;
            while (packet instanceof TFTPDataPacket) {
                TFTPDataPacket dataPacket = (TFTPDataPacket)packet;
                int block = dataPacket.getBlockNumber();
                if (block > lastBlock || lastBlock == 65535 && block == 0) {
                    try {
                        this.buffer.write(dataPacket.getData(), dataPacket.getDataOffset(), dataPacket.getDataLength());
                    }
                    catch (IOException e) {
                        this.status = Status.ERROR;
                        return;
                    }
                }
                ackPacket = new TFTPAckPacket(this.requestPacket.getAddress(), this.requestPacket.getPort(), block);
                try {
                    this.tftp.bufferedSend(ackPacket);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (dataPacket.getDataLength() < 512) {
                    this.status = Status.FINISHED;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            packet = this.getPacket();
                            this.tftp.bufferedSend(ackPacket);
                            continue;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                }
                try {
                    packet = this.getPacket();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.checkTimeout()) continue;
                return;
            }
            this.status = Status.ERROR;
            this.tftp.close();
        }

        public boolean match(TFTPWriteRequestPacket packet) {
            String file2;
            if (this.status != Status.PREPARED) {
                return false;
            }
            try {
                NetworkAddress address = NetworkAddress.getNetworkAddress(packet.getAddress(), 0);
                if (!address.equals(this.source)) {
                    return false;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
            if (packet.getFilename() == null) {
                return false;
            }
            String file1 = this.fileName.replaceFirst("^/", "");
            return file1.equals(file2 = packet.getFilename().replaceFirst("^/", ""));
        }

        public Status getStatus() {
            return this.status;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TftpTransfer other = (TftpTransfer)obj;
            if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return this.startTime == other.startTime;
        }

        public static enum Status {
            PREPARED,
            RUNNING,
            FINISHED,
            TIMEDOUT,
            ERROR;

        }
    }

    public static class TftpTransferTimeoutException
    extends TftpTransferException {
        private static final long serialVersionUID = 399042520858415551L;
    }

    public static class TftpTransferException
    extends IOException {
        private static final long serialVersionUID = -3945635975316058776L;
    }
}

