/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.collector;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.collector.Collector;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;

public class SnmpTrapReceiver
extends Collector
implements CommandResponder {
    private static Logger logger = LoggerFactory.getLogger(SnmpTrapReceiver.class);
    private MultiThreadedMessageDispatcher dispatcher;
    private Snmp snmp = null;
    private UdpAddress listenAddress;
    private ThreadPool threadPool;
    private int udpPort = 162;
    private String community;
    private static SnmpTrapReceiver nsSnmpTrapReceiver;
    private static boolean running;

    public static boolean isRunning() {
        return running;
    }

    public static void init() {
        if (Netshot.getConfig("netshot.snmptrap.disabled", "false").equals("true")) {
            logger.warn("The SNMP trap receiver is disabled by configuration.");
            return;
        }
        nsSnmpTrapReceiver = new SnmpTrapReceiver();
        nsSnmpTrapReceiver.start();
    }

    public SnmpTrapReceiver() {
        this.setName("SNMP Receiver");
        this.setDaemon(true);
        String port = Netshot.getConfig("netshot.snmptrap.port");
        if (port != null) {
            this.udpPort = Integer.parseInt(port);
        }
        this.community = Netshot.getConfig("netshot.snmptrap.community", "NETSHOT");
    }

    @Override
    public void start() {
        try {
            running = true;
            this.threadPool = ThreadPool.create("SNMP Receiver Pool", 2);
            this.dispatcher = new MultiThreadedMessageDispatcher(this.threadPool, new MessageDispatcherImpl());
            this.listenAddress = new UdpAddress(this.udpPort);
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(this.listenAddress);
            this.snmp = new Snmp(this.dispatcher, transport);
            this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv1());
            this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
            this.snmp.listen();
            this.snmp.addCommandResponder(this);
            logger.debug("Now listening for SNMP traps on UDP port {}.", (Object)this.udpPort);
        }
        catch (IOException e) {
            logger.error("I/O error with the SNMP trap receiver.", e);
            running = false;
        }
    }

    @Override
    public void processPdu(CommandResponderEvent event) {
        logger.trace("Incoming SNMP message from {}.", (Object)event.getPeerAddress());
        if (event.getSecurityLevel() == 1 && (event.getSecurityModel() == 1 || event.getSecurityModel() == 2)) {
            String community = new String(event.getSecurityName());
            if (this.community.equals(community)) {
                InetAddress inetAddress;
                Address address = event.getPeerAddress();
                if (address instanceof IpAddress && (inetAddress = ((IpAddress)address).getInetAddress()) instanceof Inet4Address) {
                    try {
                        Network4Address source = new Network4Address((Inet4Address)inetAddress, 32);
                        HashMap<String, String> data = new HashMap<String, String>();
                        for (VariableBinding variableBinding : event.getPDU().getVariableBindings()) {
                            data.put(variableBinding.getOid().toDottedString(), variableBinding.getVariable().toString());
                        }
                        if (event.getSecurityModel() == 1) {
                            data.put("version", "1");
                        } else if (event.getSecurityModel() == 2) {
                            data.put("version", "2c");
                        } else {
                            data.put("version", "Unknown");
                        }
                        ArrayList<String> matchingDrivers = new ArrayList<String>();
                        for (DeviceDriver driver : DeviceDriver.getAllDrivers()) {
                            if (!driver.analyzeTrap(data, source)) continue;
                            matchingDrivers.add(driver.getName());
                        }
                        if (matchingDrivers.size() > 0) {
                            TakeSnapshotTask.scheduleSnapshotIfNeeded(matchingDrivers, source);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Error on trap received from {}.", (Object)address, (Object)e);
                    }
                }
            } else {
                logger.warn("Invalid community {} (vs {}) received from {}.", community, this.community, event.getPeerAddress());
            }
        }
    }

    static {
        running = false;
    }
}

