/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaCacheCluster
implements CacheCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerracottaCacheCluster.class);
    private final List<ClusterTopologyListener> listeners = new CopyOnWriteArrayList<ClusterTopologyListener>();
    private volatile CacheCluster realCacheCluster;

    public void setUnderlyingCacheCluster(CacheCluster newCacheCluster) {
        if (newCacheCluster == null) {
            throw new IllegalArgumentException("CacheCluster can't be null");
        }
        CacheCluster oldRealCacheCluster = this.realCacheCluster;
        this.realCacheCluster = newCacheCluster;
        for (ClusterTopologyListener listener : this.listeners) {
            this.realCacheCluster.addTopologyListener(listener);
        }
        if (oldRealCacheCluster != null) {
            for (ClusterTopologyListener listener : this.listeners) {
                oldRealCacheCluster.removeTopologyListener(listener);
            }
        }
    }

    void fireNodeRejoinedEvent(ClusterNode oldNode, ClusterNode newNode) {
        HashSet<ClusterTopologyListener> firedToListeners = new HashSet<ClusterTopologyListener>();
        for (ClusterTopologyListener listener : this.listeners) {
            this.fireRejoinEvents(oldNode, newNode, listener);
            firedToListeners.add(listener);
        }
        for (ClusterTopologyListener listener : this.realCacheCluster.getTopologyListeners()) {
            if (firedToListeners.contains(listener)) continue;
            this.fireRejoinEvents(oldNode, newNode, listener);
        }
    }

    private void fireRejoinEvents(ClusterNode oldNode, ClusterNode newNode, ClusterTopologyListener listener) {
        try {
            listener.nodeJoined(newNode);
            listener.clusterOnline(newNode);
            listener.clusterRejoined(new DisconnectedClusterNode(oldNode), newNode);
        }
        catch (Throwable e) {
            LOGGER.error("Caught exception while firing rejoin event", e);
        }
    }

    @Override
    public boolean addTopologyListener(ClusterTopologyListener listener) {
        this.checkIfInitialized();
        boolean added = this.realCacheCluster.addTopologyListener(listener);
        if (added) {
            this.listeners.add(listener);
        }
        return added;
    }

    @Override
    public boolean removeTopologyListener(ClusterTopologyListener listener) {
        this.checkIfInitialized();
        boolean removed = this.realCacheCluster.removeTopologyListener(listener);
        if (removed) {
            this.listeners.remove(listener);
        }
        return removed;
    }

    @Override
    public ClusterNode getCurrentNode() {
        this.checkIfInitialized();
        return this.realCacheCluster.getCurrentNode();
    }

    @Override
    public Collection<ClusterNode> getNodes() {
        this.checkIfInitialized();
        return this.realCacheCluster.getNodes();
    }

    @Override
    public ClusterScheme getScheme() {
        this.checkIfInitialized();
        return this.realCacheCluster.getScheme();
    }

    @Override
    public boolean isClusterOnline() {
        this.checkIfInitialized();
        return this.realCacheCluster.isClusterOnline();
    }

    @Override
    public ClusterNode waitUntilNodeJoinsCluster() {
        this.checkIfInitialized();
        return this.realCacheCluster.waitUntilNodeJoinsCluster();
    }

    private void checkIfInitialized() {
        if (this.realCacheCluster == null) {
            throw new CacheException("The underlying cache cluster has not been initialized. Probably the terracotta client has not been configured yet.");
        }
    }

    @Override
    public List<ClusterTopologyListener> getTopologyListeners() {
        return this.listeners;
    }

    private static class DisconnectedClusterNode
    implements ClusterNode {
        private final ClusterNode delegateNode;

        public DisconnectedClusterNode(ClusterNode actualNode) {
            this.delegateNode = actualNode;
        }

        public String getId() {
            return this.delegateNode.getId();
        }

        public String getHostname() {
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostName = "[Can't determine hostname and " + this.delegateNode.getId() + " has DISCONNECTED]";
            }
            return hostName;
        }

        public String getIp() {
            String ip = "";
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                ip = "[Can't determine IP and " + this.delegateNode.getId() + " has DISCONNECTED]";
            }
            return ip;
        }
    }
}

