/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.freeradius.FreeRadiusRequest;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.server.JRadiusServer;
import net.jradius.server.ListenerRequest;
import net.jradius.server.RadiusProcessor;
import net.jradius.server.config.Configuration;

public class FreeRadiusProcessor
extends RadiusProcessor {
    private static final FreeRadiusFormat format = new FreeRadiusFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(ListenerRequest listenerRequest) throws Exception {
        FreeRadiusRequest request = (FreeRadiusRequest)listenerRequest.getRequestEvent();
        try {
            try {
                request.setApplicationContext(this.getApplicationContext());
                request.setReturnValue(this.runPacketHandlers(request));
            }
            catch (Throwable th) {
                request.setReturnValue(1);
                RadiusLog.error(">>> processRequest(): Error during processing RunPacketHandlers block", th);
            }
            try {
                this.writeResponse(request, listenerRequest.getOutputStream());
            }
            catch (Throwable e) {
                RadiusLog.error(">>> processRequest(): Error during writing response", e);
            }
        }
        finally {
            if (request != null) {
                PacketFactory.recycle(request.getPackets());
                request.getConfigItems().clear();
            }
        }
    }

    public void writeResponse(FreeRadiusRequest request, OutputStream out) throws IOException, RadiusException {
        if (Configuration.isDebug()) {
            request.printDebugInfo();
        }
        RadiusPacket[] rp = request.getPackets();
        int packetCount = rp.length;
        ByteBuffer buffer = request.buffer_out;
        buffer.clear();
        RadiusFormat.putUnsignedInt(buffer, 0L);
        RadiusFormat.putUnsignedByte(buffer, request.getReturnValue());
        RadiusFormat.putUnsignedByte(buffer, packetCount);
        for (int i = 0; i < packetCount; ++i) {
            format.packPacket(rp[i], null, buffer, false);
        }
        int pktsLength = buffer.position();
        RadiusFormat.putUnsignedInt(buffer, 0L);
        format.packAttributeList(request.getConfigItems(), buffer, false);
        int cItemsLength = buffer.position();
        RadiusFormat.putUnsignedInt(buffer, pktsLength, cItemsLength - pktsLength - 4);
        RadiusFormat.putUnsignedInt(buffer, 0, buffer.position() - 4);
        out.write(buffer.array(), 0, buffer.position());
        out.flush();
    }

    protected void logReturnCode(int result, JRCommand handler) {
        switch (result) {
            case 1: 
            case 4: 
            case 6: {
                RadiusLog.error("Error: Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            case 0: 
            case 3: {
                RadiusLog.info("Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            default: {
                RadiusLog.debug("Packet handler " + handler.getName() + " returned " + JRadiusServer.resultCodeToString(result) + ". Continue handling this packet.");
            }
        }
    }
}

