/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_PIMO_H_
#define _SOPRANO_PIMO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk2 {
    namespace Vocabulary {
        namespace PIMO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#
             */
            NEPOMUK_EXPORT QUrl pimoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#AbstractClass 
             */
            NEPOMUK_EXPORT QUrl AbstractClass();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Agent 
             * 
             * An agent (eg. person, group, software or physical artifact). 
             * The Agent class is the class of agents; things that do stuff. 
             * A well known sub-class is Person, representing people. Other 
             * kinds of agents include Organization and Group. 
             * (inspired by FOAF). 
             * Agent is not a subclass of NAO:Party. 
             */
            NEPOMUK_EXPORT QUrl Agent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Association 
             * 
             * An association between two or more pimo-things. This is used 
             * to model n-ary relations and metadata about relations. For 
             * example, the asociation of a person being organizational member 
             * is only effectual within a period of time (after the person joined 
             * the organization and before the person left the organization). 
             * There can be multiple periods of time when associations are 
             * valid. 
             */
            NEPOMUK_EXPORT QUrl Association();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Attendee 
             * 
             * The role of someone attending a social event. 
             */
            NEPOMUK_EXPORT QUrl Attendee();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#BlogPost 
             * 
             * A blog note. You just want to write something down right now and 
             * need a place to do that. Add a blog-note! This is an example class 
             * for a document type, there are more detailled ontologies to 
             * model Blog-Posts (like SIOC). 
             */
            NEPOMUK_EXPORT QUrl BlogPost();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Building 
             * 
             * A structure that has a roof and walls and stands more or less permanently 
             * in one place; "there was a three-story building on the corner"; 
             * "it was an imposing edifice". (Definition from SUMO). 
             */
            NEPOMUK_EXPORT QUrl Building();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#City 
             * 
             * A large and densely populated urban area; may include several 
             * independent administrative districts; "Ancient Troy was 
             * a great city". (Definition from SUMO) 
             */
            NEPOMUK_EXPORT QUrl City();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#ClassOrThing 
             * 
             * Superclass of class and thing. To add properties to both class 
             * and thing. 
             */
            NEPOMUK_EXPORT QUrl ClassOrThing();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#ClassOrThingOrPropertyOrAssociation 
             * 
             * Superclass of resources that can be generated by the user. 
             */
            NEPOMUK_EXPORT QUrl ClassOrThingOrPropertyOrAssociation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#ClassRole 
             * 
             * Roles of classes in PIMO: concrete instances are Abstract and 
             * Concrete. 
             */
            NEPOMUK_EXPORT QUrl ClassRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Collection 
             * 
             * A collection of Things, independent of their class. The items 
             * in the collection share a common property. Which property may 
             * be modelled explicitly or mentioned in the description of the 
             * Collection. The requirement of explicit modelling the semantic 
             * meaning of the collection is not mandatory, as collections 
             * can be created ad-hoc. Implizit modelling can be applied by 
             * the system by learning the properties. For example, a Collection 
             * of "Coworkers" could be defined as that all elements must be 
             * of class "Person" and have an attribute "work for the same Organization 
             * as the user". Further standards can be used to model these attributes. 
             */
            NEPOMUK_EXPORT QUrl Collection();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#ConcreteClass 
             */
            NEPOMUK_EXPORT QUrl ConcreteClass();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Contract 
             * 
             * A binding agreement between two or more persons that is enforceable 
             * by law. (Definition from SUMO). This is an example class for 
             * a document type, there are more detailled ontologies to model 
             * Contracts. 
             */
            NEPOMUK_EXPORT QUrl Contract();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Country 
             * 
             * The territory occupied by a nation; "he returned to the land 
             * of his birth"; "he visited several European countries". (Definition 
             * from SUMO) 
             */
            NEPOMUK_EXPORT QUrl Country();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Document 
             * 
             * A generic document. This is a placeholder class for document-management 
             * domain ontologies to subclass. Create more and specified subclasses 
             * of pimo:Document for the document types in your domain. Documents 
             * are typically instances of both NFO:Document (modeling the 
             * information element used to store the document) and a LogicalMediaType 
             * subclass. Two examples are given for what to model here: a contract 
             * for a business domain, a BlogPost for an informal domain. 
             */
            NEPOMUK_EXPORT QUrl Document();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Event 
             * 
             * Something that happens 
             * An Event is conceived as compact in time. (Definition from Merriam-Webster) 
             */
            NEPOMUK_EXPORT QUrl Event();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#FullPimoView 
             */
            NEPOMUK_EXPORT QUrl FullPimoView();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#GroundingClosure 
             */
            NEPOMUK_EXPORT QUrl GroundingClosure();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#InferOccurrences 
             */
            NEPOMUK_EXPORT QUrl InferOccurrences();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Locatable 
             * 
             * Things that can be at a location. Abstract class, use it as a superclass 
             * of things that can be placed in physical space. 
             */
            NEPOMUK_EXPORT QUrl Locatable();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Location 
             * 
             * A physical location. Subclasses are modeled for the most common 
             * locations humans work in: Building, City, Country, Room, State. 
             * This selection is intended to be applicable cross-cultural 
             * and cross-domain. City is a prototype that can be further refined 
             * for villages, etc. Subclass of a WGS84:SpatialThing, can have 
             * geo-coordinates. 
             */
            NEPOMUK_EXPORT QUrl Location();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#LogicalMediaType 
             * 
             * Logical media types represent the content aspect of information 
             * elements e.g. a flyer, a contract, a promotional video, a todo 
             * list. The user can create new logical media types dependend 
             * on their domain: a salesman will need MarketingFlyer, Offer, 
             * Invoice while a student might create Report, Thesis and Homework. 
             * This is independent from the information element and data object 
             * (NIE/NFO) in which the media type will be stored. The same contract 
             * can be stored in a PDF file, a text file, or an HTML website. 
             * The groundingOccurrence of a LogicalMediaType is the Document 
             * that stores the content. 
             */
            NEPOMUK_EXPORT QUrl LogicalMediaType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Meeting 
             * 
             * The social act of assembling for some common purpose; "his meeting 
             * with the salesman was the high point of his day". (Definition 
             * from SUMO) 
             */
            NEPOMUK_EXPORT QUrl Meeting();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Note 
             * 
             * A note. The textual contents of the note should be expressed 
             * in the nao:description value of the note. 
             */
            NEPOMUK_EXPORT QUrl Note();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#OccurrenceClosure 
             */
            NEPOMUK_EXPORT QUrl OccurrenceClosure();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Organization 
             * 
             * An administrative and functional structure (as a business 
             * or a political party). (Definition from Merriam-Webster) 
             */
            NEPOMUK_EXPORT QUrl Organization();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#OrganizationMember 
             * 
             * The role of one or multiple persons being a member in one or multiple 
             * organizations. Use pimo:organization and pimo:roleHolder 
             * to link to the organizations and persons. 
             */
            NEPOMUK_EXPORT QUrl OrganizationMember();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Person 
             * 
             * Represents a person. Either living, dead, real or imaginary. 
             * (Definition from foaf:Person) 
             */
            NEPOMUK_EXPORT QUrl Person();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#PersonGroup 
             * 
             * A group of Persons. They are connected to each other by sharing 
             * a common attribute, for example they all belong to the same organization 
             * or have a common interest. Refer to pimo:Collection for more 
             * information about defining collections. 
             */
            NEPOMUK_EXPORT QUrl PersonGroup();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#PersonRole 
             * 
             * A person takes a certain role in a given context. The role can 
             * be that of "a mentor or another person" or "giving a talk at a meeting", 
             * etc. 
             */
            NEPOMUK_EXPORT QUrl PersonRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#PersonalInformationModel 
             * 
             * A Personal Information Model (PIMO) of a user. Represents the 
             * sum of all information from the personal knowledge workspace 
             * (in literature also referred to as Personal Space of Information 
             * (PSI)) which a user needs for Personal Information Management 
             * (PIM). 
             */
            NEPOMUK_EXPORT QUrl PersonalInformationModel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#ProcessConcept 
             * 
             * Concepts that relate to a series of actions or operations conducing 
             * to an end. Abstract class. Defines optional start and endtime 
             * properties, names taken from NCAL. 
             */
            NEPOMUK_EXPORT QUrl ProcessConcept();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Project 
             * 
             * Any piece of work that is undertaken or attempted (Wordnet). 
             * An enterprise carefully planned to achieve a particular aim 
             * (Oxford Dictionary). 
             */
            NEPOMUK_EXPORT QUrl Project();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Room 
             * 
             * A properPart of a Building which is separated from the exterior 
             * of the Building and/or other Rooms of the Building by walls. 
             * Some Rooms may have a specific purpose, e.g. sleeping, bathing, 
             * cooking, entertainment, etc. (Definition from SUMO). 
             */
            NEPOMUK_EXPORT QUrl Room();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#RuleViewSpecificationGroundingClosure 
             */
            NEPOMUK_EXPORT QUrl RuleViewSpecificationGroundingClosure();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#RuleViewSpecificationInferOccurrences 
             */
            NEPOMUK_EXPORT QUrl RuleViewSpecificationInferOccurrences();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#RuleViewSpecificationOccurrenceClosure 
             */
            NEPOMUK_EXPORT QUrl RuleViewSpecificationOccurrenceClosure();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#SocialEvent 
             * 
             * A social occasion or activity. (Definition from Merriam-Webster) 
             */
            NEPOMUK_EXPORT QUrl SocialEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#State 
             * 
             * Administrative subdivisions of a Nation that are broader than 
             * any other political subdivisions that may exist. This Class 
             * includes the states of the United States, as well as the provinces 
             * of Canada and European countries. (Definition from SUMO). 
             */
            NEPOMUK_EXPORT QUrl State();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Tag 
             * 
             * Tags in the context of PIMO. A marker class for Things that are 
             * used to categorize documents (or other things). Tags must be 
             * a kind of Thing and must have a unique label. Documents should 
             * not be Tags by default. 
             */
            NEPOMUK_EXPORT QUrl Tag();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Task 
             * 
             * A (usually assigned) piece of work (often to be finished within 
             * a certain time). (Definition from Merriam-Webster) 
             */
            NEPOMUK_EXPORT QUrl Task();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Thing 
             * 
             * Entities that are in the direct attention of the user when doing 
             * knowledge work. 
             */
            NEPOMUK_EXPORT QUrl Thing();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#Topic 
             * 
             * A topic is the subject of a discussion or document. Topics are 
             * distinguished from Things in their taxonomic nature, examples 
             * are scientific areas such as "Information Science", "Biology", 
             * or categories used in content syndication such as "Sports", 
             * "Politics". They are specific to the user's domain. 
             */
            NEPOMUK_EXPORT QUrl Topic();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#associationEffectual 
             * 
             * During which time is this association effective? If omitted, 
             * the association is always effective. Start time and end-time 
             * may be left open, an open start time indicates that the fact is 
             * unknown, an open end-time indicates that the end-date is either 
             * unknown or the association has not ended. 
             * There can be multiple effectual periods. 
             */
            NEPOMUK_EXPORT QUrl associationEffectual();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#associationMember 
             * 
             * An super-property of all roles that an entity can have in an association. 
             * Member is the generic role of a thing in an association. Association 
             * subclasses should define sub-properties of this property. 
             * Associations can have Things as 
             */
            NEPOMUK_EXPORT QUrl associationMember();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#attendee 
             * 
             * A social event is attended by a person. 
             */
            NEPOMUK_EXPORT QUrl attendee();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#attendingMeeting 
             * 
             * the attended meeting 
             */
            NEPOMUK_EXPORT QUrl attendingMeeting();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#attends 
             * 
             * A person attends a social event. 
             */
            NEPOMUK_EXPORT QUrl attends();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#classRole 
             * 
             * Annotating abstract and concrete classes. Implementations 
             * may offer the feature to hide abstract classes. By default, 
             * classes are concrete. Classes can be declared abstract by setting 
             * their classRole to abstract. Instances should not have an abstract 
             * class as type (if not inferred). 
             */
            NEPOMUK_EXPORT QUrl classRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#containsLocation 
             * 
             * The subject location contains the object location. For example, 
             * a building contains a room or a country contains a city. 
             */
            NEPOMUK_EXPORT QUrl containsLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#createdPimo 
             * 
             * The creator of the Personal Information Model. The human being 
             * whose mental models are represented in the PIMO. 
             */
            NEPOMUK_EXPORT QUrl createdPimo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#creator 
             * 
             * The creator of the Personal Information Model. A subproperty 
             * of NAO:creator. The human being whose mental models are represented 
             * in the PIMO. Range is an Agent. 
             */
            NEPOMUK_EXPORT QUrl creator();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#datatypeProperty 
             * 
             * The object of statements is a literal, resource, or datatype 
             * value describing the subject thing. Users should be able to 
             * edit statements defined with this property. Abstract super-property. 
             */
            NEPOMUK_EXPORT QUrl datatypeProperty();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#dtend 
             * 
             * This property specifies the date and time when a process ends. 
             * Inspired by NCAL:dtend. 
             */
            NEPOMUK_EXPORT QUrl dtend();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#dtstart 
             * 
             * This property specifies when the process begins. Inspired 
             * by NCAL:dtstart. 
             */
            NEPOMUK_EXPORT QUrl dtstart();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#duration 
             * 
             * The duration of the process (meeting, event, etc). Difference 
             * between start and end time. 
             */
            NEPOMUK_EXPORT QUrl duration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#groundingForDeletedThing 
             * 
             * This NIE Information Element was used as a grounding occurrence 
             * for the object Thing. The Thing was then deleted by the user manually, 
             * indicating that this Information Element should not cause 
             * an automatic creation of another Thing in the future. The object 
             * resource has no range to indicate that it was completely removed 
             * from the user's PIMO, including the rdf:type statement. Relevant 
             * for data alignment and enrichment algorithms. 
             */
            NEPOMUK_EXPORT QUrl groundingForDeletedThing();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#groundingOccurrence 
             * 
             * The subject Thing represents the entity that is described in 
             * the object InformationElement. The subject Thing is the canonical, 
             * unique representation in the personal information model for 
             * the entity described in the object. Multiple InformationElements 
             * can be the grounding occurrence of the same Thing, one InformationElement 
             * can be the groundingOccurrence of only one Thing. 
             */
            NEPOMUK_EXPORT QUrl groundingOccurrence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasDeprecatedRepresentation 
             * 
             * The subject Thing was represented previously using the object 
             * resource. This indicates that the object resource was a duplicate 
             * representation of the subject and merged with the subject. 
             * Implementations can use this property to resolve dangling 
             * links in distributed system. When encountering resources 
             * that are deprecated representations of a Thing, they should 
             * be replaced with the Thing. The range is not declared as we assume 
             * all knowledge about the object is gone, including its rdf:type. 
             */
            NEPOMUK_EXPORT QUrl hasDeprecatedRepresentation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasFolder 
             * 
             * Folders can be used to store information elements related to 
             * a Thing or Class. This property can be used to connect a Class 
             * or Thing to existing Folders. Implementations can suggest 
             * annotations for documents stored inside these folders or suggest 
             * the folder for new documents related to the Thing or Class. 
             */
            NEPOMUK_EXPORT QUrl hasFolder();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasGlobalNamespace 
             * 
             * The global namespace of this user using the semdesk uri scheme, 
             * based on the Global Identifier of the user. Example semdesk://bob@example.com/things/. 
             * See http://dev.nepomuk.semanticdesktop.org/repos/trunk/doc/2008_09_semdeskurischeme/index.html 
             */
            NEPOMUK_EXPORT QUrl hasGlobalNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasLocalNamespace 
             * 
             * The local namespace of this user using the semdesk uri scheme, 
             * based on the Local Identifier of the user. Example semdesk://bob@/things/. 
             * See http://dev.nepomuk.semanticdesktop.org/repos/trunk/doc/2008_09_semdeskurischeme/index.html 
             */
            NEPOMUK_EXPORT QUrl hasLocalNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasLocation 
             * 
             * The subject thing is currently located at the object location. 
             */
            NEPOMUK_EXPORT QUrl hasLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasOrganizationMember 
             * 
             * The subject organization has the object person or organization 
             * (Agent) as a member. 
             */
            NEPOMUK_EXPORT QUrl hasOrganizationMember();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasOtherConceptualization 
             * 
             * Short: hasOtherRepresentation points from a Class in your 
             * PIMO to a class in a domain ontology that represents the same 
             * class. Longer: hasOtherConceptualization means that a class 
             * of real world objects O represented by a concept C1 in the ontology 
             * has additional conceptualizations (as classes C2-Cn in different 
             * domain ontologies). 
             * This means: IF (O_i is conceptialized by C_j in Ontology_k) 
             * AND (O_l is conceptialized by C_m in Ontology_n) THEN (O_i and 
             * O_l is the same set of objects). 
             * hasOtherConceptualization is an transitive relation, but 
             * not equivalent (not symmetric nor reflexive). 
             */
            NEPOMUK_EXPORT QUrl hasOtherConceptualization();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasOtherRepresentation 
             * 
             * hasOtherRepresentation points from a Thing in your PIMO to 
             * a thing in an ontology that represents the same real world thing. 
             * This means that the real world object O represented by an instance 
             * I1 has additional representations (as instances I2-In of different 
             * conceptualizations). 
             * This means: IF (I_i represents O_j in Ontology_k) AND (I_m represents 
             * O_n in Ontology_o) THEN (O_n and O_j are the same object). 
             * hasOtherRepresentation is a transitive relation, but not 
             * equivalent (not symmetric nor reflexive). 
             * 
             * For example, the URI of a foaf:Person representation published 
             * on the web is a hasOtherRepresentation for the person. This 
             * property is inverse functional, two Things from two information 
             * models having the same hasOtherRepresentation are considered 
             * to be representations of the same entity from the real world. 
             * 
             * TODO: rename this to subjectIndicatorRef to resemble topic 
             * maps ideas? 
             */
            NEPOMUK_EXPORT QUrl hasOtherRepresentation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasOtherSlot 
             * 
             * hasOtherSlot points from a clot in your PIMO to a slot in a domain 
             * ontology that represents the same connection idea. 
             */
            NEPOMUK_EXPORT QUrl hasOtherSlot();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasPart 
             * 
             * The object is part of the subject. Like a page is part of a book 
             * or an engine is part of a car. You can make sub-properties of this 
             * to reflect more detailed relations. The semantics of this relations 
             * is the same as skos:narrowerPartitive 
             */
            NEPOMUK_EXPORT QUrl hasPart();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasRootTopic 
             * 
             * The root topics of this PersonalInformationModel's topic 
             * hierarchy. Every topic that has no pimo:superTopic is a root 
             * topic. Semantically equivalent to skos:hasTopConcept. 
             */
            NEPOMUK_EXPORT QUrl hasRootTopic();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#hasTag 
             * 
             * The subject's contents describes the object. Or the subject 
             * can be seen as belonging to the thing described by the object. 
             * Similar semantics as skos:subject. 
             */
            NEPOMUK_EXPORT QUrl hasTag();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isDefinedBy 
             * 
             * Each element in a PIMO must be connected to the PIMO, to be able 
             * to track multiple PIMOs in a distributed scenario. Also, this 
             * is the way to find the user that this Thing belongs to. 
             */
            NEPOMUK_EXPORT QUrl isDefinedBy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isLocationOf 
             * 
             * The subject location is the current location of the object. 
             */
            NEPOMUK_EXPORT QUrl isLocationOf();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isOrganizationMemberOf 
             * 
             * The subject person or organozation (Agent) is member of the 
             * object organization. 
             */
            NEPOMUK_EXPORT QUrl isOrganizationMemberOf();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isRelated 
             * 
             * The thing is related to the other thing. Similar in meaning to 
             * skos:related. Symmetric but not transitive. 
             */
            NEPOMUK_EXPORT QUrl isRelated();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isTagFor 
             * 
             * This thing is described further in the object thing. Similar 
             * semantics as skos:isSubjectOf. 
             */
            NEPOMUK_EXPORT QUrl isTagFor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#isWriteable 
             * 
             * Defines if this information model can be modified by the user 
             * of the system. This is usually false for imported ontologies 
             * and true for the user's own PersonalInformationModel. 
             */
            NEPOMUK_EXPORT QUrl isWriteable();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#jabberId 
             * 
             * Jabber-ID of the user. Used to communicate amongst peers in 
             * the social scenario of the semantic desktop. Use the xmpp node 
             * identifier as specified by RFC3920, see http://www.xmpp.org/specs/rfc3920.html#addressing-node. 
             * The format is the same as e-mail addresses: username@hostname. 
             */
            NEPOMUK_EXPORT QUrl jabberId();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#locatedWithin 
             * 
             * The subject location is contained within the object location. 
             * For example, a room is located within a building or a city is located 
             * within a country. 
             */
            NEPOMUK_EXPORT QUrl locatedWithin();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#objectProperty 
             * 
             * The object of statements is another Thing. Users should be able 
             * to edit statements defined with this property. Abstract super-property. 
             */
            NEPOMUK_EXPORT QUrl objectProperty();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#occurrence 
             * 
             * The subject Thing is represented also in the object resource. 
             * All facts added to the object resource are valid for the subject 
             * thing. The subject is the canonical represtation of the object. 
             * In particual, this implies when (?object ?p ?v) -> (?subject 
             * ?p ?v) and (?s ?p ?object) -> (?s ?p ?subject). The class of the 
             * object is not defined, but should be compatible with the class 
             * of the subject. Occurrence relations can be inferred through 
             * same identifiers or referencingOccurrence relations. 
             */
            NEPOMUK_EXPORT QUrl occurrence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#organization 
             * 
             * relation to the organization in an OrganizationMember association. 
             */
            NEPOMUK_EXPORT QUrl organization();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#partOf 
             * 
             * This is part of the object. Like a page is part of a book or an engine 
             * is part of a car. You can make sub-properties of this to reflect 
             * more detailed relations. 
             */
            NEPOMUK_EXPORT QUrl partOf();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#referencingOccurrence 
             * 
             * The subject thing is described in the object document. Ideally, 
             * the document is public and its primary topic is the thing. Although 
             * this property is not inverse-functional (because the Occurrences 
             * are not canonical elements of a formal ontology) this property 
             * allows to use public documents, such as wikipedia pages, as 
             * indicators identity. The more formal hasOtherRepresentation 
             * property can be used when an ontology about the subject exists. 
             */
            NEPOMUK_EXPORT QUrl referencingOccurrence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#roleContext 
             * 
             * The context where the role-holder impersonates this role. 
             * For example, the company where a person is employed. 
             */
            NEPOMUK_EXPORT QUrl roleContext();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#roleHolder 
             * 
             * the person taking the role 
             */
            NEPOMUK_EXPORT QUrl roleHolder();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#subTopic 
             * 
             * The object topic is more specific in meaning than the subject 
             * topic. Transitive. Similar in meaning to skos:narrower 
             */
            NEPOMUK_EXPORT QUrl subTopic();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#superTopic 
             * 
             * The object topic is more general in meaning than the subject 
             * topic. Transitive. Similar to skos:broader. 
             */
            NEPOMUK_EXPORT QUrl superTopic();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#tagLabel 
             * 
             * The unique label of the tag. The label must be unique within the 
             * scope of one PersonalInformationModel. It is required and 
             * a subproperty of nao:prefLabel. It clarifies the use of nao:personalIdentifier 
             * by restricting the scope to tags. Semantically equivalent 
             * to skos:prefLabel, where uniqueness of labels is also recommended. 
             */
            NEPOMUK_EXPORT QUrl tagLabel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#taskDueTime 
             * 
             * when is this task due? Represented in ISO 8601, example: 2003-11-22T17:00:00 
             */
            NEPOMUK_EXPORT QUrl taskDueTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#wikiText 
             * 
             * A wiki-like free-text description of a Thing or a Class. The 
             * text can be formatted using a limited set of HTML elements and 
             * can contain links to other Things. The format is described in 
             * detail in the WIF specification (http://semanticweb.org/wiki/Wiki_Interchange_Format). 
             */
            NEPOMUK_EXPORT QUrl wikiText();

            /**
             * http://www.w3.org/2003/01/geo/wgs84_pos#alt 
             */
            NEPOMUK_EXPORT QUrl alt();

            /**
             * http://www.w3.org/2003/01/geo/wgs84_pos#lat 
             */
            NEPOMUK_EXPORT QUrl lat();

            /**
             * http://www.w3.org/2003/01/geo/wgs84_pos#long 
             */
            NEPOMUK_EXPORT QUrl pimoLong();
        }
    }
}

#endif
