/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private DeferredCloseInputStream stdout_inner_stream;
    private static final Platform platform = Platform.get();
    private static final LaunchMechanism launchMechanism = platform.launchMechanism();
    private static final byte[] helperpath = UNIXProcess.toCString(platform.helperPath());
    private static final Executor processReaperExecutor = AccessController.doPrivileged(() -> {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        ThreadGroup threadGroup2 = threadGroup;
        ThreadFactory threadFactory = runnable -> {
            long l = Boolean.getBoolean("jdk.lang.processReaperUseDefaultStackSize") ? 0L : 32768L;
            Thread thread = new Thread(threadGroup2, runnable, "process reaper", l);
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        };
        return Executors.newCachedThreadPool(threadFactory);
    });

    private static byte[] toCString(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, int[] nArray, boolean bl) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.ordinal() + 1, helperpath, byArray, byArray2, n, byArray3, n2, byArray4, nArray, bl);
        try {
            AccessController.doPrivileged(() -> {
                this.initStreams(nArray);
                return null;
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return fileDescriptor;
    }

    void initStreams(int[] nArray) throws IOException {
        switch (platform) {
            case LINUX: 
            case BSD: 
            case MACOS: {
                this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(nArray[0]);
                this.stdout = nArray[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[1]);
                this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[2]);
                processReaperExecutor.execute(() -> {
                    int n = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = n;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                });
                break;
            }
            case SOLARIS: {
                InputStream inputStream;
                OutputStream outputStream = this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new BufferedOutputStream(new FileOutputStream(UNIXProcess.newFileDescriptor(nArray[0])));
                if (nArray[1] == -1) {
                    inputStream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    this.stdout_inner_stream = new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(nArray[1]));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.stdout_inner_stream);
                    inputStream = bufferedInputStream;
                }
                this.stdout = inputStream;
                this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(nArray[2]));
                processReaperExecutor.execute(() -> {
                    int n = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = n;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                });
                break;
            }
            case AIX: {
                this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(nArray[0]);
                this.stdout = nArray[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(nArray[1]);
                this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(nArray[2]);
                processReaperExecutor.execute(() -> {
                    int n = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = n;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized boolean waitFor(long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.hasExited) {
            return true;
        }
        if (l <= 0L) {
            return false;
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = System.nanoTime() + l2;
        do {
            this.wait(TimeUnit.NANOSECONDS.toMillis(l2 + 999999L));
            if (!this.hasExited) continue;
            return true;
        } while ((l2 = l3 - System.nanoTime()) > 0L);
        return this.hasExited;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0, boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(boolean bl) {
        switch (platform) {
            case LINUX: 
            case AIX: 
            case BSD: 
            case MACOS: {
                UNIXProcess uNIXProcess = this;
                synchronized (uNIXProcess) {
                    if (!this.hasExited) {
                        UNIXProcess.destroyProcess(this.pid, bl);
                    }
                }
                try {
                    this.stdin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stdout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stderr.close();
                }
                catch (IOException iOException) {}
                break;
            }
            case SOLARIS: {
                UNIXProcess uNIXProcess = this;
                synchronized (uNIXProcess) {
                    if (!this.hasExited) {
                        UNIXProcess.destroyProcess(this.pid, bl);
                    }
                    try {
                        this.stdin.close();
                        if (this.stdout_inner_stream != null) {
                            this.stdout_inner_stream.closeDeferred(this.stdout);
                        }
                        if (this.stderr instanceof DeferredCloseInputStream) {
                            ((DeferredCloseInputStream)this.stderr).closeDeferred(this.stderr);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    break;
                }
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }

    @Override
    public Process destroyForcibly() {
        this.destroy(true);
        return this;
    }

    @Override
    public synchronized boolean isAlive() {
        return !this.hasExited;
    }

    private static native void init();

    static {
        UNIXProcess.init();
    }

    private static class DeferredCloseProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();
        private int useCount = 0;
        private boolean closePending = false;

        DeferredCloseProcessPipeInputStream(int n) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(n)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream drainInputStream(InputStream inputStream) throws IOException {
            int n;
            int n2 = 0;
            byte[] byArray = null;
            Object object = this.closeLock;
            synchronized (object) {
                if (this.buf == null) {
                    return null;
                }
                n = inputStream.available();
            }
            while (n > 0) {
                byArray = byArray == null ? new byte[n] : Arrays.copyOf(byArray, n2 + n);
                object = this.closeLock;
                synchronized (object) {
                    if (this.buf == null) {
                        return null;
                    }
                    n2 += inputStream.read(byArray, n2, n);
                    n = inputStream.available();
                }
            }
            return byArray == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(n2 == byArray.length ? byArray : Arrays.copyOf(byArray, n2));
        }

        synchronized void processExited() {
            try {
                InputStream inputStream = this.in;
                if (inputStream != null) {
                    InputStream inputStream2 = this.drainInputStream(inputStream);
                    inputStream.close();
                    this.in = inputStream2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.closeLock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.closePending = false;
                    super.close();
                }
            }
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            this.raise();
            try {
                int n = super.read(byArray);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.raise();
            try {
                int n3 = super.read(byArray, n, n2);
                return n3;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            this.raise();
            try {
                long l2 = super.skip(l);
                return l2;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.useCount == 0) {
                    super.close();
                } else {
                    this.closePending = true;
                }
            }
        }
    }

    private static class DeferredCloseInputStream
    extends FileInputStream {
        private Object lock = new Object();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        DeferredCloseInputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream inputStream) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.useCount == 0) {
                    inputStream.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = inputStream;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            this.raise();
            try {
                int n = super.read(byArray);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.raise();
            try {
                int n3 = super.read(byArray, n, n2);
                return n3;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            this.raise();
            try {
                long l2 = super.skip(l);
                return l2;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }
    }

    private static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int n) {
            super(new FileOutputStream(UNIXProcess.newFileDescriptor(n)));
        }

        synchronized void processExited() {
            OutputStream outputStream = this.out;
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    private static class ProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();

        ProcessPipeInputStream(int n) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(n)));
        }

        private static byte[] drainInputStream(InputStream inputStream) throws IOException {
            int n;
            int n2 = 0;
            byte[] byArray = null;
            while ((n = inputStream.available()) > 0) {
                byArray = byArray == null ? new byte[n] : Arrays.copyOf(byArray, n2 + n);
                n2 += inputStream.read(byArray, n2, n);
            }
            return byArray == null || n2 == byArray.length ? byArray : Arrays.copyOf(byArray, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void processExited() {
            Object object = this.closeLock;
            synchronized (object) {
                try {
                    InputStream inputStream = this.in;
                    if (inputStream != null) {
                        byte[] byArray = ProcessPipeInputStream.drainInputStream(inputStream);
                        inputStream.close();
                        this.in = byArray == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(byArray);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                super.close();
            }
        }
    }

    private static enum Platform {
        LINUX(LaunchMechanism.VFORK, LaunchMechanism.FORK),
        MACOS(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        BSD(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        SOLARIS(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        AIX(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK);

        final LaunchMechanism defaultLaunchMechanism;
        final Set<LaunchMechanism> validLaunchMechanisms;

        private Platform(LaunchMechanism ... launchMechanismArray) {
            this.defaultLaunchMechanism = launchMechanismArray[0];
            this.validLaunchMechanisms = EnumSet.copyOf(Arrays.asList(launchMechanismArray));
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private String helperPath(String string, String string2) {
            switch (this) {
                case SOLARIS: {
                    if (string2.equals("x86")) {
                        string2 = "i386";
                    } else {
                        if (!string2.equals("x86_64")) return string + "/lib/" + string2 + "/jspawnhelper";
                        string2 = "amd64";
                    }
                }
                case LINUX: 
                case AIX: 
                case BSD: {
                    return string + "/lib/" + string2 + "/jspawnhelper";
                }
                case MACOS: {
                    return string + "/lib/jspawnhelper";
                }
            }
            throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)this)));
        }

        String helperPath() {
            return AccessController.doPrivileged(() -> this.helperPath(System.getProperty("java.home"), System.getProperty("os.arch")));
        }

        LaunchMechanism launchMechanism() {
            return AccessController.doPrivileged(() -> {
                LaunchMechanism launchMechanism;
                String string = System.getProperty("jdk.lang.Process.launchMechanism");
                if (string == null) {
                    launchMechanism = this.defaultLaunchMechanism;
                    string = launchMechanism.name().toLowerCase(Locale.ENGLISH);
                } else {
                    try {
                        launchMechanism = LaunchMechanism.valueOf(string.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        launchMechanism = null;
                    }
                }
                if (launchMechanism == null || !this.validLaunchMechanisms.contains((Object)launchMechanism)) {
                    throw new Error(string + " is not a supported process launch mechanism on this platform.");
                }
                return launchMechanism;
            });
        }

        static Platform get() {
            String string = AccessController.doPrivileged(() -> System.getProperty("os.name"));
            if (string.equals("Linux")) {
                return LINUX;
            }
            if (string.contains("OS X")) {
                return MACOS;
            }
            if (string.endsWith("BSD")) {
                return BSD;
            }
            if (string.equals("SunOS")) {
                return SOLARIS;
            }
            if (string.equals("AIX")) {
                return AIX;
            }
            throw new Error(string + " is not a supported OS platform.");
        }
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

