/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitInnerClassVisitor
extends AbstractJavaSyntaxVisitor {
    protected UpdateReferencesVisitor updateReferencesVisitor = new UpdateReferencesVisitor();
    protected UpdateNewExpressionVisitor updateNewExpressionVisitor = new UpdateNewExpressionVisitor();
    protected ObjectType outerType;
    protected DefaultList<String> outerLocalVariableNames = new DefaultList();

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.outerType = null;
        this.outerLocalVariableNames.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        bodyDeclaration.setOuterType(this.outerType);
        bodyDeclaration.setOuterLocalVariableNames(this.outerLocalVariableNames.isEmpty() ? null : new DefaultList<String>((Collection<String>)this.outerLocalVariableNames));
        if (this.outerType != null || !this.outerLocalVariableNames.isEmpty()) {
            this.updateReferencesVisitor.visit(bodyDeclaration);
        }
        if (bodyDeclaration.getInnerTypeDeclarations() != null) {
            this.updateNewExpressionVisitor.visit(bodyDeclaration);
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        ClassFile outerClassFile;
        BaseFormalParameter parameters;
        ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
        this.outerLocalVariableNames.clear();
        if (cfcd.getStatements().isList()) {
            DefaultList statements = cfcd.getStatements().getList();
            Iterator iterator = statements.iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (statement.getClass() == ExpressionStatement.class) {
                    BinaryOperatorExpression boe;
                    Expression e;
                    Expression expression = ((ExpressionStatement)statement).getExpression();
                    Class<?> clazz = expression.getClass();
                    if (clazz == SuperConstructorInvocationExpression.class || clazz == ConstructorInvocationExpression.class) break;
                    if (clazz == BinaryOperatorExpression.class && (e = (boe = (BinaryOperatorExpression)expression).getLeftExpression()).getClass() == FieldReferenceExpression.class) {
                        String name = ((FieldReferenceExpression)e).getName();
                        if (name.startsWith("this$")) {
                            this.outerType = (ObjectType)boe.getRightExpression().getType();
                        } else if (name.startsWith("val$")) {
                            this.outerLocalVariableNames.add(name);
                        }
                    }
                }
                iterator.remove();
            }
        }
        if ((parameters = cfcd.getFormalParameters()) != null) {
            if (parameters.isList()) {
                int count;
                DefaultList list = parameters.getList();
                if (this.outerType != null) {
                    list.remove(0);
                }
                if ((count = this.outerLocalVariableNames.size()) > 0) {
                    int size = list.size();
                    list.subList(size - count, size).clear();
                }
            } else {
                cfcd.setFormalParameters(null);
            }
        }
        if ((outerClassFile = cfcd.getClassFile().getOuterClassFile()) != null) {
            String internalTypeName;
            String outerTypeName = outerClassFile.getInternalTypeName();
            int min = (internalTypeName = cfcd.getClassFile().getInternalTypeName()).startsWith(outerTypeName + '$') ? outerTypeName.length() + 1 : internalTypeName.lastIndexOf(36) + 1;
            if (Character.isDigit(internalTypeName.charAt(min))) {
                int i = internalTypeName.length();
                boolean anonymousFlag = true;
                while (--i > min) {
                    if (Character.isDigit(internalTypeName.charAt(i))) continue;
                    anonymousFlag = false;
                    break;
                }
                if (anonymousFlag) {
                    cfcd.setFlags(cfcd.getFlags() | 0x1000);
                }
            }
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    protected class UpdateNewExpressionVisitor
    extends AbstractJavaSyntaxVisitor {
        protected ClassFileBodyDeclaration bodyDeclaration;
        protected HashMap<String, String> finalLocalVariableNameMap = new HashMap();
        protected DefaultList<ClassFileClassDeclaration> localClassDeclarations = new DefaultList();
        protected HashSet<NewExpression> newExpressions = new HashSet();
        protected int lineNumber;

        protected UpdateNewExpressionVisitor() {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateFinalFieldReferenceVisitor visitor = new UpdateFinalFieldReferenceVisitor();
                declaration.getStatements().accept(visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept(visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateFinalFieldReferenceVisitor visitor = new UpdateFinalFieldReferenceVisitor();
                declaration.getStatements().accept(visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept(visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                declaration.getStatements().accept(new UpdateFinalFieldReferenceVisitor());
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(Statements list) {
            if (!list.isEmpty()) {
                ListIterator<TypeDeclarationStatement> iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Statement s = (Statement)iterator.next();
                    s.accept(this);
                    if (this.lineNumber != 0 || this.localClassDeclarations.isEmpty()) continue;
                    iterator.previous();
                    for (TypeDeclaration typeDeclaration : this.localClassDeclarations) {
                        iterator.add(new TypeDeclarationStatement(typeDeclaration));
                    }
                    this.localClassDeclarations.clear();
                    iterator.next();
                }
            }
        }

        @Override
        public void visit(NewExpression expression) {
            if (!this.newExpressions.contains(expression)) {
                BaseExpression parameters;
                this.newExpressions.add(expression);
                ClassFileBodyDeclaration cfbd = null;
                if (expression.getBodyDeclaration() == null) {
                    ObjectType type = expression.getObjectType();
                    String internalName = type.getInternalName();
                    InterfaceDeclaration declaration = (InterfaceDeclaration)((Object)this.bodyDeclaration.getInnerTypeDeclaration(internalName));
                    if (declaration != null) {
                        cfbd = (ClassFileBodyDeclaration)declaration.getBodyDeclaration();
                        if (type.getQualifiedName() == null && type.getName() != null) {
                            ClassFileClassDeclaration cfcd = (ClassFileClassDeclaration)declaration;
                            cfcd.setFlags(cfcd.getFlags() & 0xFFFFEFFF);
                            this.localClassDeclarations.add(cfcd);
                            this.bodyDeclaration.removeInnerType(internalName);
                            this.lineNumber = expression.getLineNumber();
                        }
                    }
                } else {
                    cfbd = (ClassFileBodyDeclaration)expression.getBodyDeclaration();
                }
                if (cfbd != null && (parameters = expression.getParameters()) != null) {
                    DefaultList<String> outerParameterNames = cfbd.getOuterLocalVariableNames();
                    if (parameters.isList()) {
                        DefaultList list = parameters.getList();
                        if (cfbd.getOuterType() != null) {
                            list.remove(0);
                        }
                        if (outerParameterNames != null) {
                            int size = list.size();
                            int count = outerParameterNames.size();
                            List lastParameters = list.subList(size - count, size);
                            Iterator parameterIterator = lastParameters.iterator();
                            Iterator outerParameterNameIterator = outerParameterNames.iterator();
                            while (parameterIterator.hasNext()) {
                                Expression param = (Expression)parameterIterator.next();
                                String outerParameterName = (String)outerParameterNameIterator.next();
                                if (param.getClass() != ClassFileLocalVariableReferenceExpression.class) continue;
                                String localVariableName = ((ClassFileLocalVariableReferenceExpression)param).getLocalVariable().getName();
                                this.finalLocalVariableNameMap.put(localVariableName, outerParameterName.substring(4));
                            }
                            lastParameters.clear();
                        }
                    } else if (parameters.getClass() == ClassFileLocalVariableReferenceExpression.class) {
                        if (outerParameterNames != null) {
                            expression.setParameters(null);
                            String localVariableName = ((ClassFileLocalVariableReferenceExpression)parameters).getLocalVariable().getName();
                            String outerParameterName = (String)outerParameterNames.get(0);
                            this.finalLocalVariableNameMap.put(localVariableName, outerParameterName.substring(4));
                        }
                    } else if (parameters.getClass() == ThisExpression.class && cfbd.getOuterType() != null) {
                        expression.setParameters(null);
                    }
                }
            }
        }

        protected class MemberDeclarationComparator
        implements Comparator<ClassFileMemberDeclaration> {
            protected MemberDeclarationComparator() {
            }

            @Override
            public int compare(ClassFileMemberDeclaration md1, ClassFileMemberDeclaration md2) {
                return md1.getFirstLineNumber() - md2.getFirstLineNumber();
            }
        }

        protected class AddLocalClassDeclarationVisitor
        extends AbstractJavaSyntaxVisitor {
            protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
            protected int lineNumber = 0;

            protected AddLocalClassDeclarationVisitor() {
            }

            @Override
            public void visit(ConstructorDeclaration declaration) {
                ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
                cfcd.setStatements(this.addLocalClassDeclarations(cfcd.getStatements()));
            }

            @Override
            public void visit(MethodDeclaration declaration) {
                ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
                cfmd.setStatements(this.addLocalClassDeclarations(cfmd.getStatements()));
            }

            @Override
            public void visit(StaticInitializerDeclaration declaration) {
                ClassFileStaticInitializerDeclaration cfsid = (ClassFileStaticInitializerDeclaration)declaration;
                cfsid.setStatements(this.addLocalClassDeclarations(cfsid.getStatements()));
            }

            protected BaseStatement addLocalClassDeclarations(BaseStatement statements) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty()) {
                    if (statements.getClass() == Statements.class) {
                        statements.accept(this);
                    } else {
                        ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)UpdateNewExpressionVisitor.this.localClassDeclarations.get(0);
                        this.searchFirstLineNumberVisitor.init();
                        statements.accept(this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        if (declaration.getFirstLineNumber() <= this.lineNumber) {
                            Statements list = new Statements();
                            Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                            list.add(new TypeDeclarationStatement(declaration));
                            declarationIterator.next();
                            declarationIterator.remove();
                            while (declarationIterator.hasNext() && (declaration = (ClassFileClassDeclaration)declarationIterator.next()).getFirstLineNumber() <= this.lineNumber) {
                                list.add(new TypeDeclarationStatement(declaration));
                                declarationIterator.remove();
                            }
                            list.add(statements);
                            statements = list;
                        } else {
                            statements.accept(this);
                        }
                    }
                }
                return statements;
            }

            @Override
            public void visit(Statements list) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty() && !list.isEmpty()) {
                    ListIterator<TypeDeclarationStatement> statementIterator = list.listIterator();
                    Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                    ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)declarationIterator.next();
                    while (statementIterator.hasNext()) {
                        Statement statement = (Statement)statementIterator.next();
                        this.searchFirstLineNumberVisitor.init();
                        statement.accept(this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        while (declaration.getFirstLineNumber() <= this.lineNumber) {
                            statementIterator.previous();
                            statementIterator.add(new TypeDeclarationStatement(declaration));
                            statementIterator.next();
                            declarationIterator.remove();
                            if (!declarationIterator.hasNext()) {
                                return;
                            }
                            declaration = (ClassFileClassDeclaration)declarationIterator.next();
                        }
                    }
                }
            }
        }

        protected class UpdateFinalFieldReferenceVisitor
        extends AbstractJavaSyntaxVisitor {
            protected boolean fina1;

            protected UpdateFinalFieldReferenceVisitor() {
            }

            @Override
            public void visit(FormalParameter declaration) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declaration.getName())) {
                    declaration.setFinal(true);
                    declaration.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declaration.getName()));
                }
            }

            @Override
            public void visit(LocalVariableDeclarationStatement statement) {
                this.fina1 = false;
                statement.getLocalVariableDeclarators().accept(this);
                if (this.fina1) {
                    statement.setFinal(true);
                }
            }

            @Override
            public void visit(LocalVariableDeclaration declaration) {
                this.fina1 = false;
                declaration.getLocalVariableDeclarators().accept(this);
                if (this.fina1) {
                    declaration.setFinal(true);
                }
            }

            @Override
            public void visit(LocalVariableDeclarator declarator) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declarator.getName())) {
                    LocalVariableDeclarator cflvd = declarator;
                    this.fina1 = true;
                    cflvd.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declarator.getName()));
                }
            }
        }
    }

    protected class UpdateReferencesVisitor
    extends AbstractJavaSyntaxVisitor {
        protected UpdateReferencesVisitor() {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.safeAccept(declaration.getStatements());
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
            this.safeAccept(declaration.getStatements());
        }

        @Override
        public void visit(SuperConstructorInvocationExpression expression) {
            SuperConstructorInvocationExpression cfscie = expression;
            if (cfscie.getParameters() != null) {
                if (cfscie.getParameters().isList()) {
                    this.visitParameters(cfscie.getParameters().getList());
                } else {
                    cfscie.setParameters(this.visitParameter((Expression)cfscie.getParameters().getFirst()));
                }
            }
        }

        @Override
        public void visit(ConstructorInvocationExpression expression) {
            ConstructorInvocationExpression cie = expression;
            assert (cie.getParameters() != null);
            if (cie.getParameters().isList()) {
                DefaultList<Expression> parameters = cie.getParameters().getList();
                parameters.remove(0);
                assert (parameters.size() > 0);
                if (parameters.size() == 1) {
                    cie.setParameters(this.visitParameter(parameters.getFirst()));
                } else {
                    this.visitParameters(parameters);
                }
            } else {
                cie.setParameters(null);
            }
        }

        protected void visitParameters(DefaultList<Expression> list) {
            ListIterator<Expression> iterator = list.listIterator();
            while (iterator.hasNext()) {
                iterator.set(this.visitParameter((Expression)iterator.next()));
            }
        }

        protected Expression visitParameter(Expression expression) {
            if (expression.getClass() == ClassFileLocalVariableReferenceExpression.class) {
                ClassFileLocalVariableReferenceExpression cflvre = (ClassFileLocalVariableReferenceExpression)expression;
                if (InitInnerClassVisitor.this.outerLocalVariableNames.contains(cflvre.getName())) {
                    return new FieldReferenceExpression(cflvre.getType(), new ObjectTypeReferenceExpression(cflvre.getLineNumber(), InitInnerClassVisitor.this.outerType), InitInnerClassVisitor.this.outerType.getInternalName(), cflvre.getName().substring(4), cflvre.getType().getDescriptor());
                }
                if (cflvre.getName() != null && cflvre.getName().startsWith("this$") && cflvre.getType().getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                    return new FieldReferenceExpression(InitInnerClassVisitor.this.outerType, new ObjectTypeReferenceExpression(cflvre.getLineNumber(), InitInnerClassVisitor.this.outerType), InitInnerClassVisitor.this.outerType.getInternalName(), "this", InitInnerClassVisitor.this.outerType.getDescriptor());
                }
            } else if (expression.getClass() == FieldReferenceExpression.class) {
                expression.accept(this);
            }
            return expression;
        }

        @Override
        public void visit(FieldReferenceExpression expression) {
            FieldReferenceExpression cffre = expression;
            if (InitInnerClassVisitor.this.outerLocalVariableNames.contains(expression.getName())) {
                cffre.setName(cffre.getName().substring(4));
                cffre.setExpression(null);
            } else if (cffre.getExpression() != null) {
                Class<?> clazz = cffre.getExpression().getClass();
                if (clazz == FieldReferenceExpression.class) {
                    FieldReferenceExpression cffre2 = (FieldReferenceExpression)cffre.getExpression();
                    if (cffre2.getName().startsWith("this$") && cffre2.getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                        cffre.setExpression(new FieldReferenceExpression(InitInnerClassVisitor.this.outerType, new ObjectTypeReferenceExpression(cffre2.getLineNumber(), InitInnerClassVisitor.this.outerType), InitInnerClassVisitor.this.outerType.getInternalName(), "this", InitInnerClassVisitor.this.outerType.getDescriptor()));
                    }
                } else if (clazz == ClassFileLocalVariableReferenceExpression.class) {
                    ClassFileLocalVariableReferenceExpression cdlvre = (ClassFileLocalVariableReferenceExpression)cffre.getExpression();
                    if (cdlvre.getName() != null && cdlvre.getName().startsWith("this$") && cdlvre.getType().getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                        cffre.setExpression(new FieldReferenceExpression(InitInnerClassVisitor.this.outerType, new ObjectTypeReferenceExpression(cdlvre.getLineNumber(), InitInnerClassVisitor.this.outerType), InitInnerClassVisitor.this.outerType.getInternalName(), "this", InitInnerClassVisitor.this.outerType.getDescriptor()));
                    }
                } else if (clazz == ThisExpression.class && cffre.getName().startsWith("this$") && cffre.getType().getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                    cffre.setExpression(new ObjectTypeReferenceExpression(cffre.getExpression().getLineNumber(), InitInnerClassVisitor.this.outerType));
                    cffre.setName("this");
                }
            }
        }

        @Override
        public void visit(NewExpression expression) {
            this.safeAccept(expression.getParameters());
            if (expression.getBodyDeclaration() != null) {
                ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)expression.getBodyDeclaration();
                for (ClassFileConstructorOrMethodDeclaration comd : bodyDeclaration.getMethodDeclarations()) {
                    this.safeAccept(comd.getStatements());
                }
            }
        }
    }
}

