/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Spliterator;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamContext;

public class StreamEx<T>
extends AbstractStreamEx<T, StreamEx<T>> {
    StreamEx(Stream<? extends T> stream, StreamContext context) {
        super(stream, context);
    }

    StreamEx(Spliterator<? extends T> spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    StreamEx<T> supply(Stream<T> stream) {
        return new StreamEx<T>(stream, this.context);
    }

    public <TT> StreamEx<TT> select(Class<TT> clazz2) {
        return (StreamEx)this.filter(clazz2::isInstance);
    }

    public <A> A[] toArray(A[] emptyArray) {
        if (emptyArray.length != 0) {
            throw new IllegalArgumentException("Empty array must be supplied");
        }
        return ((Stream)this.stream()).toArray(size -> size == 0 ? emptyArray : (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), size));
    }

    @SafeVarargs
    public static <T> StreamEx<T> of(T ... elements) {
        return StreamEx.of(Arrays.spliterator(elements));
    }

    public static <T> StreamEx<T> of(Collection<? extends T> collection) {
        return StreamEx.of(collection.spliterator());
    }

    public static <T> StreamEx<T> of(Spliterator<? extends T> spliterator) {
        return new StreamEx<T>(spliterator, StreamContext.SEQUENTIAL);
    }
}

