/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContentFragment;

public abstract class Condition<T>
implements NamedWriteable,
ToXContentFragment {
    protected T value;
    protected final String name;

    protected Condition(String name) {
        this.name = name;
    }

    public abstract Result evaluate(Stats var1);

    boolean includedInVersion(Version version) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.value, condition.value) && Objects.equals(this.name, condition.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public final String toString() {
        return "[" + this.name + ": " + this.value + "]";
    }

    public T value() {
        return this.value;
    }

    public static class Result {
        public final Condition condition;
        public final boolean matched;

        protected Result(Condition condition, boolean matched) {
            this.condition = condition;
            this.matched = matched;
        }
    }

    public static class Stats {
        public final long numDocs;
        public final long indexCreated;
        public final ByteSizeValue indexSize;

        public Stats(long numDocs, long indexCreated, ByteSizeValue indexSize) {
            this.numDocs = numDocs;
            this.indexCreated = indexCreated;
            this.indexSize = indexSize;
        }
    }
}

