Resources.ApplicationCacheModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerApplicationCacheDispatcher(new Resources.ApplicationCacheDispatcher(this));this._agent=target.applicationCacheAgent();this._agent.enable();const resourceTreeModel=target.model(SDK.ResourceTreeModel);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.FrameNavigated,this._frameNavigated,this);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.FrameDetached,this._frameDetached,this);this._statuses={};this._manifestURLsByFrame={};this._mainFrameNavigated();this._onLine=true;}
async _frameNavigated(event){const frame=(event.data);if(frame.isMainFrame()){this._mainFrameNavigated();return;}
const frameId=frame.id;const manifestURL=await this._agent.getManifestForFrame(frameId);if(manifestURL!==null&&!manifestURL)
this._frameManifestRemoved(frameId);}
_frameDetached(event){const frame=(event.data);this._frameManifestRemoved(frame.id);}
reset(){this._statuses={};this._manifestURLsByFrame={};this.dispatchEventToListeners(Resources.ApplicationCacheModel.Events.FrameManifestsReset);}
async _mainFrameNavigated(){const framesWithManifests=await this._agent.getFramesWithManifests();for(const frame of framesWithManifests||[])
this._frameManifestUpdated(frame.frameId,frame.manifestURL,frame.status);}
_frameManifestUpdated(frameId,manifestURL,status){if(status===Resources.ApplicationCacheModel.UNCACHED){this._frameManifestRemoved(frameId);return;}
if(!manifestURL)
return;if(this._manifestURLsByFrame[frameId]&&manifestURL!==this._manifestURLsByFrame[frameId])
this._frameManifestRemoved(frameId);const statusChanged=this._statuses[frameId]!==status;this._statuses[frameId]=status;if(!this._manifestURLsByFrame[frameId]){this._manifestURLsByFrame[frameId]=manifestURL;this.dispatchEventToListeners(Resources.ApplicationCacheModel.Events.FrameManifestAdded,frameId);}
if(statusChanged)
this.dispatchEventToListeners(Resources.ApplicationCacheModel.Events.FrameManifestStatusUpdated,frameId);}
_frameManifestRemoved(frameId){if(!this._manifestURLsByFrame[frameId])
return;delete this._manifestURLsByFrame[frameId];delete this._statuses[frameId];this.dispatchEventToListeners(Resources.ApplicationCacheModel.Events.FrameManifestRemoved,frameId);}
frameManifestURL(frameId){return this._manifestURLsByFrame[frameId]||'';}
frameManifestStatus(frameId){return this._statuses[frameId]||Resources.ApplicationCacheModel.UNCACHED;}
get onLine(){return this._onLine;}
_statusUpdated(frameId,manifestURL,status){this._frameManifestUpdated(frameId,manifestURL,status);}
requestApplicationCache(frameId){return this._agent.getApplicationCacheForFrame(frameId);}
_networkStateUpdated(isNowOnline){this._onLine=isNowOnline;this.dispatchEventToListeners(Resources.ApplicationCacheModel.Events.NetworkStateChanged,isNowOnline);}};SDK.SDKModel.register(Resources.ApplicationCacheModel,SDK.Target.Capability.DOM,false);Resources.ApplicationCacheModel.Events={FrameManifestStatusUpdated:Symbol('FrameManifestStatusUpdated'),FrameManifestAdded:Symbol('FrameManifestAdded'),FrameManifestRemoved:Symbol('FrameManifestRemoved'),FrameManifestsReset:Symbol('FrameManifestsReset'),NetworkStateChanged:Symbol('NetworkStateChanged')};Resources.ApplicationCacheDispatcher=class{constructor(applicationCacheModel){this._applicationCacheModel=applicationCacheModel;}
applicationCacheStatusUpdated(frameId,manifestURL,status){this._applicationCacheModel._statusUpdated(frameId,manifestURL,status);}
networkStateUpdated(isNowOnline){this._applicationCacheModel._networkStateUpdated(isNowOnline);}};Resources.ApplicationCacheModel.UNCACHED=0;Resources.ApplicationCacheModel.IDLE=1;Resources.ApplicationCacheModel.CHECKING=2;Resources.ApplicationCacheModel.DOWNLOADING=3;Resources.ApplicationCacheModel.UPDATEREADY=4;Resources.ApplicationCacheModel.OBSOLETE=5;;Resources.AppManifestView=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('resources/appManifestView.css');Common.moduleSetting('colorFormat').addChangeListener(this._updateManifest.bind(this,true));this._emptyView=new UI.EmptyWidget(Common.UIString('No manifest detected'));this._emptyView.appendLink('https://developers.google.com/web/fundamentals/engage-and-retain/web-app-manifest/?utm_source=devtools');this._emptyView.show(this.contentElement);this._emptyView.hideWidget();this._reportView=new UI.ReportView(Common.UIString('App Manifest'));this._reportView.show(this.contentElement);this._reportView.hideWidget();this._errorsSection=this._reportView.appendSection(Common.UIString('Errors and warnings'));this._installabilitySection=this._reportView.appendSection(Common.UIString('Installability'));this._identitySection=this._reportView.appendSection(Common.UIString('Identity'));this._presentationSection=this._reportView.appendSection(Common.UIString('Presentation'));this._iconsSection=this._reportView.appendSection(Common.UIString('Icons'));this._nameField=this._identitySection.appendField(Common.UIString('Name'));this._shortNameField=this._identitySection.appendField(Common.UIString('Short name'));this._startURLField=this._presentationSection.appendField(Common.UIString('Start URL'));const themeColorField=this._presentationSection.appendField(Common.UIString('Theme color'));this._themeColorSwatch=InlineEditor.ColorSwatch.create();themeColorField.appendChild(this._themeColorSwatch);const backgroundColorField=this._presentationSection.appendField(Common.UIString('Background color'));this._backgroundColorSwatch=InlineEditor.ColorSwatch.create();backgroundColorField.appendChild(this._backgroundColorSwatch);this._orientationField=this._presentationSection.appendField(Common.UIString('Orientation'));this._displayField=this._presentationSection.appendField(Common.UIString('Display'));this._throttler=new Common.Throttler(1000);SDK.targetManager.observeTargets(this);}
targetAdded(target){if(this._target)
return;this._target=target;this._resourceTreeModel=target.model(SDK.ResourceTreeModel);this._serviceWorkerManager=target.model(SDK.ServiceWorkerManager);if(!this._resourceTreeModel||!this._serviceWorkerManager)
return;this._updateManifest(true);this._registeredListeners=[this._resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.DOMContentLoaded,this._updateManifest.bind(this,true)),this._serviceWorkerManager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this._updateManifest.bind(this,false))];}
targetRemoved(target){if(this._target!==target)
return;if(!this._resourceTreeModel||!this._serviceWorkerManager)
return;delete this._resourceTreeModel;delete this._serviceWorkerManager;Common.EventTarget.removeEventListeners(this._registeredListeners);}
async _updateManifest(immediately){const{url,data,errors}=await this._resourceTreeModel.fetchAppManifest();const installabilityErrors=await this._resourceTreeModel.getInstallabilityErrors();this._throttler.schedule(()=>this._renderManifest(url,data,errors,installabilityErrors),immediately);}
async _renderManifest(url,data,errors,installabilityErrors){if(!data&&!errors.length){this._emptyView.showWidget();this._reportView.hideWidget();return;}
this._emptyView.hideWidget();this._reportView.showWidget();const link=Components.Linkifier.linkifyURL(url);link.tabIndex=0;this._reportView.setURL(link);this._errorsSection.clearContent();this._errorsSection.element.classList.toggle('hidden',!errors.length);for(const error of errors){this._errorsSection.appendRow().appendChild(UI.createIconLabel(error.message,error.critical?'smallicon-error':'smallicon-warning'));}
if(!data)
return;if(data.charCodeAt(0)===0xFEFF)
data=data.slice(1);const parsedManifest=JSON.parse(data);this._nameField.textContent=stringProperty('name');this._shortNameField.textContent=stringProperty('short_name');this._startURLField.removeChildren();const startURL=stringProperty('start_url');if(startURL){const completeURL=(Common.ParsedURL.completeURL(url,startURL));const link=Components.Linkifier.linkifyURL(completeURL,{text:startURL});link.tabIndex=0;this._startURLField.appendChild(link);}
this._themeColorSwatch.classList.toggle('hidden',!stringProperty('theme_color'));const themeColor=Common.Color.parse(stringProperty('theme_color')||'white')||Common.Color.parse('white');this._themeColorSwatch.setColor((themeColor));this._themeColorSwatch.setFormat(Common.Color.detectColorFormat(this._themeColorSwatch.color()));this._backgroundColorSwatch.classList.toggle('hidden',!stringProperty('background_color'));const backgroundColor=Common.Color.parse(stringProperty('background_color')||'white')||Common.Color.parse('white');this._backgroundColorSwatch.setColor((backgroundColor));this._backgroundColorSwatch.setFormat(Common.Color.detectColorFormat(this._backgroundColorSwatch.color()));this._orientationField.textContent=stringProperty('orientation');const displayType=stringProperty('display');this._displayField.textContent=displayType;const icons=parsedManifest['icons']||[];this._iconsSection.clearContent();for(const icon of icons){const title=(icon['sizes']||'')+'\n'+(icon['type']||'');const field=this._iconsSection.appendField(title);const image=await this._loadImage(Common.ParsedURL.completeURL(url,icon['src']));if(image)
field.appendChild(image);}
this._installabilitySection.clearContent();this._installabilitySection.element.classList.toggle('hidden',!installabilityErrors.length);for(const error of installabilityErrors)
this._installabilitySection.appendRow().appendChild(UI.createIconLabel(error,'smallicon-warning'));function stringProperty(name){const value=parsedManifest[name];if(typeof value!=='string')
return'';return value;}}
async _loadImage(url){const image=createElement('img');image.style.maxWidth='200px';image.style.maxHeight='200px';const result=new Promise((f,r)=>{image.onload=f;image.onerror=r;});image.src=url;image.alt=ls`Image from ${url}`;try{await result;return image;}catch(e){}
return null;}};;Resources.ApplicationCacheItemsView=class extends UI.SimpleView{constructor(model,frameId){super(Common.UIString('AppCache'));this._model=model;this.element.classList.add('storage-view','table');this._deleteButton=new UI.ToolbarButton(Common.UIString('Delete'),'largeicon-delete');this._deleteButton.setVisible(false);this._deleteButton.addEventListener(UI.ToolbarButton.Events.Click,this._deleteButtonClicked,this);this._connectivityIcon=createElement('span','dt-icon-label');this._connectivityIcon.style.margin='0 2px 0 5px';this._statusIcon=createElement('span','dt-icon-label');this._statusIcon.style.margin='0 2px 0 5px';this._frameId=frameId;this._emptyWidget=new UI.EmptyWidget(Common.UIString('No Application Cache information available.'));this._emptyWidget.show(this.element);this._markDirty();const status=this._model.frameManifestStatus(frameId);this.updateStatus(status);this.updateNetworkState(this._model.onLine);this._deleteButton.element.style.display='none';}
syncToolbarItems(){return[this._deleteButton,new UI.ToolbarItem(this._connectivityIcon),new UI.ToolbarSeparator(),new UI.ToolbarItem(this._statusIcon)];}
wasShown(){this._maybeUpdate();}
willHide(){this._deleteButton.setVisible(false);}
_maybeUpdate(){if(!this.isShowing()||!this._viewDirty)
return;this._update();this._viewDirty=false;}
_markDirty(){this._viewDirty=true;}
updateStatus(status){const oldStatus=this._status;this._status=status;const statusInformation={};statusInformation[Resources.ApplicationCacheModel.UNCACHED]={type:'smallicon-red-ball',text:'UNCACHED'};statusInformation[Resources.ApplicationCacheModel.IDLE]={type:'smallicon-green-ball',text:'IDLE'};statusInformation[Resources.ApplicationCacheModel.CHECKING]={type:'smallicon-orange-ball',text:'CHECKING'};statusInformation[Resources.ApplicationCacheModel.DOWNLOADING]={type:'smallicon-orange-ball',text:'DOWNLOADING'};statusInformation[Resources.ApplicationCacheModel.UPDATEREADY]={type:'smallicon-green-ball',text:'UPDATEREADY'};statusInformation[Resources.ApplicationCacheModel.OBSOLETE]={type:'smallicon-red-ball',text:'OBSOLETE'};const info=statusInformation[status]||statusInformation[Resources.ApplicationCacheModel.UNCACHED];this._statusIcon.type=info.type;this._statusIcon.textContent=info.text;if(this.isShowing()&&this._status===Resources.ApplicationCacheModel.IDLE&&(oldStatus===Resources.ApplicationCacheModel.UPDATEREADY||!this._resources))
this._markDirty();this._maybeUpdate();}
updateNetworkState(isNowOnline){if(isNowOnline){this._connectivityIcon.type='smallicon-green-ball';this._connectivityIcon.textContent=Common.UIString('Online');}else{this._connectivityIcon.type='smallicon-red-ball';this._connectivityIcon.textContent=Common.UIString('Offline');}}
async _update(){const applicationCache=await this._model.requestApplicationCache(this._frameId);if(!applicationCache||!applicationCache.manifestURL){delete this._manifest;delete this._creationTime;delete this._updateTime;delete this._size;delete this._resources;this._emptyWidget.show(this.element);this._deleteButton.setVisible(false);if(this._dataGrid)
this._dataGrid.element.classList.add('hidden');return;}
this._manifest=applicationCache.manifestURL;this._creationTime=applicationCache.creationTime;this._updateTime=applicationCache.updateTime;this._size=applicationCache.size;this._resources=applicationCache.resources;if(!this._dataGrid)
this._createDataGrid();this._populateDataGrid();this._dataGrid.autoSizeColumns(20,80);this._dataGrid.element.classList.remove('hidden');this._emptyWidget.detach();this._deleteButton.setVisible(true);}
_createDataGrid(){const columns=([{id:'resource',title:Common.UIString('Resource'),sort:DataGrid.DataGrid.Order.Ascending,sortable:true},{id:'type',title:Common.UIString('Type'),sortable:true},{id:'size',title:Common.UIString('Size'),align:DataGrid.DataGrid.Align.Right,sortable:true}]);this._dataGrid=new DataGrid.DataGrid(columns);this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.element);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._populateDataGrid,this);}
_populateDataGrid(){const selectedResource=this._dataGrid.selectedNode?this._dataGrid.selectedNode.resource:null;const sortDirection=this._dataGrid.isSortOrderAscending()?1:-1;function numberCompare(field,resource1,resource2){return sortDirection*(resource1[field]-resource2[field]);}
function localeCompare(field,resource1,resource2){return sortDirection*(resource1[field]+'').localeCompare(resource2[field]+'');}
let comparator;switch(this._dataGrid.sortColumnId()){case'resource':comparator=localeCompare.bind(null,'url');break;case'type':comparator=localeCompare.bind(null,'type');break;case'size':comparator=numberCompare.bind(null,'size');break;default:localeCompare.bind(null,'resource');}
this._resources.sort(comparator);this._dataGrid.rootNode().removeChildren();let nodeToSelect;for(let i=0;i<this._resources.length;++i){const data={};const resource=this._resources[i];data.resource=resource.url;data.type=resource.type;data.size=Number.bytesToString(resource.size);const node=new DataGrid.DataGridNode(data);node.resource=resource;node.selectable=true;this._dataGrid.rootNode().appendChild(node);if(resource===selectedResource){nodeToSelect=node;nodeToSelect.selected=true;}}
if(!nodeToSelect&&this._dataGrid.rootNode().children.length)
this._dataGrid.rootNode().children[0].selected=true;}
_deleteButtonClicked(event){if(!this._dataGrid||!this._dataGrid.selectedNode)
return;this._deleteCallback(this._dataGrid.selectedNode);}
_deleteCallback(node){}};;Resources.BackgroundServiceModel=class extends SDK.SDKModel{constructor(target){super(target);this._backgroundServiceAgent=target.backgroundServiceAgent();target.registerBackgroundServiceDispatcher(this);this._events=new Map();}
enable(serviceName){this._events.set(serviceName,[]);this._backgroundServiceAgent.startObserving(serviceName);}
setRecording(shouldRecord,serviceName){this._backgroundServiceAgent.setRecording(shouldRecord,serviceName);}
clearEvents(serviceName){this._events.set(serviceName,[]);this._backgroundServiceAgent.clearEvents(serviceName);}
getEvents(serviceName){return this._events.get(serviceName)||[];}
recordingStateChanged(isRecording,serviceName){this.dispatchEventToListeners(Resources.BackgroundServiceModel.Events.RecordingStateChanged,{isRecording,serviceName});}
backgroundServiceEventReceived(backgroundServiceEvent){this._events.get(backgroundServiceEvent.service).push(backgroundServiceEvent);this.dispatchEventToListeners(Resources.BackgroundServiceModel.Events.BackgroundServiceEventReceived,backgroundServiceEvent);}};SDK.SDKModel.register(Resources.BackgroundServiceModel,SDK.Target.Capability.Browser,false);Resources.BackgroundServiceModel.Events={RecordingStateChanged:Symbol('RecordingStateChanged'),BackgroundServiceEventReceived:Symbol('BackgroundServiceEventReceived'),};Resources.BackgroundServiceModel.RecordingState;;Resources.BackgroundServiceView=class extends UI.VBox{static getUIString(serviceName){switch(serviceName){case Protocol.BackgroundService.ServiceName.BackgroundFetch:return ls`Background Fetch`;case Protocol.BackgroundService.ServiceName.BackgroundSync:return ls`Background Sync`;case Protocol.BackgroundService.ServiceName.PushMessaging:return ls`Push Messaging`;case Protocol.BackgroundService.ServiceName.Notifications:return ls`Notifications`;case Protocol.BackgroundService.ServiceName.PaymentHandler:return ls`Payment Handler`;case Protocol.BackgroundService.ServiceName.PeriodicBackgroundSync:return ls`Periodic Background Sync`;default:return'';}}
constructor(serviceName,model){super(true);this.registerRequiredCSS('resources/backgroundServiceView.css');this.registerRequiredCSS('ui/emptyWidget.css');this._serviceName=serviceName;this._model=model;this._model.addEventListener(Resources.BackgroundServiceModel.Events.RecordingStateChanged,this._onRecordingStateChanged,this);this._model.addEventListener(Resources.BackgroundServiceModel.Events.BackgroundServiceEventReceived,this._onEventReceived,this);this._model.enable(this._serviceName);this._serviceWorkerManager=this._model.target().model(SDK.ServiceWorkerManager);this._securityOriginManager=this._model.target().model(SDK.SecurityOriginManager);this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.MainSecurityOriginChanged,()=>this._onOriginChanged());this._recordAction=(UI.actionRegistry.action('background-service.toggle-recording'));this._recordButton=null;this._originCheckbox=null;this._saveButton=null;this._toolbar=new UI.Toolbar('background-service-toolbar',this.contentElement);this._setupToolbar();this._splitWidget=new UI.SplitWidget(false,true);this._splitWidget.show(this.contentElement);this._dataGrid=this._createDataGrid();this._previewPanel=new UI.VBox();this._selectedEventNode=null;this._preview=null;this._splitWidget.setMainWidget(this._dataGrid.asWidget());this._splitWidget.setSidebarWidget(this._previewPanel);this._showPreview(null);}
async _setupToolbar(){this._recordButton=UI.Toolbar.createActionButton(this._recordAction);this._toolbar.appendToolbarItem(this._recordButton);const clearButton=new UI.ToolbarButton(ls`Clear`,'largeicon-clear');clearButton.addEventListener(UI.ToolbarButton.Events.Click,()=>this._clearEvents());this._toolbar.appendToolbarItem(clearButton);this._toolbar.appendSeparator();this._saveButton=new UI.ToolbarButton(ls`Save events`,'largeicon-download');this._saveButton.addEventListener(UI.ToolbarButton.Events.Click,()=>this._saveToFile());this._saveButton.setEnabled(false);this._toolbar.appendToolbarItem(this._saveButton);this._toolbar.appendSeparator();this._originCheckbox=new UI.ToolbarCheckbox(ls`Show events from other domains`,undefined,()=>this._refreshView());this._toolbar.appendToolbarItem(this._originCheckbox);}
_refreshView(){this._clearView();const events=this._model.getEvents(this._serviceName).filter(event=>this._acceptEvent(event));for(const event of events)
this._addEvent(event);}
_clearView(){this._selectedEventNode=null;this._dataGrid.rootNode().removeChildren();this._saveButton.setEnabled(false);this._showPreview(null);}
_toggleRecording(){this._model.setRecording(!this._recordButton.toggled(),this._serviceName);}
_clearEvents(){this._model.clearEvents(this._serviceName);this._clearView();}
_onRecordingStateChanged(event){const state=(event.data);if(state.serviceName!==this._serviceName)
return;if(state.isRecording===this._recordButton.toggled())
return;this._recordButton.setToggled(state.isRecording);this._showPreview(this._selectedEventNode);}
_onEventReceived(event){const serviceEvent=(event.data);if(!this._acceptEvent(serviceEvent))
return;this._addEvent(serviceEvent);}
_onOriginChanged(){if(this._originCheckbox.checked())
return;this._refreshView();}
_addEvent(serviceEvent){const data=this._createEventData(serviceEvent);const dataNode=new Resources.BackgroundServiceView.EventDataNode(data,serviceEvent.eventMetadata);this._dataGrid.rootNode().appendChild(dataNode);if(this._dataGrid.rootNode().children.length===1){this._saveButton.setEnabled(true);this._showPreview(this._selectedEventNode);}}
_createDataGrid(){const columns=([{id:'id',title:ls`#`,weight:1},{id:'timestamp',title:ls`Timestamp`,weight:8},{id:'eventName',title:ls`Event`,weight:10},{id:'origin',title:ls`Origin`,weight:10},{id:'swScope',title:ls`SW Scope`,weight:2},{id:'instanceId',title:ls`Instance ID`,weight:10},]);const dataGrid=new DataGrid.DataGrid(columns);dataGrid.setStriped(true);dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,event=>this._showPreview((event.data)));return dataGrid;}
_createEventData(serviceEvent){let swScope='';const registration=this._serviceWorkerManager.registrations().get(serviceEvent.serviceWorkerRegistrationId);if(registration)
swScope=registration.scopeURL.substr(registration.securityOrigin.length);return{id:this._dataGrid.rootNode().children.length+1,timestamp:UI.formatTimestamp(serviceEvent.timestamp*1000,true),origin:serviceEvent.origin,swScope,eventName:serviceEvent.eventName,instanceId:serviceEvent.instanceId,};}
_acceptEvent(event){if(event.service!==this._serviceName)
return false;if(this._originCheckbox.checked())
return true;const origin=event.origin.substr(0,event.origin.length-1);return this._securityOriginManager.securityOrigins().includes(origin);}
_showPreview(dataNode){if(this._selectedEventNode&&this._selectedEventNode===dataNode)
return;this._selectedEventNode=dataNode;if(this._preview)
this._preview.detach();if(this._selectedEventNode){this._preview=this._selectedEventNode.createPreview();this._preview.show(this._previewPanel.contentElement);return;}
this._preview=new UI.VBox();this._preview.contentElement.classList.add('background-service-preview','fill');const centered=this._preview.contentElement.createChild('div');if(this._dataGrid.rootNode().children.length){centered.createChild('p').textContent=ls`Select an entry to view metadata`;}else if(this._recordButton.toggled()){const featureName=Resources.BackgroundServiceView.getUIString(this._serviceName);centered.createChild('p').textContent=ls`Recording ${featureName} activity...`;centered.createChild('p').textContent=ls`DevTools will record all ${featureName} activity for up to 3 days, even when closed.`;}else{const landingRecordButton=UI.Toolbar.createActionButton(this._recordAction);const recordKey=createElementWithClass('b','background-service-shortcut');recordKey.textContent=UI.shortcutRegistry.shortcutDescriptorsForAction('background-service.toggle-recording')[0].name;centered.createChild('p').appendChild(UI.formatLocalized('Click the record button %s or hit %s to start recording.',[UI.createInlineButton(landingRecordButton),recordKey]));}
this._preview.show(this._previewPanel.contentElement);}
async _saveToFile(){const fileName=`${this._serviceName}-${new Date().toISO8601Compact()}.json`;const stream=new Bindings.FileOutputStream();const accepted=await stream.open(fileName);if(!accepted)
return;const events=this._model.getEvents(this._serviceName).filter(event=>this._acceptEvent(event));await stream.write(JSON.stringify(events,undefined,2));stream.close();}};Resources.BackgroundServiceView.EventData;Resources.BackgroundServiceView.EventDataNode=class extends DataGrid.DataGridNode{constructor(data,eventMetadata){super(data);this._eventMetadata=eventMetadata.sort((m1,m2)=>m1.key.compareTo(m2.key));}
createPreview(){const preview=new UI.VBox();preview.element.classList.add('background-service-metadata');for(const entry of this._eventMetadata){const div=createElementWithClass('div','background-service-metadata-entry');div.createChild('div','background-service-metadata-name').textContent=entry.key+': ';if(entry.value){div.createChild('div','background-service-metadata-value source-code').textContent=entry.value;}else{div.createChild('div','background-service-metadata-value background-service-empty-value').textContent=ls`empty`;}
preview.element.appendChild(div);}
if(!preview.element.children.length){const div=createElementWithClass('div','background-service-metadata-entry');div.createChild('div','background-service-metadata-name').textContent=ls`No metadata for this event`;preview.element.appendChild(div);}
return preview;}};Resources.BackgroundServiceView.ActionDelegate=class{handleAction(context,actionId){const view=context.flavor(Resources.BackgroundServiceView);switch(actionId){case'background-service.toggle-recording':view._toggleRecording();return true;}
return false;}};;Resources.ClearStorageView=class extends UI.ThrottledWidget{constructor(){super(true,1000);const types=Protocol.Storage.StorageType;this._pieColors=new Map([[types.Appcache,'rgb(110, 161, 226)'],[types.Cache_storage,'rgb(229, 113, 113)'],[types.Cookies,'rgb(239, 196, 87)'],[types.Indexeddb,'rgb(155, 127, 230)'],[types.Local_storage,'rgb(116, 178, 102)'],[types.Service_workers,'rgb(255, 167, 36)'],[types.Websql,'rgb(203, 220, 56)'],]);this._reportView=new UI.ReportView(Common.UIString('Clear storage'));this._reportView.registerRequiredCSS('resources/clearStorageView.css');this._reportView.element.classList.add('clear-storage-header');this._reportView.show(this.contentElement);this._target=null;this._securityOrigin=null;this._settings=new Map();for(const type of Resources.ClearStorageView.AllStorageTypes)
this._settings.set(type,Common.settings.createSetting('clear-storage-'+type,true));const quota=this._reportView.appendSection(Common.UIString('Usage'));this._quotaRow=quota.appendSelectableRow();const learnMoreRow=quota.appendRow();const learnMore=UI.XLink.create('https://developers.google.com/web/tools/chrome-devtools/progressive-web-apps#opaque-responses',ls`Learn more`);learnMoreRow.appendChild(learnMore);this._quotaUsage=null;this._pieChart=new PerfUI.PieChart({chartName:ls`Storage Usage`,size:110,formatter:Number.bytesToString,showLegend:true});const usageBreakdownRow=quota.appendRow();usageBreakdownRow.classList.add('usage-breakdown-row');usageBreakdownRow.appendChild(this._pieChart.element);const clearButtonSection=this._reportView.appendSection('','clear-storage-button').appendRow();this._clearButton=UI.createTextButton(ls`Clear site data`,this._clear.bind(this));clearButtonSection.appendChild(this._clearButton);const application=this._reportView.appendSection(Common.UIString('Application'));this._appendItem(application,Common.UIString('Unregister service workers'),'service_workers');application.markFieldListAsGroup();const storage=this._reportView.appendSection(Common.UIString('Storage'));this._appendItem(storage,Common.UIString('Local and session storage'),'local_storage');this._appendItem(storage,Common.UIString('IndexedDB'),'indexeddb');this._appendItem(storage,Common.UIString('Web SQL'),'websql');this._appendItem(storage,Common.UIString('Cookies'),'cookies');storage.markFieldListAsGroup();const caches=this._reportView.appendSection(Common.UIString('Cache'));this._appendItem(caches,Common.UIString('Cache storage'),'cache_storage');this._appendItem(caches,Common.UIString('Application cache'),'appcache');caches.markFieldListAsGroup();SDK.targetManager.observeTargets(this);}
_appendItem(section,title,settingName){const row=section.appendRow();row.appendChild(UI.SettingsUI.createSettingCheckbox(title,this._settings.get(settingName),true));}
targetAdded(target){if(this._target)
return;this._target=target;const securityOriginManager=target.model(SDK.SecurityOriginManager);this._updateOrigin(securityOriginManager.mainSecurityOrigin(),securityOriginManager.unreachableMainSecurityOrigin());securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.MainSecurityOriginChanged,this._originChanged,this);}
targetRemoved(target){if(this._target!==target)
return;const securityOriginManager=target.model(SDK.SecurityOriginManager);securityOriginManager.removeEventListener(SDK.SecurityOriginManager.Events.MainSecurityOriginChanged,this._originChanged,this);}
_originChanged(event){const mainOrigin=(event.data.mainSecurityOrigin);const unreachableMainOrigin=(event.data.unreachableMainSecurityOrigin);this._updateOrigin(mainOrigin,unreachableMainOrigin);}
_updateOrigin(mainOrigin,unreachableMainOrigin){if(unreachableMainOrigin){this._securityOrigin=unreachableMainOrigin;this._reportView.setSubtitle(ls`${unreachableMainOrigin} (failed to load)`);}else{this._securityOrigin=mainOrigin;this._reportView.setSubtitle(mainOrigin);}
this.doUpdate();}
_clear(){if(!this._securityOrigin)
return;const selectedStorageTypes=[];for(const type of this._settings.keys()){if(this._settings.get(type).get())
selectedStorageTypes.push(type);}
if(this._target)
Resources.ClearStorageView.clear(this._target,this._securityOrigin,selectedStorageTypes);this._clearButton.disabled=true;const label=this._clearButton.textContent;this._clearButton.textContent=Common.UIString('Clearing...');setTimeout(()=>{this._clearButton.disabled=false;this._clearButton.textContent=label;},500);}
static clear(target,securityOrigin,selectedStorageTypes){target.storageAgent().clearDataForOrigin(securityOrigin,selectedStorageTypes.join(','));const set=new Set(selectedStorageTypes);const hasAll=set.has(Protocol.Storage.StorageType.All);if(set.has(Protocol.Storage.StorageType.Cookies)||hasAll){const cookieModel=target.model(SDK.CookieModel);if(cookieModel)
cookieModel.clear();}
if(set.has(Protocol.Storage.StorageType.Indexeddb)||hasAll){for(const target of SDK.targetManager.targets()){const indexedDBModel=target.model(Resources.IndexedDBModel);if(indexedDBModel)
indexedDBModel.clearForOrigin(securityOrigin);}}
if(set.has(Protocol.Storage.StorageType.Local_storage)||hasAll){const storageModel=target.model(Resources.DOMStorageModel);if(storageModel)
storageModel.clearForOrigin(securityOrigin);}
if(set.has(Protocol.Storage.StorageType.Websql)||hasAll){const databaseModel=target.model(Resources.DatabaseModel);if(databaseModel){databaseModel.disable();databaseModel.enable();}}
if(set.has(Protocol.Storage.StorageType.Cache_storage)||hasAll){const target=SDK.targetManager.mainTarget();const model=target&&target.model(SDK.ServiceWorkerCacheModel);if(model)
model.clearForOrigin(securityOrigin);}
if(set.has(Protocol.Storage.StorageType.Appcache)||hasAll){const appcacheModel=target.model(Resources.ApplicationCacheModel);if(appcacheModel)
appcacheModel.reset();}}
async doUpdate(){if(!this._securityOrigin)
return;const securityOrigin=(this._securityOrigin);const response=await this._target.storageAgent().invoke_getUsageAndQuota({origin:securityOrigin});if(response[Protocol.Error]){this._quotaRow.textContent='';this._resetPieChart(0);return;}
this._quotaRow.textContent=Common.UIString('%s used out of %s storage quota.\u00a0',Number.bytesToString(response.usage),Number.bytesToString(response.quota));if(response.quota<125829120){this._quotaRow.title=ls`Storage quota is limited in Incognito mode`;this._quotaRow.appendChild(UI.Icon.create('smallicon-info'));}
if(!this._quotaUsage||this._quotaUsage!==response.usage){this._quotaUsage=response.usage;this._resetPieChart(response.usage);for(const usageForType of response.usageBreakdown.sort((a,b)=>b.usage-a.usage)){const value=usageForType.usage;if(!value)
continue;const title=this._getStorageTypeName(usageForType.storageType);const color=this._pieColors.get(usageForType.storageType)||'#ccc';this._pieChart.addSlice(value,color,title);}}
this._usageUpdatedForTest(response.usage,response.quota,response.usageBreakdown);this.update();}
_resetPieChart(total){this._pieChart.setTotal(total);}
_getStorageTypeName(type){switch(type){case Protocol.Storage.StorageType.File_systems:return Common.UIString('File System');case Protocol.Storage.StorageType.Websql:return Common.UIString('Web SQL');case Protocol.Storage.StorageType.Appcache:return Common.UIString('Application Cache');case Protocol.Storage.StorageType.Indexeddb:return Common.UIString('IndexedDB');case Protocol.Storage.StorageType.Cache_storage:return Common.UIString('Cache Storage');case Protocol.Storage.StorageType.Service_workers:return Common.UIString('Service Workers');default:return Common.UIString('Other');}}
_usageUpdatedForTest(usage,quota,usageBreakdown){}};Resources.ClearStorageView.AllStorageTypes=[Protocol.Storage.StorageType.Appcache,Protocol.Storage.StorageType.Cache_storage,Protocol.Storage.StorageType.Cookies,Protocol.Storage.StorageType.Indexeddb,Protocol.Storage.StorageType.Local_storage,Protocol.Storage.StorageType.Service_workers,Protocol.Storage.StorageType.Websql];Resources.ClearStorageView.ActionDelegate=class{handleAction(context,actionId){switch(actionId){case'resources.clear':return this._handleClear();}
return false;}
_handleClear(){const target=SDK.targetManager.mainTarget();if(!target)
return false;const resourceTreeModel=target.model(SDK.ResourceTreeModel);if(!resourceTreeModel)
return false;const securityOrigin=resourceTreeModel.getMainSecurityOrigin();if(!securityOrigin)
return false;Resources.ClearStorageView.clear(target,securityOrigin,Resources.ClearStorageView.AllStorageTypes);return true;}};;Resources.StorageItemsView=class extends UI.VBox{constructor(title,filterName){super(false);this._filterRegex=null;this._refreshButton=this._addButton(Common.UIString('Refresh'),'largeicon-refresh',this.refreshItems);this._mainToolbar=new UI.Toolbar('top-resources-toolbar',this.element);this._filterItem=new UI.ToolbarInput(Common.UIString('Filter'),0.4);this._filterItem.addEventListener(UI.ToolbarInput.Event.TextChanged,this._filterChanged,this);const toolbarSeparator=new UI.ToolbarSeparator();this._deleteAllButton=this._addButton(Common.UIString('Clear All'),'largeicon-clear',this.deleteAllItems);this._deleteSelectedButton=this._addButton(Common.UIString('Delete Selected'),'largeicon-delete',this.deleteSelectedItem);const toolbarItems=[this._refreshButton,this._filterItem,toolbarSeparator,this._deleteAllButton,this._deleteSelectedButton];for(const item of toolbarItems)
this._mainToolbar.appendToolbarItem(item);}
_addButton(label,glyph,callback){const button=new UI.ToolbarButton(label,glyph);button.addEventListener(UI.ToolbarButton.Events.Click,callback,this);return button;}
_filterChanged(event){const text=(event.data);this._filterRegex=text?new RegExp(text.escapeForRegExp(),'i'):null;this.refreshItems();}
filter(items,keyFunction){if(!this._filterRegex)
return items;return items.filter(item=>this._filterRegex.test(keyFunction(item)));}
wasShown(){this.refreshItems();}
setCanDeleteAll(enabled){this._deleteAllButton.setEnabled(enabled);}
setCanDeleteSelected(enabled){this._deleteSelectedButton.setEnabled(enabled);}
setCanRefresh(enabled){this._refreshButton.setEnabled(enabled);}
setCanFilter(enabled){this._filterItem.setEnabled(enabled);}
deleteAllItems(){}
deleteSelectedItem(){}
refreshItems(){}};;Resources.CookieItemsView=class extends Resources.StorageItemsView{constructor(model,cookieDomain){super(Common.UIString('Cookies'),'cookiesPanel');this.element.classList.add('storage-view');this._model=model;this._cookieDomain=cookieDomain;this._totalSize=0;this._cookiesTable=null;this._refreshThrottler=new Common.Throttler(300);this._eventDescriptors=[];this.setCookiesDomain(model,cookieDomain);}
setCookiesDomain(model,domain){this._model=model;this._cookieDomain=domain;this.refreshItems();Common.EventTarget.removeEventListeners(this._eventDescriptors);const networkManager=model.target().model(SDK.NetworkManager);this._eventDescriptors=[networkManager.addEventListener(SDK.NetworkManager.Events.ResponseReceived,this._onResponseReceived,this)];}
_saveCookie(newCookie,oldCookie){if(!this._model)
return Promise.resolve(false);if(oldCookie&&(newCookie.name()!==oldCookie.name()||newCookie.url()!==oldCookie.url()))
this._model.deleteCookie(oldCookie);return this._model.saveCookie(newCookie);}
_deleteCookie(cookie,callback){this._model.deleteCookie(cookie,callback);}
_updateWithCookies(allCookies){this._totalSize=allCookies.reduce((size,cookie)=>size+cookie.size(),0);if(!this._cookiesTable){this._cookiesTable=new CookieTable.CookiesTable(this._saveCookie.bind(this),this.refreshItems.bind(this),()=>this.setCanDeleteSelected(!!this._cookiesTable.selectedCookie()),this._deleteCookie.bind(this));}
const parsedURL=this._cookieDomain.asParsedURL();const host=parsedURL?parsedURL.host:'';this._cookiesTable.setCookieDomain(host);const shownCookies=this.filter(allCookies,cookie=>`${cookie.name()} ${cookie.value()} ${cookie.domain()}`);this._cookiesTable.setCookies(shownCookies);this._cookiesTable.show(this.element);this.setCanFilter(true);this.setCanDeleteAll(true);this.setCanDeleteSelected(!!this._cookiesTable.selectedCookie());}
deleteAllItems(){this._model.clear(this._cookieDomain,()=>this.refreshItems());}
deleteSelectedItem(){const selectedCookie=this._cookiesTable.selectedCookie();if(selectedCookie)
this._model.deleteCookie(selectedCookie,()=>this.refreshItems());}
refreshItems(){this._model.getCookiesForDomain(this._cookieDomain).then(this._updateWithCookies.bind(this));}
_onResponseReceived(){this._refreshThrottler.schedule(()=>Promise.resolve(this.refreshItems()));}};;Resources.Database=class{constructor(model,id,domain,name,version){this._model=model;this._id=id;this._domain=domain;this._name=name;this._version=version;}
get id(){return this._id;}
get name(){return this._name;}
set name(x){this._name=x;}
get version(){return this._version;}
set version(x){this._version=x;}
get domain(){return this._domain;}
set domain(x){this._domain=x;}
async tableNames(){const names=await this._model._agent.getDatabaseTableNames(this._id)||[];return names.sort();}
async executeSql(query,onSuccess,onError){const response=await this._model._agent.invoke_executeSQL({'databaseId':this._id,'query':query});const error=response[Protocol.Error];if(error){onError(error);return;}
const sqlError=response.sqlError;if(!sqlError){onSuccess(response.columnNames,response.values);return;}
let message;if(sqlError.message)
message=sqlError.message;else if(sqlError.code===2)
message=Common.UIString('Database no longer has expected version.');else
message=Common.UIString('An unexpected error %s occurred.',sqlError.code);onError(message);}};Resources.DatabaseModel=class extends SDK.SDKModel{constructor(target){super(target);this._databases=[];this._agent=target.databaseAgent();this.target().registerDatabaseDispatcher(new Resources.DatabaseDispatcher(this));}
enable(){if(this._enabled)
return;this._agent.enable();this._enabled=true;}
disable(){if(!this._enabled)
return;this._enabled=false;this._databases=[];this._agent.disable();this.dispatchEventToListeners(Resources.DatabaseModel.Events.DatabasesRemoved);}
databases(){const result=[];for(const database of this._databases)
result.push(database);return result;}
_addDatabase(database){this._databases.push(database);this.dispatchEventToListeners(Resources.DatabaseModel.Events.DatabaseAdded,database);}};SDK.SDKModel.register(Resources.DatabaseModel,SDK.Target.Capability.None,false);Resources.DatabaseModel.Events={DatabaseAdded:Symbol('DatabaseAdded'),DatabasesRemoved:Symbol('DatabasesRemoved'),};Resources.DatabaseDispatcher=class{constructor(model){this._model=model;}
addDatabase(payload){this._model._addDatabase(new Resources.Database(this._model,payload.id,payload.domain,payload.name,payload.version));}};Resources.DatabaseModel._symbol=Symbol('DatabaseModel');;Resources.DOMStorage=class extends Common.Object{constructor(model,securityOrigin,isLocalStorage){super();this._model=model;this._securityOrigin=securityOrigin;this._isLocalStorage=isLocalStorage;}
static storageId(securityOrigin,isLocalStorage){return{securityOrigin:securityOrigin,isLocalStorage:isLocalStorage};}
get id(){return Resources.DOMStorage.storageId(this._securityOrigin,this._isLocalStorage);}
get securityOrigin(){return this._securityOrigin;}
get isLocalStorage(){return this._isLocalStorage;}
getItems(){return this._model._agent.getDOMStorageItems(this.id);}
setItem(key,value){this._model._agent.setDOMStorageItem(this.id,key,value);}
removeItem(key){this._model._agent.removeDOMStorageItem(this.id,key);}
clear(){this._model._agent.clear(this.id);}};Resources.DOMStorage.Events={DOMStorageItemsCleared:Symbol('DOMStorageItemsCleared'),DOMStorageItemRemoved:Symbol('DOMStorageItemRemoved'),DOMStorageItemAdded:Symbol('DOMStorageItemAdded'),DOMStorageItemUpdated:Symbol('DOMStorageItemUpdated')};Resources.DOMStorageModel=class extends SDK.SDKModel{constructor(target){super(target);this._securityOriginManager=target.model(SDK.SecurityOriginManager);this._storages={};this._agent=target.domstorageAgent();}
enable(){if(this._enabled)
return;this.target().registerDOMStorageDispatcher(new Resources.DOMStorageDispatcher(this));this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginAdded,this._securityOriginAdded,this);this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,this._securityOriginRemoved,this);for(const securityOrigin of this._securityOriginManager.securityOrigins())
this._addOrigin(securityOrigin);this._agent.enable();this._enabled=true;}
clearForOrigin(origin){if(!this._enabled)
return;for(const isLocal of[true,false]){const key=this._storageKey(origin,isLocal);const storage=this._storages[key];storage.clear();}
this._removeOrigin(origin);this._addOrigin(origin);}
_securityOriginAdded(event){this._addOrigin((event.data));}
_addOrigin(securityOrigin){const parsed=new Common.ParsedURL(securityOrigin);if(!parsed.isValid||parsed.scheme==='data'||parsed.scheme==='about'||parsed.scheme==='javascript')
return;for(const isLocal of[true,false]){const key=this._storageKey(securityOrigin,isLocal);console.assert(!this._storages[key]);const storage=new Resources.DOMStorage(this,securityOrigin,isLocal);this._storages[key]=storage;this.dispatchEventToListeners(Resources.DOMStorageModel.Events.DOMStorageAdded,storage);}}
_securityOriginRemoved(event){this._removeOrigin((event.data));}
_removeOrigin(securityOrigin){for(const isLocal of[true,false]){const key=this._storageKey(securityOrigin,isLocal);const storage=this._storages[key];if(!storage)
continue;delete this._storages[key];this.dispatchEventToListeners(Resources.DOMStorageModel.Events.DOMStorageRemoved,storage);}}
_storageKey(securityOrigin,isLocalStorage){return JSON.stringify(Resources.DOMStorage.storageId(securityOrigin,isLocalStorage));}
_domStorageItemsCleared(storageId){const domStorage=this.storageForId(storageId);if(!domStorage)
return;const eventData={};domStorage.dispatchEventToListeners(Resources.DOMStorage.Events.DOMStorageItemsCleared,eventData);}
_domStorageItemRemoved(storageId,key){const domStorage=this.storageForId(storageId);if(!domStorage)
return;const eventData={key:key};domStorage.dispatchEventToListeners(Resources.DOMStorage.Events.DOMStorageItemRemoved,eventData);}
_domStorageItemAdded(storageId,key,value){const domStorage=this.storageForId(storageId);if(!domStorage)
return;const eventData={key:key,value:value};domStorage.dispatchEventToListeners(Resources.DOMStorage.Events.DOMStorageItemAdded,eventData);}
_domStorageItemUpdated(storageId,key,oldValue,value){const domStorage=this.storageForId(storageId);if(!domStorage)
return;const eventData={key:key,oldValue:oldValue,value:value};domStorage.dispatchEventToListeners(Resources.DOMStorage.Events.DOMStorageItemUpdated,eventData);}
storageForId(storageId){return this._storages[JSON.stringify(storageId)];}
storages(){const result=[];for(const id in this._storages)
result.push(this._storages[id]);return result;}};SDK.SDKModel.register(Resources.DOMStorageModel,SDK.Target.Capability.DOM,false);Resources.DOMStorageModel.Events={DOMStorageAdded:Symbol('DOMStorageAdded'),DOMStorageRemoved:Symbol('DOMStorageRemoved')};Resources.DOMStorageDispatcher=class{constructor(model){this._model=model;}
domStorageItemsCleared(storageId){this._model._domStorageItemsCleared(storageId);}
domStorageItemRemoved(storageId,key){this._model._domStorageItemRemoved(storageId,key);}
domStorageItemAdded(storageId,key,value){this._model._domStorageItemAdded(storageId,key,value);}
domStorageItemUpdated(storageId,key,oldValue,value){this._model._domStorageItemUpdated(storageId,key,oldValue,value);}};Resources.DOMStorageModel._symbol=Symbol('DomStorage');;Resources.DOMStorageItemsView=class extends Resources.StorageItemsView{constructor(domStorage){super(Common.UIString('DOM Storage'),'domStoragePanel');this._domStorage=domStorage;this.element.classList.add('storage-view','table');const columns=([{id:'key',title:Common.UIString('Key'),sortable:false,editable:true,longText:true,weight:50},{id:'value',title:Common.UIString('Value'),sortable:false,editable:true,longText:true,weight:50}]);this._dataGrid=new DataGrid.DataGrid(columns,this._editingCallback.bind(this),this._deleteCallback.bind(this),this.refreshItems.bind(this));this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,event=>this._previewEntry((event.data)));this._dataGrid.addEventListener(DataGrid.DataGrid.Events.DeselectedNode,event=>this._previewEntry(null));this._dataGrid.setStriped(true);this._dataGrid.setName('DOMStorageItemsView');this._splitWidget=new UI.SplitWidget(false,false);this._splitWidget.show(this.element);this._splitWidget.setSecondIsSidebar(true);this._previewPanel=new UI.VBox();const resizer=this._previewPanel.element.createChild('div','preview-panel-resizer');const dataGridWidget=this._dataGrid.asWidget();dataGridWidget.setMinimumSize(0,50);this._splitWidget.setMainWidget(dataGridWidget);this._splitWidget.setSidebarWidget(this._previewPanel);this._splitWidget.installResizer(resizer);this._preview=null;this._previewValue=null;this._showPreview(null,null);this._eventListeners=[];this.setStorage(domStorage);}
setStorage(domStorage){Common.EventTarget.removeEventListeners(this._eventListeners);this._domStorage=domStorage;this._eventListeners=[this._domStorage.addEventListener(Resources.DOMStorage.Events.DOMStorageItemsCleared,this._domStorageItemsCleared,this),this._domStorage.addEventListener(Resources.DOMStorage.Events.DOMStorageItemRemoved,this._domStorageItemRemoved,this),this._domStorage.addEventListener(Resources.DOMStorage.Events.DOMStorageItemAdded,this._domStorageItemAdded,this),this._domStorage.addEventListener(Resources.DOMStorage.Events.DOMStorageItemUpdated,this._domStorageItemUpdated,this),];this.refreshItems();}
_domStorageItemsCleared(){if(!this.isShowing()||!this._dataGrid)
return;this._dataGrid.rootNode().removeChildren();this._dataGrid.addCreationNode(false);this.setCanDeleteSelected(false);}
_domStorageItemRemoved(event){if(!this.isShowing()||!this._dataGrid)
return;const storageData=event.data;const rootNode=this._dataGrid.rootNode();const children=rootNode.children;for(let i=0;i<children.length;++i){const childNode=children[i];if(childNode.data.key===storageData.key){rootNode.removeChild(childNode);this.setCanDeleteSelected(children.length>1);return;}}}
_domStorageItemAdded(event){if(!this.isShowing()||!this._dataGrid)
return;const storageData=event.data;const rootNode=this._dataGrid.rootNode();const children=rootNode.children;for(let i=0;i<children.length;++i){if(children[i].data.key===storageData.key)
return;}
const childNode=new DataGrid.DataGridNode({key:storageData.key,value:storageData.value},false);rootNode.insertChild(childNode,children.length-1);}
_domStorageItemUpdated(event){if(!this.isShowing()||!this._dataGrid)
return;const storageData=event.data;const childNode=this._dataGrid.rootNode().children.find(child=>child.data.key===storageData.key);if(!childNode||childNode.data.value===storageData.value)
return;childNode.data.value=storageData.value;childNode.refresh();if(!childNode.selected)
return;this._previewEntry(childNode);this.setCanDeleteSelected(true);}
_showDOMStorageItems(items){const rootNode=this._dataGrid.rootNode();let selectedKey=null;for(const node of rootNode.children){if(!node.selected)
continue;selectedKey=node.data.key;break;}
rootNode.removeChildren();let selectedNode=null;const filteredItems=item=>`${item[0]} ${item[1]}`;for(const item of this.filter(items,filteredItems)){const key=item[0];const value=item[1];const node=new DataGrid.DataGridNode({key:key,value:value},false);node.selectable=true;rootNode.appendChild(node);if(!selectedNode||key===selectedKey)
selectedNode=node;}
if(selectedNode)
selectedNode.selected=true;this._dataGrid.addCreationNode(false);this.setCanDeleteSelected(!!selectedNode);}
deleteSelectedItem(){if(!this._dataGrid||!this._dataGrid.selectedNode)
return;this._deleteCallback(this._dataGrid.selectedNode);}
refreshItems(){this._domStorage.getItems().then(items=>items&&this._showDOMStorageItems(items));}
deleteAllItems(){this._domStorage.clear();this._domStorageItemsCleared();}
_editingCallback(editingNode,columnIdentifier,oldText,newText){const domStorage=this._domStorage;if(columnIdentifier==='key'){if(typeof oldText==='string')
domStorage.removeItem(oldText);domStorage.setItem(newText,editingNode.data.value||'');this._removeDupes(editingNode);}else{domStorage.setItem(editingNode.data.key||'',newText);}}
_removeDupes(masterNode){const rootNode=this._dataGrid.rootNode();const children=rootNode.children;for(let i=children.length-1;i>=0;--i){const childNode=children[i];if((childNode.data.key===masterNode.data.key)&&(masterNode!==childNode))
rootNode.removeChild(childNode);}}
_deleteCallback(node){if(!node||node.isCreationNode)
return;if(this._domStorage)
this._domStorage.removeItem(node.data.key);}
_showPreview(preview,value){if(this._preview&&this._previewValue===value)
return;if(this._preview)
this._preview.detach();if(!preview)
preview=new UI.EmptyWidget(Common.UIString('Select a value to preview'));this._previewValue=value;this._preview=preview;preview.show(this._previewPanel.contentElement);}
async _previewEntry(entry){const value=entry&&entry.data&&entry.data.value;if(!value){this._showPreview(null,value);return;}
const protocol=this._domStorage.isLocalStorage?'localstorage':'sessionstorage';const url=`${protocol}://${entry.key}`;const provider=Common.StaticContentProvider.fromString(url,Common.resourceTypes.XHR,(value));const preview=await SourceFrame.PreviewFactory.createPreview(provider,'text/plain');if(!entry.selected)
return;this._showPreview(preview,value);}};;Resources.DatabaseQueryView=class extends UI.VBox{constructor(database){super();this.database=database;this.element.classList.add('storage-view','query','monospace');this.element.addEventListener('selectstart',this._selectStart.bind(this),false);this._promptContainer=this.element.createChild('div','database-query-prompt-container');this._promptContainer.appendChild(UI.Icon.create('smallicon-text-prompt','prompt-icon'));this._promptElement=this._promptContainer.createChild('div');this._promptElement.className='database-query-prompt';this._promptElement.addEventListener('keydown',this._promptKeyDown.bind(this));this._prompt=new UI.TextPrompt();this._prompt.initialize(this.completions.bind(this),' ');this._proxyElement=this._prompt.attach(this._promptElement);this.element.addEventListener('click',this._messagesClicked.bind(this),true);this.element.tabIndex=0;this.element.addEventListener('focus',this._prompt.focus.bind(this._prompt));}
_messagesClicked(){if(!this._prompt.isCaretInsidePrompt()&&!this.element.hasSelection())
this._prompt.moveCaretToEndOfPrompt();}
async completions(expression,prefix,force){if(!prefix)
return[];prefix=prefix.toLowerCase();const tableNames=await this.database.tableNames();return tableNames.map(name=>name+' ').concat(Resources.DatabaseQueryView._SQL_BUILT_INS).filter(proposal=>proposal.toLowerCase().startsWith(prefix)).map(completion=>({text:completion}));}
_selectStart(event){if(this._selectionTimeout)
clearTimeout(this._selectionTimeout);this._prompt.clearAutocomplete();function moveBackIfOutside(){delete this._selectionTimeout;if(!this._prompt.isCaretInsidePrompt()&&!this.element.hasSelection())
this._prompt.moveCaretToEndOfPrompt();this._prompt.autoCompleteSoon();}
this._selectionTimeout=setTimeout(moveBackIfOutside.bind(this),100);}
_promptKeyDown(event){if(isEnterKey(event)){this._enterKeyPressed(event);return;}}
async _enterKeyPressed(event){event.consume(true);const query=this._prompt.textWithCurrentSuggestion();this._prompt.clearAutocomplete();if(!query.length)
return;this._prompt.setEnabled(false);try{const result=await new Promise((resolve,reject)=>{this.database.executeSql(query,(columnNames,values)=>resolve({columnNames,values}),errorText=>reject(errorText));});this._queryFinished(query,result.columnNames,result.values);}catch(e){this._appendErrorQueryResult(query,e);}
this._prompt.setEnabled(true);this._prompt.setText('');this._prompt.focus();}
_queryFinished(query,columnNames,values){const dataGrid=DataGrid.SortableDataGrid.create(columnNames,values);const trimmedQuery=query.trim();let view=null;if(dataGrid){dataGrid.setStriped(true);dataGrid.renderInline();dataGrid.autoSizeColumns(5);view=dataGrid.asWidget();}
this._appendViewQueryResult(trimmedQuery,view);if(trimmedQuery.match(/^create /i)||trimmedQuery.match(/^drop table /i))
this.dispatchEventToListeners(Resources.DatabaseQueryView.Events.SchemaUpdated,this.database);}
_appendViewQueryResult(query,view){const resultElement=this._appendQueryResult(query);if(view)
view.show(resultElement);else
resultElement.remove();this._promptElement.scrollIntoView(false);}
_appendErrorQueryResult(query,errorText){const resultElement=this._appendQueryResult(query);resultElement.classList.add('error');resultElement.appendChild(UI.Icon.create('smallicon-error','prompt-icon'));resultElement.createTextChild(errorText);this._promptElement.scrollIntoView(false);}
_appendQueryResult(query){const element=createElement('div');element.className='database-user-query';element.appendChild(UI.Icon.create('smallicon-user-command','prompt-icon'));this.element.insertBefore(element,this._promptContainer);const commandTextElement=createElement('span');commandTextElement.className='database-query-text';commandTextElement.textContent=query;element.appendChild(commandTextElement);const resultElement=createElement('div');resultElement.className='database-query-result';element.appendChild(resultElement);return resultElement;}};Resources.DatabaseQueryView.Events={SchemaUpdated:Symbol('SchemaUpdated')};Resources.DatabaseQueryView._SQL_BUILT_INS=['SELECT ','FROM ','WHERE ','LIMIT ','DELETE FROM ','CREATE ','DROP ','TABLE ','INDEX ','UPDATE ','INSERT INTO ','VALUES ('];;Resources.DatabaseTableView=class extends UI.SimpleView{constructor(database,tableName){super(Common.UIString('Database'));this.database=database;this.tableName=tableName;this.element.classList.add('storage-view','table');this._visibleColumnsSetting=Common.settings.createSetting('databaseTableViewVisibleColumns',{});this.refreshButton=new UI.ToolbarButton(Common.UIString('Refresh'),'largeicon-refresh');this.refreshButton.addEventListener(UI.ToolbarButton.Events.Click,this._refreshButtonClicked,this);this._visibleColumnsInput=new UI.ToolbarInput(Common.UIString('Visible columns'),1);this._visibleColumnsInput.addEventListener(UI.ToolbarInput.Event.TextChanged,this._onVisibleColumnsChanged,this);}
wasShown(){this.update();}
syncToolbarItems(){return[this.refreshButton,this._visibleColumnsInput];}
_escapeTableName(tableName){return tableName.replace(/\"/g,'""');}
update(){this.database.executeSql('SELECT rowid, * FROM "'+this._escapeTableName(this.tableName)+'"',this._queryFinished.bind(this),this._queryError.bind(this));}
_queryFinished(columnNames,values){this.detachChildWidgets();this.element.removeChildren();this._dataGrid=DataGrid.SortableDataGrid.create(columnNames,values);this._visibleColumnsInput.setVisible(!!this._dataGrid);if(!this._dataGrid){this._emptyWidget=new UI.EmptyWidget(ls`The "${this.tableName}"\ntable is empty.`);this._emptyWidget.show(this.element);return;}
this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.element);this._dataGrid.autoSizeColumns(5);this._columnsMap=new Map();for(let i=1;i<columnNames.length;++i)
this._columnsMap.set(columnNames[i],String(i));this._lastVisibleColumns='';const visibleColumnsText=this._visibleColumnsSetting.get()[this.tableName]||'';this._visibleColumnsInput.setValue(visibleColumnsText);this._onVisibleColumnsChanged();}
_onVisibleColumnsChanged(){if(!this._dataGrid)
return;const text=this._visibleColumnsInput.value();const parts=text.split(/[\s,]+/);const matches=new Set();const columnsVisibility={};columnsVisibility['0']=true;for(let i=0;i<parts.length;++i){const part=parts[i];if(this._columnsMap.has(part)){matches.add(part);columnsVisibility[this._columnsMap.get(part)]=true;}}
const newVisibleColumns=matches.valuesArray().sort().join(', ');if(newVisibleColumns.length===0){for(const v of this._columnsMap.values())
columnsVisibility[v]=true;}
if(newVisibleColumns===this._lastVisibleColumns)
return;const visibleColumnsRegistry=this._visibleColumnsSetting.get();visibleColumnsRegistry[this.tableName]=text;this._visibleColumnsSetting.set(visibleColumnsRegistry);this._dataGrid.setColumnsVisiblity(columnsVisibility);this._lastVisibleColumns=newVisibleColumns;}
_queryError(error){this.detachChildWidgets();this.element.removeChildren();const errorMsgElement=createElement('div');errorMsgElement.className='storage-table-error';errorMsgElement.textContent=ls`An error occurred trying to\nread the "${this.tableName}" table.`;this.element.appendChild(errorMsgElement);}
_refreshButtonClicked(event){this.update();}};;Resources.IndexedDBModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerStorageDispatcher(this);this._securityOriginManager=target.model(SDK.SecurityOriginManager);this._indexedDBAgent=target.indexedDBAgent();this._storageAgent=target.storageAgent();this._databases=new Map();this._databaseNamesBySecurityOrigin={};this._originsUpdated=new Set();this._throttler=new Common.Throttler(1000);}
static keyFromIDBKey(idbKey){if(typeof(idbKey)==='undefined'||idbKey===null)
return undefined;let type;const key={};switch(typeof(idbKey)){case'number':key.number=idbKey;type=Resources.IndexedDBModel.KeyTypes.NumberType;break;case'string':key.string=idbKey;type=Resources.IndexedDBModel.KeyTypes.StringType;break;case'object':if(idbKey instanceof Date){key.date=idbKey.getTime();type=Resources.IndexedDBModel.KeyTypes.DateType;}else if(Array.isArray(idbKey)){key.array=[];for(let i=0;i<idbKey.length;++i)
key.array.push(Resources.IndexedDBModel.keyFromIDBKey(idbKey[i]));type=Resources.IndexedDBModel.KeyTypes.ArrayType;}
break;default:return undefined;}
key.type=(type);return key;}
static _keyRangeFromIDBKeyRange(idbKeyRange){const keyRange={};keyRange.lower=Resources.IndexedDBModel.keyFromIDBKey(idbKeyRange.lower);keyRange.upper=Resources.IndexedDBModel.keyFromIDBKey(idbKeyRange.upper);keyRange.lowerOpen=!!idbKeyRange.lowerOpen;keyRange.upperOpen=!!idbKeyRange.upperOpen;return keyRange;}
static idbKeyPathFromKeyPath(keyPath){let idbKeyPath;switch(keyPath.type){case Resources.IndexedDBModel.KeyPathTypes.NullType:idbKeyPath=null;break;case Resources.IndexedDBModel.KeyPathTypes.StringType:idbKeyPath=keyPath.string;break;case Resources.IndexedDBModel.KeyPathTypes.ArrayType:idbKeyPath=keyPath.array;break;}
return idbKeyPath;}
static keyPathStringFromIDBKeyPath(idbKeyPath){if(typeof idbKeyPath==='string')
return'"'+idbKeyPath+'"';if(idbKeyPath instanceof Array)
return'["'+idbKeyPath.join('", "')+'"]';return null;}
enable(){if(this._enabled)
return;this._indexedDBAgent.enable();this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginAdded,this._securityOriginAdded,this);this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,this._securityOriginRemoved,this);for(const securityOrigin of this._securityOriginManager.securityOrigins())
this._addOrigin(securityOrigin);this._enabled=true;}
clearForOrigin(origin){if(!this._enabled)
return;this._removeOrigin(origin);this._addOrigin(origin);}
async deleteDatabase(databaseId){if(!this._enabled)
return;await this._indexedDBAgent.deleteDatabase(databaseId.securityOrigin,databaseId.name);this._loadDatabaseNames(databaseId.securityOrigin);}
async refreshDatabaseNames(){for(const securityOrigin in this._databaseNamesBySecurityOrigin)
await this._loadDatabaseNames(securityOrigin);this.dispatchEventToListeners(Resources.IndexedDBModel.Events.DatabaseNamesRefreshed);}
refreshDatabase(databaseId){this._loadDatabase(databaseId,true);}
clearObjectStore(databaseId,objectStoreName){return this._indexedDBAgent.clearObjectStore(databaseId.securityOrigin,databaseId.name,objectStoreName);}
deleteEntries(databaseId,objectStoreName,idbKeyRange){const keyRange=Resources.IndexedDBModel._keyRangeFromIDBKeyRange(idbKeyRange);return this._indexedDBAgent.deleteObjectStoreEntries(databaseId.securityOrigin,databaseId.name,objectStoreName,keyRange);}
_securityOriginAdded(event){const securityOrigin=(event.data);this._addOrigin(securityOrigin);}
_securityOriginRemoved(event){const securityOrigin=(event.data);this._removeOrigin(securityOrigin);}
_addOrigin(securityOrigin){console.assert(!this._databaseNamesBySecurityOrigin[securityOrigin]);this._databaseNamesBySecurityOrigin[securityOrigin]=[];this._loadDatabaseNames(securityOrigin);if(this._isValidSecurityOrigin(securityOrigin))
this._storageAgent.trackIndexedDBForOrigin(securityOrigin);}
_removeOrigin(securityOrigin){console.assert(this._databaseNamesBySecurityOrigin[securityOrigin]);for(let i=0;i<this._databaseNamesBySecurityOrigin[securityOrigin].length;++i)
this._databaseRemoved(securityOrigin,this._databaseNamesBySecurityOrigin[securityOrigin][i]);delete this._databaseNamesBySecurityOrigin[securityOrigin];if(this._isValidSecurityOrigin(securityOrigin))
this._storageAgent.untrackIndexedDBForOrigin(securityOrigin);}
_isValidSecurityOrigin(securityOrigin){const parsedURL=securityOrigin.asParsedURL();return!!parsedURL&&parsedURL.scheme.startsWith('http');}
_updateOriginDatabaseNames(securityOrigin,databaseNames){const newDatabaseNames=new Set(databaseNames);const oldDatabaseNames=new Set(this._databaseNamesBySecurityOrigin[securityOrigin]);this._databaseNamesBySecurityOrigin[securityOrigin]=databaseNames;for(const databaseName of oldDatabaseNames){if(!newDatabaseNames.has(databaseName))
this._databaseRemoved(securityOrigin,databaseName);}
for(const databaseName of newDatabaseNames){if(!oldDatabaseNames.has(databaseName))
this._databaseAdded(securityOrigin,databaseName);}}
databases(){const result=[];for(const securityOrigin in this._databaseNamesBySecurityOrigin){const databaseNames=this._databaseNamesBySecurityOrigin[securityOrigin];for(let i=0;i<databaseNames.length;++i)
result.push(new Resources.IndexedDBModel.DatabaseId(securityOrigin,databaseNames[i]));}
return result;}
_databaseAdded(securityOrigin,databaseName){const databaseId=new Resources.IndexedDBModel.DatabaseId(securityOrigin,databaseName);this.dispatchEventToListeners(Resources.IndexedDBModel.Events.DatabaseAdded,{model:this,databaseId:databaseId});}
_databaseRemoved(securityOrigin,databaseName){const databaseId=new Resources.IndexedDBModel.DatabaseId(securityOrigin,databaseName);this.dispatchEventToListeners(Resources.IndexedDBModel.Events.DatabaseRemoved,{model:this,databaseId:databaseId});}
async _loadDatabaseNames(securityOrigin){const databaseNames=await this._indexedDBAgent.requestDatabaseNames(securityOrigin);if(!databaseNames)
return[];if(!this._databaseNamesBySecurityOrigin[securityOrigin])
return[];this._updateOriginDatabaseNames(securityOrigin,databaseNames);return databaseNames;}
async _loadDatabase(databaseId,entriesUpdated){const databaseWithObjectStores=await this._indexedDBAgent.requestDatabase(databaseId.securityOrigin,databaseId.name);if(!databaseWithObjectStores)
return;if(!this._databaseNamesBySecurityOrigin[databaseId.securityOrigin])
return;const databaseModel=new Resources.IndexedDBModel.Database(databaseId,databaseWithObjectStores.version);this._databases.set(databaseId,databaseModel);for(const objectStore of databaseWithObjectStores.objectStores){const objectStoreIDBKeyPath=Resources.IndexedDBModel.idbKeyPathFromKeyPath(objectStore.keyPath);const objectStoreModel=new Resources.IndexedDBModel.ObjectStore(objectStore.name,objectStoreIDBKeyPath,objectStore.autoIncrement);for(let j=0;j<objectStore.indexes.length;++j){const index=objectStore.indexes[j];const indexIDBKeyPath=Resources.IndexedDBModel.idbKeyPathFromKeyPath(index.keyPath);const indexModel=new Resources.IndexedDBModel.Index(index.name,indexIDBKeyPath,index.unique,index.multiEntry);objectStoreModel.indexes[indexModel.name]=indexModel;}
databaseModel.objectStores[objectStoreModel.name]=objectStoreModel;}
this.dispatchEventToListeners(Resources.IndexedDBModel.Events.DatabaseLoaded,{model:this,database:databaseModel,entriesUpdated:entriesUpdated});}
loadObjectStoreData(databaseId,objectStoreName,idbKeyRange,skipCount,pageSize,callback){this._requestData(databaseId,databaseId.name,objectStoreName,'',idbKeyRange,skipCount,pageSize,callback);}
loadIndexData(databaseId,objectStoreName,indexName,idbKeyRange,skipCount,pageSize,callback){this._requestData(databaseId,databaseId.name,objectStoreName,indexName,idbKeyRange,skipCount,pageSize,callback);}
async _requestData(databaseId,databaseName,objectStoreName,indexName,idbKeyRange,skipCount,pageSize,callback){const keyRange=idbKeyRange?Resources.IndexedDBModel._keyRangeFromIDBKeyRange(idbKeyRange):undefined;const response=await this._indexedDBAgent.invoke_requestData({securityOrigin:databaseId.securityOrigin,databaseName,objectStoreName,indexName,skipCount,pageSize,keyRange});if(response[Protocol.Error]){console.error('IndexedDBAgent error: '+response[Protocol.Error]);return;}
const runtimeModel=this.target().model(SDK.RuntimeModel);if(!runtimeModel||!this._databaseNamesBySecurityOrigin[databaseId.securityOrigin])
return;const dataEntries=response.objectStoreDataEntries;const entries=[];for(const dataEntry of dataEntries){const key=runtimeModel.createRemoteObject(dataEntry.key);const primaryKey=runtimeModel.createRemoteObject(dataEntry.primaryKey);const value=runtimeModel.createRemoteObject(dataEntry.value);entries.push(new Resources.IndexedDBModel.Entry(key,primaryKey,value));}
callback(entries,response.hasMore);}
async getMetadata(databaseId,objectStore){const databaseOrigin=databaseId.securityOrigin;const databaseName=databaseId.name;const objectStoreName=objectStore.name;const response=await this._indexedDBAgent.invoke_getMetadata({securityOrigin:databaseOrigin,databaseName,objectStoreName});if(response[Protocol.Error]){console.error('IndexedDBAgent error: '+response[Protocol.Error]);return null;}
return{entriesCount:response.entriesCount,keyGeneratorValue:response.keyGeneratorValue};}
async _refreshDatabaseList(securityOrigin){const databaseNames=await this._loadDatabaseNames(securityOrigin);for(const databaseName of databaseNames)
this._loadDatabase(new Resources.IndexedDBModel.DatabaseId(securityOrigin,databaseName),false);}
indexedDBListUpdated(securityOrigin){this._originsUpdated.add(securityOrigin);this._throttler.schedule(()=>{const promises=Array.from(this._originsUpdated,securityOrigin=>{this._refreshDatabaseList(securityOrigin);});this._originsUpdated.clear();return Promise.all(promises);});}
indexedDBContentUpdated(securityOrigin,databaseName,objectStoreName){const databaseId=new Resources.IndexedDBModel.DatabaseId(securityOrigin,databaseName);this.dispatchEventToListeners(Resources.IndexedDBModel.Events.IndexedDBContentUpdated,{databaseId:databaseId,objectStoreName:objectStoreName,model:this});}
cacheStorageListUpdated(securityOrigin){}
cacheStorageContentUpdated(securityOrigin){}};SDK.SDKModel.register(Resources.IndexedDBModel,SDK.Target.Capability.DOM,false);Resources.IndexedDBModel.KeyTypes={NumberType:'number',StringType:'string',DateType:'date',ArrayType:'array'};Resources.IndexedDBModel.KeyPathTypes={NullType:'null',StringType:'string',ArrayType:'array'};Resources.IndexedDBModel.Events={DatabaseAdded:Symbol('DatabaseAdded'),DatabaseRemoved:Symbol('DatabaseRemoved'),DatabaseLoaded:Symbol('DatabaseLoaded'),DatabaseNamesRefreshed:Symbol('DatabaseNamesRefreshed'),IndexedDBContentUpdated:Symbol('IndexedDBContentUpdated')};Resources.IndexedDBModel.Entry=class{constructor(key,primaryKey,value){this.key=key;this.primaryKey=primaryKey;this.value=value;}};Resources.IndexedDBModel.DatabaseId=class{constructor(securityOrigin,name){this.securityOrigin=securityOrigin;this.name=name;}
equals(databaseId){return this.name===databaseId.name&&this.securityOrigin===databaseId.securityOrigin;}};Resources.IndexedDBModel.Database=class{constructor(databaseId,version){this.databaseId=databaseId;this.version=version;this.objectStores={};}};Resources.IndexedDBModel.ObjectStore=class{constructor(name,keyPath,autoIncrement){this.name=name;this.keyPath=keyPath;this.autoIncrement=autoIncrement;this.indexes={};}
get keyPathString(){return(Resources.IndexedDBModel.keyPathStringFromIDBKeyPath((this.keyPath)));}};Resources.IndexedDBModel.ObjectStoreMetadata;Resources.IndexedDBModel.Index=class{constructor(name,keyPath,unique,multiEntry){this.name=name;this.keyPath=keyPath;this.unique=unique;this.multiEntry=multiEntry;}
get keyPathString(){return(Resources.IndexedDBModel.keyPathStringFromIDBKeyPath((this.keyPath)));}};;Resources.IDBDatabaseView=class extends UI.VBox{constructor(model,database){super();this._model=model;const databaseName=database?database.databaseId.name:ls`Loading\u2026`;this._reportView=new UI.ReportView(databaseName);this._reportView.show(this.contentElement);const bodySection=this._reportView.appendSection('');this._securityOriginElement=bodySection.appendField(ls`Security origin`);this._versionElement=bodySection.appendField(ls`Version`);this._objectStoreCountElement=bodySection.appendField(ls`Object stores`);const footer=this._reportView.appendSection('').appendRow();this._clearButton=UI.createTextButton(ls`Delete database`,()=>this._deleteDatabase(),ls`Delete database`);footer.appendChild(this._clearButton);this._refreshButton=UI.createTextButton(ls`Refresh database`,()=>this._refreshDatabaseButtonClicked(),ls`Refresh database`);footer.appendChild(this._refreshButton);if(database)
this.update(database);}
_refreshDatabase(){this._securityOriginElement.textContent=this._database.databaseId.securityOrigin;this._versionElement.textContent=this._database.version;this._objectStoreCountElement.textContent=Object.keys(this._database.objectStores).length;}
_refreshDatabaseButtonClicked(){this._model.refreshDatabase(this._database.databaseId);}
update(database){this._database=database;this._reportView.setTitle(this._database.databaseId.name);this._refreshDatabase();this._updatedForTests();}
_updatedForTests(){}
async _deleteDatabase(){const ok=await UI.ConfirmDialog.show(Common.UIString('Please confirm delete of "%s" database.',this._database.databaseId.name),this.element);if(ok)
this._model.deleteDatabase(this._database.databaseId);}};Resources.IDBDataView=class extends UI.SimpleView{constructor(model,databaseId,objectStore,index,refreshObjectStoreCallback){super(Common.UIString('IDB'));this.registerRequiredCSS('resources/indexedDBViews.css');this._model=model;this._databaseId=databaseId;this._isIndex=!!index;this._refreshObjectStoreCallback=refreshObjectStoreCallback;this.element.classList.add('indexed-db-data-view','storage-view');this._refreshButton=new UI.ToolbarButton(Common.UIString('Refresh'),'largeicon-refresh');this._refreshButton.addEventListener(UI.ToolbarButton.Events.Click,this._refreshButtonClicked,this);this._deleteSelectedButton=new UI.ToolbarButton(Common.UIString('Delete selected'),'largeicon-delete');this._deleteSelectedButton.addEventListener(UI.ToolbarButton.Events.Click,()=>this._deleteButtonClicked(null));this._clearButton=new UI.ToolbarButton(Common.UIString('Clear object store'),'largeicon-clear');this._clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._clearButtonClicked,this);this._needsRefresh=new UI.ToolbarItem(UI.createIconLabel(Common.UIString('Data may be stale'),'smallicon-warning'));this._needsRefresh.setVisible(false);this._needsRefresh.setTitle(Common.UIString('Some entries may have been modified'));this._createEditorToolbar();this._pageSize=50;this._skipCount=0;this.update(objectStore,index);this._entries=[];}
_createDataGrid(){const keyPath=this._isIndex?this._index.keyPath:this._objectStore.keyPath;const columns=([]);columns.push({id:'number',title:Common.UIString('#'),sortable:false,width:'50px'});columns.push({id:'key',titleDOMFragment:this._keyColumnHeaderFragment(Common.UIString('Key'),keyPath),sortable:false});if(this._isIndex){columns.push({id:'primaryKey',titleDOMFragment:this._keyColumnHeaderFragment(Common.UIString('Primary key'),this._objectStore.keyPath),sortable:false});}
columns.push({id:'value',title:Common.UIString('Value'),sortable:false});const dataGrid=new DataGrid.DataGrid(columns,undefined,this._deleteButtonClicked.bind(this),this._updateData.bind(this,true));dataGrid.setStriped(true);dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,event=>this._updateToolbarEnablement(),this);return dataGrid;}
_keyColumnHeaderFragment(prefix,keyPath){const keyColumnHeaderFragment=createDocumentFragment();keyColumnHeaderFragment.createTextChild(prefix);if(keyPath===null)
return keyColumnHeaderFragment;keyColumnHeaderFragment.createTextChild(' ('+Common.UIString('Key path: '));if(Array.isArray(keyPath)){keyColumnHeaderFragment.createTextChild('[');for(let i=0;i<keyPath.length;++i){if(i!==0)
keyColumnHeaderFragment.createTextChild(', ');keyColumnHeaderFragment.appendChild(this._keyPathStringFragment(keyPath[i]));}
keyColumnHeaderFragment.createTextChild(']');}else{const keyPathString=(keyPath);keyColumnHeaderFragment.appendChild(this._keyPathStringFragment(keyPathString));}
keyColumnHeaderFragment.createTextChild(')');return keyColumnHeaderFragment;}
_keyPathStringFragment(keyPathString){const keyPathStringFragment=createDocumentFragment();keyPathStringFragment.createTextChild('"');const keyPathSpan=keyPathStringFragment.createChild('span','source-code indexed-db-key-path');keyPathSpan.textContent=keyPathString;keyPathStringFragment.createTextChild('"');return keyPathStringFragment;}
_createEditorToolbar(){const editorToolbar=new UI.Toolbar('data-view-toolbar',this.element);editorToolbar.appendToolbarItem(this._refreshButton);editorToolbar.appendToolbarItem(new UI.ToolbarSeparator());this._pageBackButton=new UI.ToolbarButton(Common.UIString('Show previous page'),'largeicon-play-back');this._pageBackButton.addEventListener(UI.ToolbarButton.Events.Click,this._pageBackButtonClicked,this);editorToolbar.appendToolbarItem(this._pageBackButton);this._pageForwardButton=new UI.ToolbarButton(Common.UIString('Show next page'),'largeicon-play');this._pageForwardButton.setEnabled(false);this._pageForwardButton.addEventListener(UI.ToolbarButton.Events.Click,this._pageForwardButtonClicked,this);editorToolbar.appendToolbarItem(this._pageForwardButton);this._keyInput=new UI.ToolbarInput(ls`Start from key`,0.5);this._keyInput.addEventListener(UI.ToolbarInput.Event.TextChanged,this._updateData.bind(this,false));editorToolbar.appendToolbarItem(this._keyInput);editorToolbar.appendToolbarItem(new UI.ToolbarSeparator());editorToolbar.appendToolbarItem(this._clearButton);editorToolbar.appendToolbarItem(this._deleteSelectedButton);editorToolbar.appendToolbarItem(this._needsRefresh);}
_pageBackButtonClicked(event){this._skipCount=Math.max(0,this._skipCount-this._pageSize);this._updateData(false);}
_pageForwardButtonClicked(event){this._skipCount=this._skipCount+this._pageSize;this._updateData(false);}
refreshData(){this._updateData(true);}
update(objectStore,index){this._objectStore=objectStore;this._index=index;if(this._dataGrid)
this._dataGrid.asWidget().detach();this._dataGrid=this._createDataGrid();this._dataGrid.asWidget().show(this.element);this._skipCount=0;this._updateData(true);}
_parseKey(keyString){let result;try{result=JSON.parse(keyString);}catch(e){result=keyString;}
return result;}
_updateData(force){const key=this._parseKey(this._keyInput.value());const pageSize=this._pageSize;let skipCount=this._skipCount;let selected=this._dataGrid.selectedNode?this._dataGrid.selectedNode.data['number']:0;selected=Math.max(selected,this._skipCount);this._refreshButton.setEnabled(false);this._clearButton.setEnabled(!this._isIndex);if(!force&&this._lastKey===key&&this._lastPageSize===pageSize&&this._lastSkipCount===skipCount)
return;if(this._lastKey!==key||this._lastPageSize!==pageSize){skipCount=0;this._skipCount=0;}
this._lastKey=key;this._lastPageSize=pageSize;this._lastSkipCount=skipCount;function callback(entries,hasMore){this._refreshButton.setEnabled(true);this.clear();this._entries=entries;let selectedNode=null;for(let i=0;i<entries.length;++i){const data={};data['number']=i+skipCount;data['key']=entries[i].key;data['primaryKey']=entries[i].primaryKey;data['value']=entries[i].value;const node=new Resources.IDBDataGridNode(data);this._dataGrid.rootNode().appendChild(node);if(data['number']<=selected)
selectedNode=node;}
if(selectedNode)
selectedNode.select();this._pageBackButton.setEnabled(!!skipCount);this._pageForwardButton.setEnabled(hasMore);this._needsRefresh.setVisible(false);this._updateToolbarEnablement();this._updatedDataForTests();}
const idbKeyRange=key?window.IDBKeyRange.lowerBound(key):null;if(this._isIndex){this._model.loadIndexData(this._databaseId,this._objectStore.name,this._index.name,idbKeyRange,skipCount,pageSize,callback.bind(this));}else{this._model.loadObjectStoreData(this._databaseId,this._objectStore.name,idbKeyRange,skipCount,pageSize,callback.bind(this));}
this._model.getMetadata(this._databaseId,this._objectStore).then(this._updateSummaryBar.bind(this));}
_updateSummaryBar(metadata){if(!this._summaryBarElement)
this._summaryBarElement=this.element.createChild('div','object-store-summary-bar');this._summaryBarElement.removeChildren();if(!metadata)
return;const separator='\u2002\u2758\u2002';const span=this._summaryBarElement.createChild('span');span.textContent=ls`Total entries: ${String(metadata.entriesCount)}`;if(this._objectStore.autoIncrement){span.textContent+=separator;span.textContent+=ls`Key generator value: ${String(metadata.keyGeneratorValue)}`;}}
_updatedDataForTests(){}
_refreshButtonClicked(event){this._updateData(true);}
async _clearButtonClicked(event){this._clearButton.setEnabled(false);await this._model.clearObjectStore(this._databaseId,this._objectStore.name);this._clearButton.setEnabled(true);this._updateData(true);}
markNeedsRefresh(){this._needsRefresh.setVisible(true);}
async _deleteButtonClicked(node){if(!node){node=this._dataGrid.selectedNode;if(!node)
return;}
const key=(this._isIndex?node.data.primaryKey:node.data.key);const keyValue=(key.value);await this._model.deleteEntries(this._databaseId,this._objectStore.name,window.IDBKeyRange.only(keyValue));this._refreshObjectStoreCallback();}
clear(){this._dataGrid.rootNode().removeChildren();this._entries=[];}
_updateToolbarEnablement(){const empty=!this._dataGrid||this._dataGrid.rootNode().children.length===0;this._clearButton.setEnabled(!empty);this._deleteSelectedButton.setEnabled(!empty&&this._dataGrid.selectedNode!==null);}};Resources.IDBDataGridNode=class extends DataGrid.DataGridNode{constructor(data){super(data,false);this.selectable=true;}
createCell(columnIdentifier){const cell=super.createCell(columnIdentifier);const value=(this.data[columnIdentifier]);switch(columnIdentifier){case'value':case'key':case'primaryKey':cell.removeChildren();const objectElement=ObjectUI.ObjectPropertiesSection.defaultObjectPresentation(value,undefined,true,true);cell.appendChild(objectElement);break;default:}
return cell;}};;Resources.ResourcesPanel=class extends UI.PanelWithSidebar{constructor(){super('resources');this.registerRequiredCSS('resources/resourcesPanel.css');this._resourcesLastSelectedItemSetting=Common.settings.createSetting('resourcesLastSelectedElementPath',[]);this.visibleView=null;this._pendingViewPromise=null;this._categoryView=null;const mainContainer=new UI.VBox();this.storageViews=mainContainer.element.createChild('div','vbox flex-auto');this._storageViewToolbar=new UI.Toolbar('resources-toolbar',mainContainer.element);this.splitWidget().setMainWidget(mainContainer);this._domStorageView=null;this._cookieView=null;this._emptyWidget=null;this._sidebar=new Resources.ApplicationPanelSidebar(this);this._sidebar.show(this.panelSidebarElement());}
static _instance(){return(self.runtime.sharedInstance(Resources.ResourcesPanel));}
static _shouldCloseOnReset(view){const viewClassesToClose=[SourceFrame.ResourceSourceFrame,SourceFrame.ImageView,SourceFrame.FontView,Resources.StorageItemsView,Resources.DatabaseQueryView,Resources.DatabaseTableView];return viewClassesToClose.some(type=>view instanceof type);}
focus(){this._sidebar.focus();}
lastSelectedItemPath(){return this._resourcesLastSelectedItemSetting.get();}
setLastSelectedItemPath(path){this._resourcesLastSelectedItemSetting.set(path);}
resetView(){if(this.visibleView&&Resources.ResourcesPanel._shouldCloseOnReset(this.visibleView))
this.showView(null);}
showView(view){this._pendingViewPromise=null;if(this.visibleView===view)
return;if(this.visibleView)
this.visibleView.detach();if(view)
view.show(this.storageViews);this.visibleView=view;this._storageViewToolbar.removeToolbarItems();const toolbarItems=(view instanceof UI.SimpleView&&view.syncToolbarItems())||[];for(let i=0;i<toolbarItems.length;++i)
this._storageViewToolbar.appendToolbarItem(toolbarItems[i]);this._storageViewToolbar.element.classList.toggle('hidden',!toolbarItems.length);}
async scheduleShowView(viewPromise){this._pendingViewPromise=viewPromise;const view=await viewPromise;if(this._pendingViewPromise!==viewPromise)
return null;this.showView(view);return view;}
showCategoryView(categoryName,categoryLink){if(!this._categoryView)
this._categoryView=new Resources.StorageCategoryView();this._categoryView.setText(categoryName);this._categoryView.setLink(categoryLink);this.showView(this._categoryView);}
showDOMStorage(domStorage){if(!domStorage)
return;if(!this._domStorageView)
this._domStorageView=new Resources.DOMStorageItemsView(domStorage);else
this._domStorageView.setStorage(domStorage);this.showView(this._domStorageView);}
showCookies(cookieFrameTarget,cookieDomain){const model=cookieFrameTarget.model(SDK.CookieModel);if(!model)
return;if(!this._cookieView)
this._cookieView=new Resources.CookieItemsView(model,cookieDomain);else
this._cookieView.setCookiesDomain(model,cookieDomain);this.showView(this._cookieView);}
clearCookies(target,cookieDomain){const model=target.model(SDK.CookieModel);if(!model)
return;model.clear(cookieDomain,()=>{if(this._cookieView)
this._cookieView.refreshItems();});}};Resources.ResourcesPanel.ResourceRevealer=class{async reveal(resource){if(!(resource instanceof SDK.Resource))
return Promise.reject(new Error('Internal error: not a resource'));const sidebar=Resources.ResourcesPanel._instance()._sidebar;await UI.viewManager.showView('resources');await sidebar.showResource(resource);}};;Resources.ApplicationPanelSidebar=class extends UI.VBox{constructor(panel){super();this._panel=panel;this._sidebarTree=new UI.TreeOutlineInShadow();this._sidebarTree.element.classList.add('resources-sidebar');this._sidebarTree.registerRequiredCSS('resources/resourcesSidebar.css');this._sidebarTree.element.classList.add('filter-all');this._sidebarTree.addEventListener(UI.TreeOutline.Events.ElementAttached,this._treeElementAdded,this);this.contentElement.appendChild(this._sidebarTree.element);this._applicationTreeElement=this._addSidebarSection(Common.UIString('Application'));const manifestTreeElement=new Resources.AppManifestTreeElement(panel);this._applicationTreeElement.appendChild(manifestTreeElement);this.serviceWorkersTreeElement=new Resources.ServiceWorkersTreeElement(panel);this._applicationTreeElement.appendChild(this.serviceWorkersTreeElement);const clearStorageTreeElement=new Resources.ClearStorageTreeElement(panel);this._applicationTreeElement.appendChild(clearStorageTreeElement);const storageTreeElement=this._addSidebarSection(Common.UIString('Storage'));this.localStorageListTreeElement=new Resources.StorageCategoryTreeElement(panel,Common.UIString('Local Storage'),'LocalStorage');this.localStorageListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/localstorage?utm_source=devtools');const localStorageIcon=UI.Icon.create('mediumicon-table','resource-tree-item');this.localStorageListTreeElement.setLeadingIcons([localStorageIcon]);storageTreeElement.appendChild(this.localStorageListTreeElement);this.sessionStorageListTreeElement=new Resources.StorageCategoryTreeElement(panel,Common.UIString('Session Storage'),'SessionStorage');this.sessionStorageListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/sessionstorage?utm_source=devtools');const sessionStorageIcon=UI.Icon.create('mediumicon-table','resource-tree-item');this.sessionStorageListTreeElement.setLeadingIcons([sessionStorageIcon]);storageTreeElement.appendChild(this.sessionStorageListTreeElement);this.indexedDBListTreeElement=new Resources.IndexedDBTreeElement(panel);this.indexedDBListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/indexeddb?utm_source=devtools');storageTreeElement.appendChild(this.indexedDBListTreeElement);this.databasesListTreeElement=new Resources.StorageCategoryTreeElement(panel,Common.UIString('Web SQL'),'Databases');this.databasesListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/websql?utm_source=devtools');const databaseIcon=UI.Icon.create('mediumicon-database','resource-tree-item');this.databasesListTreeElement.setLeadingIcons([databaseIcon]);storageTreeElement.appendChild(this.databasesListTreeElement);this.cookieListTreeElement=new Resources.StorageCategoryTreeElement(panel,Common.UIString('Cookies'),'Cookies');this.cookieListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/cookies?utm_source=devtools');const cookieIcon=UI.Icon.create('mediumicon-cookie','resource-tree-item');this.cookieListTreeElement.setLeadingIcons([cookieIcon]);storageTreeElement.appendChild(this.cookieListTreeElement);const cacheTreeElement=this._addSidebarSection(Common.UIString('Cache'));this.cacheStorageListTreeElement=new Resources.ServiceWorkerCacheTreeElement(panel);cacheTreeElement.appendChild(this.cacheStorageListTreeElement);this.applicationCacheListTreeElement=new Resources.StorageCategoryTreeElement(panel,Common.UIString('Application Cache'),'ApplicationCache');this.applicationCacheListTreeElement.setLink('https://developers.google.com/web/tools/chrome-devtools/storage/applicationcache?utm_source=devtools');const applicationCacheIcon=UI.Icon.create('mediumicon-table','resource-tree-item');this.applicationCacheListTreeElement.setLeadingIcons([applicationCacheIcon]);cacheTreeElement.appendChild(this.applicationCacheListTreeElement);if(Runtime.experiments.isEnabled('backgroundServices')){const backgroundServiceTreeElement=this._addSidebarSection(ls`Background Services`);this.backgroundFetchTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.BackgroundFetch);backgroundServiceTreeElement.appendChild(this.backgroundFetchTreeElement);this.backgroundSyncTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.BackgroundSync);backgroundServiceTreeElement.appendChild(this.backgroundSyncTreeElement);if(Runtime.experiments.isEnabled('backgroundServicesNotifications')){this.notificationsTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.Notifications);backgroundServiceTreeElement.appendChild(this.notificationsTreeElement);}
if(Runtime.experiments.isEnabled('backgroundServicesPaymentHandler')){this.paymentHandlerTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.PaymentHandler);backgroundServiceTreeElement.appendChild(this.paymentHandlerTreeElement);}
if(Runtime.experiments.isEnabled('backgroundServicesPeriodicBackgroundSync')){this.periodicBackgroundSyncTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.PeriodicBackgroundSync);backgroundServiceTreeElement.appendChild(this.periodicBackgroundSyncTreeElement);}
if(Runtime.experiments.isEnabled('backgroundServicesPushMessaging')){this.pushMessagingTreeElement=new Resources.BackgroundServiceTreeElement(panel,Protocol.BackgroundService.ServiceName.PushMessaging);backgroundServiceTreeElement.appendChild(this.pushMessagingTreeElement);}}
this._resourcesSection=new Resources.ResourcesSection(panel,this._addSidebarSection(Common.UIString('Frames')));this._databaseTableViews=new Map();this._databaseQueryViews=new Map();this._databaseTreeElements=new Map();this._domStorageTreeElements=new Map();this._domains={};this._sidebarTree.contentElement.addEventListener('mousemove',this._onmousemove.bind(this),false);this._sidebarTree.contentElement.addEventListener('mouseleave',this._onmouseleave.bind(this),false);SDK.targetManager.observeTargets(this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.FrameNavigated,this._frameNavigated,this);const selection=this._panel.lastSelectedItemPath();if(!selection.length)
manifestTreeElement.select();}
_addSidebarSection(title){const treeElement=new UI.TreeElement(title,true);treeElement.listItemElement.classList.add('storage-group-list-item');treeElement.setCollapsible(false);treeElement.selectable=false;this._sidebarTree.appendChild(treeElement);return treeElement;}
targetAdded(target){if(this._target)
return;this._target=target;this._databaseModel=target.model(Resources.DatabaseModel);this._databaseModel.addEventListener(Resources.DatabaseModel.Events.DatabaseAdded,this._databaseAdded,this);this._databaseModel.addEventListener(Resources.DatabaseModel.Events.DatabasesRemoved,this._resetWebSQL,this);const resourceTreeModel=target.model(SDK.ResourceTreeModel);if(!resourceTreeModel)
return;if(resourceTreeModel.cachedResourcesLoaded())
this._initialize();resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.CachedResourcesLoaded,this._initialize,this);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.WillLoadCachedResources,this._resetWithFrames,this);}
targetRemoved(target){if(target!==this._target)
return;delete this._target;const resourceTreeModel=target.model(SDK.ResourceTreeModel);if(resourceTreeModel){resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.CachedResourcesLoaded,this._initialize,this);resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.WillLoadCachedResources,this._resetWithFrames,this);}
this._databaseModel.removeEventListener(Resources.DatabaseModel.Events.DatabaseAdded,this._databaseAdded,this);this._databaseModel.removeEventListener(Resources.DatabaseModel.Events.DatabasesRemoved,this._resetWebSQL,this);this._resetWithFrames();}
focus(){this._sidebarTree.focus();}
_initialize(){for(const frame of SDK.ResourceTreeModel.frames())
this._addCookieDocument(frame);this._databaseModel.enable();const cacheStorageModel=this._target.model(SDK.ServiceWorkerCacheModel);if(cacheStorageModel)
cacheStorageModel.enable();const resourceTreeModel=this._target.model(SDK.ResourceTreeModel);if(resourceTreeModel)
this._populateApplicationCacheTree(resourceTreeModel);SDK.targetManager.observeModels(Resources.DOMStorageModel,({modelAdded:model=>this._domStorageModelAdded(model),modelRemoved:model=>this._domStorageModelRemoved(model)}));this.indexedDBListTreeElement._initialize();SDK.targetManager.observeModels(Resources.IndexedDBModel,({modelAdded:model=>model.enable(),modelRemoved:model=>this.indexedDBListTreeElement.removeIndexedDBForModel(model)}));const serviceWorkerCacheModel=this._target.model(SDK.ServiceWorkerCacheModel);this.cacheStorageListTreeElement._initialize(serviceWorkerCacheModel);const backgroundServiceModel=this._target.model(Resources.BackgroundServiceModel);if(Runtime.experiments.isEnabled('backgroundServices')){this.backgroundFetchTreeElement._initialize(backgroundServiceModel);this.backgroundSyncTreeElement._initialize(backgroundServiceModel);if(Runtime.experiments.isEnabled('backgroundServicesNotifications'))
this.notificationsTreeElement._initialize(backgroundServiceModel);if(Runtime.experiments.isEnabled('backgroundServicesPaymentHandler'))
this.paymentHandlerTreeElement._initialize(backgroundServiceModel);if(Runtime.experiments.isEnabled('backgroundServicesPeriodicBackgroundSync'))
this.periodicBackgroundSyncTreeElement._initialize(backgroundServiceModel);if(Runtime.experiments.isEnabled('backgroundServicesPushMessaging'))
this.pushMessagingTreeElement._initialize(backgroundServiceModel);}}
_domStorageModelAdded(model){model.enable();model.storages().forEach(this._addDOMStorage.bind(this));model.addEventListener(Resources.DOMStorageModel.Events.DOMStorageAdded,this._domStorageAdded,this);model.addEventListener(Resources.DOMStorageModel.Events.DOMStorageRemoved,this._domStorageRemoved,this);}
_domStorageModelRemoved(model){model.storages().forEach(this._removeDOMStorage.bind(this));model.removeEventListener(Resources.DOMStorageModel.Events.DOMStorageAdded,this._domStorageAdded,this);model.removeEventListener(Resources.DOMStorageModel.Events.DOMStorageRemoved,this._domStorageRemoved,this);}
_resetWithFrames(){this._resourcesSection.reset();this._reset();}
_resetWebSQL(){const queryViews=this._databaseQueryViews.valuesArray();for(let i=0;i<queryViews.length;++i){queryViews[i].removeEventListener(Resources.DatabaseQueryView.Events.SchemaUpdated,this._updateDatabaseTables,this);}
this._databaseTableViews.clear();this._databaseQueryViews.clear();this._databaseTreeElements.clear();this.databasesListTreeElement.removeChildren();this.databasesListTreeElement.setExpandable(false);}
_resetAppCache(){for(const frameId of Object.keys(this._applicationCacheFrameElements))
this._applicationCacheFrameManifestRemoved({data:frameId});this.applicationCacheListTreeElement.setExpandable(false);}
_treeElementAdded(event){const selection=this._panel.lastSelectedItemPath();if(!selection.length)
return;const element=event.data;const index=selection.indexOf(element.itemURL);if(index<0)
return;for(let parent=element.parent;parent;parent=parent.parent)
parent.expand();if(index>0)
element.expand();element.select();}
_reset(){this._domains={};this._resetWebSQL();this.cookieListTreeElement.removeChildren();}
_frameNavigated(event){const frame=(event.data);if(frame.isTopFrame())
this._reset();const applicationCacheFrameTreeElement=this._applicationCacheFrameElements[frame.id];if(applicationCacheFrameTreeElement)
applicationCacheFrameTreeElement.frameNavigated(frame);this._addCookieDocument(frame);}
_databaseAdded(event){const database=(event.data);const databaseTreeElement=new Resources.DatabaseTreeElement(this,database);this._databaseTreeElements.set(database,databaseTreeElement);this.databasesListTreeElement.appendChild(databaseTreeElement);}
_addCookieDocument(frame){const parsedURL=frame.url.asParsedURL();if(!parsedURL||(parsedURL.scheme!=='http'&&parsedURL.scheme!=='https'&&parsedURL.scheme!=='file'))
return;const domain=parsedURL.securityOrigin();if(!this._domains[domain]){this._domains[domain]=true;const cookieDomainTreeElement=new Resources.CookieTreeElement(this._panel,frame,domain);this.cookieListTreeElement.appendChild(cookieDomainTreeElement);}}
_domStorageAdded(event){const domStorage=(event.data);this._addDOMStorage(domStorage);}
_addDOMStorage(domStorage){console.assert(!this._domStorageTreeElements.get(domStorage));const domStorageTreeElement=new Resources.DOMStorageTreeElement(this._panel,domStorage);this._domStorageTreeElements.set(domStorage,domStorageTreeElement);if(domStorage.isLocalStorage)
this.localStorageListTreeElement.appendChild(domStorageTreeElement);else
this.sessionStorageListTreeElement.appendChild(domStorageTreeElement);}
_domStorageRemoved(event){const domStorage=(event.data);this._removeDOMStorage(domStorage);}
_removeDOMStorage(domStorage){const treeElement=this._domStorageTreeElements.get(domStorage);if(!treeElement)
return;const wasSelected=treeElement.selected;const parentListTreeElement=treeElement.parent;parentListTreeElement.removeChild(treeElement);if(wasSelected)
parentListTreeElement.select();this._domStorageTreeElements.remove(domStorage);}
selectDatabase(database){if(database){this._showDatabase(database);this._databaseTreeElements.get(database).select();}}
async showResource(resource,line,column){await this._resourcesSection.revealResource(resource,line,column);}
_showDatabase(database,tableName){if(!database)
return;let view;if(tableName){let tableViews=this._databaseTableViews.get(database);if(!tableViews){tableViews=({});this._databaseTableViews.set(database,tableViews);}
view=tableViews[tableName];if(!view){view=new Resources.DatabaseTableView(database,tableName);tableViews[tableName]=view;}}else{view=this._databaseQueryViews.get(database);if(!view){view=new Resources.DatabaseQueryView(database);this._databaseQueryViews.set(database,view);view.addEventListener(Resources.DatabaseQueryView.Events.SchemaUpdated,this._updateDatabaseTables,this);}}
this._innerShowView(view);}
_showApplicationCache(frameId){if(!this._applicationCacheViews[frameId]){this._applicationCacheViews[frameId]=new Resources.ApplicationCacheItemsView(this._applicationCacheModel,frameId);}
this._innerShowView(this._applicationCacheViews[frameId]);}
showFileSystem(view){this._innerShowView(view);}
_innerShowView(view){this._panel.showView(view);}
_updateDatabaseTables(event){const database=event.data;if(!database)
return;const databasesTreeElement=this._databaseTreeElements.get(database);if(!databasesTreeElement)
return;databasesTreeElement.invalidateChildren();const tableViews=this._databaseTableViews.get(database);if(!tableViews)
return;const tableNamesHash={};const panel=this._panel;function tableNamesCallback(tableNames){const tableNamesLength=tableNames.length;for(let i=0;i<tableNamesLength;++i)
tableNamesHash[tableNames[i]]=true;for(const tableName in tableViews){if(!(tableName in tableNamesHash)){if(panel.visibleView===tableViews[tableName])
panel.showView(null);delete tableViews[tableName];}}}
database.getTableNames(tableNamesCallback);}
_populateApplicationCacheTree(resourceTreeModel){this._applicationCacheModel=this._target.model(Resources.ApplicationCacheModel);this._applicationCacheViews={};this._applicationCacheFrameElements={};this._applicationCacheManifestElements={};this._applicationCacheModel.addEventListener(Resources.ApplicationCacheModel.Events.FrameManifestAdded,this._applicationCacheFrameManifestAdded,this);this._applicationCacheModel.addEventListener(Resources.ApplicationCacheModel.Events.FrameManifestRemoved,this._applicationCacheFrameManifestRemoved,this);this._applicationCacheModel.addEventListener(Resources.ApplicationCacheModel.Events.FrameManifestsReset,this._resetAppCache,this);this._applicationCacheModel.addEventListener(Resources.ApplicationCacheModel.Events.FrameManifestStatusUpdated,this._applicationCacheFrameManifestStatusChanged,this);this._applicationCacheModel.addEventListener(Resources.ApplicationCacheModel.Events.NetworkStateChanged,this._applicationCacheNetworkStateChanged,this);}
_applicationCacheFrameManifestAdded(event){const frameId=event.data;const manifestURL=this._applicationCacheModel.frameManifestURL(frameId);let manifestTreeElement=this._applicationCacheManifestElements[manifestURL];if(!manifestTreeElement){manifestTreeElement=new Resources.ApplicationCacheManifestTreeElement(this._panel,manifestURL);this.applicationCacheListTreeElement.appendChild(manifestTreeElement);this._applicationCacheManifestElements[manifestURL]=manifestTreeElement;}
const model=this._target.model(SDK.ResourceTreeModel);const frameTreeElement=new Resources.ApplicationCacheFrameTreeElement(this,model.frameForId(frameId),manifestURL);manifestTreeElement.appendChild(frameTreeElement);manifestTreeElement.expand();this._applicationCacheFrameElements[frameId]=frameTreeElement;}
_applicationCacheFrameManifestRemoved(event){const frameId=event.data;const frameTreeElement=this._applicationCacheFrameElements[frameId];if(!frameTreeElement)
return;const manifestURL=frameTreeElement.manifestURL;delete this._applicationCacheFrameElements[frameId];delete this._applicationCacheViews[frameId];frameTreeElement.parent.removeChild(frameTreeElement);const manifestTreeElement=this._applicationCacheManifestElements[manifestURL];if(manifestTreeElement.childCount())
return;delete this._applicationCacheManifestElements[manifestURL];manifestTreeElement.parent.removeChild(manifestTreeElement);}
_applicationCacheFrameManifestStatusChanged(event){const frameId=event.data;const status=this._applicationCacheModel.frameManifestStatus(frameId);if(this._applicationCacheViews[frameId])
this._applicationCacheViews[frameId].updateStatus(status);}
_applicationCacheNetworkStateChanged(event){const isNowOnline=event.data;for(const manifestURL in this._applicationCacheViews)
this._applicationCacheViews[manifestURL].updateNetworkState(isNowOnline);}
showView(view){if(view)
this.showResource(view.resource);}
_onmousemove(event){const nodeUnderMouse=event.target;if(!nodeUnderMouse)
return;const listNode=nodeUnderMouse.enclosingNodeOrSelfWithNodeName('li');if(!listNode)
return;const element=listNode.treeElement;if(this._previousHoveredElement===element)
return;if(this._previousHoveredElement){this._previousHoveredElement.hovered=false;delete this._previousHoveredElement;}
if(element instanceof Resources.FrameTreeElement){this._previousHoveredElement=element;element.hovered=true;}}
_onmouseleave(event){if(this._previousHoveredElement){this._previousHoveredElement.hovered=false;delete this._previousHoveredElement;}}};Resources.BaseStorageTreeElement=class extends UI.TreeElement{constructor(storagePanel,title,expandable){super(title,expandable);this._storagePanel=storagePanel;}
onselect(selectedByUser){if(!selectedByUser)
return false;const path=[];for(let el=this;el;el=el.parent){const url=el.itemURL;if(!url)
break;path.push(url);}
this._storagePanel.setLastSelectedItemPath(path);return false;}
showView(view){this._storagePanel.showView(view);}};Resources.StorageCategoryTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,categoryName,settingsKey){super(storagePanel,categoryName,false);this._expandedSetting=Common.settings.createSetting('resources'+settingsKey+'Expanded',settingsKey==='Frames');this._categoryName=categoryName;this._categoryLink=null;}
get itemURL(){return'category://'+this._categoryName;}
setLink(link){this._categoryLink=link;}
onselect(selectedByUser){super.onselect(selectedByUser);this._storagePanel.showCategoryView(this._categoryName,this._categoryLink);return false;}
onattach(){super.onattach();if(this._expandedSetting.get())
this.expand();}
onexpand(){this._expandedSetting.set(true);}
oncollapse(){this._expandedSetting.set(false);}};Resources.BackgroundServiceTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,serviceName){super(storagePanel,Resources.BackgroundServiceView.getUIString(serviceName),false);this._serviceName=serviceName;this._selected=false;this._view=null;this._model=null;const backgroundServiceIcon=UI.Icon.create(this._getIconType(),'resource-tree-item');this.setLeadingIcons([backgroundServiceIcon]);}
_getIconType(){switch(this._serviceName){case Protocol.BackgroundService.ServiceName.BackgroundFetch:return'mediumicon-fetch';case Protocol.BackgroundService.ServiceName.BackgroundSync:return'mediumicon-sync';case Protocol.BackgroundService.ServiceName.PushMessaging:return'mediumicon-cloud';case Protocol.BackgroundService.ServiceName.Notifications:return'mediumicon-bell';case Protocol.BackgroundService.ServiceName.PaymentHandler:return'mediumicon-payment';case Protocol.BackgroundService.ServiceName.PeriodicBackgroundSync:return'mediumicon-schedule';default:console.error(`Service ${this._serviceName} does not have a dedicated icon`);return'mediumicon-table';}}
_initialize(model){this._model=model;if(this._selected&&!this._view)
this.onselect(false);}
get itemURL(){return`background-service://${this._serviceName}`;}
onselect(selectedByUser){super.onselect(selectedByUser);this._selected=true;if(!this._model)
return false;if(!this._view)
this._view=new Resources.BackgroundServiceView(this._serviceName,this._model);this.showView(this._view);UI.context.setFlavor(Resources.BackgroundServiceView,this._view);return false;}};Resources.DatabaseTreeElement=class extends Resources.BaseStorageTreeElement{constructor(sidebar,database){super(sidebar._panel,database.name,true);this._sidebar=sidebar;this._database=database;const icon=UI.Icon.create('mediumicon-database','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'database://'+encodeURI(this._database.name);}
onselect(selectedByUser){super.onselect(selectedByUser);this._sidebar._showDatabase(this._database);return false;}
onexpand(){this._updateChildren();}
async _updateChildren(){const tableNames=await this._database.tableNames();for(const tableName of tableNames)
this.appendChild(new Resources.DatabaseTableTreeElement(this._sidebar,this._database,tableName));}};Resources.DatabaseTableTreeElement=class extends Resources.BaseStorageTreeElement{constructor(sidebar,database,tableName){super(sidebar._panel,tableName,false);this._sidebar=sidebar;this._database=database;this._tableName=tableName;const icon=UI.Icon.create('mediumicon-table','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'database://'+encodeURI(this._database.name)+'/'+encodeURI(this._tableName);}
onselect(selectedByUser){super.onselect(selectedByUser);this._sidebar._showDatabase(this._database,this._tableName);return false;}};Resources.ServiceWorkerCacheTreeElement=class extends Resources.StorageCategoryTreeElement{constructor(storagePanel){super(storagePanel,Common.UIString('Cache Storage'),'CacheStorage');const icon=UI.Icon.create('mediumicon-database','resource-tree-item');this.setLeadingIcons([icon]);this._swCacheModel=null;}
_initialize(model){this._swCacheTreeElements=[];this._swCacheModel=model;if(model){for(const cache of model.caches())
this._addCache(model,cache);}
SDK.targetManager.addModelListener(SDK.ServiceWorkerCacheModel,SDK.ServiceWorkerCacheModel.Events.CacheAdded,this._cacheAdded,this);SDK.targetManager.addModelListener(SDK.ServiceWorkerCacheModel,SDK.ServiceWorkerCacheModel.Events.CacheRemoved,this._cacheRemoved,this);}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Refresh Caches'),this._refreshCaches.bind(this));contextMenu.show();}
_refreshCaches(){if(this._swCacheModel)
this._swCacheModel.refreshCacheNames();}
_cacheAdded(event){const cache=(event.data.cache);const model=(event.data.model);this._addCache(model,cache);}
_addCache(model,cache){const swCacheTreeElement=new Resources.SWCacheTreeElement(this._storagePanel,model,cache);this._swCacheTreeElements.push(swCacheTreeElement);this.appendChild(swCacheTreeElement);}
_cacheRemoved(event){const cache=(event.data.cache);const model=(event.data.model);const swCacheTreeElement=this._cacheTreeElement(model,cache);if(!swCacheTreeElement)
return;this.removeChild(swCacheTreeElement);this._swCacheTreeElements.remove(swCacheTreeElement);this.setExpandable(this.childCount()>0);}
_cacheTreeElement(model,cache){let index=-1;let i;for(i=0;i<this._swCacheTreeElements.length;++i){if(this._swCacheTreeElements[i]._cache.equals(cache)&&this._swCacheTreeElements[i]._model===model){index=i;break;}}
if(index!==-1)
return this._swCacheTreeElements[i];return null;}};Resources.SWCacheTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,model,cache){super(storagePanel,cache.cacheName+' - '+cache.securityOrigin,false);this._model=model;this._cache=cache;this._view=null;const icon=UI.Icon.create('mediumicon-table','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'cache://'+this._cache.cacheId;}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Delete'),this._clearCache.bind(this));contextMenu.show();}
_clearCache(){this._model.deleteCache(this._cache);}
update(cache){this._cache=cache;if(this._view)
this._view.update(cache);}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view)
this._view=new Resources.ServiceWorkerCacheView(this._model,this._cache);this.showView(this._view);return false;}};Resources.ServiceWorkersTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel){super(storagePanel,Common.UIString('Service Workers'),false);const icon=UI.Icon.create('mediumicon-service-worker','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'service-workers://';}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view)
this._view=new Resources.ServiceWorkersView();this.showView(this._view);return false;}};Resources.AppManifestTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel){super(storagePanel,Common.UIString('Manifest'),false);const icon=UI.Icon.create('mediumicon-manifest','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'manifest://';}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view)
this._view=new Resources.AppManifestView();this.showView(this._view);return false;}};Resources.ClearStorageTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel){super(storagePanel,Common.UIString('Clear storage'),false);const icon=UI.Icon.create('mediumicon-clear-storage','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'clear-storage://';}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view)
this._view=new Resources.ClearStorageView();this.showView(this._view);return false;}};Resources.IndexedDBTreeElement=class extends Resources.StorageCategoryTreeElement{constructor(storagePanel){super(storagePanel,Common.UIString('IndexedDB'),'IndexedDB');const icon=UI.Icon.create('mediumicon-database','resource-tree-item');this.setLeadingIcons([icon]);}
_initialize(){SDK.targetManager.addModelListener(Resources.IndexedDBModel,Resources.IndexedDBModel.Events.DatabaseAdded,this._indexedDBAdded,this);SDK.targetManager.addModelListener(Resources.IndexedDBModel,Resources.IndexedDBModel.Events.DatabaseRemoved,this._indexedDBRemoved,this);SDK.targetManager.addModelListener(Resources.IndexedDBModel,Resources.IndexedDBModel.Events.DatabaseLoaded,this._indexedDBLoaded,this);SDK.targetManager.addModelListener(Resources.IndexedDBModel,Resources.IndexedDBModel.Events.IndexedDBContentUpdated,this._indexedDBContentUpdated,this);this._idbDatabaseTreeElements=[];for(const indexedDBModel of SDK.targetManager.models(Resources.IndexedDBModel)){const databases=indexedDBModel.databases();for(let j=0;j<databases.length;++j)
this._addIndexedDB(indexedDBModel,databases[j]);}}
removeIndexedDBForModel(model){const idbDatabaseTreeElements=this._idbDatabaseTreeElements.filter(element=>element._model===model);for(const idbDatabaseTreeElement of idbDatabaseTreeElements)
this._removeIDBDatabaseTreeElement(idbDatabaseTreeElement);}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Refresh IndexedDB'),this.refreshIndexedDB.bind(this));contextMenu.show();}
refreshIndexedDB(){for(const indexedDBModel of SDK.targetManager.models(Resources.IndexedDBModel))
indexedDBModel.refreshDatabaseNames();}
_indexedDBAdded(event){const databaseId=(event.data.databaseId);const model=(event.data.model);this._addIndexedDB(model,databaseId);}
_addIndexedDB(model,databaseId){const idbDatabaseTreeElement=new Resources.IDBDatabaseTreeElement(this._storagePanel,model,databaseId);this._idbDatabaseTreeElements.push(idbDatabaseTreeElement);this.appendChild(idbDatabaseTreeElement);model.refreshDatabase(databaseId);}
_indexedDBRemoved(event){const databaseId=(event.data.databaseId);const model=(event.data.model);const idbDatabaseTreeElement=this._idbDatabaseTreeElement(model,databaseId);if(!idbDatabaseTreeElement)
return;this._removeIDBDatabaseTreeElement(idbDatabaseTreeElement);}
_removeIDBDatabaseTreeElement(idbDatabaseTreeElement){idbDatabaseTreeElement.clear();this.removeChild(idbDatabaseTreeElement);this._idbDatabaseTreeElements.remove(idbDatabaseTreeElement);this.setExpandable(this.childCount()>0);}
_indexedDBLoaded(event){const database=(event.data.database);const model=(event.data.model);const entriesUpdated=(event.data.entriesUpdated);const idbDatabaseTreeElement=this._idbDatabaseTreeElement(model,database.databaseId);if(!idbDatabaseTreeElement)
return;idbDatabaseTreeElement.update(database,entriesUpdated);this._indexedDBLoadedForTest();}
_indexedDBLoadedForTest(){}
_indexedDBContentUpdated(event){const databaseId=(event.data.databaseId);const objectStoreName=(event.data.objectStoreName);const model=(event.data.model);const idbDatabaseTreeElement=this._idbDatabaseTreeElement(model,databaseId);if(!idbDatabaseTreeElement)
return;idbDatabaseTreeElement.indexedDBContentUpdated(objectStoreName);}
_idbDatabaseTreeElement(model,databaseId){return this._idbDatabaseTreeElements.find(x=>x._databaseId.equals(databaseId)&&x._model===model)||null;}};Resources.IDBDatabaseTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,model,databaseId){super(storagePanel,databaseId.name+' - '+databaseId.securityOrigin,false);this._model=model;this._databaseId=databaseId;this._idbObjectStoreTreeElements={};const icon=UI.Icon.create('mediumicon-database','resource-tree-item');this.setLeadingIcons([icon]);this._model.addEventListener(Resources.IndexedDBModel.Events.DatabaseNamesRefreshed,this._refreshIndexedDB,this);}
get itemURL(){return'indexedDB://'+this._databaseId.securityOrigin+'/'+this._databaseId.name;}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Refresh IndexedDB'),this._refreshIndexedDB.bind(this));contextMenu.show();}
_refreshIndexedDB(){this._model.refreshDatabase(this._databaseId);}
indexedDBContentUpdated(objectStoreName){if(this._idbObjectStoreTreeElements[objectStoreName])
this._idbObjectStoreTreeElements[objectStoreName].markNeedsRefresh();}
update(database,entriesUpdated){this._database=database;const objectStoreNames={};const objectStoreNamesSorted=Object.keys(this._database.objectStores).sort();for(const objectStoreName of objectStoreNamesSorted){const objectStore=this._database.objectStores[objectStoreName];objectStoreNames[objectStore.name]=true;if(!this._idbObjectStoreTreeElements[objectStore.name]){const idbObjectStoreTreeElement=new Resources.IDBObjectStoreTreeElement(this._storagePanel,this._model,this._databaseId,objectStore);this._idbObjectStoreTreeElements[objectStore.name]=idbObjectStoreTreeElement;this.appendChild(idbObjectStoreTreeElement);}
this._idbObjectStoreTreeElements[objectStore.name].update(objectStore,entriesUpdated);}
for(const objectStoreName in this._idbObjectStoreTreeElements){if(!objectStoreNames[objectStoreName])
this._objectStoreRemoved(objectStoreName);}
if(this._view)
this._view.update(database);this._updateTooltip();}
_updateTooltip(){if(Object.keys(this._idbObjectStoreTreeElements).length===0)
this.tooltip=ls`Version: ${this._database.version} (empty)`;else
this.tooltip=ls`Version: ${this._database.version}`;}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view)
this._view=new Resources.IDBDatabaseView(this._model,this._database);this.showView(this._view);return false;}
_objectStoreRemoved(objectStoreName){const objectStoreTreeElement=this._idbObjectStoreTreeElements[objectStoreName];objectStoreTreeElement.clear();this.removeChild(objectStoreTreeElement);delete this._idbObjectStoreTreeElements[objectStoreName];this._updateTooltip();}
clear(){for(const objectStoreName in this._idbObjectStoreTreeElements)
this._objectStoreRemoved(objectStoreName);}};Resources.IDBObjectStoreTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,model,databaseId,objectStore){super(storagePanel,objectStore.name,false);this._model=model;this._databaseId=databaseId;this._idbIndexTreeElements={};this._objectStore=objectStore;this._view=null;const icon=UI.Icon.create('mediumicon-table','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'indexedDB://'+this._databaseId.securityOrigin+'/'+this._databaseId.name+'/'+
this._objectStore.name;}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
markNeedsRefresh(){if(this._view)
this._view.markNeedsRefresh();for(const indexName in this._idbIndexTreeElements)
this._idbIndexTreeElements[indexName].markNeedsRefresh();}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Clear'),this._clearObjectStore.bind(this));contextMenu.show();}
_refreshObjectStore(){if(this._view)
this._view.refreshData();for(const indexName in this._idbIndexTreeElements)
this._idbIndexTreeElements[indexName].refreshIndex();}
async _clearObjectStore(){await this._model.clearObjectStore(this._databaseId,this._objectStore.name);this.update(this._objectStore,true);}
update(objectStore,entriesUpdated){this._objectStore=objectStore;const indexNames={};for(const indexName in this._objectStore.indexes){const index=this._objectStore.indexes[indexName];indexNames[index.name]=true;if(!this._idbIndexTreeElements[index.name]){const idbIndexTreeElement=new Resources.IDBIndexTreeElement(this._storagePanel,this._model,this._databaseId,this._objectStore,index,this._refreshObjectStore.bind(this));this._idbIndexTreeElements[index.name]=idbIndexTreeElement;this.appendChild(idbIndexTreeElement);}
this._idbIndexTreeElements[index.name].update(this._objectStore,index,entriesUpdated);}
for(const indexName in this._idbIndexTreeElements){if(!indexNames[indexName])
this._indexRemoved(indexName);}
for(const indexName in this._idbIndexTreeElements){if(!indexNames[indexName]){this.removeChild(this._idbIndexTreeElements[indexName]);delete this._idbIndexTreeElements[indexName];}}
if(this.childCount())
this.expand();if(this._view&&entriesUpdated)
this._view.update(this._objectStore,null);this._updateTooltip();}
_updateTooltip(){const keyPathString=this._objectStore.keyPathString;let tooltipString=keyPathString!==null?ls`Key path: ${keyPathString}`:'';if(this._objectStore.autoIncrement)
tooltipString+='\n'+Common.UIString('autoIncrement');this.tooltip=tooltipString;}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view){this._view=new Resources.IDBDataView(this._model,this._databaseId,this._objectStore,null,this._refreshObjectStore.bind(this));}
this.showView(this._view);return false;}
_indexRemoved(indexName){const indexTreeElement=this._idbIndexTreeElements[indexName];indexTreeElement.clear();this.removeChild(indexTreeElement);delete this._idbIndexTreeElements[indexName];}
clear(){for(const indexName in this._idbIndexTreeElements)
this._indexRemoved(indexName);if(this._view)
this._view.clear();}};Resources.IDBIndexTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,model,databaseId,objectStore,index,refreshObjectStore){super(storagePanel,index.name,false);this._model=model;this._databaseId=databaseId;this._objectStore=objectStore;this._index=index;this._refreshObjectStore=refreshObjectStore;}
get itemURL(){return'indexedDB://'+this._databaseId.securityOrigin+'/'+this._databaseId.name+'/'+
this._objectStore.name+'/'+this._index.name;}
markNeedsRefresh(){if(this._view)
this._view.markNeedsRefresh();}
refreshIndex(){if(this._view)
this._view.refreshData();}
update(objectStore,index,entriesUpdated){this._objectStore=objectStore;this._index=index;if(this._view&&entriesUpdated)
this._view.update(this._objectStore,this._index);this._updateTooltip();}
_updateTooltip(){const tooltipLines=[];const keyPathString=this._index.keyPathString;tooltipLines.push(ls`Key path: ${keyPathString}`);if(this._index.unique)
tooltipLines.push(Common.UIString('unique'));if(this._index.multiEntry)
tooltipLines.push(Common.UIString('multiEntry'));this.tooltip=tooltipLines.join('\n');}
onselect(selectedByUser){super.onselect(selectedByUser);if(!this._view){this._view=new Resources.IDBDataView(this._model,this._databaseId,this._objectStore,this._index,this._refreshObjectStore);}
this.showView(this._view);return false;}
clear(){if(this._view)
this._view.clear();}};Resources.DOMStorageTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,domStorage){super(storagePanel,domStorage.securityOrigin?domStorage.securityOrigin:Common.UIString('Local Files'),false);this._domStorage=domStorage;const icon=UI.Icon.create('mediumicon-table','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'storage://'+this._domStorage.securityOrigin+'/'+
(this._domStorage.isLocalStorage?'local':'session');}
onselect(selectedByUser){super.onselect(selectedByUser);this._storagePanel.showDOMStorage(this._domStorage);return false;}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Clear'),()=>this._domStorage.clear());contextMenu.show();}};Resources.CookieTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,frame,cookieDomain){super(storagePanel,cookieDomain?cookieDomain:Common.UIString('Local Files'),false);this._target=frame.resourceTreeModel().target();this._cookieDomain=cookieDomain;this.tooltip=ls`cookies used by frames from ${cookieDomain}`;const icon=UI.Icon.create('mediumicon-cookie','resource-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'cookies://'+this._cookieDomain;}
onattach(){super.onattach();this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.defaultSection().appendItem(Common.UIString('Clear'),()=>this._storagePanel.clearCookies(this._target,this._cookieDomain));contextMenu.show();}
onselect(selectedByUser){super.onselect(selectedByUser);this._storagePanel.showCookies(this._target,this._cookieDomain);return false;}};Resources.ApplicationCacheManifestTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,manifestURL){const title=new Common.ParsedURL(manifestURL).displayName;super(storagePanel,title,false);this.tooltip=manifestURL;this._manifestURL=manifestURL;}
get itemURL(){return'appcache://'+this._manifestURL;}
get manifestURL(){return this._manifestURL;}
onselect(selectedByUser){super.onselect(selectedByUser);this._storagePanel.showCategoryView(this._manifestURL,null);return false;}};Resources.ApplicationCacheFrameTreeElement=class extends Resources.BaseStorageTreeElement{constructor(sidebar,frame,manifestURL){super(sidebar._panel,'',false);this._sidebar=sidebar;this._frameId=frame.id;this._manifestURL=manifestURL;this._refreshTitles(frame);const icon=UI.Icon.create('largeicon-navigator-folder','navigator-tree-item');icon.classList.add('navigator-folder-tree-item');this.setLeadingIcons([icon]);}
get itemURL(){return'appcache://'+this._manifestURL+'/'+encodeURI(this.titleAsText());}
get frameId(){return this._frameId;}
get manifestURL(){return this._manifestURL;}
_refreshTitles(frame){this.title=frame.displayName();}
frameNavigated(frame){this._refreshTitles(frame);}
onselect(selectedByUser){super.onselect(selectedByUser);this._sidebar._showApplicationCache(this._frameId);return false;}};Resources.StorageCategoryView=class extends UI.VBox{constructor(){super();this.element.classList.add('storage-view');this._emptyWidget=new UI.EmptyWidget('');this._linkElement=null;this._emptyWidget.show(this.element);}
setText(text){this._emptyWidget.text=text;}
setLink(link){if(link&&!this._linkElement)
this._linkElement=this._emptyWidget.appendLink(link);if(!link&&this._linkElement)
this._linkElement.classList.add('hidden');if(link&&this._linkElement){this._linkElement.setAttribute('href',link);this._linkElement.classList.remove('hidden');}}};;Resources.ResourcesSection=class{constructor(storagePanel,treeElement){this._panel=storagePanel;this._treeElement=treeElement;this._treeElementForFrameId=new Map();function addListener(eventType,handler,target){SDK.targetManager.addModelListener(SDK.ResourceTreeModel,eventType,event=>handler.call(target,event.data));}
addListener(SDK.ResourceTreeModel.Events.FrameAdded,this._frameAdded,this);addListener(SDK.ResourceTreeModel.Events.FrameNavigated,this._frameNavigated,this);addListener(SDK.ResourceTreeModel.Events.FrameDetached,this._frameDetached,this);addListener(SDK.ResourceTreeModel.Events.ResourceAdded,this._resourceAdded,this);const mainTarget=SDK.targetManager.mainTarget();const resourceTreeModel=mainTarget&&mainTarget.model(SDK.ResourceTreeModel);const mainFrame=resourceTreeModel&&resourceTreeModel.mainFrame;if(mainFrame)
this._frameAdded(mainFrame);}
static _getParentFrame(frame){const parentFrame=frame.parentFrame;if(parentFrame)
return parentFrame;const parentTarget=frame.resourceTreeModel().target().parentTarget();if(!parentTarget)
return null;return parentTarget.model(SDK.ResourceTreeModel).mainFrame;}
_expandFrame(frame){if(!frame)
return false;let treeElement=this._treeElementForFrameId.get(frame.id);if(!treeElement&&!this._expandFrame(Resources.ResourcesSection._getParentFrame(frame)))
return false;treeElement=this._treeElementForFrameId.get(frame.id);if(!treeElement)
return false;treeElement.expand();return true;}
async revealResource(resource,line,column){if(!this._expandFrame(resource.frame()))
return;const resourceTreeElement=Resources.FrameResourceTreeElement.forResource(resource);if(resourceTreeElement)
await resourceTreeElement.revealResource(line,column);}
_frameAdded(frame){const parentFrame=Resources.ResourcesSection._getParentFrame(frame);const parentTreeElement=parentFrame?this._treeElementForFrameId.get(parentFrame.id):this._treeElement;if(!parentTreeElement)
return;const frameTreeElement=new Resources.FrameTreeElement(this,frame);this._treeElementForFrameId.set(frame.id,frameTreeElement);parentTreeElement.appendChild(frameTreeElement);}
_frameDetached(frame){const frameTreeElement=this._treeElementForFrameId.get(frame.id);if(!frameTreeElement)
return;this._treeElementForFrameId.remove(frame.id);if(frameTreeElement.parent)
frameTreeElement.parent.removeChild(frameTreeElement);}
_frameNavigated(frame){const frameTreeElement=this._treeElementForFrameId.get(frame.id);if(frameTreeElement)
frameTreeElement.frameNavigated(frame);}
_resourceAdded(resource){const frameTreeElement=this._treeElementForFrameId.get(resource.frameId);if(!frameTreeElement){return;}
frameTreeElement.appendResource(resource);}
reset(){this._treeElement.removeChildren();this._treeElementForFrameId.clear();}};Resources.FrameTreeElement=class extends Resources.BaseStorageTreeElement{constructor(section,frame){super(section._panel,'',false);this._populated=false;this._section=section;this._frame=frame;this._frameId=frame.id;this._categoryElements={};this._treeElementForResource={};this.setExpandable(true);this.frameNavigated(frame);const icon=UI.Icon.create('largeicon-navigator-frame','navigator-tree-item');icon.classList.add('navigator-frame-tree-item');this.setLeadingIcons([icon]);}
frameNavigated(frame){this.invalidateChildren();this._frameId=frame.id;this.title=frame.displayName();this._categoryElements={};this._treeElementForResource={};}
get itemURL(){return'frame://'+encodeURI(this.titleAsText());}
onselect(selectedByUser){super.onselect(selectedByUser);this._section._panel.showCategoryView(this.titleAsText(),null);this.listItemElement.classList.remove('hovered');SDK.OverlayModel.hideDOMNodeHighlight();return false;}
set hovered(hovered){if(hovered){this.listItemElement.classList.add('hovered');this._frame.resourceTreeModel().domModel().overlayModel().highlightFrame(this._frameId);}else{this.listItemElement.classList.remove('hovered');SDK.OverlayModel.hideDOMNodeHighlight();}}
appendResource(resource){if(!this._populated)
return;const statusCode=resource['statusCode'];if(statusCode>=301&&statusCode<=303)
return;const resourceType=resource.resourceType();const categoryName=resourceType.name();let categoryElement=resourceType===Common.resourceTypes.Document?this:this._categoryElements[categoryName];if(!categoryElement){categoryElement=new Resources.StorageCategoryTreeElement(this._section._panel,resource.resourceType().category().title,categoryName);this._categoryElements[resourceType.name()]=categoryElement;this._insertInPresentationOrder(this,categoryElement);}
const resourceTreeElement=new Resources.FrameResourceTreeElement(this._section._panel,resource);this._insertInPresentationOrder(categoryElement,resourceTreeElement);this._treeElementForResource[resource.url]=resourceTreeElement;}
resourceByURL(url){const treeElement=this._treeElementForResource[url];return treeElement?treeElement._resource:null;}
appendChild(treeElement){if(!this._populated)
return;this._insertInPresentationOrder(this,treeElement);}
_insertInPresentationOrder(parentTreeElement,childTreeElement){function typeWeight(treeElement){if(treeElement instanceof Resources.StorageCategoryTreeElement)
return 2;if(treeElement instanceof Resources.FrameTreeElement)
return 1;return 3;}
function compare(treeElement1,treeElement2){const typeWeight1=typeWeight(treeElement1);const typeWeight2=typeWeight(treeElement2);let result;if(typeWeight1>typeWeight2)
result=1;else if(typeWeight1<typeWeight2)
result=-1;else
result=treeElement1.titleAsText().localeCompare(treeElement2.titleAsText());return result;}
const childCount=parentTreeElement.childCount();let i;for(i=0;i<childCount;++i){if(compare(childTreeElement,parentTreeElement.childAt(i))<0)
break;}
parentTreeElement.insertChild(childTreeElement,i);}
async onpopulate(){this._populated=true;for(const child of this._frame.childFrames)
this._section._frameAdded(child);for(const resource of this._frame.resources())
this.appendResource(resource);}};Resources.FrameResourceTreeElement=class extends Resources.BaseStorageTreeElement{constructor(storagePanel,resource){super(storagePanel,resource.displayName,false);this._panel=storagePanel;this._resource=resource;this._previewPromise=null;this.tooltip=resource.url;this._resource[Resources.FrameResourceTreeElement._symbol]=this;const icon=UI.Icon.create('largeicon-navigator-file','navigator-tree-item');icon.classList.add('navigator-file-tree-item');icon.classList.add('navigator-'+resource.resourceType().name()+'-tree-item');this.setLeadingIcons([icon]);}
static forResource(resource){return resource[Resources.FrameResourceTreeElement._symbol];}
get itemURL(){return this._resource.url;}
_preparePreview(){if(this._previewPromise)
return this._previewPromise;const viewPromise=SourceFrame.PreviewFactory.createPreview(this._resource,this._resource.mimeType);this._previewPromise=viewPromise.then(view=>{if(view)
return view;return new UI.EmptyWidget(this._resource.url);});return this._previewPromise;}
onselect(selectedByUser){super.onselect(selectedByUser);this._panel.scheduleShowView(this._preparePreview());return false;}
ondblclick(event){InspectorFrontendHost.openInNewTab(this._resource.url);return false;}
onattach(){super.onattach();this.listItemElement.draggable=true;this.listItemElement.addEventListener('dragstart',this._ondragstart.bind(this),false);this.listItemElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),true);}
_ondragstart(event){event.dataTransfer.setData('text/plain',this._resource.content||'');event.dataTransfer.effectAllowed='copy';return true;}
_handleContextMenuEvent(event){const contextMenu=new UI.ContextMenu(event);contextMenu.appendApplicableItems(this._resource);contextMenu.show();}
async revealResource(line,column){this.revealAndSelect(true);const view=await this._panel.scheduleShowView(this._preparePreview());if(!(view instanceof SourceFrame.ResourceSourceFrame)||typeof line!=='number')
return;view.revealPosition(line,column,true);}};Resources.FrameResourceTreeElement._symbol=Symbol('treeElement');;Resources.ServiceWorkerCacheView=class extends UI.SimpleView{constructor(model,cache){super(Common.UIString('Cache'));this.registerRequiredCSS('resources/serviceWorkerCacheViews.css');this._model=model;this._entriesForTest=null;this.element.classList.add('service-worker-cache-data-view');this.element.classList.add('storage-view');const editorToolbar=new UI.Toolbar('data-view-toolbar',this.element);this._splitWidget=new UI.SplitWidget(false,false);this._splitWidget.show(this.element);this._previewPanel=new UI.VBox();const resizer=this._previewPanel.element.createChild('div','cache-preview-panel-resizer');this._splitWidget.setMainWidget(this._previewPanel);this._splitWidget.installResizer(resizer);this._preview=null;this._cache=cache;this._dataGrid=null;this._lastPageSize=null;this._lastSkipCount=null;this._refreshThrottler=new Common.Throttler(300);this._pageBackButton=new UI.ToolbarButton(Common.UIString('Show previous page'),'largeicon-play-back');this._pageBackButton.addEventListener(UI.ToolbarButton.Events.Click,this._pageBackButtonClicked,this);editorToolbar.appendToolbarItem(this._pageBackButton);this._pageForwardButton=new UI.ToolbarButton(Common.UIString('Show next page'),'largeicon-play');this._pageForwardButton.setEnabled(false);this._pageForwardButton.addEventListener(UI.ToolbarButton.Events.Click,this._pageForwardButtonClicked,this);editorToolbar.appendToolbarItem(this._pageForwardButton);this._refreshButton=new UI.ToolbarButton(Common.UIString('Refresh'),'largeicon-refresh');this._refreshButton.addEventListener(UI.ToolbarButton.Events.Click,this._refreshButtonClicked,this);editorToolbar.appendToolbarItem(this._refreshButton);this._deleteSelectedButton=new UI.ToolbarButton(Common.UIString('Delete Selected'),'largeicon-delete');this._deleteSelectedButton.addEventListener(UI.ToolbarButton.Events.Click,()=>this._deleteButtonClicked(null));editorToolbar.appendToolbarItem(this._deleteSelectedButton);const entryPathFilterBox=new UI.ToolbarInput(ls`Filter by Path`,1);editorToolbar.appendToolbarItem(entryPathFilterBox);const entryPathFilterThrottler=new Common.Throttler(300);this._entryPathFilter='';entryPathFilterBox.addEventListener(UI.ToolbarInput.Event.TextChanged,()=>{entryPathFilterThrottler.schedule(()=>{this._entryPathFilter=entryPathFilterBox.value();this._skipCount=0;return this._updateData(true);});});this._pageSize=50;this._skipCount=0;this._returnCount=(null);this._summaryBarElement=(null);this.update(cache);}
_resetDataGrid(){if(this._dataGrid)
this._dataGrid.asWidget().detach();this._dataGrid=this._createDataGrid();const dataGridWidget=this._dataGrid.asWidget();this._splitWidget.setSidebarWidget(dataGridWidget);dataGridWidget.setMinimumSize(0,250);this._skipCount=0;}
wasShown(){this._model.addEventListener(SDK.ServiceWorkerCacheModel.Events.CacheStorageContentUpdated,this._cacheContentUpdated,this);this._updateData(true);}
willHide(){this._model.removeEventListener(SDK.ServiceWorkerCacheModel.Events.CacheStorageContentUpdated,this._cacheContentUpdated,this);}
_showPreview(preview){if(preview&&this._preview===preview)
return;if(this._preview)
this._preview.detach();if(!preview)
preview=new UI.EmptyWidget(Common.UIString('Select a cache entry above to preview'));this._preview=preview;this._preview.show(this._previewPanel.element);}
_createDataGrid(){const columns=([{id:'number',title:'#',sortable:false,width:'3px'},{id:'name',title:Common.UIString('Name'),weight:4,sortable:true},{id:'responseType',title:ls`Response-Type`,weight:1,align:DataGrid.DataGrid.Align.Right,sortable:true},{id:'contentType',title:Common.UIString('Content-Type'),weight:1,sortable:true},{id:'contentLength',title:Common.UIString('Content-Length'),weight:1,align:DataGrid.DataGrid.Align.Right,sortable:true},{id:'responseTime',title:Common.UIString('Time Cached'),width:'12em',weight:1,align:DataGrid.DataGrid.Align.Right,sortable:true}]);const dataGrid=new DataGrid.DataGrid(columns,undefined,this._deleteButtonClicked.bind(this),this._updateData.bind(this,true));dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortingChanged,this);dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,event=>this._previewCachedResponse(event.data.data),this);dataGrid.setStriped(true);return dataGrid;}
_sortingChanged(){if(!this._dataGrid)
return;const accending=this._dataGrid.isSortOrderAscending();const columnId=this._dataGrid.sortColumnId();let comparator;if(columnId==='name')
comparator=(a,b)=>a._path.localeCompare(b._path);else if(columnId==='contentType')
comparator=(a,b)=>a.data.mimeType.localeCompare(b.data.mimeType);else if(columnId==='contentLength')
comparator=(a,b)=>a.data.resourceSize-b.data.resourceSize;else if(columnId==='responseTime')
comparator=(a,b)=>a.data.endTime-b.data.endTime;const children=this._dataGrid.rootNode().children.slice();this._dataGrid.rootNode().removeChildren();children.sort((a,b)=>{const result=comparator(a,b);return accending?result:-result;});children.forEach(child=>this._dataGrid.rootNode().appendChild(child));}
_pageBackButtonClicked(event){this._skipCount=Math.max(0,this._skipCount-this._pageSize);this._updateData(false);}
_pageForwardButtonClicked(event){this._skipCount=this._skipCount+this._pageSize;this._updateData(false);}
async _deleteButtonClicked(node){if(!node){node=this._dataGrid&&this._dataGrid.selectedNode;if(!node)
return;}
await this._model.deleteCacheEntry(this._cache,(node.data.url()));node.remove();}
update(cache){this._cache=cache;this._resetDataGrid();this._updateData(true);}
_updateSummaryBar(){if(!this._summaryBarElement)
this._summaryBarElement=this.element.createChild('div','cache-storage-summary-bar');this._summaryBarElement.removeChildren();const span=this._summaryBarElement.createChild('span');if(this._entryPathFilter)
span.textContent=ls`Matching entries: ${this._returnCount}`;else
span.textContent=ls`Total entries: ${this._returnCount}`;}
_updateDataCallback(skipCount,entries,returnCount){const selected=this._dataGrid.selectedNode&&this._dataGrid.selectedNode.data.url();this._refreshButton.setEnabled(true);this._entriesForTest=entries;this._returnCount=returnCount;this._updateSummaryBar();const hasMore=(this._skipCount+this._pageSize)<returnCount;const oldEntries=new Map();const rootNode=this._dataGrid.rootNode();for(const node of rootNode.children)
oldEntries.set(node.data.url,node);rootNode.removeChildren();let selectedNode=null;for(let i=0;i<entries.length;++i){const entry=entries[i];let node=oldEntries.get(entry.requestURL);if(!node||node.data.responseTime!==entry.responseTime){node=new Resources.ServiceWorkerCacheView.DataGridNode(i+this._skipCount,this._createRequest(entry),entry.responseType);node.selectable=true;}else{node.data.number=i+this._skipCount;}
rootNode.appendChild(node);if(entry.requestURL===selected)
selectedNode=node;}
this._pageBackButton.setEnabled(!!skipCount);this._pageForwardButton.setEnabled(hasMore);if(!selectedNode)
this._showPreview(null);else
selectedNode.revealAndSelect();this._updatedForTest();}
_updateData(force){const pageSize=this._pageSize;let skipCount=this._skipCount;if(!force&&this._lastPageSize===pageSize&&this._lastSkipCount===skipCount)
return;this._refreshButton.setEnabled(false);if(this._lastPageSize!==pageSize){skipCount=0;this._skipCount=0;}
this._lastPageSize=pageSize;this._lastSkipCount=skipCount;return new Promise(resolve=>{this._model.loadCacheData(this._cache,skipCount,pageSize,this._entryPathFilter,(entries,returnCount)=>{this._updateDataCallback(skipCount,entries,returnCount);resolve();});});}
_refreshButtonClicked(event){this._updateData(true);}
_cacheContentUpdated(event){const nameAndOrigin=event.data;if(this._cache.securityOrigin!==nameAndOrigin.origin||this._cache.cacheName!==nameAndOrigin.cacheName)
return;this._refreshThrottler.schedule(()=>Promise.resolve(this._updateData(true)),true);}
async _previewCachedResponse(request){let preview=request[Resources.ServiceWorkerCacheView._previewSymbol];if(!preview){preview=new Resources.ServiceWorkerCacheView.RequestView(request);request[Resources.ServiceWorkerCacheView._previewSymbol]=preview;}
if(request===this._dataGrid.selectedNode.data)
this._showPreview(preview);}
_createRequest(entry){const request=new SDK.NetworkRequest('cache-storage-'+entry.requestURL,entry.requestURL,'','','',null);request.requestMethod=entry.requestMethod;request.setRequestHeaders(entry.requestHeaders);request.statusCode=entry.responseStatus;request.statusText=entry.responseStatusText;request.protocol=new Common.ParsedURL(entry.requestURL).scheme;request.responseHeaders=entry.responseHeaders;request.setRequestHeadersText('');request.endTime=entry.responseTime;let header=entry.responseHeaders.find(header=>header.name.toLowerCase()==='content-type');const contentType=header?header.value:'text/plain';request.mimeType=contentType;header=entry.responseHeaders.find(header=>header.name.toLowerCase()==='content-length');request.resourceSize=(header&&header.value)|0;let resourceType=Common.ResourceType.fromMimeType(contentType);if(!resourceType)
resourceType=Common.ResourceType.fromURL(entry.requestURL)||Common.resourceTypes.Other;request.setResourceType(resourceType);request.setContentDataProvider(this._requestContent.bind(this,request));return request;}
async _requestContent(request){const isText=request.resourceType().isTextType();const contentData={error:null,content:null,encoded:!isText};const response=await this._cache.requestCachedResponse(request.url(),request.requestHeaders());if(response)
contentData.content=isText?window.atob(response.body):response.body;return contentData;}
_updatedForTest(){}};Resources.ServiceWorkerCacheView._previewSymbol=Symbol('preview');Resources.ServiceWorkerCacheView._RESPONSE_CACHE_SIZE=10;Resources.ServiceWorkerCacheView.DataGridNode=class extends DataGrid.DataGridNode{constructor(number,request,responseType){super(request);this._number=number;const parsed=new Common.ParsedURL(request.url());if(parsed.isValid)
this._name=request.url().trimURL(parsed.domain());else
this._name=request.url();this._request=request;this._responseType=responseType;}
createCell(columnId){const cell=this.createTD(columnId);let value;if(columnId==='number'){value=String(this._number);}else if(columnId==='name'){value=this._name;}else if(columnId==='responseType'){if(this._responseType==='opaqueResponse')
value='opaque';else if(this._responseType==='opaqueRedirect')
value='opaqueredirect';else
value=this._responseType;}else if(columnId==='contentType'){value=this._request.mimeType;}else if(columnId==='contentLength'){value=(this._request.resourceSize|0).toLocaleString('en-US');}else if(columnId==='responseTime'){value=new Date(this._request.endTime*1000).toLocaleString();}
DataGrid.DataGrid.setElementText(cell,value||'',true);cell.title=this._request.url();return cell;}};Resources.ServiceWorkerCacheView.RequestView=class extends UI.VBox{constructor(request){super();this._tabbedPane=new UI.TabbedPane();this._tabbedPane.addEventListener(UI.TabbedPane.Events.TabSelected,this._tabSelected,this);this._resourceViewTabSetting=Common.settings.createSetting('cacheStorageViewTab','preview');this._tabbedPane.appendTab('headers',Common.UIString('Headers'),new Network.RequestHeadersView(request));this._tabbedPane.appendTab('preview',Common.UIString('Preview'),new Network.RequestPreviewView(request));this._tabbedPane.show(this.element);}
wasShown(){super.wasShown();this._selectTab();}
_selectTab(tabId){if(!tabId)
tabId=this._resourceViewTabSetting.get();if(!this._tabbedPane.selectTab(tabId))
this._tabbedPane.selectTab('headers');}
_tabSelected(event){if(!event.data.isUserGesture)
return;this._resourceViewTabSetting.set(event.data.tabId);}};;Resources.ServiceWorkersView=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('resources/serviceWorkersView.css');this._currentWorkersView=new UI.ReportView(Common.UIString('Service Workers'));this._currentWorkersView.setBodyScrollable(false);this.contentElement.classList.add('service-worker-list');this._currentWorkersView.show(this.contentElement);this._currentWorkersView.element.classList.add('service-workers-this-origin');this._toolbar=this._currentWorkersView.createToolbar();this._toolbar.makeWrappable(true);this._sections=new Map();this._registrationSymbol=Symbol('Resources.ServiceWorkersView');this._manager=null;this._securityOriginManager=null;this._filterThrottler=new Common.Throttler(300);this._otherWorkers=this.contentElement.createChild('div','service-workers-other-origin');this._otherSWFilter=this._otherWorkers.createChild('div','service-worker-filter');this._otherSWFilter.setAttribute('tabindex',0);this._otherSWFilter.setAttribute('role','switch');this._otherSWFilter.setAttribute('aria-checked',false);this._otherSWFilter.addEventListener('keydown',event=>{if(event.target!==this._otherSWFilter)
return;if(isEnterKey(event)||event.key===' ')
this._toggleFilter();});const filterLabel=this._otherSWFilter.createChild('label','service-worker-filter-label');filterLabel.textContent=Common.UIString('Service workers from other origins');filterLabel.addEventListener('click',()=>this._toggleFilter());const toolbar=new UI.Toolbar('service-worker-filter-toolbar',this._otherSWFilter);this._filter=new UI.ToolbarInput(ls`Filter service worker`,1);this._filter.addEventListener(UI.ToolbarInput.Event.TextChanged,()=>this._filterChanged());toolbar.appendToolbarItem(this._filter);this._otherWorkersView=new UI.ReportView();this._otherWorkersView.setBodyScrollable(false);this._otherWorkersView.show(this._otherWorkers);this._otherWorkersView.element.classList.add('service-workers-for-other-origins');this._updateCollapsedStyle();this._toolbar.appendToolbarItem(MobileThrottling.throttlingManager().createOfflineToolbarCheckbox());const updateOnReloadSetting=Common.settings.createSetting('serviceWorkerUpdateOnReload',false);updateOnReloadSetting.setTitle(Common.UIString('Update on reload'));const forceUpdate=new UI.ToolbarSettingCheckbox(updateOnReloadSetting,ls`On page reload, force the service worker to update, and activate it`);this._toolbar.appendToolbarItem(forceUpdate);const bypassServiceWorkerSetting=Common.settings.createSetting('bypassServiceWorker',false);bypassServiceWorkerSetting.setTitle(Common.UIString('Bypass for network'));const fallbackToNetwork=new UI.ToolbarSettingCheckbox(bypassServiceWorkerSetting,ls`Bypass the service worker and load resources from the network`);this._toolbar.appendToolbarItem(fallbackToNetwork);this._eventListeners=new Map();SDK.targetManager.observeModels(SDK.ServiceWorkerManager,this);this._updateListVisibility();}
modelAdded(serviceWorkerManager){if(this._manager)
return;this._manager=serviceWorkerManager;this._securityOriginManager=serviceWorkerManager.target().model(SDK.SecurityOriginManager);for(const registration of this._manager.registrations().values())
this._updateRegistration(registration);this._eventListeners.set(serviceWorkerManager,[this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this._registrationUpdated,this),this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationDeleted,this._registrationDeleted,this),this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginAdded,this._updateSectionVisibility,this),this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,this._updateSectionVisibility,this),]);}
modelRemoved(serviceWorkerManager){if(!this._manager||this._manager!==serviceWorkerManager)
return;Common.EventTarget.removeEventListeners(this._eventListeners.get(serviceWorkerManager));this._eventListeners.delete(serviceWorkerManager);this._manager=null;this._securityOriginManager=null;}
_getTimeStamp(registration){const versions=registration.versionsByMode();let timestamp=0;const active=versions.get(SDK.ServiceWorkerVersion.Modes.Active);const installing=versions.get(SDK.ServiceWorkerVersion.Modes.Installing);const waiting=versions.get(SDK.ServiceWorkerVersion.Modes.Waiting);const redundant=versions.get(SDK.ServiceWorkerVersion.Modes.Redundant);if(active)
timestamp=active.scriptResponseTime;else if(waiting)
timestamp=waiting.scriptResponseTime;else if(installing)
timestamp=installing.scriptResponseTime;else if(redundant)
timestamp=redundant.scriptResponseTime;return timestamp;}
_updateSectionVisibility(){let hasOthers=false;let hasThis=false;const movedSections=[];for(const section of this._sections.values()){const expectedView=this._getReportViewForOrigin(section._registration.securityOrigin);hasOthers|=expectedView===this._otherWorkersView;hasThis|=expectedView===this._currentWorkersView;if(section._section.parentWidget()!==expectedView)
movedSections.push(section);}
for(const section of movedSections){const registration=section._registration;this._removeRegistrationFromList(registration);this._updateRegistration(registration,true);}
this._currentWorkersView.sortSections((a,b)=>{const aTimestamp=this._getTimeStamp(a[this._registrationSymbol]);const bTimestamp=this._getTimeStamp(b[this._registrationSymbol]);return bTimestamp-aTimestamp;});const scorer=new Sources.FilePathScoreFunction(this._filter.value());this._otherWorkersView.sortSections((a,b)=>{const cmp=scorer.score(b.title(),null)-scorer.score(a.title(),null);return cmp===0?a.title().localeCompare(b.title()):cmp;});for(const section of this._sections.values()){if(section._section.parentWidget()===this._currentWorkersView||this._isRegistrationVisible(section._registration))
section._section.showWidget();else
section._section.hideWidget();}
this.contentElement.classList.toggle('service-worker-has-current',hasThis);this._otherWorkers.classList.toggle('hidden',!hasOthers);this._updateListVisibility();}
_registrationUpdated(event){const registration=(event.data);this._updateRegistration(registration);this._gcRegistrations();}
_gcRegistrations(){let hasNonDeletedRegistrations=false;const securityOrigins=new Set(this._securityOriginManager.securityOrigins());for(const registration of this._manager.registrations().values()){if(!securityOrigins.has(registration.securityOrigin)&&!this._isRegistrationVisible(registration))
continue;if(!registration.canBeRemoved()){hasNonDeletedRegistrations=true;break;}}
if(!hasNonDeletedRegistrations)
return;for(const registration of this._manager.registrations().values()){const visible=securityOrigins.has(registration.securityOrigin)||this._isRegistrationVisible(registration);if(!visible&&registration.canBeRemoved())
this._removeRegistrationFromList(registration);}}
_getReportViewForOrigin(origin){if(this._securityOriginManager.securityOrigins().includes(origin)||this._securityOriginManager.unreachableMainSecurityOrigin()===origin)
return this._currentWorkersView;else
return this._otherWorkersView;}
_updateRegistration(registration,skipUpdate){let section=this._sections.get(registration);if(!section){const title=registration.scopeURL;const uiSection=this._getReportViewForOrigin(registration.securityOrigin).appendSection(title);uiSection[this._registrationSymbol]=registration;section=new Resources.ServiceWorkersView.Section((this._manager),uiSection,registration);this._sections.set(registration,section);}
if(skipUpdate)
return;this._updateSectionVisibility();section._scheduleUpdate();}
_registrationDeleted(event){const registration=(event.data);this._removeRegistrationFromList(registration);}
_removeRegistrationFromList(registration){const section=this._sections.get(registration);if(section)
section._section.detach();this._sections.delete(registration);this._updateSectionVisibility();}
_isRegistrationVisible(registration){const filterString=this._filter.value();if(!filterString||!registration.scopeURL)
return true;const regex=String.filterRegex(filterString);return registration.scopeURL.match(regex);}
_filterChanged(){this._updateCollapsedStyle();this._filterThrottler.schedule(()=>Promise.resolve(this._updateSectionVisibility()));}
_updateCollapsedStyle(){const expanded=this._otherSWFilter.getAttribute('aria-checked')==='true';this._otherWorkers.classList.toggle('service-worker-filter-collapsed',!expanded);if(expanded)
this._otherWorkersView.showWidget();else
this._otherWorkersView.hideWidget();this._otherWorkersView.setHeaderVisible(false);}
_updateListVisibility(){this.contentElement.classList.toggle('service-worker-list-empty',this._sections.size===0);}
_toggleFilter(){const expanded=this._otherSWFilter.getAttribute('aria-checked')==='true';this._otherSWFilter.setAttribute('aria-checked',!expanded);this._filterChanged();}};Resources.ServiceWorkersView.Section=class{constructor(manager,section,registration){this._manager=manager;this._section=section;this._registration=registration;this._fingerprint=null;this._pushNotificationDataSetting=Common.settings.createLocalSetting('pushData',Common.UIString('Test push message from DevTools.'));this._syncTagNameSetting=Common.settings.createLocalSetting('syncTagName','test-tag-from-devtools');this._toolbar=section.createToolbar();this._toolbar.renderAsLinks();this._updateButton=new UI.ToolbarButton(Common.UIString('Update'),undefined,Common.UIString('Update'));this._updateButton.addEventListener(UI.ToolbarButton.Events.Click,this._updateButtonClicked,this);this._toolbar.appendToolbarItem(this._updateButton);this._deleteButton=new UI.ToolbarButton(Common.UIString('Unregister service worker'),undefined,Common.UIString('Unregister'));this._deleteButton.addEventListener(UI.ToolbarButton.Events.Click,this._unregisterButtonClicked,this);this._toolbar.appendToolbarItem(this._deleteButton);this._sourceField=this._wrapWidget(this._section.appendField(Common.UIString('Source')));this._statusField=this._wrapWidget(this._section.appendField(Common.UIString('Status')));this._clientsField=this._wrapWidget(this._section.appendField(Common.UIString('Clients')));this._createSyncNotificationField(Common.UIString('Push'),this._pushNotificationDataSetting.get(),Common.UIString('Push data'),this._push.bind(this));this._createSyncNotificationField(Common.UIString('Sync'),this._syncTagNameSetting.get(),Common.UIString('Sync tag'),this._sync.bind(this));this._linkifier=new Components.Linkifier();this._clientInfoCache=new Map();this._throttler=new Common.Throttler(500);}
_createSyncNotificationField(label,initialValue,placeholder,callback){const form=this._wrapWidget(this._section.appendField(label)).createChild('form','service-worker-editor-with-button');const editor=form.createChild('input','source-code service-worker-notification-editor');const button=UI.createTextButton(label);button.type='submit';form.appendChild(button);editor.value=initialValue;editor.placeholder=placeholder;UI.ARIAUtils.setAccessibleName(editor,label);form.addEventListener('submit',e=>{callback(editor.value||'');e.consume(true);});}
_scheduleUpdate(){if(Resources.ServiceWorkersView._noThrottle){this._update();return;}
this._throttler.schedule(this._update.bind(this));}
_targetForVersionId(versionId){const version=this._manager.findVersion(versionId);if(!version||!version.targetId)
return null;return SDK.targetManager.targetById(version.targetId);}
_addVersion(versionsStack,icon,label){const installingEntry=versionsStack.createChild('div','service-worker-version');installingEntry.createChild('div',icon);installingEntry.createChild('span').textContent=label;return installingEntry;}
_updateClientsField(version){this._clientsField.removeChildren();this._section.setFieldVisible(Common.UIString('Clients'),version.controlledClients.length);for(const client of version.controlledClients){const clientLabelText=this._clientsField.createChild('div','service-worker-client');if(this._clientInfoCache.has(client)){this._updateClientInfo(clientLabelText,(this._clientInfoCache.get(client)));}
this._manager.target().targetAgent().getTargetInfo(client).then(this._onClientInfo.bind(this,clientLabelText));}}
_updateSourceField(version){this._sourceField.removeChildren();const fileName=Common.ParsedURL.extractName(version.scriptURL);const name=this._sourceField.createChild('div','report-field-value-filename');const link=Components.Linkifier.linkifyURL(version.scriptURL,{text:fileName});link.tabIndex=0;name.appendChild(link);if(this._registration.errors.length){const errorsLabel=UI.createIconLabel(String(this._registration.errors.length),'smallicon-error');errorsLabel.classList.add('link');errorsLabel.tabIndex=0;UI.ARIAUtils.setAccessibleName(errorsLabel,ls`${this._registration.errors.length} registration errors`);errorsLabel.addEventListener('click',()=>Common.console.show());errorsLabel.addEventListener('keydown',event=>{if(isEnterKey(event)||event.key===' ')
Common.console.show();});name.appendChild(errorsLabel);}
this._sourceField.createChild('div','report-field-value-subtitle').textContent=Common.UIString('Received %s',new Date(version.scriptResponseTime*1000).toLocaleString());}
_update(){const fingerprint=this._registration.fingerprint();if(fingerprint===this._fingerprint)
return Promise.resolve();this._fingerprint=fingerprint;this._toolbar.setEnabled(!this._registration.isDeleted);const versions=this._registration.versionsByMode();const scopeURL=this._registration.scopeURL;const title=this._registration.isDeleted?Common.UIString('%s - deleted',scopeURL):scopeURL;this._section.setTitle(title);const active=versions.get(SDK.ServiceWorkerVersion.Modes.Active);const waiting=versions.get(SDK.ServiceWorkerVersion.Modes.Waiting);const installing=versions.get(SDK.ServiceWorkerVersion.Modes.Installing);const redundant=versions.get(SDK.ServiceWorkerVersion.Modes.Redundant);this._statusField.removeChildren();const versionsStack=this._statusField.createChild('div','service-worker-version-stack');versionsStack.createChild('div','service-worker-version-stack-bar');if(active){this._updateSourceField(active);const activeEntry=this._addVersion(versionsStack,'service-worker-active-circle',Common.UIString('#%s activated and is %s',active.id,active.runningStatus));if(active.isRunning()||active.isStarting()){this._createLink(activeEntry,Common.UIString('stop'),this._stopButtonClicked.bind(this,active.id));if(!this._targetForVersionId(active.id))
this._createLink(activeEntry,Common.UIString('inspect'),this._inspectButtonClicked.bind(this,active.id));}else if(active.isStartable()){this._createLink(activeEntry,Common.UIString('start'),this._startButtonClicked.bind(this));}
this._updateClientsField(active);}else if(redundant){this._updateSourceField(redundant);this._addVersion(versionsStack,'service-worker-redundant-circle',Common.UIString('#%s is redundant',redundant.id));this._updateClientsField(redundant);}
if(waiting){const waitingEntry=this._addVersion(versionsStack,'service-worker-waiting-circle',Common.UIString('#%s waiting to activate',waiting.id));this._createLink(waitingEntry,Common.UIString('skipWaiting'),this._skipButtonClicked.bind(this));waitingEntry.createChild('div','service-worker-subtitle').textContent=Common.UIString('Received %s',new Date(waiting.scriptResponseTime*1000).toLocaleString());if(!this._targetForVersionId(waiting.id)&&(waiting.isRunning()||waiting.isStarting()))
this._createLink(waitingEntry,Common.UIString('inspect'),this._inspectButtonClicked.bind(this,waiting.id));}
if(installing){const installingEntry=this._addVersion(versionsStack,'service-worker-installing-circle',Common.UIString('#%s trying to install',installing.id));installingEntry.createChild('div','service-worker-subtitle').textContent=Common.UIString('Received %s',new Date(installing.scriptResponseTime*1000).toLocaleString());if(!this._targetForVersionId(installing.id)&&(installing.isRunning()||installing.isStarting())){this._createLink(installingEntry,Common.UIString('inspect'),this._inspectButtonClicked.bind(this,installing.id));}}
return Promise.resolve();}
_createLink(parent,title,listener,className,useCapture){const button=parent.createChild('button',className);button.classList.add('link');button.textContent=title;button.tabIndex=0;button.addEventListener('click',listener,useCapture);return button;}
_unregisterButtonClicked(event){this._manager.deleteRegistration(this._registration.id);}
_updateButtonClicked(event){this._manager.updateRegistration(this._registration.id);}
_push(data){this._pushNotificationDataSetting.set(data);this._manager.deliverPushMessage(this._registration.id,data);}
_sync(tag){this._syncTagNameSetting.set(tag);this._manager.dispatchSyncEvent(this._registration.id,tag,true);}
_onClientInfo(element,targetInfo){if(!targetInfo)
return;this._clientInfoCache.set(targetInfo.targetId,targetInfo);this._updateClientInfo(element,targetInfo);}
_updateClientInfo(element,targetInfo){if(targetInfo.type!=='page'&&targetInfo.type==='iframe'){const clientString=element.createChild('span','service-worker-client-string');clientString.createTextChild(ls`Worker: ${targetInfo.url}`);return;}
element.removeChildren();const clientString=element.createChild('span','service-worker-client-string');clientString.createTextChild(targetInfo.url);this._createLink(element,ls`focus`,this._activateTarget.bind(this,targetInfo.targetId),'service-worker-client-focus-link');}
_activateTarget(targetId){this._manager.target().targetAgent().activateTarget(targetId);}
_startButtonClicked(){this._manager.startWorker(this._registration.scopeURL);}
_skipButtonClicked(){this._manager.skipWaiting(this._registration.scopeURL);}
_stopButtonClicked(versionId){this._manager.stopWorker(versionId);}
_inspectButtonClicked(versionId){this._manager.inspectWorker(versionId);}
_wrapWidget(container){const shadowRoot=UI.createShadowRootWithCoreStyles(container);UI.appendStyle(shadowRoot,'resources/serviceWorkersView.css');const contentElement=createElement('div');shadowRoot.appendChild(contentElement);return contentElement;}};;Runtime.cachedResources["resources/appManifestView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n/*# sourceURL=resources/appManifestView.css */";Runtime.cachedResources["resources/backgroundServiceView.css"]=".background-service-toolbar {\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n}\n\n.data-grid {\n    flex: auto;\n    border: none;\n}\n\n.background-service-preview {\n    position: absolute;\n    background-color: white;\n    justify-content: center;\n    align-items: center;\n    overflow: auto;\n    font-size: 13px;\n    color: #777;\n}\n\n.background-service-preview > div {\n    max-width: 450px;\n    margin: 10px;\n}\n\n.background-service-preview > div > p {\n    flex: none;\n    white-space: pre-line;\n    text-align: center;\n}\n\n.background-service-shortcut {\n    color: hsla(0, 0%, 50%, 1);\n}\n\n.background-service-metadata {\n    padding-left: 5px;\n    padding-top: 10px;\n}\n\n.background-service-metadata-entry {\n    padding-left: 10px;\n    padding-bottom: 5px;\n}\n\n.background-service-metadata-name {\n    color: rgb(33%, 33%, 33%);\n    display: inline-block;\n    margin-right: 0.25em;\n    font-weight: bold;\n}\n\n.background-service-metadata-value {\n    display: inline;\n    margin-right: 1em;\n    white-space: pre-wrap;\n    word-break: break-all;\n    user-select: text;\n}\n\n.background-service-empty-value {\n    color: #888;\n    font-style: italic;\n}\n\n/*# sourceURL=resources/backgroundServiceView.css */";Runtime.cachedResources["resources/clearStorageView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.report-row {\n    display: flex;\n    align-items: center;\n}\n\n.clear-storage-button .report-row {\n    margin: 0 0 0 17px;\n    display: flex;\n}\n\n.link {\n    margin-left: 10px;\n    display: none;\n}\n\n.report-row:hover .link {\n    display: inline;\n}\n\n.usage-breakdown-row {\n    min-width: fit-content;\n}\n\n/*# sourceURL=resources/clearStorageView.css */";Runtime.cachedResources["resources/indexedDBViews.css"]="/*\n * Copyright (C) 2012 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.indexed-db-data-view .data-view-toolbar {\n    position: relative;\n    background-color: #eee;\n    border-bottom: 1px solid #ccc;\n}\n\n.indexed-db-data-view .data-grid {\n    flex: auto;\n}\n\n.indexed-db-data-view .data-grid .data-container tr:nth-last-child(1) {\n    background-color: white;\n}\n\n.indexed-db-data-view .data-grid .data-container tr:nth-last-child(1) td {\n    border: 0;\n}\n\n.indexed-db-data-view .data-grid .data-container tr:nth-last-child(2) td {\n    border-bottom: 1px solid #aaa;\n}\n\n.indexed-db-data-view .data-grid:focus .data-container tr.selected {\n    background-color: #cdddf5;\n    color: inherit;\n}\n\n.indexed-db-data-view .section,\n.indexed-db-data-view .section > .header,\n.indexed-db-data-view .section > .header .title {\n    margin: 0;\n    min-height: inherit;\n    line-height: inherit;\n}\n\n.indexed-db-data-view .data-grid .data-container td .section .header .title {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.indexed-db-key-path {\n    color: rgb(196, 26, 22);\n    white-space: pre-wrap;\n    unicode-bidi: -webkit-isolate;\n}\n\n.source-code.indexed-db-key-path {\n    font-size: unset !important;\n}\n\n.resources-toolbar {\n    padding-right: 10px;\n}\n\n.object-store-summary-bar {\n    flex: 0 0 27px;\n    line-height: 27px;\n    padding-left: 5px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n/*# sourceURL=resources/indexedDBViews.css */";Runtime.cachedResources["resources/resourcesPanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.resources-toolbar {\n    border-top: 1px solid #ccc;\n    background-color: var(--toolbar-bg-color);\n}\n\n.top-resources-toolbar {\n    border-bottom: 1px solid #ccc;\n    background-color: var(--toolbar-bg-color);\n}\n\n.resources.panel .status {\n    float: right;\n    height: 16px;\n    margin-top: 1px;\n    margin-left: 4px;\n    line-height: 1em;\n}\n\n.storage-view {\n    display: flex;\n    overflow: hidden;\n}\n\n.storage-view {\n    overflow: hidden;\n}\n\n.storage-view .data-grid:not(.inline) {\n    border: none;\n    flex: auto;\n}\n\n.storage-view .storage-table-error {\n    color: rgb(66%, 33%, 33%);\n    font-size: 24px;\n    font-weight: bold;\n    padding: 10px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.storage-view.query {\n    padding: 2px 0;\n    overflow-y: overlay;\n    overflow-x: hidden;\n}\n\n.storage-view .filter-bar {\n    border-top: none;\n    border-bottom: var(--divider-border);\n}\n\n.database-query-prompt-container {\n    position: relative;\n    padding: 1px 22px 1px 24px;\n}\n\n.database-query-prompt {\n    min-height: 16px;\n    white-space: pre-wrap;\n}\n\n.prompt-icon {\n    position: absolute;\n    display: block;\n    left: 7px;\n    top: 9px;\n    margin-top: -7px;\n    -webkit-user-select: none;\n}\n\n.database-query-prompt-container .prompt-icon {\n    top: 10px;\n}\n\n.database-user-query {\n    position: relative;\n    border-bottom: 1px solid rgb(245, 245, 245);\n    padding: 1px 22px 1px 24px;\n    min-height: 16px;\n    flex-shrink: 0;\n}\n\n.database-query-text {\n    color: rgb(0, 128, 255);\n    -webkit-user-select: text;\n}\n\n.database-query-result {\n    position: relative;\n    padding: 1px 22px 1px 24px;\n    min-height: 16px;\n    margin-left: -24px;\n    padding-right: 0;\n}\n\n.database-query-result.error {\n    color: red;\n    -webkit-user-select: text;\n}\n\n.resources-sidebar {\n    padding: 0;\n}\n\n/*# sourceURL=resources/resourcesPanel.css */";Runtime.cachedResources["resources/resourcesSidebar.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding-left: 0;\n    color: rgb(90, 90, 90);\n}\n\n.tree-outline > ol {\n    padding-bottom: 10px;\n}\n\n.tree-outline li {\n    min-height: 20px;\n}\n\nli.storage-group-list-item {\n    padding: 10px 8px 6px 8px;\n}\n\nli.storage-group-list-item:not(:first-child) {\n    border-top: 1px solid rgb(230, 230, 230);\n}\n\nli.storage-group-list-item::before {\n    display: none;\n}\n\n.navigator-tree-item {\n    margin: -3px -7px -3px -7px;\n}\n\n.navigator-file-tree-item {\n    background: linear-gradient(45deg, hsl(0, 0%, 50%), hsl(0, 0%, 70%));\n}\n\n.navigator-folder-tree-item {\n    background: linear-gradient(45deg, hsl(210, 82%, 65%), hsl(210, 82%, 80%));\n}\n\n.navigator-frame-tree-item {\n    background-color: #5a5a5a;\n}\n\n.navigator-script-tree-item {\n    background: linear-gradient(45deg, hsl(48, 70%, 50%), hsl(48, 70%, 70%));\n}\n\n.navigator-stylesheet-tree-item {\n    background: linear-gradient(45deg, hsl(256, 50%, 50%), hsl(256, 50%, 70%));\n}\n\n.navigator-image-tree-item,\n.navigator-font-tree-item {\n    background: linear-gradient(45deg, hsl(109, 33%, 50%), hsl(109, 33%, 70%));\n}\n\n.resource-tree-item {\n    background: rgba(90, 90, 90, .7);\n}\n\n/*# sourceURL=resources/resourcesSidebar.css */";Runtime.cachedResources["resources/serviceWorkerCacheViews.css"]="/*\n * Copyright 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.service-worker-cache-data-view .data-view-toolbar {\n    position: relative;\n    background-color: #eee;\n    border-bottom: 1px solid #ccc;\n    padding-right: 10px;\n}\n\n.service-worker-cache-data-view .data-grid {\n    flex: auto;\n}\n\n.service-worker-cache-data-view .data-grid .data-container tr:nth-last-child(1) td {\n    border: 0;\n}\n\n.service-worker-cache-data-view .data-grid .data-container tr:nth-last-child(2) td {\n    border-bottom: 1px solid #aaa;\n}\n\n.service-worker-cache-data-view .data-grid .data-container tr.selected {\n    background-color: rgb(212, 212, 212);\n    color: inherit;\n}\n\n.service-worker-cache-data-view .data-grid:focus .data-container tr.selected {\n    background-color: var(--selection-bg-color);\n    color: white;\n}\n\n.service-worker-cache-data-view .section,\n.service-worker-cache-data-view .section > .header,\n.service-worker-cache-data-view .section > .header .title {\n    margin: 0;\n    min-height: inherit;\n    line-height: inherit;\n}\n\n.service-worker-cache-data-view .data-grid .data-container td .section .header .title {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.cache-preview-panel-resizer {\n    background-color: #eee;\n    height: 4px;\n    border-bottom: 1px solid rgb(64%, 64%, 64%);\n}\n\n.cache-storage-summary-bar {\n    flex: 0 0 27px;\n    line-height: 27px;\n    padding-left: 5px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n/*# sourceURL=resources/serviceWorkerCacheViews.css */";Runtime.cachedResources["resources/serviceWorkersView.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.service-worker-version-stack {\n    position: relative;\n}\n\n.service-worker-version-stack-bar {\n    position: absolute;\n    top: 10px;\n    bottom: 20px;\n    left: 4px;\n    content: \"\";\n    border-left: 1px solid #888;\n    z-index: 0;\n}\n\n.service-worker-version:not(:last-child) {\n    margin-bottom: 7px;\n}\n\n.service-worker-active-circle,\n.service-worker-redundant-circle,\n.service-worker-waiting-circle,\n.service-worker-installing-circle {\n    position: relative;\n    display: inline-block;\n    width: 10px;\n    height: 10px;\n    z-index: 10;\n    margin-right: 5px;\n    border-radius: 50%;\n    border: 1px solid #555;\n}\n\n.service-worker-active-circle {\n    background-color: #50B04F;\n}\n.service-worker-waiting-circle {\n    background-color: #F38E24;\n\n}\n.service-worker-installing-circle {\n    background-color: white;\n}\n\n.service-worker-redundant-circle {\n    background-color: gray;\n}\n\n.service-worker-subtitle {\n    padding-left: 14px;\n    line-height: 14px;\n    color: #888;\n}\n\n.link {\n    margin-left: 7px;\n}\n\n.service-worker-editor-with-button {\n    align-items: baseline;\n    display: flex;\n}\n\n.service-worker-notification-editor {\n    border: solid 1px #d8d8d8;\n    display: flex;\n    flex: auto;\n    margin-right: 4px;\n    max-width: 400px;\n    min-width: 80px;\n}\n\n.report-field-value-filename,\n.service-worker-client-string {\n    max-width: 400px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.service-worker-client {\n    display: flex;\n}\n\n.service-worker-client-focus-link {\n    flex: none;\n    margin-right: 2px;\n    align-self: center;\n}\n\n.service-worker-notification-editor.source-code {\n    /** Simulate CodeMirror that is shown above */\n    padding: 4px;\n}\n\n.service-worker-list {\n    background-color: #f9f9f9;\n    overflow: auto;\n}\n\n.service-workers-this-origin {\n    flex-shrink: 0;\n    flex-grow: 0;\n}\n\n.service-worker-has-current .service-workers-other-origin {\n    margin-top: 16px;\n    border-top: 1px solid rgb(230, 230, 230)\n}\n\n.service-worker-list-empty .service-workers-other-origin {\n    display: none;\n}\n\n.service-workers-this-origin,\n.service-worker-filter,\n.service-workers-other-origin {\n    min-width: 400px;\n}\n\n.service-worker-filter {\n    padding: 16px 20px 12px 12px;\n    flex-grow: 0;\n    flex-shrink: 0;\n    background-color: white;\n    border-bottom: solid 1px rgb(230, 230, 230);\n}\n\n.service-worker-filter-label {\n    cursor: pointer;\n    margin-left: 4px;\n}\n\n.service-worker-filter[data-keyboard-focus=\"true\"]:focus {\n    background-color: var(--toolbar-bg-color);\n}\n\n.service-worker-filter-label::before {\n    -webkit-user-select: none;\n    -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n    -webkit-mask-size: 32px 24px;\n    content: '';\n    color: transparent;\n    background-color: rgb(110, 110, 110);\n    text-shadow: none;\n    height: 12px;\n    width: 10px;\n    display: inline-block;\n}\n\n.service-worker-filter[aria-checked=\"true\"] .service-worker-filter-label::before {\n    -webkit-mask-position: -16px 0;\n}\n\n.service-worker-filter-toolbar {\n    margin: 8px 10px 0 12px;\n    max-width: 530px;\n}\n\n.service-worker-filter-collapsed .service-worker-filter-toolbar {\n    display: none;\n}\n\n/*# sourceURL=resources/serviceWorkersView.css */";