/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xbaseinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.Messages;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInput;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBaseInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String dbfFileName;
    private int rowLimit;
    private boolean rowNrAdded;
    private String rowNrField;
    private boolean acceptingFilenames;
    private String acceptingField;
    private String acceptingStepName;
    private StepMeta acceptingStep;
    private boolean includeFilename;
    private String filenameField;
    private String charactersetName;

    public String getDbfFileName() {
        return this.dbfFileName;
    }

    public void setDbfFileName(String dbfFileName) {
        this.dbfFileName = dbfFileName;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNrField() {
        return this.rowNrField;
    }

    public void setRowNrField(String rowNrField) {
        this.rowNrField = rowNrField;
    }

    public boolean isRowNrAdded() {
        return this.rowNrAdded;
    }

    public void setRowNrAdded(boolean rowNrAdded) {
        this.rowNrAdded = rowNrAdded;
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean acceptingFilenames) {
        this.acceptingFilenames = acceptingFilenames;
    }

    public StepMeta getAcceptingStep() {
        return this.acceptingStep;
    }

    public void setAcceptingStep(StepMeta acceptingStep) {
        this.acceptingStep = acceptingStep;
    }

    public String getAcceptingStepName() {
        return this.acceptingStepName;
    }

    public void setAcceptingStepName(String acceptingStepName) {
        this.acceptingStepName = acceptingStepName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        XBaseInputMeta retval = (XBaseInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.dbfFileName = XMLHandler.getTagValue((Node)stepnode, (String)"file_dbf");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (int)0);
            this.rowNrAdded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"add_rownr"));
            this.rowNrField = XMLHandler.getTagValue((Node)stepnode, (String)"field_rownr");
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.charactersetName = XMLHandler.getTagValue((Node)stepnode, (String)"charset_name");
            this.acceptingFilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"accept_filenames"));
            this.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            this.acceptingStepName = XMLHandler.getTagValue((Node)stepnode, (String)"accept_stepname");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("XBaseInputMeta.Exception.UnableToReadStepInformationFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.dbfFileName = null;
        this.rowLimit = 0;
        this.rowNrAdded = false;
        this.rowNrField = null;
    }

    public String getLookupStepname() {
        if (this.acceptingFilenames && this.acceptingStep != null && !Const.isEmpty((String)this.acceptingStep.getName())) {
            return this.acceptingStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.acceptingStep = StepMeta.findStep(steps, this.acceptingStepName);
    }

    @Override
    public String[] getInfoSteps() {
        if (this.acceptingFilenames && this.acceptingStep != null) {
            return new String[]{this.acceptingStep.getName()};
        }
        return super.getInfoSteps();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowMetaInterface getOutputFields(FileInputList files, String name) throws KettleStepException {
        RowMeta rowMeta = new RowMeta();
        XBase xbi = null;
        try {
            try {
                xbi = new XBase(KettleVFS.getInputStream((FileObject)files.getFile(0)));
                xbi.setDbfFile(files.getFile(0).getName().getURI());
                xbi.open();
                RowMetaInterface add = xbi.getFields();
                for (int i = 0; i < add.size(); ++i) {
                    ValueMetaInterface v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                rowMeta.addRowMeta(add);
            }
            catch (Exception ke) {
                throw new KettleStepException(Messages.getString("XBaseInputMeta.Exception.UnableToReadMetaDataFromXBaseFile"), (Throwable)ke);
            }
            Object var9_9 = null;
            if (xbi != null) {
                xbi.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (xbi != null) {
                xbi.close();
            }
            throw throwable;
        }
        if (this.rowNrAdded && this.rowNrField != null && this.rowNrField.length() > 0) {
            ValueMeta rnr = new ValueMeta(this.rowNrField, 5);
            rnr.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)rnr);
        }
        if (this.includeFilename) {
            ValueMeta v = new ValueMeta(this.filenameField, 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
        return rowMeta;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        FileInputList fileList = this.getTextFileList(space);
        if (fileList.nrOfFiles() == 0) {
            throw new KettleStepException(Messages.getString("XBaseInputMeta.Exception.NoFilesFoundToProcess"));
        }
        row.addRowMeta(this.getOutputFields(fileList, name));
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"file_dbf", (String)this.dbfFileName));
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"add_rownr", (boolean)this.rowNrAdded));
        retval.append("    " + XMLHandler.addTagValue((String)"field_rownr", (String)this.rowNrField));
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"charset_name", (String)this.charactersetName));
        retval.append("    " + XMLHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    " + XMLHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        retval.append("    " + XMLHandler.addTagValue((String)"accept_stepname", (String)(this.acceptingStep != null ? this.acceptingStep.getName() : "")));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.dbfFileName = rep.getStepAttributeString(id_step, "file_dbf");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.rowNrAdded = rep.getStepAttributeBoolean(id_step, "add_rownr");
            this.rowNrField = rep.getStepAttributeString(id_step, "field_rownr");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.charactersetName = rep.getStepAttributeString(id_step, "charset_name");
            this.acceptingFilenames = rep.getStepAttributeBoolean(id_step, "accept_filenames");
            this.acceptingField = rep.getStepAttributeString(id_step, "accept_field");
            this.acceptingStepName = rep.getStepAttributeString(id_step, "accept_stepname");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("XBaseInputMeta.Exception.UnexpectedErrorReadingMetaDataFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "file_dbf", this.dbfFileName);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "add_rownr", this.rowNrAdded);
            rep.saveStepAttribute(id_transformation, id_step, "field_rownr", this.rowNrField);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "charset_name", this.charactersetName);
            rep.saveStepAttribute(id_transformation, id_step, "accept_filenames", this.acceptingFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.acceptingField);
            rep.saveStepAttribute(id_transformation, id_step, "accept_stepname", this.acceptingStep != null ? this.acceptingStep.getName() : "");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("XBaseInputMeta.Exception.UnableToSaveMetaDataToRepository") + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.dbfFileName == null) {
            CheckResult cr;
            if (!this.isAcceptingFilenames()) {
                CheckResult cr2 = new CheckResult(4, Messages.getString("XBaseInputMeta.Remark.PleaseSelectFileToUse"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr2);
                return;
            }
            if (Const.isEmpty((String)this.getAcceptingStepName())) {
                cr = new CheckResult(4, Messages.getString("XBaseInput.Log.Error.InvalidAcceptingStepName"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (!Const.isEmpty((String)this.getAcceptingField())) return;
            cr = new CheckResult(4, Messages.getString("XBaseInput.Log.Error.InvalidAcceptingFieldName"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        CheckResult cr = new CheckResult(1, Messages.getString("XBaseInputMeta.Remark.FileToUseIsSpecified"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        XBase xbi = new XBase(transMeta.environmentSubstitute(this.dbfFileName));
        try {
            try {
                xbi.open();
                cr = new CheckResult(1, Messages.getString("XBaseInputMeta.Remark.FileExistsAndCanBeOpened"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                RowMetaInterface r = xbi.getFields();
                cr = new CheckResult(1, r.size() + Messages.getString("XBaseInputMeta.Remark.OutputFieldsCouldBeDetermined"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException ke) {
                cr = new CheckResult(4, Messages.getString("XBaseInputMeta.Remark.NoFieldsCouldBeFoundInFileBecauseOfError") + Const.CR + ke.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                Object var12_15 = null;
                xbi.close();
                return;
            }
            Object var12_14 = null;
            xbi.close();
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            xbi.close();
            throw throwable;
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new XBaseInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XBaseInputData();
    }

    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])new String[]{this.dbfFileName}, (String[])new String[]{null}, (String[])new String[]{"N"});
    }

    public FileInputList getTextFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])new String[]{this.dbfFileName}, (String[])new String[]{null}, (String[])new String[]{"N"});
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"javadbf.jar"};
    }

    public String getCharactersetName() {
        return this.charactersetName;
    }

    public void setCharactersetName(String charactersetName) {
        this.charactersetName = charactersetName;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (!this.acceptingFilenames && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.dbfFileName))).exists()) {
                this.dbfFileName = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.dbfFileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

