/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JClass;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.JumpPosition;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLinkGenerator
implements LinkGenerator,
HyperlinkListener {
    private static final Logger LOG = LoggerFactory.getLogger(CodeLinkGenerator.class);
    private final ContentPanel contentPanel;
    private final CodeArea codeArea;
    private final JClass jCls;

    public CodeLinkGenerator(ContentPanel contentPanel, CodeArea codeArea, JClass cls) {
        this.contentPanel = contentPanel;
        this.codeArea = codeArea;
        this.jCls = cls;
    }

    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offset) {
        try {
            char ch;
            int sourceOffset;
            Token token = textArea.modelToToken(offset);
            if (token == null) {
                return null;
            }
            int type = token.getType();
            if (type == 20) {
                sourceOffset = token.getOffset();
            } else if (type == 19 && token.length() > 1) {
                sourceOffset = token.getOffset() + 1;
            } else {
                return null;
            }
            if (token.length() == 1 && ((ch = token.getTextArray()[token.getTextOffset()]) == '.' || ch == ',' || ch == ';')) {
                return null;
            }
            final JumpPosition defPos = this.codeArea.getDefPosForNodeAtOffset(this.jCls, sourceOffset);
            if (defPos == null) {
                return null;
            }
            if (Objects.equals(defPos.getNode().getRootClass(), this.jCls) && defPos.getLine() == textArea.getLineOfOffset(sourceOffset) + 1) {
                return null;
            }
            return new LinkGeneratorResult(){

                public HyperlinkEvent execute() {
                    return new HyperlinkEvent(defPos, HyperlinkEvent.EventType.ACTIVATED, null, defPos.getNode().makeLongString());
                }

                public int getSourceOffset() {
                    return sourceOffset;
                }
            };
        }
        catch (Exception e) {
            LOG.error("isLinkAtOffset error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JumpPosition) {
            this.contentPanel.getTabbedPane().codeJump((JumpPosition)obj);
        }
    }
}

