/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileWithId;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class CompactVirtualFileSet
extends AbstractSet<VirtualFile> {
    private final Set<VirtualFile> weirdFiles;
    private TIntHashSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    public CompactVirtualFileSet() {
        this.weirdFiles = new THashSet();
    }

    public CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new THashSet();
        this.addAll(files2);
    }

    @Override
    public boolean contains(Object file2) {
        if (file2 instanceof VirtualFileWithId) {
            BitSet ids = this.fileIds;
            int id = ((VirtualFileWithId)file2).getId();
            if (ids != null) {
                return ids.get(id);
            }
            TIntHashSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id);
            }
        }
        return this.weirdFiles.contains(file2);
    }

    @Override
    public boolean add(@NotNull VirtualFile file2) {
        boolean added;
        if (file2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file2 instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)((Object)file2)).getId();
            BitSet ids = this.fileIds;
            TIntHashSet idSet = this.idSet;
            if (ids != null) {
                added = !ids.get(id);
                ids.set(id);
            } else if (idSet != null) {
                added = idSet.add(id);
                if (idSet.size() > 1000) {
                    this.fileIds = new BitSet();
                    idSet.forEach(i -> {
                        this.fileIds.set(i);
                        return true;
                    });
                    this.idSet = null;
                }
            } else {
                added = this.weirdFiles.add(file2);
                if (this.weirdFiles.size() > 10) {
                    this.idSet = idSet = new TIntHashSet(this.weirdFiles.size());
                    Iterator<VirtualFile> iterator2 = this.weirdFiles.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile wf = iterator2.next();
                        if (!(wf instanceof VirtualFileWithId)) continue;
                        int i2 = ((VirtualFileWithId)((Object)wf)).getId();
                        idSet.add(i2);
                        iterator2.remove();
                    }
                }
            }
        } else {
            added = this.weirdFiles.add(file2);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public int size() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        return (ids == null ? 0 : ids.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator idsIterator = ids == null ? Collections.emptyIterator() : ContainerUtil.mapIterator(ids.stream().iterator(), (? super T id) -> virtualFileManager.findFileById((int)id));
        Iterator idSetIterator = idSet == null ? Collections.emptyIterator() : CompactVirtualFileSet.mapIterator(idSet.iterator(), id -> virtualFileManager.findFileById(id));
        Iterator<VirtualFile> weirdFileIterator = this.weirdFiles.iterator();
        Iterator<VirtualFile> iterator2 = ContainerUtil.filterIterator(ContainerUtil.concatIterators(idsIterator, idSetIterator, weirdFileIterator), Objects::nonNull);
        if (iterator2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    @NotNull
    @Contract(pure=true)
    public static <U> Iterator<U> mapIterator(final @NotNull TIntIterator iterator2, final @NotNull IntFunction<? extends U> mapper) {
        if (iterator2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(4);
        }
        if (mapper == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(5);
        }
        Iterator iterator3 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
        if (iterator3 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(6);
        }
        return iterator3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

