/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIr;
import org.jetbrains.kotlin.backend.common.serialization.KotlinMangler;
import org.jetbrains.kotlin.backend.common.serialization.UniqId;
import org.jetbrains.kotlin.backend.common.serialization.UniqIdKt;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0017J\r\u0010\u001d\u001a\u00020\u001e*\u00020\u0017H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u0006*\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u0013*\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorReferenceSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinMangler;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "serializeString", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIr$String;", "mangler", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/backend/common/serialization/KotlinMangler;)V", "getDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "getSerializeString", "()Lkotlin/jvm/functions/Function1;", "functionName", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFunctionName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/String;", "hashMangle", "", "getHashMangle", "(Ljava/lang/String;)J", "hashedMangle", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getHashedMangle", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)J", "serializeDescriptorReference", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIr$DescriptorReference;", "declaration", "isExported", "", "ir.serialization.common"})
public class DescriptorReferenceSerializer
implements KotlinMangler {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final Function1<String, KotlinIr.String> serializeString;
    private final /* synthetic */ KotlinMangler $$delegate_0;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final KotlinIr.DescriptorReference serializeDescriptorReference(@NotNull IrDeclaration declaration2) {
        void packageFqName;
        UniqId uniqId;
        UniqId uniqId2;
        IrDeclaration it;
        boolean bl;
        boolean bl2;
        IrDeclaration irDeclaration;
        IrDeclaration discoverableDescriptorsDeclaration;
        IrDeclaration irDeclaration2;
        IrDeclaration realDeclaration;
        IrDeclaration irDeclaration3;
        boolean isTypeParameter;
        Pair pair;
        DeclarationDescriptor containingDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        DeclarationDescriptor descriptor2 = declaration2.getDescriptor();
        if (!this.isExported(declaration2)) {
            IrDeclaration irDeclaration4 = declaration2;
            if (!(irDeclaration4 instanceof IrDeclarationWithVisibility)) {
                irDeclaration4 = null;
            }
            IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)irDeclaration4;
            if (!Intrinsics.areEqual((Object)(irDeclarationWithVisibility != null ? irDeclarationWithVisibility.getVisibility() : null), (Object)Visibilities.INVISIBLE_FAKE)) {
                return null;
            }
        }
        if (declaration2 instanceof IrAnonymousInitializer) {
            return null;
        }
        if (descriptor2 instanceof ParameterDescriptor) return null;
        if (descriptor2 instanceof VariableDescriptor) {
            if (!(descriptor2 instanceof PropertyDescriptor)) return null;
        }
        if (declaration2 instanceof IrTypeParameter && !(declaration2.getParent() instanceof IrClass)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration = declarationDescriptor;
        if (declarationDescriptor2 instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)containingDeclaration);
            if (classId == null) return null;
            ClassId classId2 = classId;
            pair = new Pair((Object)classId2.getPackageFqName().toString(), (Object)classId2.getRelativeClassName().toString());
        } else {
            if (!(declarationDescriptor2 instanceof PackageFragmentDescriptor)) return null;
            pair = new Pair((Object)((PackageFragmentDescriptor)containingDeclaration).getFqName().toString(), (Object)"");
        }
        Pair pair2 = pair;
        String string = (String)pair2.component1();
        String classFqName = (String)pair2.component2();
        boolean isAccessor = AdditionalIrUtilsKt.isAccessor(declaration2);
        boolean isBackingField = declaration2 instanceof IrField && ((IrField)declaration2).getCorrespondingProperty() != null;
        boolean isFakeOverride = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
        boolean isDefaultConstructor = descriptor2 instanceof ClassConstructorDescriptor && containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.OBJECT;
        boolean isEnumEntry = descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY;
        boolean isEnumSpecial = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE);
        boolean bl3 = isTypeParameter = declaration2 instanceof IrTypeParameter && declaration2.getParent() instanceof IrClass;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.ENUM_ENTRY && !isFakeOverride) {
            return null;
        }
        if (isFakeOverride) {
            IrElement irElement;
            IrDeclaration irDeclaration5 = declaration2;
            if (irDeclaration5 instanceof IrSimpleFunction) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrSimpleFunction)declaration2);
            } else if (irDeclaration5 instanceof IrField) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrField)declaration2);
            } else {
                if (!(irDeclaration5 instanceof IrProperty)) {
                    String string2 = "Unexpected fake override declaration";
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrProperty)declaration2);
            }
            irDeclaration3 = (IrDeclaration)irElement;
        } else {
            irDeclaration3 = realDeclaration = declaration2;
        }
        if (isAccessor) {
            IrDeclaration irDeclaration6 = realDeclaration;
            if (irDeclaration6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrProperty irProperty = ((IrSimpleFunction)irDeclaration6).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = irProperty;
        } else if (isBackingField) {
            IrDeclaration irDeclaration7 = realDeclaration;
            if (irDeclaration7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrField");
            }
            IrProperty irProperty = ((IrField)irDeclaration7).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = irProperty;
        } else {
            irDeclaration2 = isDefaultConstructor || isEnumEntry ? null : realDeclaration;
        }
        IrDeclaration irDeclaration8 = discoverableDescriptorsDeclaration = irDeclaration2;
        if (irDeclaration8 != null) {
            irDeclaration = irDeclaration8;
            bl2 = false;
            bl = false;
            it = irDeclaration;
            boolean bl5 = false;
            uniqId2 = this.declarationTable.uniqIdByDeclaration(it);
        } else {
            uniqId2 = null;
        }
        UniqId uniqId3 = uniqId = uniqId2;
        if (uniqId3 != null) {
            irDeclaration = uniqId3;
            bl2 = false;
            bl = false;
            it = irDeclaration;
            boolean bl6 = false;
            this.declarationTable.getDescriptors().put(discoverableDescriptorsDeclaration.getDescriptor(), (UniqId)((Object)it));
        }
        KotlinIr.DescriptorReference.Builder builder = KotlinIr.DescriptorReference.newBuilder();
        void v17 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"packageFqName");
        KotlinIr.DescriptorReference.Builder builder2 = builder.setPackageFqName((KotlinIr.String)this.serializeString.invoke((Object)v17));
        String string3 = classFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"classFqName");
        KotlinIr.DescriptorReference.Builder builder3 = builder2.setClassFqName((KotlinIr.String)this.serializeString.invoke((Object)string3));
        String string4 = descriptor2.getName().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"descriptor.name.toString()");
        KotlinIr.DescriptorReference.Builder proto = builder3.setName((KotlinIr.String)this.serializeString.invoke((Object)string4));
        if (uniqId != null) {
            proto.setUniqId(UniqIdKt.protoUniqId(uniqId));
        }
        if (isFakeOverride) {
            proto.setIsFakeOverride(true);
        }
        if (isBackingField) {
            proto.setIsBackingField(true);
        }
        if (isAccessor) {
            if (AdditionalIrUtilsKt.isGetter(declaration2)) {
                proto.setIsGetter(true);
                return proto.build();
            }
            if (AdditionalIrUtilsKt.isSetter(declaration2)) {
                proto.setIsSetter(true);
                return proto.build();
            }
            String string5 = "A property accessor which is neither a getter, nor a setter: " + descriptor2;
            bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        if (isDefaultConstructor) {
            proto.setIsDefaultConstructor(true);
            return proto.build();
        }
        if (isEnumEntry) {
            proto.setIsEnumEntry(true);
            return proto.build();
        }
        if (isEnumSpecial) {
            proto.setIsEnumSpecial(true);
            return proto.build();
        }
        if (!isTypeParameter) return proto.build();
        proto.setIsTypeParameter(true);
        return proto.build();
    }

    @NotNull
    public final DeclarationTable getDeclarationTable() {
        return this.declarationTable;
    }

    @NotNull
    public final Function1<String, KotlinIr.String> getSerializeString() {
        return this.serializeString;
    }

    public DescriptorReferenceSerializer(@NotNull DeclarationTable declarationTable, @NotNull Function1<? super String, KotlinIr.String> serializeString, @NotNull KotlinMangler mangler) {
        Intrinsics.checkParameterIsNotNull((Object)declarationTable, (String)"declarationTable");
        Intrinsics.checkParameterIsNotNull(serializeString, (String)"serializeString");
        Intrinsics.checkParameterIsNotNull((Object)mangler, (String)"mangler");
        this.$$delegate_0 = mangler;
        this.declarationTable = declarationTable;
        this.serializeString = serializeString;
    }

    @Override
    @NotNull
    public String getFunctionName(@NotNull IrFunction $this$functionName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$functionName, (String)"$this$functionName");
        return this.$$delegate_0.getFunctionName($this$functionName);
    }

    @Override
    public long getHashMangle(@NotNull String $this$hashMangle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hashMangle, (String)"$this$hashMangle");
        return this.$$delegate_0.getHashMangle($this$hashMangle);
    }

    @Override
    public long getHashedMangle(@NotNull IrDeclaration $this$hashedMangle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hashedMangle, (String)"$this$hashedMangle");
        return this.$$delegate_0.getHashedMangle($this$hashedMangle);
    }

    @Override
    public boolean isExported(@NotNull IrDeclaration $this$isExported) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isExported, (String)"$this$isExported");
        return this.$$delegate_0.isExported($this$isExported);
    }
}

