(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/pipe#pipe__%
    (lambda (_direction143743_ _closeonexec143744_)
      (if (memq _direction143743_ '(in out inout none))
          '#!void
          (error '"Invalid argument; direction must be one of in, out, inout, none"))
      (let* ((_ptr143749_
              (let ((_r143746_ (std/os/pipe#make_pipe_ptr)))
                (if _r143746_
                    _r143746_
                    (error '"Error allocating memory" 'make_pipe_ptr))))
             (_g143786_
              (let ((_r143751_ (std/os/pipe#_pipe _ptr143749_)))
                (if (not (##fxnegative? _r143751_))
                    _r143751_
                    (std/os/error#raise-os-error
                     (##fx- _r143751_)
                     std/os/pipe#pipe))))
             (_ifd143755_ (std/os/pipe#pipe_ptr_ref _ptr143749_ '0))
             (_ofd143757_ (std/os/pipe#pipe_ptr_ref _ptr143749_ '1))
             (_set-nonblock143759_
              (if _closeonexec143744_
                  std/os/fcntl#fd-set-nonblock/closeonexec
                  std/os/fcntl#fd-set-nonblock)))
        (let ((_$e143762_ _direction143743_))
          (if (eq? 'in _$e143762_)
              (let ((_iraw143765_ (std/os/fd#fdopen _ifd143755_ 'in 'pipe)))
                (_set-nonblock143759_ _iraw143765_)
                (values _iraw143765_ _ofd143757_))
              (if (eq? 'out _$e143762_)
                  (let ((_oraw143767_
                         (std/os/fd#fdopen _ofd143757_ 'out 'pipe)))
                    (_set-nonblock143759_ _oraw143767_)
                    (values _ifd143755_ _oraw143767_))
                  (if (eq? 'inout _$e143762_)
                      (let ((_iraw143769_
                             (std/os/fd#fdopen _ifd143755_ 'in 'pipe))
                            (_oraw143770_
                             (std/os/fd#fdopen _ofd143757_ 'out 'pipe)))
                        (_set-nonblock143759_ _iraw143769_)
                        (_set-nonblock143759_ _oraw143770_)
                        (values _iraw143769_ _oraw143770_))
                      (if (eq? 'none _$e143762_)
                          (values _ifd143755_ _ofd143757_)
                          '#!void))))))))
  (define std/os/pipe#pipe__0
    (lambda ()
      (let* ((_direction143776_ 'inout) (_closeonexec143778_ '#t))
        (std/os/pipe#pipe__% _direction143776_ _closeonexec143778_))))
  (define std/os/pipe#pipe__1
    (lambda (_direction143780_)
      (let ((_closeonexec143782_ '#t))
        (std/os/pipe#pipe__% _direction143780_ _closeonexec143782_))))
  (define std/os/pipe#pipe
    (lambda _g143788_
      (let ((_g143787_ (length _g143788_)))
        (cond ((##fx= _g143787_ 0) (apply std/os/pipe#pipe__0 _g143788_))
              ((##fx= _g143787_ 1) (apply std/os/pipe#pipe__1 _g143788_))
              ((##fx= _g143787_ 2) (apply std/os/pipe#pipe__% _g143788_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/pipe#pipe
                _g143788_))))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/os/pipe#" _pipe make_pipe_ptr pipe_ptr_ref))
  (c-declare "#include <errno.h>")
  (c-declare "#include <unistd.h>")
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args))) (if (##fx< r 0) (##fx- (__errno)) r))))
  (namespace ("std/os/pipe#" __pipe __errno))
  (c-define-type pipe* (pointer int (pipe*) "ffi_free"))
  (define-c-lambda __errno () int "___return (errno);")
  (define-c-lambda __pipe (pipe*) int "pipe")
  (define-with-errno _pipe __pipe (pipe-ptr))
  (define-c-lambda
   make_pipe_ptr
   ()
   pipe*
   "___return ((int*)malloc (2 * sizeof (int)));")
  (define-c-lambda
   pipe_ptr_ref
   (pipe* int)
   int
   "___return (___arg1[___arg2]);")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
