/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RepositoriesMetaData
extends AbstractNamedDiffable<MetaData.Custom>
implements MetaData.Custom {
    public static final String TYPE = "repositories";
    private final List<RepositoryMetaData> repositories;

    public RepositoriesMetaData(List<RepositoryMetaData> repositories) {
        this.repositories = Collections.unmodifiableList(repositories);
    }

    public List<RepositoryMetaData> repositories() {
        return this.repositories;
    }

    public RepositoryMetaData repository(String name) {
        for (RepositoryMetaData repository : this.repositories) {
            if (!name.equals(repository.name())) continue;
            return repository;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoriesMetaData that = (RepositoriesMetaData)o;
        return this.repositories.equals(that.repositories);
    }

    public int hashCode() {
        return this.repositories.hashCode();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public RepositoriesMetaData(StreamInput in) throws IOException {
        RepositoryMetaData[] repository = new RepositoryMetaData[in.readVInt()];
        for (int i = 0; i < repository.length; ++i) {
            repository[i] = new RepositoryMetaData(in);
        }
        this.repositories = Collections.unmodifiableList(Arrays.asList(repository));
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoriesMetaData.readDiffFrom(MetaData.Custom.class, TYPE, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.repositories.size());
        for (RepositoryMetaData repository : this.repositories) {
            repository.writeTo(out);
        }
    }

    public static RepositoriesMetaData fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<RepositoryMetaData> repository = new ArrayList<RepositoryMetaData>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String name = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("failed to parse repository [{}], expected object", name);
                }
                String type = null;
                Settings settings = Settings.EMPTY;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        if ("type".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            type = parser.text();
                            continue;
                        }
                        if ("settings".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], incompatible params", name);
                            }
                            settings = Settings.fromXContent(parser);
                            continue;
                        }
                        throw new ElasticsearchParseException("failed to parse repository [{}], unknown field [{}]", name, currentFieldName);
                    }
                    throw new ElasticsearchParseException("failed to parse repository [{}]", name);
                }
                if (type == null) {
                    throw new ElasticsearchParseException("failed to parse repository [{}], missing repository type", name);
                }
                repository.add(new RepositoryMetaData(name, type, settings));
                continue;
            }
            throw new ElasticsearchParseException("failed to parse repositories", new Object[0]);
        }
        return new RepositoriesMetaData(repository);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (RepositoryMetaData repository : this.repositories) {
            RepositoriesMetaData.toXContent(repository, builder, params);
        }
        return builder;
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.API_AND_GATEWAY;
    }

    public static void toXContent(RepositoryMetaData repository, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(repository.name());
        builder.field("type", repository.type());
        builder.startObject("settings");
        repository.settings().toXContent(builder, params);
        builder.endObject();
        builder.endObject();
    }
}

