# object.omit [![NPM version](https://badge.fury.io/js/object.omit.svg)](http://badge.fury.io/js/object.omit)

> Return a copy of an object without the given key, or array of keys.

## Install
```bash
npm i object.omit --save-dev
```


## Usage

```js
var omit = require('object.omit');
```

Pass a string `key` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, 'a')
//=> { b: 'b', c: 'c' }
```

Pass an array of `keys` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c'])
//=> { b: 'b' }
```

Returns the object if no keys are passed:

```js
omit({a: 'a', b: 'b', c: 'c'})
//=> {a: 'a', b: 'b', c: 'c'}
```

Returns an empty object if no value is passed.

```js
omit()
//=> {}
```

### Other awesome javascript/node.js utils
 * [object.filter](https://github.com/jonschlinkert/object.filter): Create a new object filtered to have only properties for which the callback returns true.
 * [object.pick](https://github.com/jonschlinkert/object.pick): Returns a filtered copy of an object with only the specified keys, like `pick` from lo-dash / underscore.
 * [object.pluck](https://github.com/jonschlinkert/object.pluck): Like pluck from underscore / lo-dash, but returns an object composed of specified properties, with values unmodified from those of the original object.
 * [object.reduce](https://github.com/jonschlinkert/object.reduce): Reduces an object to a value that is the accumulated result of running each property in the object through a callback.
 * [object.defaults](https://github.com/jonschlinkert/object.defaults): Like `extend` but only copies missing properties/values to the target object.

## Runing tests
Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/object.omit/issues)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014-2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on April 09, 2015._
