#include "IoState.h"
#include "IoObject.h"

IoObject *IoGLScissor_proto(void *state);
IoObject *IoGLU_proto(void *state);
IoObject *IoGLUQuadric_proto(void *state);
IoObject *IoGLUT_proto(void *state);
IoObject *IoOpenGL_proto(void *state);
void IoBox_glInit(void *context);
void IoVector_glInit(void *context);

void IoOpenGLInit(IoObject *context)
{
	IoState *self = IoObject_state((IoObject *)context);

	IoObject_setSlot_to_(context, SIOSYMBOL("GLScissor"), IoGLScissor_proto(self));

	IoObject_setSlot_to_(context, SIOSYMBOL("GLU"), IoGLU_proto(self));

	IoObject_setSlot_to_(context, SIOSYMBOL("GLUQuadric"), IoGLUQuadric_proto(self));

	IoObject_setSlot_to_(context, SIOSYMBOL("GLUT"), IoGLUT_proto(self));

	IoObject_setSlot_to_(context, SIOSYMBOL("OpenGL"), IoOpenGL_proto(self));

	IoBox_glInit(context);
	IoVector_glInit(context);
}
