/*
 * Decompiled with CFR 0.152.
 */
package org.freixas.jcalendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import org.freixas.jcalendar.DateEvent;
import org.freixas.jcalendar.DateListener;
import org.freixas.jcalendar.JCalendar$1;
import org.freixas.jcalendar.JCalendar$2;
import org.freixas.jcalendar.JCalendar$3;
import org.freixas.jcalendar.JCalendar$4;
import org.freixas.jcalendar.JCalendar$5;
import org.freixas.jcalendar.JCalendar$6;
import org.freixas.jcalendar.JCalendar$ButtonAction;
import org.freixas.jcalendar.JCalendar$DayListener;
import org.freixas.jcalendar.JCalendar$TimeListener;
import org.freixas.jcalendar.JCalendarCombo;
import z.gic;

public class JCalendar
extends JPanel {
    public static final int DISPLAY_DATE = 1;
    public static final int DISPLAY_TIME = 2;
    private static final int MONTH_DECR_BUTTON = 0;
    private static final int MONTH_INCR_BUTTON = 1;
    private static final int YEAR_DECR_BUTTON = 2;
    private static final int YEAR_INCR_BUTTON = 3;
    private int selectedComponents;
    private Calendar selectedCalendar;
    private int selectedYear = -1;
    private int selectedMonth = -1;
    private int selectedDay = -1;
    private int selectedHour = -1;
    private int selectedMinute = -1;
    private int selectedSecond = -1;
    private Calendar displayCalendar;
    private int displayYear;
    private int displayMonth;
    private Locale locale;
    private boolean isTodayDisplayed = false;
    private boolean isNullAllowed = true;
    private boolean isNullDate = true;
    private String timePattern;
    private JButton yearDecrButton;
    private JButton monthDecrButton;
    private JLabel monthYearLabel;
    private JButton monthIncrButton;
    private JButton yearIncrButton;
    private JLabel[] dayOfWeekLabels;
    private JToggleButton[][] dayButtons;
    private JToggleButton offScreenButton;
    private ButtonGroup dayGroup;
    private SpinnerDateModel spinnerDateModel;
    private JSpinner spinner;
    private JLabel todaysLabel;
    private Font titleFont;
    private Font dayOfWeekFont;
    private Font dayFont;
    private Font timeFont;
    private Font todayFont;
    private DateFormat formatMonth;
    private DateFormat formatWeekDay;
    private String lastMonth;
    private String lastYear;
    static InputMap inputMap = new InputMap();
    static ActionMap actionMap = new ActionMap();
    private static Action yearBackward = new JCalendar$1("yearBackward");
    private static Action yearForward = new JCalendar$2("yearForward");
    private static Action monthBackward = new JCalendar$3("montBackward");
    private static Action monthForward = new JCalendar$4("monthForward");
    private static Action setNullDate = new JCalendar$5("setNullDate");
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.freixas.jcalendar.Bundle");
    private JCalendarCombo comboCalendar;

    public JCalendar() {
        this(Calendar.getInstance(), Locale.getDefault(), 1, false, null);
    }

    public JCalendar(int n2, boolean bl2) {
        this(Calendar.getInstance(), Locale.getDefault(), n2, bl2, null);
    }

    public JCalendar(Calendar calendar, Locale locale, int n2, boolean bl2) {
        this(calendar, locale, n2, bl2, null);
    }

    public JCalendar(Calendar calendar, Locale locale, int n2, boolean bl2, String string) {
        this.selectedCalendar = (Calendar)calendar.clone();
        this.displayCalendar = (Calendar)this.selectedCalendar.clone();
        this.selectedComponents = n2;
        if ((n2 & 3) == 0) {
            throw new IllegalStateException(bundle.getString("IllegalStateException"));
        }
        this.locale = locale;
        this.isTodayDisplayed = bl2;
        if ((n2 & 2) > 0) {
            if (string == null) {
                DateFormat dateFormat = DateFormat.getTimeInstance(2, locale);
                this.timePattern = "HH:mm:ss";
                if (dateFormat instanceof SimpleDateFormat) {
                    this.timePattern = ((SimpleDateFormat)dateFormat).toPattern();
                }
            } else {
                this.timePattern = string;
            }
        }
        this.createCalendarComponents();
        this.setDate(new Date());
    }

    public void addDateListener(DateListener dateListener) {
        this.listenerList.add(DateListener.class, dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.listenerList.remove(DateListener.class, dateListener);
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void setNullAllowed(boolean bl2) {
        this.isNullAllowed = bl2;
    }

    public Date getDate() {
        if (this.isNullDate) {
            return null;
        }
        return this.selectedCalendar.getTime();
    }

    public void setDate(Date date) {
        if (date == null) {
            if (!this.isNullAllowed) {
                return;
            }
            if (!this.isNullDate) {
                this.isNullDate = true;
                this.selectedYear = -1;
                this.selectedMonth = -1;
                this.selectedDay = -1;
                this.selectedCalendar.set(1, 9999);
                this.selectedCalendar.set(2, 9);
                this.selectedCalendar.set(5, 9);
                this.selectedCalendar.set(11, 0);
                this.selectedCalendar.set(12, 0);
                this.selectedCalendar.set(13, 0);
                this.updateCalendarComponents();
                this.fireDateChange();
            }
        } else {
            int n2 = this.selectedYear;
            int n3 = this.selectedMonth;
            int n4 = this.selectedDay;
            int n5 = this.selectedHour;
            int n6 = this.selectedMinute;
            int n7 = this.selectedSecond;
            this.selectedCalendar.setTime(date);
            this.selectedYear = this.selectedCalendar.get(1);
            this.selectedMonth = this.selectedCalendar.get(2);
            this.selectedDay = this.selectedCalendar.get(5);
            this.selectedHour = this.selectedCalendar.get(11);
            this.selectedMinute = this.selectedCalendar.get(12);
            this.selectedSecond = this.selectedCalendar.get(13);
            if ((this.selectedComponents & 1) > 0 && n4 != this.selectedDay || n3 != this.selectedMonth || n2 != this.selectedYear || (this.selectedComponents & 2) > 0 && n5 != this.selectedHour || n6 != this.selectedMinute || n7 != this.selectedSecond) {
                this.isNullDate = false;
                this.displayCalendar.setTime(date);
                this.updateCalendarComponents();
                this.fireDateChange();
            }
        }
    }

    public void setDisplayDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.displayCalendar.setTime(date);
        int n2 = this.displayCalendar.get(2);
        int n3 = this.displayCalendar.get(1);
        if (n2 != this.displayMonth || n3 != this.displayYear) {
            this.updateCalendarComponents();
        }
    }

    public String getTimePattern() {
        if ((this.selectedComponents & 2) != 0) {
            return this.timePattern;
        }
        return null;
    }

    public Calendar getCalendar() {
        return (Calendar)this.selectedCalendar.clone();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getSelectedComponents() {
        return this.selectedComponents;
    }

    public boolean isTodayDisplayed() {
        return this.isTodayDisplayed;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null && this.titleFont != null || !font.equals(this.titleFont)) {
            this.titleFont = font;
            if (this.isDisplayable()) {
                this.setupTitleFont();
            }
        }
    }

    public Font getDayOfWeekFont() {
        return this.dayOfWeekFont;
    }

    public void setDayOfWeekFont(Font font) {
        if (font == null && this.dayOfWeekFont != null || !font.equals(this.dayOfWeekFont)) {
            this.dayOfWeekFont = font;
            if (this.isDisplayable()) {
                this.setupDayOfWeekFonts();
            }
        }
    }

    public Font getDayFont() {
        return this.dayFont;
    }

    public void setDayFont(Font font) {
        if (font == null && this.dayFont != null || !font.equals(this.dayFont)) {
            this.dayFont = font;
            if (this.isDisplayable()) {
                this.setupDayFonts();
            }
        }
    }

    public Font getTimeFont() {
        return this.timeFont;
    }

    public void setTimeFont(Font font) {
        if (font == null && this.timeFont != null || !font.equals(this.timeFont)) {
            this.timeFont = font;
            if (this.isDisplayable()) {
                this.setupTimeFont();
            }
        }
    }

    public Font getTodayFont() {
        return this.todayFont;
    }

    public void setTodayFont(Font font) {
        if (font == null && this.todayFont != null || !font.equals(this.todayFont)) {
            this.todayFont = font;
            if (this.isDisplayable()) {
                this.setupTodayFont();
            }
        }
    }

    @Override
    public void setEnabled(boolean bl2) {
        if (bl2 != this.isEnabled()) {
            super.setEnabled(bl2);
            if ((this.selectedComponents & 1) > 0) {
                int n2;
                this.yearDecrButton.setEnabled(bl2);
                this.monthDecrButton.setEnabled(bl2);
                this.monthYearLabel.setEnabled(bl2);
                this.monthIncrButton.setEnabled(bl2);
                this.yearIncrButton.setEnabled(bl2);
                for (n2 = 0; n2 < 7; ++n2) {
                    this.dayOfWeekLabels[n2].setEnabled(bl2);
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    for (int i2 = 0; i2 < 7; ++i2) {
                        if (this.dayButtons[n2][i2].getText().length() <= 0) continue;
                        this.dayButtons[n2][i2].setEnabled(bl2);
                    }
                }
            }
            if ((this.selectedComponents & 2) > 0) {
                this.spinner.setEnabled(bl2);
            }
        }
    }

    @Override
    public void addNotify() {
        this.setupTitleFont();
        this.setupDayOfWeekFonts();
        this.setupDayFonts();
        this.setupTimeFont();
        this.setupTodayFont();
        super.addNotify();
    }

    @Override
    protected String paramString() {
        String string = (this.selectedComponents & 1) == 1 ? DateFormat.getDateInstance(0, this.locale).format(this.getDate()) : ((this.selectedComponents & 2) == 2 ? DateFormat.getTimeInstance(0, this.locale).format(this.getDate()) : DateFormat.getDateTimeInstance(0, 0, this.locale).format(this.getDate()));
        return super.paramString() + ",selectedDate=" + string;
    }

    JCalendarCombo getJCalendarComboParent() {
        return this.comboCalendar;
    }

    void setJCalendarComboParent(JCalendarCombo jCalendarCombo) {
        this.comboCalendar = jCalendarCombo;
    }

    void addSpinnerMaps(InputMap inputMap, ActionMap actionMap) {
        inputMap.setParent(this.spinner.getInputMap(1));
        this.spinner.setInputMap(1, inputMap);
        actionMap.setParent(this.spinner.getActionMap());
        this.spinner.setActionMap(actionMap);
    }

    protected void fireDateChange() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DateListener.class) continue;
            DateEvent dateEvent = this.isNullDate ? new DateEvent(this, null) : new DateEvent(this, this.selectedCalendar);
            ((DateListener)objectArray[i2 + 1]).dateChanged(dateEvent);
        }
    }

    protected void setupTitleFont() {
        if (this.monthYearLabel == null) {
            return;
        }
        if (this.titleFont != null) {
            this.monthYearLabel.setFont(this.titleFont);
        } else {
            Font font = UIManager.getFont("Label.font");
            this.monthYearLabel.setFont(font);
        }
    }

    protected void setupDayOfWeekFonts() {
        if (this.dayOfWeekLabels == null) {
            return;
        }
        Font font = this.dayOfWeekFont;
        if (font == null) {
            font = UIManager.getFont("Label.font");
            font = font.deriveFont((float)((double)font.getSize2D() * 9.0 / 11.0));
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            this.dayOfWeekLabels[i2].setFont(font);
        }
    }

    protected void setupDayFonts() {
        if (this.dayButtons == null) {
            return;
        }
        Font font = this.dayFont;
        if (font == null) {
            font = UIManager.getFont("Button.font");
            font = font.deriveFont((float)((double)font.getSize2D() * 9.0 / 11.0));
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < 7; ++i3) {
                this.dayButtons[i2][i3].setFont(font);
            }
        }
    }

    protected void setupTimeFont() {
        if (this.spinner == null) {
            return;
        }
        if (this.timeFont != null) {
            this.spinner.setFont(this.timeFont);
        } else {
            Font font = UIManager.getFont("Spinner.font");
            this.spinner.setFont(font);
        }
    }

    protected void setupTodayFont() {
        if (this.todaysLabel == null) {
            return;
        }
        if (this.todayFont != null) {
            this.todaysLabel.setFont(this.todayFont);
        } else {
            Font font = UIManager.getFont("Label.font");
            this.todaysLabel.setFont(font);
        }
    }

    private void createCalendarComponents() {
        JPanel jPanel;
        Serializable serializable;
        Object object;
        Object object2;
        BorderLayout borderLayout = new BorderLayout(2, 2);
        JPanel jPanel2 = this.createSubPanel(borderLayout);
        if ((this.selectedComponents & 1) > 0) {
            this.formatMonth = new SimpleDateFormat("MMM", this.locale);
            this.formatWeekDay = new SimpleDateFormat("EEE", this.locale);
            this.setInputMap(1, inputMap);
            this.setActionMap(actionMap);
            object2 = new JCalendar$ButtonAction(this, "YearDecrButton", "YearDecrButtonMnemonic", "YearDecrButtonAccelerator", "YearDecrButtonImage", "YearDecrButtonShort", "YearDecrButtonLong", 2);
            this.yearDecrButton = this.newButton((JCalendar$ButtonAction)object2);
            this.monthDecrButton = this.newButton(new JCalendar$ButtonAction(this, "MonthDecrButton", "MonthDecrButtonMnemonic", "MonthDecrButtonAccelerator", "MonthDecrButtonImage", "MonthDecrButtonShort", "MonthDecrButtonLong", 0));
            object = this.createSubPanel(new FlowLayout(0, 2, 0));
            ((Container)object).add(this.yearDecrButton);
            ((Container)object).add(this.monthDecrButton);
            this.monthYearLabel = new JLabel();
            this.monthYearLabel.setHorizontalAlignment(0);
            this.monthIncrButton = this.newButton(new JCalendar$ButtonAction(this, "MonthIncrButton", "MonthIncrButtonMnemonic", "MonthIncrButtonAccelerator", "MonthIncrButtonImage", "MonthIncrButtonShort", "MonthIncrButtonLong", 1));
            this.yearIncrButton = this.newButton(new JCalendar$ButtonAction(this, "YearIncrButton", "YearIncrButtonMnemonic", "YearIncrButtonAccelerator", "YearIncrButtonImage", "YearIncrButtonShort", "YearIncrButtonLong", 3));
            serializable = this.createSubPanel(new FlowLayout(0, 2, 0));
            ((Container)serializable).add(this.monthIncrButton);
            ((Container)serializable).add(this.yearIncrButton);
            jPanel = this.createSubPanel(new BorderLayout(2, 2));
            jPanel.add((Component)object, "West");
            jPanel.add(this.monthYearLabel);
            jPanel.add((Component)serializable, "East");
            JPanel jPanel3 = this.createSubPanel(new GridLayout(7, 7));
            int n2 = this.displayCalendar.getFirstDayOfWeek();
            Calendar calendar = Calendar.getInstance(this.locale);
            calendar.set(2000, 2, 15);
            while (calendar.get(7) != n2) {
                calendar.add(5, 1);
            }
            this.dayOfWeekLabels = new JLabel[7];
            for (int i2 = 0; i2 < 7; ++i2) {
                Date date = calendar.getTime();
                String string = this.formatWeekDay.format(date);
                this.dayOfWeekLabels[i2] = new JLabel(string);
                this.dayOfWeekLabels[i2].setHorizontalAlignment(0);
                jPanel3.add(this.dayOfWeekLabels[i2]);
                calendar.add(5, 1);
            }
            this.dayButtons = new JToggleButton[6][7];
            this.dayGroup = new ButtonGroup();
            JCalendar$DayListener jCalendar$DayListener = new JCalendar$DayListener(this, null);
            for (int i3 = 0; i3 < 6; ++i3) {
                for (int i4 = 0; i4 < 7; ++i4) {
                    this.dayButtons[i3][i4] = new JToggleButton();
                    this.dayButtons[i3][i4].setMargin(new Insets(1, 2, 1, 2));
                    gic.a((AbstractButton)this.dayButtons[i3][i4]);
                    this.dayButtons[i3][i4].addItemListener(jCalendar$DayListener);
                    jPanel3.add(this.dayButtons[i3][i4]);
                    this.dayGroup.add(this.dayButtons[i3][i4]);
                }
            }
            this.offScreenButton = new JToggleButton("X");
            this.dayGroup.add(this.offScreenButton);
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jPanel3);
        }
        if ((this.selectedComponents & 2) > 0) {
            this.spinnerDateModel = new SpinnerDateModel();
            this.spinnerDateModel.addChangeListener(new JCalendar$TimeListener(this, null));
            this.spinner = new JSpinner(this.spinnerDateModel);
            object2 = new JSpinner.DateEditor(this.spinner, this.timePattern);
            ((JSpinner.DefaultEditor)object2).getTextField().setEditable(false);
            ((JSpinner.DefaultEditor)object2).getTextField().setHorizontalAlignment(0);
            this.spinner.setEditor((JComponent)object2);
            object = new InputMap();
            ((InputMap)object).put(KeyStroke.getKeyStroke("BACK_SPACE"), "setNullDate");
            ((InputMap)object).put(KeyStroke.getKeyStroke("DELETE"), "setNullDate");
            ((InputMap)object).setParent(this.spinner.getInputMap(1));
            serializable = new ActionMap();
            ((ActionMap)serializable).put("setNullDate", new JCalendar$6(this, "setNullDate"));
            ((ActionMap)serializable).setParent(this.spinner.getActionMap());
            this.spinner.setInputMap(1, (InputMap)object);
            this.spinner.setActionMap((ActionMap)serializable);
            jPanel = this.createSubPanel(new FlowLayout(1, 2, 2));
            jPanel.add(this.spinner);
            jPanel2.add((Component)jPanel, "South");
        }
        this.setLayout(new BorderLayout(2, 2));
        this.add(jPanel2);
        if (this.isTodayDisplayed) {
            object2 = new Object[]{new Date()};
            object = MessageFormat.format(bundle.getString("Today"), (Object[])object2);
            this.todaysLabel = new JLabel((String)object);
            this.todaysLabel.setHorizontalAlignment(0);
            this.add((Component)this.todaysLabel, "South");
        }
    }

    private JPanel createSubPanel(LayoutManager layoutManager) {
        JPanel jPanel = new JPanel(layoutManager);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JButton newButton(JCalendar$ButtonAction jCalendar$ButtonAction) {
        JButton jButton = new JButton(jCalendar$ButtonAction);
        jButton.setMargin(new Insets(1, 2, 1, 2));
        jButton.setOpaque(false);
        gic.a((AbstractButton)jButton);
        return jButton;
    }

    private void updateCalendarComponents() {
        Object object;
        if ((this.selectedComponents & 1) > 0) {
            this.offScreenButton.setSelected(true);
            this.displayMonth = this.displayCalendar.get(2);
            this.displayYear = this.displayCalendar.get(1);
            object = this.formatMonth.format(this.displayCalendar.getTime());
            String string = Integer.toString(this.displayYear);
            Object object2 = new Object[]{object, string};
            this.monthYearLabel.setText(MessageFormat.format(bundle.getString("MonthYearTitle"), (Object[])object2));
            if (!((String)object).equals(this.lastMonth) || !string.equals(this.lastYear)) {
                int n2;
                int n3;
                object2 = (Calendar)this.displayCalendar.clone();
                ((Calendar)object2).set(5, 1);
                int n4 = ((Calendar)object2).get(7);
                int n5 = ((Calendar)object2).getFirstDayOfWeek();
                for (n3 = 0; n3 < 7 && (n2 = (n5 - 1 + n3) % 7 + 1) != n4; ++n3) {
                    this.dayButtons[0][n3].setText("");
                    this.dayButtons[0][n3].setEnabled(false);
                }
                n2 = ((Calendar)object2).getActualMaximum(5);
                int n6 = 0;
                for (int i2 = 1; i2 <= n2; ++i2) {
                    this.dayButtons[n6][n3].setText(Integer.toString(i2));
                    this.dayButtons[n6][n3].setEnabled(true);
                    if (i2 == this.selectedDay && this.displayMonth == this.selectedMonth && this.displayYear == this.selectedYear) {
                        this.dayButtons[n6][n3].setSelected(true);
                    } else {
                        this.dayButtons[n6][n3].getModel().setSelected(false);
                    }
                    n3 = (n3 + 1) % 7;
                    if (n3 != 0) continue;
                    ++n6;
                }
                while (n6 < 6) {
                    this.dayButtons[n6][n3].setText("");
                    this.dayButtons[n6][n3].setEnabled(false);
                    this.dayButtons[n6][n3].getModel().setSelected(false);
                    if ((n3 = (n3 + 1) % 7) != 0) continue;
                    ++n6;
                }
            }
        }
        if ((this.selectedComponents & 2) > 0) {
            if (this.isNullDate) {
                object = (Calendar)this.selectedCalendar.clone();
                ((Calendar)object).setTime(new Date());
                ((Calendar)object).set(10, 12);
                ((Calendar)object).set(12, 0);
                ((Calendar)object).set(13, 0);
                this.spinnerDateModel.setValue(((Calendar)object).getTime());
                this.spinner.setEnabled((this.selectedComponents & 1) == 0);
            } else {
                this.spinner.setEnabled(this.isEnabled());
                this.spinnerDateModel.setValue(this.selectedCalendar.getTime());
                this.spinnerDateModel.setStart(null);
                this.spinnerDateModel.setEnd(null);
                this.spinner.revalidate();
            }
        }
    }

    private void yearBackward() {
        this.displayCalendar.add(1, -1);
        this.updateCalendarComponents();
    }

    private void yearForward() {
        this.displayCalendar.add(1, 1);
        this.updateCalendarComponents();
    }

    private void monthBackward() {
        this.displayCalendar.add(2, -1);
        this.updateCalendarComponents();
    }

    private void monthForward() {
        this.displayCalendar.add(2, 1);
        this.updateCalendarComponents();
    }

    static /* synthetic */ void access$000(JCalendar jCalendar) {
        jCalendar.yearBackward();
    }

    static /* synthetic */ void access$100(JCalendar jCalendar) {
        jCalendar.yearForward();
    }

    static /* synthetic */ void access$200(JCalendar jCalendar) {
        jCalendar.monthBackward();
    }

    static /* synthetic */ void access$300(JCalendar jCalendar) {
        jCalendar.monthForward();
    }

    static /* synthetic */ ResourceBundle access$600() {
        return bundle;
    }

    static /* synthetic */ int access$700(JCalendar jCalendar) {
        return jCalendar.selectedDay;
    }

    static /* synthetic */ int access$800(JCalendar jCalendar) {
        return jCalendar.selectedMonth;
    }

    static /* synthetic */ int access$900(JCalendar jCalendar) {
        return jCalendar.selectedYear;
    }

    static /* synthetic */ int access$702(JCalendar jCalendar, int n2) {
        jCalendar.selectedDay = n2;
        return jCalendar.selectedDay;
    }

    static /* synthetic */ int access$802(JCalendar jCalendar, int n2) {
        jCalendar.selectedMonth = n2;
        return jCalendar.selectedMonth;
    }

    static /* synthetic */ int access$1000(JCalendar jCalendar) {
        return jCalendar.displayMonth;
    }

    static /* synthetic */ int access$902(JCalendar jCalendar, int n2) {
        jCalendar.selectedYear = n2;
        return jCalendar.selectedYear;
    }

    static /* synthetic */ int access$1100(JCalendar jCalendar) {
        return jCalendar.displayYear;
    }

    static /* synthetic */ boolean access$1202(JCalendar jCalendar, boolean bl2) {
        jCalendar.isNullDate = bl2;
        return jCalendar.isNullDate;
    }

    static /* synthetic */ Calendar access$1300(JCalendar jCalendar) {
        return jCalendar.selectedCalendar;
    }

    static /* synthetic */ void access$1400(JCalendar jCalendar) {
        jCalendar.updateCalendarComponents();
    }

    static /* synthetic */ Locale access$1500(JCalendar jCalendar) {
        return jCalendar.locale;
    }

    static /* synthetic */ SpinnerDateModel access$1600(JCalendar jCalendar) {
        return jCalendar.spinnerDateModel;
    }

    static /* synthetic */ boolean access$1200(JCalendar jCalendar) {
        return jCalendar.isNullDate;
    }

    static /* synthetic */ int access$1700(JCalendar jCalendar) {
        return jCalendar.selectedComponents;
    }

    static {
        inputMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), "setNullDate");
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "setNullDate");
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "yearBackward");
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "yearForward");
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "monthBackward");
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "monthForward");
        actionMap.put("setNullDate", setNullDate);
        actionMap.put("yearBackward", yearBackward);
        actionMap.put("yearForward", yearForward);
        actionMap.put("monthBackward", monthBackward);
        actionMap.put("monthForward", monthForward);
    }
}

