/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import com.swabunga.spell.swing.autospell.AutoSpellViewFactory;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;

public class AutoSpellEditorKit
extends StyledEditorKit
implements AutoSpellConstants {
    private StyledEditorKit editorKit = null;
    private JEditorPane pane = null;

    public AutoSpellEditorKit(StyledEditorKit styledEditorKit) {
        this.editorKit = styledEditorKit;
    }

    public StyledEditorKit getStyledEditorKit() {
        return this.editorKit;
    }

    public Object clone() {
        return new AutoSpellEditorKit(this.editorKit);
    }

    public void deinstall(JEditorPane jEditorPane) {
        this.editorKit.deinstall(jEditorPane);
        this.pane = null;
    }

    public Element getCharacterAttributeRun() {
        return this.editorKit.getCharacterAttributeRun();
    }

    public MutableAttributeSet getInputAttributes() {
        return this.editorKit.getInputAttributes();
    }

    public void install(JEditorPane jEditorPane) {
        this.editorKit.install(jEditorPane);
        this.pane = jEditorPane;
    }

    public String getContentType() {
        return this.editorKit.getContentType();
    }

    public Action[] getActions() {
        Action[] actionArray = new Action[this.editorKit.getActions().length + 1];
        for (int i = 0; i < this.editorKit.getActions().length; ++i) {
            actionArray[i] = this.editorKit.getActions()[i];
        }
        actionArray[actionArray.length - 1] = new SpellCheckAction();
        return actionArray;
    }

    public Caret createCaret() {
        return this.editorKit.createCaret();
    }

    public Document createDefaultDocument() {
        return this.editorKit.createDefaultDocument();
    }

    public ViewFactory getViewFactory() {
        return new AutoSpellViewFactory(this.editorKit.getViewFactory());
    }

    public void read(InputStream inputStream, Document document, int n) throws IOException, BadLocationException {
        this.editorKit.read(inputStream, document, n);
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws IOException, BadLocationException {
        this.editorKit.write(outputStream, document, n, n2);
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        this.editorKit.read(reader, document, n);
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        this.editorKit.write(writer, document, n, n2);
    }

    private class SpellCheckAction
    extends AbstractAction {
        public SpellCheckAction() {
            super("Mark as misspelled");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AutoSpellEditorKit.this.pane.getCaretPosition();
            if (n < 0) {
                return;
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(((StyledDocument)AutoSpellEditorKit.this.pane.getDocument()).getCharacterElement(n).getAttributes());
            simpleAttributeSet.addAttribute("misspelled", AutoSpellConstants.wordMisspelledTrue);
            ((JTextPane)AutoSpellEditorKit.this.pane).setCharacterAttributes(simpleAttributeSet, false);
        }
    }
}

