/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class AttrDecl
extends XMLNode
implements XMLConstants,
CXMLConstants,
Externalizable {
    int atttype;
    int attpres;
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int ENTITY = 4;
    public static final int ENTITIES = 5;
    public static final int NMTOKEN = 6;
    public static final int NMTOKENS = 7;
    public static final int NOTATION = 8;
    public static final int ENUMERATION = 9;
    public static final int DEFAULT = 0;
    public static final int REQUIRED = 1;
    public static final int IMPLIED = 2;
    public static final int FIXED = 3;
    static final String[] attrDeclTypes = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "NOTATION", ""};
    static final String[] attrDeclPresence = new String[]{null, "#REQUIRED", "#IMPLIED", "#FIXED"};
    static final int EXTERNAL = 128;
    private static final int ATTRDECL_DTD = 0;
    private static final int ATTRDECL_PARENT = 1;
    private static final int ATTRDECL_QXNAME = 2;
    private static final int ATTRDECL_DEFAULT = 3;
    private static final int ATTRDECL_ENUMVAL = 4;
    private static final int ATTRDECL_DATASZ = 5;

    AttrDecl(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    public short getNodeType() {
        return 14;
    }

    public String getNodeName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public int getAttrType() {
        return this.atttype;
    }

    public int getAttrPresence() {
        return this.attpres;
    }

    public String getDefaultValue() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetAttrDeclDefault();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public Vector getEnumerationValues() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetEnumValues();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectOutput(objectOutput);
        this.writeExternal(cXMLStream, cXMLContext);
        cXMLStream.flush();
    }

    public void writeExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException {
        cXMLStream.writeByte(32);
        cXMLStream.writeUTF(this.getNodeName());
        cXMLStream.writeInt(this.atttype);
        cXMLStream.writeInt(this.attpres);
        cXMLStream.writeUTF(this.getDefaultValue());
        Vector vector = this.getEnumerationValues();
        if (vector != null) {
            int n = vector.size();
            cXMLStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                cXMLStream.writeUTF((String)vector.elementAt(i));
            }
        } else {
            cXMLStream.writeShort(0);
        }
        cXMLStream.writeBoolean(this.isNodeFlag(128));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectInput(objectInput);
        this.readExternal(cXMLStream, cXMLContext);
    }

    public void readExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = cXMLStream.readByte();
        if (by != 32) {
            throw new IOException("Error in reading serialized stream corresponding to AttrDecl");
        }
        String string = cXMLStream.readUTF();
        this.xdkSetQxName(QxNameHash.create("", string, "", string));
        this.atttype = cXMLStream.readInt();
        this.attpres = cXMLStream.readInt();
        this.xdkSetAttrDeclDefault(cXMLStream.readUTF());
        int n = cXMLStream.readShort();
        if (n != 0) {
            Vector<String> vector = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                vector.addElement(cXMLStream.readUTF());
            }
            this.xdkSetEnumValue(vector);
        }
        if (cXMLStream.readBoolean()) {
            this.setNodeFlag(128);
        }
    }

    DTD xdkGetDTD() {
        return (DTD)this.data[(int)this.nodeId + 0];
    }

    void xdkSetDTD(DTD dTD) {
        this.data[(int)this.nodeId + 0] = dTD;
    }

    XMLNode xdkGetParentNode() {
        return (XMLNode)this.data[(int)this.nodeId + 1];
    }

    void xdkSetParentNode(XMLNode xMLNode) {
        this.data[(int)this.nodeId + 1] = xMLNode;
    }

    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 2];
    }

    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 2] = qxName;
    }

    String xdkGetAttrDeclDefault() {
        return (String)this.data[(int)this.nodeId + 3];
    }

    void xdkSetAttrDeclDefault(String string) {
        this.data[(int)this.nodeId + 3] = string;
    }

    Vector xdkGetEnumValues() {
        return (Vector)this.data[(int)this.nodeId + 4];
    }

    void xdkSetEnumValue(Vector vector) {
        this.data[(int)this.nodeId + 4] = vector;
    }

    int xdkGetNodeArraySize() {
        return 5;
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        AttrDecl attrDecl = (AttrDecl)xMLDocument.createNodeFromType((short)14);
        attrDecl.attpres = this.attpres;
        attrDecl.atttype = this.atttype;
        attrDecl.xdkSetDTD(this.xdkGetDTD());
        attrDecl.xdkSetParentNode(null);
        attrDecl.xdkSetQxName(this.xdkGetQxName());
        attrDecl.xdkSetAttrDeclDefault(this.xdkGetAttrDeclDefault());
        attrDecl.xdkSetEnumValue(this.xdkGetEnumValues());
        attrDecl.setNodeFlag(128, this.isNodeFlag(128));
        return attrDecl;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeChars("<!ATTLIST ");
            xMLOutputStream.writeChars(this.getParentNode().getNodeName() + " ");
            xMLOutputStream.writeChars(this.getNodeName() + " ");
            if (this.atttype != 9) {
                xMLOutputStream.writeChars(attrDeclTypes[this.atttype] + " ");
            }
            if (this.atttype == 9 || this.atttype == 8) {
                Vector vector = this.getEnumerationValues();
                int n = vector.size();
                xMLOutputStream.write(40);
                xMLOutputStream.writeChars((String)vector.elementAt(0));
                for (int i = 1; i < n; ++i) {
                    xMLOutputStream.write(124);
                    xMLOutputStream.writeChars((String)vector.elementAt(i));
                }
                xMLOutputStream.write(41);
                xMLOutputStream.write(32);
            }
            if (this.attpres != 0) {
                xMLOutputStream.writeChars(attrDeclPresence[this.attpres]);
                xMLOutputStream.write(32);
            }
            if (this.getDefaultValue() != null) {
                xMLOutputStream.writeQuotedString(this.getDefaultValue());
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
    }

    public AttrDecl() {
    }

    AttrDecl(String string, int n) {
        this.atttype = n;
        this.xdkSetQxName(QxNameHash.create("", string, "", string));
    }
}

