/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import railo.commons.io.res.Resource;

public class Util {
    private static File tempFile;
    private static File homeFile;
    private static final SimpleDateFormat HTTP_TIME_STRING_FORMAT;

    static {
        HTTP_TIME_STRING_FORMAT = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.ENGLISH);
        HTTP_TIME_STRING_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65535];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        Util.closeEL(inputStream);
        Util.closeEL(outputStream);
    }

    public static String toString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        if (string != null) {
            stringBuffer.append(string);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append("\n" + string);
            }
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static boolean toBooleanValue(String string) throws IOException {
        if ("true".equals(string = string.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("yes".equals(string)) {
            return true;
        }
        if ("no".equals(string)) {
            return false;
        }
        throw new IOException("can't cast string to a boolean value");
    }

    public static void closeEL(InputStream inputStream, OutputStream outputStream) {
        Util.closeEL(inputStream);
        Util.closeEL(outputStream);
    }

    public static void closeEL(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public static void closeEL(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public static void closeEL(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public static void closeEL(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public static String getContentAsString(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = bufferedReader.readLine();
        if (string2 != null) {
            stringBuffer.append(string2);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append("\n" + string2);
            }
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(String string, boolean bl) {
        if (!bl) {
            return Util.isEmpty(string);
        }
        return string == null || string.trim().length() == 0;
    }

    public static int length(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static int toInVersion(String string) {
        int n = string.lastIndexOf(".rcs");
        if (n == -1) {
            n = string.lastIndexOf(".rc");
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        int n2 = 0;
        int n3 = string.indexOf(46, n2);
        int n4 = 0;
        n4 += Integer.parseInt(string.substring(n2, n3)) * 1000000;
        n2 = n3 + 1;
        n3 = string.indexOf(46, n2);
        n4 += Integer.parseInt(string.substring(n2, n3)) * 10000;
        n2 = n3 + 1;
        n3 = string.indexOf(46, n2);
        n4 += Integer.parseInt(string.substring(n2, n3)) * 100;
        n2 = n3 + 1;
        return n4 += Integer.parseInt(string.substring(n2));
    }

    public static String toStringVersion(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n / 1000000;
        n -= n2 * 1000000;
        stringBuffer.append(String.valueOf(n2));
        stringBuffer.append(".");
        n2 = n / 10000;
        n -= n2 * 10000;
        stringBuffer.append(Util.len(String.valueOf(n2), 2));
        stringBuffer.append(".");
        n2 = n / 100;
        stringBuffer.append(Util.len(String.valueOf(n2), 2));
        stringBuffer.append(".");
        stringBuffer.append(Util.len(String.valueOf(n -= n2 * 100), 3));
        return stringBuffer.toString();
    }

    private static Object len(String string, int n) {
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        int n;
        if (string2.equals(string3)) {
            return string;
        }
        if (!bl && string2.length() == 1 && string3.length() == 1) {
            return string.replace(string2.charAt(0), string3.charAt(0));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n3;
            if (bl) break;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String parsePlaceHolder(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("{temp")) {
            if (string.startsWith("}", 5)) {
                string = new File(Util.getTempDirectory(), string.substring(6)).toString();
            } else if (string.startsWith("-dir}", 5)) {
                string = new File(Util.getTempDirectory(), string.substring(10)).toString();
            } else if (string.startsWith("-directory}", 5)) {
                string = new File(Util.getTempDirectory(), string.substring(16)).toString();
            }
        } else if (string.startsWith("{system")) {
            if (string.startsWith("}", 7)) {
                string = new File(Util.getSystemDirectory(), string.substring(8)).toString();
            } else if (string.startsWith("-dir}", 7)) {
                string = new File(Util.getSystemDirectory(), string.substring(12)).toString();
            } else if (string.startsWith("-directory}", 7)) {
                string = new File(Util.getSystemDirectory(), string.substring(18)).toString();
            }
        } else if (string.startsWith("{home")) {
            if (string.startsWith("}", 5)) {
                string = new File(Util.getHomeDirectory(), string.substring(6)).toString();
            } else if (string.startsWith("-dir}", 5)) {
                string = new File(Util.getHomeDirectory(), string.substring(10)).toString();
            } else if (string.startsWith("-directory}", 5)) {
                string = new File(Util.getHomeDirectory(), string.substring(16)).toString();
            }
        }
        return string;
    }

    public static File getTempDirectory() {
        if (tempFile != null) {
            return tempFile;
        }
        String string = System.getProperty("java.io.tmpdir");
        if (string != null && (tempFile = new File(string)).exists()) {
            tempFile = Util.getCanonicalFileEL(tempFile);
            return tempFile;
        }
        try {
            File file = File.createTempFile("a", "a");
            tempFile = file.getParentFile();
            tempFile = Util.getCanonicalFileEL(tempFile);
            file.delete();
        }
        catch (IOException iOException) {}
        return tempFile;
    }

    public static File getHomeDirectory() {
        if (homeFile != null) {
            return homeFile;
        }
        String string = System.getProperty("user.home");
        if (string != null) {
            homeFile = new File(string);
            homeFile = Util.getCanonicalFileEL(homeFile);
        }
        return homeFile;
    }

    public static File getSystemDirectory() {
        String string = System.getProperty("java.library.path");
        if (string != null) {
            File file;
            String[] stringArray = string.split(File.pathSeparator);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().indexOf("windows\\system") != -1 && (file = new File(stringArray[n])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().indexOf("windows") != -1 && (file = new File(stringArray[n])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().indexOf("winnt") != -1 && (file = new File(stringArray[n])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().indexOf("win") != -1 && (file = new File(stringArray[n])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                file = new File(stringArray[n]);
                if (file.exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++n;
            }
        }
        return null;
    }

    public static File getCanonicalFileEL(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static String toHTTPTimeString(Date date) {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(date), "+00:00", "", true);
    }

    public static String toHTTPTimeString() {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(new Date()), "+00:00", "", true);
    }

    public static boolean hasUpperCase(String string) {
        if (Util.isEmpty(string)) {
            return false;
        }
        return !string.equals(string.toLowerCase());
    }

    public static BufferedInputStream toBufferedInputStream(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream outputStream) {
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }

    public static void copy(Resource resource, Resource resource2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = Util.toBufferedInputStream(resource.getInputStream());
            bufferedOutputStream = Util.toBufferedOutputStream(resource2.getOutputStream());
        }
        catch (IOException iOException) {
            Util.closeEL(bufferedOutputStream);
            Util.closeEL(bufferedInputStream);
            throw iOException;
        }
        Util.copy(bufferedInputStream, bufferedOutputStream);
    }

    public static String toVariableName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        long l = 0L;
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (n == 0 && c >= '0' && c <= '9') {
                stringBuffer.append("_" + c);
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
                l += (long)(c * (n + 1));
            }
            ++n;
        }
        if (bl && l > 0L) {
            stringBuffer.append(l);
        }
        return stringBuffer.toString();
    }

    public static String first(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return stringTokenizer.nextToken();
    }

    public static String last(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    public static String removeQuotes(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        if (bl) {
            string = string.trim();
        }
        if (string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if ((c == '\"' || c == '\'') && c == c2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

