/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.util;

import java.io.File;
import java.io.FileFilter;

public final class ExtensionFilter
implements FileFilter {
    private final String[] extensions;
    private final boolean allowDir;
    private final boolean ignoreCase;

    public ExtensionFilter(String string) {
        this(new String[]{string}, false, true);
    }

    public ExtensionFilter(String string, boolean bl) {
        this(new String[]{string}, bl, true);
    }

    public ExtensionFilter(String[] stringArray) {
        this(stringArray, false, true);
    }

    public ExtensionFilter(String[] stringArray, boolean bl) {
        this(stringArray, bl, true);
    }

    public ExtensionFilter(String[] stringArray, boolean bl, boolean bl2) {
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith(".")) {
                stringArray[n] = "." + stringArray[n];
            }
            if (bl2) {
                stringArray[n] = stringArray[n].toLowerCase();
            }
            ++n;
        }
        this.extensions = stringArray;
        this.allowDir = bl;
        this.ignoreCase = bl2;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.allowDir;
        }
        if (file.exists()) {
            String string = this.ignoreCase ? file.getName().toLowerCase() : file.getName();
            int n = 0;
            while (n < this.extensions.length) {
                if (string.endsWith(this.extensions[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String[] getExtensions() {
        return this.extensions;
    }
}

