/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThread;
import org.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;

public class PDDocumentCatalog
implements COSObjectable {
    private COSDictionary root;
    private PDDocument document;
    private PDAcroForm acroForm = null;

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)new COSString("Catalog"));
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, (COSBase)this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    public COSBase getCOSObject() {
        return this.root;
    }

    public COSDictionary getCOSDictionary() {
        return this.root;
    }

    public PDAcroForm getAcroForm() {
        if (this.acroForm == null) {
            COSDictionary acroFormDic = (COSDictionary)this.root.getDictionaryObject(COSName.ACRO_FORM);
            if (acroFormDic == null) {
                this.acroForm = new PDAcroForm(this.document);
                this.root.setItem(COSName.ACRO_FORM, (COSBase)this.acroForm.getDictionary());
            } else {
                this.acroForm = new PDAcroForm(this.document, acroFormDic);
            }
        }
        return this.acroForm;
    }

    public PDPageNode getPages() {
        return new PDPageNode((COSDictionary)this.root.getDictionaryObject(COSName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        PDPageNode rootNode = this.getPages();
        rootNode.getAllKids(retval);
        return retval;
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("ViewerPreferences");
        if (dict != null) {
            retval = new PDViewerPreferences(dict);
        }
        return retval;
    }

    public void setViewerPreferences(PDViewerPreferences prefs) {
        this.root.setItem("ViewerPreferences", (COSObjectable)prefs);
    }

    public PDDocumentOutline getDocumentOutline() {
        PDDocumentOutline retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("Outlines");
        if (dict != null) {
            retval = new PDDocumentOutline(dict);
        }
        return retval;
    }

    public void setDocumentOutline(PDDocumentOutline outlines) {
        this.root.setItem("Outlines", (COSObjectable)outlines);
    }

    public List getThreads() {
        COSArray array = (COSArray)this.root.getDictionaryObject("Threads");
        if (array == null) {
            array = new COSArray();
            this.root.setItem("Threads", (COSBase)array);
        }
        ArrayList<PDThread> pdObjects = new ArrayList<PDThread>();
        for (int i = 0; i < array.size(); ++i) {
            pdObjects.add(new PDThread((COSDictionary)array.getObject(i)));
        }
        return new COSArrayList(pdObjects, array);
    }

    public void setThreads(List threads) {
        this.root.setItem("Threads", (COSBase)COSArrayList.converterToCOSArray(threads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.root.getDictionaryObject("Metadata");
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.root.setItem("Metadata", (COSObjectable)meta);
    }

    public void setOpenAction(PDAction action) {
        this.root.setItem(COSName.getPDFName("OpenAction"), (COSObjectable)action);
    }

    public PDAction getOpenAction() {
        PDAction action = null;
        COSDictionary actionDic = (COSDictionary)this.root.getDictionaryObject("OpenAction");
        action = PDActionFactory.createAction(actionDic);
        return action;
    }

    public PDDocumentCatalogAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.root.getDictionaryObject("AA");
        if (addAct == null) {
            addAct = new COSDictionary();
            this.root.setItem("AA", (COSBase)addAct);
        }
        return new PDDocumentCatalogAdditionalActions(addAct);
    }

    public void setActions(PDDocumentCatalogAdditionalActions actions) {
        this.root.setItem("AA", (COSObjectable)actions);
    }

    public PDDocumentNameDictionary getNames() {
        PDDocumentNameDictionary nameDic = null;
        COSDictionary names = (COSDictionary)this.root.getDictionaryObject("Names");
        if (names != null) {
            nameDic = new PDDocumentNameDictionary(this, names);
        }
        return nameDic;
    }

    public void setNames(PDDocumentNameDictionary names) {
        this.root.setItem("Names", (COSObjectable)names);
    }
}

