/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.visitor;

import japa.parser.ast.BlockComment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.LineComment;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.GenericVisitor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifierVisitorAdapter<A>
implements GenericVisitor<Node, A> {
    private void removeNulls(List<?> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            if (list.get(i) == null) {
                list.remove(i);
            }
            --i;
        }
    }

    @Override
    public Node visit(AnnotationDeclaration n, A arg) {
        List<BodyDeclaration> members;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((members = n.getMembers()) != null) {
            int i = 0;
            while (i < members.size()) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(members);
        }
        return n;
    }

    @Override
    public Node visit(AnnotationMemberDeclaration n, A arg) {
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        if (n.getDefaultValue() != null) {
            n.setDefaultValue((Expression)n.getDefaultValue().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ArrayAccessExpr n, A arg) {
        n.setName((Expression)n.getName().accept(this, arg));
        n.setIndex((Expression)n.getIndex().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ArrayCreationExpr n, A arg) {
        n.setType((Type)n.getType().accept(this, arg));
        if (n.getDimensions() != null) {
            List<Expression> dimensions = n.getDimensions();
            if (dimensions != null) {
                int i = 0;
                while (i < dimensions.size()) {
                    dimensions.set(i, (Expression)dimensions.get(i).accept(this, arg));
                    ++i;
                }
                this.removeNulls(dimensions);
            }
        } else {
            n.setInitializer((ArrayInitializerExpr)n.getInitializer().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ArrayInitializerExpr n, A arg) {
        List<Expression> values;
        if (n.getValues() != null && (values = n.getValues()) != null) {
            int i = 0;
            while (i < values.size()) {
                values.set(i, (Expression)values.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(values);
        }
        return n;
    }

    @Override
    public Node visit(AssertStmt n, A arg) {
        n.setCheck((Expression)n.getCheck().accept(this, arg));
        if (n.getMessage() != null) {
            n.setMessage((Expression)n.getMessage().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(AssignExpr n, A arg) {
        n.setTarget((Expression)n.getTarget().accept(this, arg));
        n.setValue((Expression)n.getValue().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(BinaryExpr n, A arg) {
        n.setLeft((Expression)n.getLeft().accept(this, arg));
        n.setRight((Expression)n.getRight().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(BlockStmt n, A arg) {
        List<Statement> stmts = n.getStmts();
        if (stmts != null) {
            int i = 0;
            while (i < stmts.size()) {
                stmts.set(i, (Statement)stmts.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(stmts);
        }
        return n;
    }

    @Override
    public Node visit(BooleanLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(BreakStmt n, A arg) {
        return n;
    }

    @Override
    public Node visit(CastExpr n, A arg) {
        n.setType((Type)n.getType().accept(this, arg));
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(CatchClause n, A arg) {
        n.setExcept((Parameter)n.getExcept().accept(this, arg));
        n.setCatchBlock((BlockStmt)n.getCatchBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(CharLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(ClassExpr n, A arg) {
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ClassOrInterfaceDeclaration n, A arg) {
        List<BodyDeclaration> members;
        List<ClassOrInterfaceType> implementz;
        List<ClassOrInterfaceType> extendz;
        List<TypeParameter> typeParameters;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((typeParameters = n.getTypeParameters()) != null) {
            int i = 0;
            while (i < typeParameters.size()) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeParameters);
        }
        if ((extendz = n.getExtends()) != null) {
            int i = 0;
            while (i < extendz.size()) {
                extendz.set(i, (ClassOrInterfaceType)extendz.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(extendz);
        }
        if ((implementz = n.getImplements()) != null) {
            int i = 0;
            while (i < implementz.size()) {
                implementz.set(i, (ClassOrInterfaceType)implementz.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(implementz);
        }
        if ((members = n.getMembers()) != null) {
            int i = 0;
            while (i < members.size()) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(members);
        }
        return n;
    }

    @Override
    public Node visit(ClassOrInterfaceType n, A arg) {
        List<Type> typeArgs;
        if (n.getScope() != null) {
            n.setScope((ClassOrInterfaceType)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            int i = 0;
            while (i < typeArgs.size()) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeArgs);
        }
        return n;
    }

    @Override
    public Node visit(CompilationUnit n, A arg) {
        List<TypeDeclaration> types;
        List<ImportDeclaration> imports;
        if (n.getPackage() != null) {
            n.setPackage((PackageDeclaration)n.getPackage().accept(this, arg));
        }
        if ((imports = n.getImports()) != null) {
            int i = 0;
            while (i < imports.size()) {
                imports.set(i, (ImportDeclaration)imports.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(imports);
        }
        if ((types = n.getTypes()) != null) {
            int i = 0;
            while (i < types.size()) {
                types.set(i, (TypeDeclaration)types.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(types);
        }
        return n;
    }

    @Override
    public Node visit(ConditionalExpr n, A arg) {
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        n.setThenExpr((Expression)n.getThenExpr().accept(this, arg));
        n.setElseExpr((Expression)n.getElseExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ConstructorDeclaration n, A arg) {
        List<NameExpr> throwz;
        List<Parameter> parameters;
        List<TypeParameter> typeParameters;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((typeParameters = n.getTypeParameters()) != null) {
            int i = 0;
            while (i < typeParameters.size()) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeParameters);
        }
        if ((parameters = n.getParameters()) != null) {
            int i = 0;
            while (i < parameters.size()) {
                parameters.set(i, (Parameter)parameters.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(parameters);
        }
        if ((throwz = n.getThrows()) != null) {
            int i = 0;
            while (i < throwz.size()) {
                throwz.set(i, (NameExpr)throwz.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(throwz);
        }
        n.setBlock((BlockStmt)n.getBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ContinueStmt n, A arg) {
        return n;
    }

    @Override
    public Node visit(DoStmt n, A arg) {
        n.setBody((Statement)n.getBody().accept(this, arg));
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(DoubleLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(EmptyMemberDeclaration n, A arg) {
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(EmptyStmt n, A arg) {
        return n;
    }

    @Override
    public Node visit(EmptyTypeDeclaration n, A arg) {
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(EnclosedExpr n, A arg) {
        n.setInner((Expression)n.getInner().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(EnumConstantDeclaration n, A arg) {
        List<BodyDeclaration> classBody;
        List<Expression> args;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((args = n.getArgs()) != null) {
            int i = 0;
            while (i < args.size()) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(args);
        }
        if ((classBody = n.getClassBody()) != null) {
            int i = 0;
            while (i < classBody.size()) {
                classBody.set(i, (BodyDeclaration)classBody.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(classBody);
        }
        return n;
    }

    @Override
    public Node visit(EnumDeclaration n, A arg) {
        List<BodyDeclaration> members;
        List<EnumConstantDeclaration> entries;
        List<ClassOrInterfaceType> implementz;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((implementz = n.getImplements()) != null) {
            int i = 0;
            while (i < implementz.size()) {
                implementz.set(i, (ClassOrInterfaceType)implementz.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(implementz);
        }
        if ((entries = n.getEntries()) != null) {
            int i = 0;
            while (i < entries.size()) {
                entries.set(i, (EnumConstantDeclaration)entries.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(entries);
        }
        if ((members = n.getMembers()) != null) {
            int i = 0;
            while (i < members.size()) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(members);
        }
        return n;
    }

    @Override
    public Node visit(ExplicitConstructorInvocationStmt n, A arg) {
        List<Expression> args;
        List<Type> typeArgs;
        if (!n.isThis() && n.getExpr() != null) {
            n.setExpr((Expression)n.getExpr().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            int i = 0;
            while (i < typeArgs.size()) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeArgs);
        }
        if ((args = n.getArgs()) != null) {
            int i = 0;
            while (i < args.size()) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(args);
        }
        return n;
    }

    @Override
    public Node visit(ExpressionStmt n, A arg) {
        n.setExpression((Expression)n.getExpression().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(FieldAccessExpr n, A arg) {
        n.setScope((Expression)n.getScope().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(FieldDeclaration n, A arg) {
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        List<VariableDeclarator> variables = n.getVariables();
        int i = 0;
        while (i < variables.size()) {
            variables.set(i, (VariableDeclarator)variables.get(i).accept(this, arg));
            ++i;
        }
        this.removeNulls(variables);
        return n;
    }

    @Override
    public Node visit(ForeachStmt n, A arg) {
        n.setVariable((VariableDeclarationExpr)n.getVariable().accept(this, arg));
        n.setIterable((Expression)n.getIterable().accept(this, arg));
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ForStmt n, A arg) {
        List<Expression> update;
        List<Expression> init = n.getInit();
        if (init != null) {
            int i = 0;
            while (i < init.size()) {
                init.set(i, (Expression)init.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(init);
        }
        if (n.getCompare() != null) {
            n.setCompare((Expression)n.getCompare().accept(this, arg));
        }
        if ((update = n.getUpdate()) != null) {
            int i = 0;
            while (i < update.size()) {
                update.set(i, (Expression)update.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(update);
        }
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(IfStmt n, A arg) {
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        n.setThenStmt((Statement)n.getThenStmt().accept(this, arg));
        if (n.getElseStmt() != null) {
            n.setElseStmt((Statement)n.getElseStmt().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ImportDeclaration n, A arg) {
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(InitializerDeclaration n, A arg) {
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        n.setBlock((BlockStmt)n.getBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(InstanceOfExpr n, A arg) {
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(IntegerLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(IntegerLiteralMinValueExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(JavadocComment n, A arg) {
        return n;
    }

    @Override
    public Node visit(LabeledStmt n, A arg) {
        n.setStmt((Statement)n.getStmt().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(LongLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(LongLiteralMinValueExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(MarkerAnnotationExpr n, A arg) {
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(MemberValuePair n, A arg) {
        n.setValue((Expression)n.getValue().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(MethodCallExpr n, A arg) {
        List<Expression> args;
        List<Type> typeArgs;
        if (n.getScope() != null) {
            n.setScope((Expression)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            int i = 0;
            while (i < typeArgs.size()) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeArgs);
        }
        if ((args = n.getArgs()) != null) {
            int i = 0;
            while (i < args.size()) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(args);
        }
        return n;
    }

    @Override
    public Node visit(MethodDeclaration n, A arg) {
        List<NameExpr> throwz;
        List<TypeParameter> typeParameters;
        List<AnnotationExpr> annotations;
        if (n.getJavaDoc() != null) {
            n.setJavaDoc((JavadocComment)n.getJavaDoc().accept(this, arg));
        }
        if ((annotations = n.getAnnotations()) != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        if ((typeParameters = n.getTypeParameters()) != null) {
            int i = 0;
            while (i < typeParameters.size()) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeParameters);
        }
        n.setType((Type)n.getType().accept(this, arg));
        List<Parameter> parameters = n.getParameters();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.size()) {
                parameters.set(i, (Parameter)parameters.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(parameters);
        }
        if ((throwz = n.getThrows()) != null) {
            int i = 0;
            while (i < throwz.size()) {
                throwz.set(i, (NameExpr)throwz.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(throwz);
        }
        if (n.getBody() != null) {
            n.setBody((BlockStmt)n.getBody().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(NameExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(NormalAnnotationExpr n, A arg) {
        n.setName((NameExpr)n.getName().accept(this, arg));
        List<MemberValuePair> pairs = n.getPairs();
        if (pairs != null) {
            int i = 0;
            while (i < pairs.size()) {
                pairs.set(i, (MemberValuePair)pairs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(pairs);
        }
        return n;
    }

    @Override
    public Node visit(NullLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(ObjectCreationExpr n, A arg) {
        List<BodyDeclaration> anonymousClassBody;
        List<Type> typeArgs;
        if (n.getScope() != null) {
            n.setScope((Expression)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            int i = 0;
            while (i < typeArgs.size()) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeArgs);
        }
        n.setType((ClassOrInterfaceType)n.getType().accept(this, arg));
        List<Expression> args = n.getArgs();
        if (args != null) {
            int i = 0;
            while (i < args.size()) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(args);
        }
        if ((anonymousClassBody = n.getAnonymousClassBody()) != null) {
            int i = 0;
            while (i < anonymousClassBody.size()) {
                anonymousClassBody.set(i, (BodyDeclaration)anonymousClassBody.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(anonymousClassBody);
        }
        return n;
    }

    @Override
    public Node visit(PackageDeclaration n, A arg) {
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(Parameter n, A arg) {
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        n.setId((VariableDeclaratorId)n.getId().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(PrimitiveType n, A arg) {
        return n;
    }

    @Override
    public Node visit(QualifiedNameExpr n, A arg) {
        n.setQualifier((NameExpr)n.getQualifier().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ReferenceType n, A arg) {
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ReturnStmt n, A arg) {
        if (n.getExpr() != null) {
            n.setExpr((Expression)n.getExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(SingleMemberAnnotationExpr n, A arg) {
        n.setName((NameExpr)n.getName().accept(this, arg));
        n.setMemberValue((Expression)n.getMemberValue().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(StringLiteralExpr n, A arg) {
        return n;
    }

    @Override
    public Node visit(SuperExpr n, A arg) {
        if (n.getClassExpr() != null) {
            n.setClassExpr((Expression)n.getClassExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(SwitchEntryStmt n, A arg) {
        List<Statement> stmts;
        if (n.getLabel() != null) {
            n.setLabel((Expression)n.getLabel().accept(this, arg));
        }
        if ((stmts = n.getStmts()) != null) {
            int i = 0;
            while (i < stmts.size()) {
                stmts.set(i, (Statement)stmts.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(stmts);
        }
        return n;
    }

    @Override
    public Node visit(SwitchStmt n, A arg) {
        n.setSelector((Expression)n.getSelector().accept(this, arg));
        List<SwitchEntryStmt> entries = n.getEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                entries.set(i, (SwitchEntryStmt)entries.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(entries);
        }
        return n;
    }

    @Override
    public Node visit(SynchronizedStmt n, A arg) {
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        n.setBlock((BlockStmt)n.getBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ThisExpr n, A arg) {
        if (n.getClassExpr() != null) {
            n.setClassExpr((Expression)n.getClassExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ThrowStmt n, A arg) {
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(TryStmt n, A arg) {
        n.setTryBlock((BlockStmt)n.getTryBlock().accept(this, arg));
        List<CatchClause> catchs = n.getCatchs();
        if (catchs != null) {
            int i = 0;
            while (i < catchs.size()) {
                catchs.set(i, (CatchClause)catchs.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(catchs);
        }
        if (n.getFinallyBlock() != null) {
            n.setFinallyBlock((BlockStmt)n.getFinallyBlock().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(TypeDeclarationStmt n, A arg) {
        n.setTypeDeclaration((TypeDeclaration)n.getTypeDeclaration().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(TypeParameter n, A arg) {
        List<ClassOrInterfaceType> typeBound = n.getTypeBound();
        if (typeBound != null) {
            int i = 0;
            while (i < typeBound.size()) {
                typeBound.set(i, (ClassOrInterfaceType)typeBound.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(typeBound);
        }
        return n;
    }

    @Override
    public Node visit(UnaryExpr n, A arg) {
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(VariableDeclarationExpr n, A arg) {
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.size()) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
                ++i;
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        List<VariableDeclarator> vars = n.getVars();
        int i = 0;
        while (i < vars.size()) {
            vars.set(i, (VariableDeclarator)vars.get(i).accept(this, arg));
            ++i;
        }
        this.removeNulls(vars);
        return n;
    }

    @Override
    public Node visit(VariableDeclarator n, A arg) {
        n.setId((VariableDeclaratorId)n.getId().accept(this, arg));
        if (n.getInit() != null) {
            n.setInit((Expression)n.getInit().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(VariableDeclaratorId n, A arg) {
        return n;
    }

    @Override
    public Node visit(VoidType n, A arg) {
        return n;
    }

    @Override
    public Node visit(WhileStmt n, A arg) {
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(WildcardType n, A arg) {
        if (n.getExtends() != null) {
            n.setExtends((ReferenceType)n.getExtends().accept(this, arg));
        }
        if (n.getSuper() != null) {
            n.setSuper((ReferenceType)n.getSuper().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(BlockComment n, A arg) {
        return n;
    }

    @Override
    public Node visit(LineComment n, A arg) {
        return n;
    }
}

