/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Pattern PROC_DIR_PATTERN = Pattern.compile("([\\d]*)");
    private static final FilenameFilter PROCESS_DIRECTORY_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File fileToTest = new File(dir, name);
            return fileToTest.isDirectory() && PROC_DIR_PATTERN.matcher(name).matches();
        }
    };

    public String[] pidsFromProcFilesystem() {
        return new File("/proc").list(PROCESS_DIRECTORY_FILTER);
    }

    public String slurp(String fileName) throws IOException {
        return this.slurpFromInputStream(new FileInputStream(fileName));
    }

    public byte[] slurpToByteArray(String fileName) throws IOException {
        File fileToRead = new File(fileName);
        byte[] contents = new byte[(int)fileToRead.length()];
        FileInputStream inputStream = new FileInputStream(fileToRead);
        ((InputStream)inputStream).read(contents);
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String slurpFromInputStream(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sw.write(line);
                sw.write(10);
            }
        }
        finally {
            stream.close();
        }
        return sw.toString();
    }

    public String runRegexOnFile(Pattern pattern, String filename) {
        try {
            String file = this.slurp(filename);
            Matcher matcher = pattern.matcher(file);
            matcher.find();
            String firstMatch = matcher.group(1);
            if (firstMatch != null && firstMatch.length() > 0) {
                return firstMatch;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

