# Integrated user interface. 
# Copyright (c) 1997, 1998 by Kristian Hasler
# All rights reserved.
# See the file COPYRIGHT for the copyright notes.

proc open_dialog text {
	set w .dialog    
	catch "destroy $w"
	toplevel $w
	wm title $w "Relete: error"
	label $w.label -text "ReLaTe: $text" \
		-borderwidth 2 -relief groove
	button $w.button -text Dismiss -command "set dialogDone 1" 
	pack $w.label -expand 1 -fill x -ipadx 4 -ipady 4
	pack $w.button -pady 4
	bind $w <Enter> "focus $w"
	update
	set height [winfo vrootheight .]	
	set width [winfo vrootwidth .]
	set width [expr $width-[winfo width .dialog]]
	set height [expr $height-[winfo height .dialog]]
	wm geometry .dialog +[expr "$width/2"]+[expr "$height/2"]
	focus .dialog
	global dialogDone
	while { 1 } {
		set dialogDone 0
		tkwait variable dialogDone
		break
	}
	destroy $w
}

catch {
proc constrain_window {win maxstr xpad ylines ypad} {
    set fn [.top.b1 cget -font]
    set w  [expr [font measure $fn $maxstr] + $xpad]
    set h  [expr $ylines * [font metrics $fn -linespace] + $ypad]
    wm geometry $win [format "%sx%s" $w $h]
}
}

proc build_manu {} {
	.top.b2 configure -relief sunken
	.top.b1 configure -relief raised
	.top.b3 configure -relief raised
	pack forget .main.2
	set w .main.1
	catch {destroy $w}
	frame $w
	global video.address audio.address whiteboard.address texteditor.address \
		video.ttl audio.ttl whiteboard.ttl texteditor.ttl \
		video.port audio.port whiteboard.port texteditor.port \
		video.check audio.check whiteboard.check texteditor.check \
		tcl_platform
	
	frame $w.toplabels 
	frame $w.labels
	frame $w.tools 
	frame $w.address
	frame $w.port
	frame $w.ttl

	foreach i {format address port ttl required} {
		label $w.toplabels.$i -text $i
		pack $w.toplabels.$i -side left -fill x -padx 14
	}
	pack $w.toplabels.address -padx 32
	pack $w.toplabels.ttl -padx 24

	foreach i {whiteboard texteditor video audio} {
		label $w.labels.$i -text $i
		entry $w.address.$i -width 15 -bg white
		entry $w.port.$i -width 6 -bg white
		entry $w.ttl.$i -width 3 -bg white
		checkbutton $w.tools.$i -variable $i.check
		pack $w.labels.$i -fill x -pady 4
		pack $w.address.$i -fill x -padx 8 -pady 4

		pack $w.ttl.$i -fill x -padx 16 -pady 4
		if {$tcl_platform(platform)=="windows"} {
			pack $w.tools.$i  -padx 20
			pack $w.port.$i -fill x -padx 8 -pady 4
		} else {
			pack $w.tools.$i  -padx 20 -pady 4
			pack $w.port.$i -fill x -padx 0 -pady 4
		}
		$w.address.$i insert 0 [set "$i.address"]
		$w.ttl.$i insert 0 [set "$i.ttl"]
		$w.port.$i insert 0 [set "$i.port"]
	}

	pack $w.toplabels -anchor w
	pack $w.labels -side left -pady 10
	pack $w.address -side left	
	pack $w.port -side left
	pack $w.ttl -side left
	pack $w.tools -side left
	pack $w -padx 5 -fill y -expand 1 -pady 10
}

proc build_pers {} {
	.top.b1 configure -relief sunken
	.top.b2 configure -relief raised
	.top.b3 configure -relief raised
	.top.b4 configure -relief raised

	global name email phone loc tcl_platform
	set w .main.2
	catch {destroy .main.1}
	catch {destroy $w}
	frame $w
	frame $w.msg -relief ridge
	label $w.msg.label -wraplength 4.3i \
		-justify left -text \
"Please check your name and email address as they will be used to identify you in \
this conference. If they are incorrect click in the box and change them as necessary." -relief groove -padx 4 -pady 4

	pack $w.msg.label -padx 6 -pady 2
	pack $w.msg -side top

	foreach i {name email phone loc} {
		frame $w.$i -bd 2
		entry $w.$i.entry -relief sunken -state normal -bg white
		label $w.$i.label -width 17 -anchor e
		pack $w.$i.label -side left 
		pack $w.$i.entry -side left -fill x -expand 1 -padx 8
	}

	$w.name.label config -text "Full Name:"
	$w.email.label config -text "Email Address:"
	$w.phone.label config -text "Telephone Number:"
	$w.loc.label config -text "Location:" 
	pack $w.msg -pady 10
	pack $w.name $w.email $w.phone $w.loc -side top -fill x

	$w.name.entry insert 0 [format "%s" $name]
	$w.email.entry insert 0 [format "%s" $email]
	$w.phone.entry insert 0 [format "%s" $phone]
	$w.loc.entry insert 0 [format "%s" $loc]

	pack $w -padx 5 -fill y -expand 1

	global dialogDone
	while { 1 } {
		set dialogDone 0
		focus $w.name.entry
		tkwait variable dialogDone
		set name [string trim [.main.2.name.entry get]]
		set email [string trim [.main.2.email.entry get]]
		set phone [string trim [.main.2.phone.entry get]]
		set loc [string trim [.main.2.loc.entry get]]
		if { $dialogDone < 0 } {
			exit 0
		}
		if { [string length $name] <= 2 } {
			open_dialog "please enter a reasonable name"
			continue
		}
		if { [string first . $email] < 0 || [string first @ $email] < 0 } {
			open_dialog "email address should have form user@host.domain"
			continue
		}
		if { [string length $phone] <= 4 } {
			open_dialog "please enter a reasonable telephone number"
			continue
		}
		if { [string length $loc] <= 1 } {
			open_dialog "please enter a reasonable location"
			continue
		}
		break
	}
}

proc build_about {} {
	.top.b1 configure -relief raised
	.top.b2 configure -relief raised
	.top.b3 configure -relief raised
	.top.b4 configure -relief sunken

	global name email phone loc

	pack forget .main.2
	set w .main.1
	catch {destroy $w}
	frame $w
	label $w.msg -wraplength 4.3i \
		-justify left -text \
"The ReLaTe Integrated Interface and VIC/RAT patches were written by Kristian\
Hasler for the joint UCL and Exeter University Remote Language Teaching\
project.\n\nBased on the original design by Isidor Kouvelas and\
incorporates UCL MBus and LBL conference bus code.\n\nAdditional Contributors:\nGary\
Stringer, Colin Perkins, Louise Clark, Jane Hughes and John Andrews\n\nReLaTe\
Project Managers:\nJohn Bucket (Exeter), Angela Sasse (UCL)." \
	 -padx 4 -pady 4
	pack $w.msg -side left -fill x -expand 1 -padx 10
	pack $w -padx 5 -fill y -expand 1
}

proc build_misc {} {
	.top.b1 configure -relief raised
	.top.b2 configure -relief raised
	.top.b3 configure -relief sunken
	.top.b4 configure -relief raised

	global name email phone loc audio.check rat32 force_rat32 sync
	pack forget .main.2
	set w .main.1
	catch {destroy $w}
	frame $w
	checkbutton $w.b1 -text "Use Rat 3.2" -variable force_rat32
	checkbutton $w.b2 -text "Video/Audio synchronisation" -variable sync
	if {[expr $rat32==2]} {
		$w.b1 configure -state normal
	} else {
		$w.b1 configure -state disabled
	}
	if {[expr $rat32>0]} {
		$w.b2 configure -state normal
	} else {
		$w.b2 configure -state disabled
	}
	pack $w.b1 $w.b2 -padx 25 -side left -fill x -expand 1
	pack $w -fill y -expand 1
}

proc save_settings {} {
	catch {
		foreach i {whiteboard texteditor video audio} {
			global $i.address $i.ttl $i.port $i.check
			set $i.address [string trim [.main.1.address.$i get]]
			set $i.ttl [string trim [.main.1.ttl.$i get]]
			set $i.port [string trim [.main.1.port.$i get]]
		}
	}
}

set channel [expr int([expr rand()*100+300])]
init_confbus $channel
set V(class) "Mbone Applications"
set sync 0
if {[expr $rat32==1]} {
	set force_rat32 1
} else {
	set force_rat32 0
}

proc resource r {
	return [option get . $r relate]
}

catch {option readfile ~/relate.ini startupFile}
set relatenew [resource relatenew]

if {$tcl_platform(platform)=="windows"} {
	set bfont -*-helvetica-bold-r-normal-*-14-*-*-*-p-*-iso8859-1
	option add *font {helvetica 8}
} else {
	set bfont -*-helvetica-bold-r-normal-*-10-*-*-*-p-*-iso8859-1
	option add *font -*-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1
	. configure -background gray80

	option add *background gray80 startupFile
	option add *foreground black startupFile
	option add *activeBackground gray85 startupFile
	option add *selectBackground gray85 startupFile
	option add *disabledForeground gray50 startupFile
	option add *scrollbarBackground gray50 startupFile
	option add *scrollbarForeground gray80 startupFile
	option add *scrollbarActiveForeground gray95 startupFile

	option add *Checkbutton.anchor w startupFile
	option add *Radiobutton.anchor w startupFile
	option add *Radiobutton.relief flat startupFile
	option add *Scale.sliderForeground gray80 startupFile
	option add *Scale.activeForeground gray85 startupFile
	option add *Scale.background gray80 startupFile
	option add *selector forestgreen startupFile
} 

if {$relatenew=="2"} {
	set video.check [resource relateVideoCheck]
	set audio.check [resource relateAudioCheck]
	set whiteboard.check [resource relateWhiteboardCheck]
	set texteditor.check [resource relateTexteditorCheck]
	set video.address [resource relateVideoAddress]
	set audio.address [resource relateAudioAddress]
	set whiteboard.address [resource relateWhiteboardAddress]
	set texteditor.address [resource relateTexteditorAddress]
	set video.ttl [resource relateVideoTTL]
	set audio.ttl [resource relateAudioTTL]
	set whiteboard.ttl [resource relateWhiteboardTTL]
	set texteditor.ttl [resource relateTexteditorTTL]
	set video.port [resource relateVideoPort]
	set audio.port [resource relateAudioPort]
	set whiteboard.port [resource relateWhiteboardPort]
	set texteditor.port [resource relateTexteditorPort]
} else {
	wm title . "Welcome to ReLaTe !"
	set w .top
	frame $w
	label $w.msg -wraplength 2.5i \
		-justify left -text \
"Thank you for installing the ReLaTe Integrated Interface!  \
Please ensure that the following versions (or higher\
versions) of the MBone tools are in your path:\
\n\n - RAT 3.0.29\n - VIC 2.8ucl2\n - NTE 1.5.31\n - WBD1.0ucl2\n"
	pack $w.msg -side top -ipadx 4 -ipady 4
	button $w.button -text "OK" -command "set dialogDone 1"
	pack $w.button -side bottom
	pack $w -ipadx 5 -ipady 5 -fill both -expand 1
	update
	set height [winfo vrootheight .]	
	set width [winfo vrootwidth .]
	set width [expr $width-[winfo width .]]
	set height [expr $height-[winfo height .]]
	wm geometry . +[expr "$width/2"]+[expr "$height/2"]
	focus .
	global dialogDone
	while { 1 } {
		set dialogDone 0
		tkwait variable dialogDone
		break
	}
	destroy $w
	set video.check 1
	set audio.check 1
	set whiteboard.check 1
	set texteditor.check 1
	set video.address 224.9.9.9
	set audio.address 224.9.9.9
	set whiteboard.address 224.9.9.9
	set texteditor.address 224.9.9.9
	set video.ttl 47
	set audio.ttl 47
	set whiteboard.ttl 47
	set texteditor.ttl 47
	set video.port 50500
	set audio.port 30500
	set whiteboard.port 9999
	set texteditor.port 14395
}

set cryptkey Wi8Ble
set name ""
set email ""
set phone ""
set loc ""

if {$tcl_platform(platform)=="windows"} {
	catch {set name  [registry get "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpName"]  }
	catch {set email [registry get "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpEmail"] }
	catch {set phone [registry get "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpPhone"] }
	catch {set loc   [registry get "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpLoc"  ] }
} else {
	catch "option readfile ~/.RTPdefaults startupFile"
	set name [option get . rtpName  startupFile]
	set email [option get . rtpEmail startupFile]
	set phone [option get . rtpPhone startupFile]
	set loc [option get . rtpLoc   startupFile]
}
wm title . "Welcome to ReLaTe !"

frame .top
button .top.b1 -relief raised -borderwidth 1 -text "Personal Details" -command "save_settings; build_pers" -bd 1 -padx 3
button .top.b2 -relief raised -borderwidth 1 -text "Conference Configuration" -command "build_manu" -bd 1 -padx 3
button .top.b3 -relief raised -borderwidth 1 -text "Miscellaneous" -command "save_settings; build_misc" -bd 1 -padx 3
button .top.b4 -relief raised -borderwidth 1 -text "About ReLaTe" -command "save_settings; build_about" -bd 1 -padx 3
pack .top.b1 .top.b2 .top.b3 .top.b4 -side left -padx 5

frame .buttons
frame .buttons.right
button .buttons.right.accept -text "   Start   " -command "set dialogDone 1" -bd 1
button .buttons.right.dismiss -text "  Quit   " -command "set dialogDone -1" -bd 1

pack .buttons.right.dismiss .buttons.right.accept \
	-side right -expand 1 -padx 5 -pady 5
pack .buttons.right -side right -anchor e

frame .main -relief raised -borderwidth 2 
pack .top -side top -fill x -anchor n
pack .main -side top -fill both -expand 1 -ipadx 5
pack .buttons -side right -expand 1 -fill x -anchor s

constrain_window . \
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" \
		0 19 0
update
set height [winfo vrootheight .]
set width [winfo vrootwidth .]
set width [expr $width-[winfo width .]]
set height [expr $height-[winfo height .]]
wm geometry . +[expr "$width/2"]+[expr "$height/2"]
wm resizable . 0 0
focus .
build_pers

if {$tcl_platform(platform)=="windows"} {
	registry set "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpName"  "$name" 
	registry set "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpEmail"  "$email" 
	registry set "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpPhone"  "$phone" 
	registry set "HKEY_CURRENT_USER\\Software\\$V(class)\\common" "*rtpLoc"  "$loc" 
} else {
	set f [open ~/.RTPdefaults w+]
	puts $f "*rtpName:  $name"
	puts $f "*rtpEmail: $email"
	puts $f "*rtpPhone: $phone"
	puts $f "*rtpLoc:   $loc"
	close $f
}

save_settings
set f [open ~/relate.ini w+]
puts $f "*relatenew: 2"
puts $f "*relateVideoCheck: [set "video.check"]"
puts $f "*relateAudioCheck: [set "audio.check"]"
puts $f "*relateWhiteboardCheck: [set "whiteboard.check"]"
puts $f "*relateTexteditorCheck: [set "texteditor.check"]"
puts $f "*relateVideoAddress: [set "video.address"]"
puts $f "*relateAudioAddress: [set "audio.address"]"
puts $f "*relateWhiteboardAddress: [set "whiteboard.address"]"
puts $f "*relateTexteditorAddress: [set "texteditor.address"]"
puts $f "*relateVideoTTL: [set "video.ttl"]"
puts $f "*relateAudioTTL: [set "audio.ttl"]"
puts $f "*relateWhiteboardTTL: [set "whiteboard.ttl"]"
puts $f "*relateTexteditorTTL: [set "texteditor.ttl"]"
puts $f "*relateVideoPort: [set "video.port"]"
puts $f "*relateAudioPort: [set "audio.port"]"
puts $f "*relateWhiteboardPort: [set "whiteboard.port"]"
puts $f "*relateTexteditorPort: [set "texteditor.port"]"
close $f

destroy .buttons
destroy .top
destroy .main

proc bye {} {
	global force_rat32 rat32 audio.check video.check whiteboard.check texteditor.check ratproc vicproc nteproc wbdproc tcl_platform
	if {$tcl_platform(platform)=="unix"} {
		if {[set "audio.check"] && [expr [expr $rat32==0] || [expr $force_rat32==0]]} {catch {exec kill [set "ratproc"]}} 
		if [set "whiteboard.check"] {catch {exec kill [set "wbdproc"]}} 
		if [set "texteditor.check"] {catch {exec kill [set "nteproc"]}} 
	} else {
		if {[set "audio.check"] && [expr [expr $rat32==0] || [expr $force_rat32==0]]} {terminate_process $ratproc}
		if [set "whiteboard.check"] {terminate_process $wbdproc}
		if [set "texteditor.check"] {terminate_process $nteproc}
	} 	
	if [set "video.check"] {quit_vic}
	if {[set "audio.check"] && [expr $rat32>1] && [expr $force_rat32==1]} {mbus_send "R" "mbus.quit" ""}
	after 1000 {destroy .}
}

# * build user interface *
wm title . "ReLaTe Integrated Interface"
wm resizable . 1 1
frame .r
pack .r -side right -fill y
wm geometry . +0+0
wm geometry . ""
update

if {[set "whiteboard.check"] || [set "texteditor.check"]} {
	set username [lindex [split $email @] 0]
	frame .r.t
	pack .r.t -side top

	# nte
	if [set "texteditor.check"] {
		frame .r.t.nte -container true
		set ntewin [winfo id .r.t.nte]
		if [expr $nte15==1] {
			catch {set nteproc [exec nte -s -use $ntewin -N $name -geometry 656x583 -U $username -p -t [set "texteditor.ttl"] [set "texteditor.address"]/[set "texteditor.port"] &] }
		} else {
			catch {set nteproc [exec nte -use $ntewin -N $name -geometry 656x583 -U $username -p -t [set "texteditor.ttl"] [set "texteditor.address"]/[set "texteditor.port"] &] }
		}
		pack .r.t.nte
		if {![string compare [info vars nteproc] ""]} {
			open_dialog "NTE error - check your path."
		}
	}

	if [set "whiteboard.check"] {
		# wbd
		frame .r.t.wbd -container true
		set wbdwin [winfo id .r.t.wbd]
		catch {set wbdproc [exec wbd -use $wbdwin -relate -N $name -geometry 656x583 -maxhops [set "whiteboard.ttl"] [set "whiteboard.address"]/[set "whiteboard.port"] &] }
		pack .r.t.wbd
		if [set "texteditor.check"] {
			after 1000 {pack forget .r.t.wbd}
		}
		if {![string compare [info vars wbdproc] ""]} {
			open_dialog "WBD error - check your path."
		}
	}
	update
}

if [set "video.check"] {
	frame .l
	pack .l -side left -fill y
	frame .l.vic -container true
	set vicwin [winfo id .l.vic]
	catch {set vicproc [exec vic -I $channel -r -B 400 -f h261 -C stvic -t [set "video.ttl"] -w $vicwin [set "video.address"]/[set "video.port"] &] }
	pack .l.vic -side bottom
	update
	if {![string compare [info vars vicproc] ""]} {
		open_dialog "VIC error - check your path."
	}
}

frame .r.b
pack .r.b -side bottom -fill x
# RAT 3.2....

if {[set "audio.check"] && [expr $rat32>0] && [expr $force_rat32==1]} {
	frame .r.b.rat 
	pack .r.b.rat -side left -fill y
	if {[expr $rat32==2]} {set ratname "rat32"
	} else {set ratname "rat"}
	# set address to video engine so that VIC receives powermeter messages.
	if {[expr $sync==1]} {
		catch {set ratproc [exec [set "ratname"] -wait -mbus 1 -sync -ui "(video engine ui [pid])" -f dvi/dvi -t [set "audio.ttl"] [set "audio.address"]/[set "audio.port"] &] }
	} else {
		catch {set ratproc [exec [set "ratname"] -wait -mbus 1 -ui "(video engine ui [pid])" -f dvi/dvi -t [set "audio.ttl"] [set "audio.address"]/[set "audio.port"] &] }
	}
	start_confbus
	mbus_ui_init "(audio engine rat [set "ratproc"])" 1
	mbus_init "(video engine ui [pid])" 1
	after 3000 {
		mbus_send "U" "mbus.go" ""
		small_ui
	}
	after 6000 {
		mbus_send "R" "rtp.source.name" "[mbus_encode_str $my_cname] [mbus_encode_str $name]"
		mbus_send "R" "rtp.source.email" "[mbus_encode_str $my_cname] [mbus_encode_str $email]"
		mbus_send "R" "rtp.source.phone" "[mbus_encode_str $my_cname] [mbus_encode_str $phone]"
		mbus_send "R" "rtp.source.loc" "[mbus_encode_str $my_cname] [mbus_encode_str $loc]"
	}
	if {![string compare [info vars ratproc] ""]} {
		open_dialog "RAT3.2 error - check your path."
	}
}

# RAT 3.0....
if {[set "audio.check"] && [expr [expr $rat32==0] || [expr $force_rat32==0]]} {
	frame .r.b.rat -container true
	pack .r.b.rat -side left
	set ratwin [winfo id .r.b.rat]
	catch {set ratproc [exec rat -lbl_channel $channel -f dvi/dvi -t [set "audio.ttl"] -smallui -use $ratwin [set "audio.address"]/[set "audio.port"] &] }
	pack .r.b.rat -side left
	update
	if {![string compare [info vars ratproc] ""]} {
		open_dialog "RAT3.0 error - check your path."
	}
}

frame .r.b.t
pack .r.b.t -side right

button .r.b.t.ws -font $bfont -text Work-space -state disabled -command switch-wb -wraplength 35
pack .r.b.t.ws -side top -fill x
label .r.b.t.title -font $bfont -text "ReLaTe"
pack .r.b.t.title -side top -fill x
label .r.b.t.version -font $bfont -text "v2.0"
pack .r.b.t.version -side top -fill x
button .r.b.t.quit -font $bfont -text Quit -command bye
pack .r.b.t.quit -side top -fill x

frame .r.b.i
pack .r.b.i -side bottom -fill both -expand 1

label .r.b.i.ucl -bitmap "ucl"
pack .r.b.i.ucl -side left -fill both -expand 1

label .r.b.i.relate -bitmap "relate"
pack .r.b.i.relate -side left -fill both -expand 1

label .r.b.i.merci -bitmap "exeter"
pack .r.b.i.merci -side left -fill both -expand 1

if {[set "whiteboard.check"] && [set "texteditor.check"]} {
	.r.b.t.ws configure -state normal
}

proc switch-nt {} {
	pack forget .r.t.wbd
	pack .r.t.nte -side top
	.r.b.t.ws configure -command switch-wb
	update
}

proc switch-wb {} {
	pack forget .r.t.nte
	pack .r.t.wbd -side top
	.r.b.t.ws configure -command switch-nt
	update
}
