/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.IndentPrinter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;

public class PSVIWriter
implements XMLComponent,
XMLDocumentFilter {
    public static final String XERCES_PSVI_NS = "http://apache.org/xml/2001/PSVInfosetExtension";
    protected static final String NAMESPACE_BINDER = "http://apache.org/xml/properties/internal/namespace-binder";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVINFOSET = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String PSVI_OUTPUT = "psvi_output.xml";
    protected boolean fIncludeIgnorableWhitespace;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/properties/internal/namespace-binder", "http://apache.org/xml/features/dom/include-ignorable-whitespace", "http://apache.org/xml/features/validation/schema/augment-psvi"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.TRUE, null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null};
    protected boolean fPSVInfoset;
    private String fEmptySymbol;
    private String fXmlSymbol;
    private String fXmlnsSymbol;
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected SymbolTable fSymbolTable;
    protected NamespaceContext fNamespaceContext;
    private QName fAttrQName = new QName();
    private Stack _elementState = new Stack();
    private OutputStream _output;
    private Writer _writer;
    private EncodingInfo _encodingInfo;
    private final StringBuffer fErrorBuffer = new StringBuffer();
    protected Printer _printer;

    public PSVIWriter() {
        System.out.println("Generating Schema Information Set Contribution (PSVI) \nwhich follow as a consequence of validation and/or assessment.");
        System.out.println("NOTE: Requires use of -s and -v");
        System.out.println("Output: generated in psvi_output.xml");
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fPSVInfoset = xMLComponentManager.getFeature(PSVINFOSET);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fPSVInfoset = false;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fIncludeIgnorableWhitespace = xMLComponentManager.getFeature(INCLUDE_IGNORABLE_WHITESPACE);
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fErrorBuffer.setLength(0);
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndenting(true);
            outputFormat.setLineSeparator("\r\n");
            outputFormat.setLineWidth(150);
            outputFormat.setOmitComments(false);
            outputFormat.setOmitDocumentType(false);
            outputFormat.setOmitXMLDeclaration(false);
            FileOutputStream fileOutputStream = new FileOutputStream(PSVI_OUTPUT);
            this._output = new BufferedOutputStream(fileOutputStream);
            this._encodingInfo = outputFormat.getEncodingInfo();
            this._writer = this._encodingInfo.getWriter(this._output);
            this._printer = new IndentPrinter(this._writer, outputFormat);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        if (this.fPSVInfoset) {
            this.printIndentTag("<document xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:psv='http://apache.org/xml/2001/PSVInfosetExtension' xmlns='http://www.w3.org/2001/05/XMLInfoset'>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.printElement("characterEncodingScheme", string2);
            this.printElement("standalone", string3);
            this.printElement("version", string);
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.checkForChildren();
            this.printIndentTag("<docTypeDeclaration>");
            if (string2 != null) {
                this.printElement("publicIdentifier", string2);
            }
            if (string3 != null) {
                this.printElement("systemIdentifier", string3);
            }
            this.printUnIndentTag("</docTypeDeclaration>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.checkForChildren();
            this.printIndentTag("<comment>");
            this.printElement("content", xMLString.toString());
            this.printUnIndentTag("</comment>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.checkForChildren();
            this.printIndentTag("<processingInstruction>");
            this.printElement("target", string);
            this.printElement("content", xMLString.toString());
            this.printUnIndentTag("</processingInstruction>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.checkForChildren();
            this._elementState.push(new ElementState(true));
            this.printIndentTag("<element>");
            this.printElement("namespaceName", qName.uri);
            this.printElement("localName", qName.localpart);
            this.printElement("prefix", qName.prefix);
            this.printAttributes(xMLAttributes);
            this.printInScopeNamespaces();
            this.printPSVIStartElement(augmentations);
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.printIndentTag("<element>");
            this.printElement("namespaceName", qName.uri);
            this.printElement("localName", qName.localpart);
            this.printElement("prefix", qName.prefix);
            this.printAttributes(xMLAttributes);
            this.printInScopeNamespaces();
            this.printTag("<children/>");
            this.printPSVIStartElement(augmentations);
            this.printPSVIEndElement(augmentations);
            this.printUnIndentTag("</element>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            this.checkForChildren();
            this.printIndentTag("<character>");
            this.printElement("characterCode", xMLString.toString());
            this.printElement("elementContentWhitespace", "false");
            this.printUnIndentTag("</character>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset && this.fIncludeIgnorableWhitespace) {
            this.checkForChildren();
            this.printIndentTag("<character>");
            this.printElement("characterCode", xMLString.toString());
            this.printElement("elementContentWhitespace", "true");
            this.printUnIndentTag("</character>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            ElementState elementState = (ElementState)this._elementState.peek();
            if (elementState.isEmpty) {
                this.printTag("<children/>");
            } else {
                this.printUnIndentTag("</children>");
            }
            this._elementState.pop();
            this.printPSVIEndElement(augmentations);
            this.printUnIndentTag("</element>");
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(qName, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.fPSVInfoset) {
            try {
                this.printUnIndentTag("</children>");
                this.printElement("documentElement", "");
                this.printTag("<notations/>");
                this.printTag("<unparsedEntities/>");
                this.printElement("baseURI", "");
                this.printElement("allDeclarationsProcessed", "true");
                this.printUnIndentTag("</document>");
                this._printer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void printPSVIStartElement(Augmentations augmentations) {
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            // empty if block
        }
    }

    public void printPSVIEndElement(Augmentations augmentations) {
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            StringList stringList;
            XSNotationDeclaration xSNotationDeclaration;
            this.printElement("psv:validationContext", elementPSVI.getValidationContext());
            short s = elementPSVI.getValidity();
            if (s == 0) {
                this.printElement("psv:validity", "unknown");
            } else if (s == 2) {
                this.printElement("psv:validity", "valid");
            } else if (s == 1) {
                this.printElement("psv:validity", "invalid");
            }
            short s2 = elementPSVI.getValidationAttempted();
            if (s2 == 0) {
                this.printElement("psv:validationAttempted", "none");
                return;
            }
            if (s2 == 1) {
                this.printElement("psv:validationAttempted", "partial");
            } else if (s2 == 2) {
                this.printElement("psv:validationAttempted", "full");
            }
            XSTypeDefinition xSTypeDefinition = elementPSVI.getTypeDefinition();
            short s3 = xSTypeDefinition.getTypeCategory();
            if (s3 == 14) {
                this.printElement("psv:typeDefinitionType", "simple");
            } else if (s3 == 13) {
                this.printElement("psv:typeDefinitionType", "complex");
            }
            this.printElement("psv:typeDefinitionNamespace ", xSTypeDefinition.getNamespace());
            this.printElement("psv:typeDefinitionAnonymous", String.valueOf(xSTypeDefinition.getAnonymous()));
            this.printElement("psv:typeDefinitionName", xSTypeDefinition.getName());
            XSSimpleTypeDefinition xSSimpleTypeDefinition = elementPSVI.getMemberTypeDefinition();
            if (xSSimpleTypeDefinition != null) {
                this.printElement("psv:memberTypeDefinitionAnonymous", String.valueOf(xSSimpleTypeDefinition.getAnonymous()));
                this.printElement("psv:memberTypeDefinitionName", xSSimpleTypeDefinition.getName());
                this.printElement("psv:memberTypeDefinitionNamespace", xSSimpleTypeDefinition.getNamespace());
            }
            if ((xSNotationDeclaration = elementPSVI.getNotation()) != null) {
                this.printElement("psv:notationSystem", xSNotationDeclaration.getSystemId());
                this.printElement("psv:notationPublic", xSNotationDeclaration.getPublicId());
            }
            if ((stringList = elementPSVI.getErrorCodes()) != null) {
                int n = 0;
                while (n < stringList.getLength()) {
                    this.fErrorBuffer.append(stringList.item(n));
                    ++n;
                }
                this.printElement("psv:schemaErrorCode", this.fErrorBuffer.toString());
                this.fErrorBuffer.setLength(0);
            } else {
                this.printElement("psv:schemaErrorCode", "");
            }
            this.printElement("psv:schemaNormalizedValue", elementPSVI.getSchemaNormalizedValue());
            String string = elementPSVI.getIsSchemaSpecified() ? "schema" : "infoset";
            this.printElement("psv:schemaSpecified", string);
        }
    }

    public void printPSVIAttribute(Augmentations augmentations) {
        AttributePSVI attributePSVI = (AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI");
        if (attributePSVI != null) {
            StringList stringList;
            this.printElement("psv:validationContext", attributePSVI.getValidationContext());
            short s = attributePSVI.getValidity();
            if (s == 0) {
                this.printElement("psv:validity", "unknown");
            } else if (s == 2) {
                this.printElement("psv:validity", "valid");
            } else if (s == 1) {
                this.printElement("psv:validity", "invalid");
            }
            short s2 = attributePSVI.getValidationAttempted();
            if (s2 == 0) {
                this.printElement("psv:validationAttempted", "none");
                return;
            }
            if (s2 == 2) {
                this.printElement("psv:validationAttempted", "full");
            }
            if ((stringList = attributePSVI.getErrorCodes()) == null) {
                this.printElement("psv:schemaErrorCode", "");
            } else {
                int n = 0;
                while (n < stringList.getLength()) {
                    this.fErrorBuffer.append(stringList.item(n));
                    ++n;
                }
                this.printElement("psv:schemaErrorCode", this.fErrorBuffer.toString());
                this.fErrorBuffer.setLength(0);
            }
            this.printElement("psv:schemaNormalizedValue", attributePSVI.getSchemaNormalizedValue());
            this.printElement("psv:schemaSpecified", attributePSVI.getIsSchemaSpecified() ? "schema" : "infoset");
            XSTypeDefinition xSTypeDefinition = attributePSVI.getTypeDefinition();
            XSSimpleTypeDefinition xSSimpleTypeDefinition = attributePSVI.getMemberTypeDefinition();
            short s3 = xSTypeDefinition.getTypeCategory();
            if (s3 == 14) {
                this.printElement("psv:typeDefinitionType", "simple");
            }
            this.printElement("psv:typeDefinitionNamespace", xSTypeDefinition.getNamespace());
            this.printElement("psv:typeDefinitionAnonymous", String.valueOf(xSTypeDefinition.getAnonymous()));
            this.printElement("psv:typeDefinitionName", xSTypeDefinition.getName());
            if (xSSimpleTypeDefinition != null) {
                this.printElement("psv:memberTypeDefinitionAnonymous", String.valueOf(xSSimpleTypeDefinition.getAnonymous()));
                this.printElement("psv:memberTypeDefinitionName", xSSimpleTypeDefinition.getName());
                this.printElement("psv:memberTypeDefinitionNamespace", xSSimpleTypeDefinition.getNamespace());
            }
        }
    }

    private void printTag(String string) {
        try {
            this._printer.printText(string);
            this._printer.breakLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printIndentTag(String string) {
        try {
            this._printer.indent();
            this._printer.printText(string);
            this._printer.breakLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printUnIndentTag(String string) {
        try {
            this._printer.unindent();
            this._printer.printText(string);
            this._printer.breakLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printElement(String string, String string2) {
        try {
            if (string2 == null || string2 == "") {
                this._printer.printText("<" + string + " xsi:nil='true'/>");
                this._printer.breakLine();
                return;
            }
            this._printer.printText("<" + string + ">");
            this._printer.printText(string2);
            this._printer.printText("</" + string + ">");
            this._printer.breakLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printAttributes(XMLAttributes xMLAttributes) {
        boolean bl = false;
        boolean bl2 = false;
        int n = xMLAttributes.getLength();
        if (n == 0) {
            this.printTag("<attributes/>");
            this.printTag("<namespaceAttributes/>");
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = xMLAttributes.getLocalName(n2);
            String string2 = xMLAttributes.getPrefix(n2);
            if (string2 == this.fXmlnsSymbol || string == this.fXmlnsSymbol) {
                bl = true;
            } else {
                if (!bl2) {
                    this.printIndentTag("<attributes>");
                }
                boolean bl3 = xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI") != null;
                this.printIndentTag("<attribute>");
                this.printElement("namespaceName", xMLAttributes.getURI(n2));
                this.printElement("localName", xMLAttributes.getLocalName(n2));
                this.printElement("prefix", xMLAttributes.getPrefix(n2));
                this.printElement("normalizedValue", xMLAttributes.getValue(n2));
                if (!bl3) {
                    this.printElement("specified", String.valueOf(xMLAttributes.isSpecified(n2)));
                    this.printElement("attributeType", xMLAttributes.getType(n2));
                } else {
                    this.printElement("attributeType", null);
                }
                this.printElement("references", "");
                this.printPSVIAttribute(xMLAttributes.getAugmentations(n2));
                this.printUnIndentTag("</attribute>");
                bl2 = true;
            }
            ++n2;
        }
        if (bl2) {
            this.printUnIndentTag("</attributes>");
        } else {
            this.printTag("<attributes/>");
        }
        if (bl) {
            this.printNamespaceAttributes(xMLAttributes);
        } else {
            this.printTag("<namespaceAttributes/>");
        }
    }

    private void printNamespaceAttributes(XMLAttributes xMLAttributes) {
        int n = xMLAttributes.getLength();
        this.printIndentTag("<namespaceAttributes>");
        int n2 = 0;
        while (n2 < n) {
            String string = xMLAttributes.getLocalName(n2);
            String string2 = xMLAttributes.getPrefix(n2);
            if (string2 == this.fXmlnsSymbol || string == this.fXmlnsSymbol) {
                this.printIndentTag("<attribute>");
                this.printElement("namespaceName", XMLNS_URI);
                this.printElement("localName", string);
                this.printElement("prefix", string2);
                this.printElement("normalizedValue", xMLAttributes.getValue(n2));
                this.printElement("specified", String.valueOf(xMLAttributes.isSpecified(n2)));
                this.printElement("attributeType", xMLAttributes.getType(n2));
                this.printElement("references", "");
                this.printPSVIAttribute(xMLAttributes.getAugmentations(n2));
                this.printUnIndentTag("</attribute>");
            }
            ++n2;
        }
        this.printUnIndentTag("</namespaceAttributes>");
    }

    private void printInScopeNamespaces() {
        this.printIndentTag("<inScopeNamespaces>");
        this.printIndentTag("<namespace>");
        this.printElement("prefix", "xml");
        this.printElement("namespaceName", NamespaceContext.XML_URI);
        this.printUnIndentTag("</namespace>");
        Enumeration enumeration = this.fNamespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            this.printIndentTag("<namespace>");
            String string = (String)enumeration.nextElement();
            String string2 = this.fNamespaceContext.getURI(string);
            this.printElement("prefix", string);
            this.printElement("namespaceName", string2);
            this.printUnIndentTag("</namespace>");
        }
        this.printUnIndentTag("</inScopeNamespaces>");
    }

    private void checkForChildren() {
        if (!this._elementState.empty()) {
            ElementState elementState = (ElementState)this._elementState.peek();
            if (elementState.isEmpty) {
                this.printIndentTag("<children>");
                elementState.isEmpty = false;
            }
        } else {
            this.printIndentTag("<children>");
            this._elementState.push(new ElementState(false));
        }
    }

    class ElementState {
        public boolean isEmpty;
        XMLAttributes fAttributes;

        public ElementState(XMLAttributes xMLAttributes) {
            this.fAttributes = xMLAttributes;
            this.isEmpty = true;
        }

        public ElementState(boolean bl) {
            this.isEmpty = bl;
        }

        public XMLAttributes getAttributes() {
            return this.fAttributes;
        }

        public void isEmpty(boolean bl) {
            this.isEmpty = bl;
        }
    }
}

