/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.Counter;
import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GetElementsByTagName {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final String DEFAULT_ELEMENT_NAME = "*";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;

    public static void print(PrintWriter printWriter, Document document, String string, String string2) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return;
        }
        if (string2 == null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)nodeList.item(n2);
                GetElementsByTagName.print(printWriter, element, element.getAttributes());
                ++n2;
            }
        } else {
            int n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                Element element = (Element)nodeList.item(n3);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem(string2) != null) {
                    GetElementsByTagName.print(printWriter, element, namedNodeMap);
                }
                ++n3;
            }
        }
    }

    protected static void print(PrintWriter printWriter, Element element, NamedNodeMap namedNodeMap) {
        printWriter.print('<');
        printWriter.print(element.getNodeName());
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                printWriter.print(' ');
                printWriter.print(attr.getNodeName());
                printWriter.print("=\"");
                printWriter.print(GetElementsByTagName.normalize(attr.getNodeValue()));
                printWriter.print('\"');
                ++n2;
            }
        }
        printWriter.println('>');
        printWriter.flush();
    }

    protected static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            GetElementsByTagName.printUsage();
            System.exit(1);
        }
        var1_1 = new Counter();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = "*";
        var5_5 = null;
        var6_6 = true;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = 0;
        while (var10_10 < var0.length) {
            block38: {
                var11_11 = var0[var10_10];
                if (!var11_11.startsWith("-")) ** GOTO lbl-1000
                var12_12 = var11_11.substring(1);
                if (var12_12.equals("p")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var13_19 = var0[var10_10];
                    try {
                        var3_3 = (ParserWrapper)Class.forName((String)var13_19).newInstance();
                    }
                    catch (Exception var14_21) {
                        var3_3 = null;
                        System.err.println("error: Unable to instantiate parser (" + (String)var13_19 + ")");
                    }
                } else if (var12_12.equals("e")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -e option.");
                    }
                    var4_4 = var0[var10_10];
                } else if (var12_12.equals("a")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -a option.");
                    }
                    var5_5 = var0[var10_10];
                } else if (var12_12.equalsIgnoreCase("n")) {
                    var6_6 = var12_12.equals("n");
                } else if (var12_12.equalsIgnoreCase("v")) {
                    var7_7 = var12_12.equals("v");
                } else if (var12_12.equalsIgnoreCase("s")) {
                    var8_8 = var12_12.equals("s");
                } else if (var12_12.equalsIgnoreCase("f")) {
                    var9_9 = var12_12.equals("f");
                } else if (var12_12.equals("h")) {
                    GetElementsByTagName.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception var12_13) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block38;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var6_6);
                    }
                    catch (SAXException var12_14) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var7_7);
                    }
                    catch (SAXException var12_15) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var8_8);
                    }
                    catch (SAXException var12_16) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var9_9);
                    }
                    catch (SAXException var12_17) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var12_12 = var3_3.parse(var11_11);
                        GetElementsByTagName.print(var2_2, (Document)var12_12, var4_4, var5_5);
                    }
                    catch (SAXParseException var12_18) {
                    }
                    catch (Exception var13_20) {
                        System.err.println("error: Parse error occurred - " + var13_20.getMessage());
                        if (var13_20 instanceof SAXException) {
                            var13_19 = ((SAXException)var13_20).getException();
                        }
                        var13_19.printStackTrace(System.err);
                    }
                }
            }
            ++var10_10;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.GetElementsByTagName (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -e name  Specify element name for search.");
        System.err.println("  -a name  Specify attribute name for specified elements.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Element:    *");
        System.out.print("  Namespaces: ");
        System.err.println("on");
        System.out.print("  Validation: ");
        System.err.println("off");
        System.out.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
    }
}

