{-# OPTIONS_GHC -optc-D__HUGS__ #-}
{-# INCLUDE "HsUnix.h" #-}
{-# LINE 1 "Exts.hsc" #-}
{-# OPTIONS -fffi #-}
{-# LINE 2 "Exts.hsc" #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  System.Posix.Signals.Exts
-- Copyright   :  (c) The University of Glasgow 2002
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- Maintainer  :  libraries@haskell.org
-- Stability   :  provisional
-- Portability :  non-portable (requires POSIX, includes Linuxisms/BSDisms)
--
-- non-POSIX signal support commonly available
--
-----------------------------------------------------------------------------

{-# LINE 17 "Exts.hsc" #-}

module System.Posix.Signals.Exts (
  module System.Posix.Signals

{-# LINE 22 "Exts.hsc" #-}
  , infoEvent, sigINFO

{-# LINE 24 "Exts.hsc" #-}

{-# LINE 25 "Exts.hsc" #-}
  , windowChange, sigWINCH

{-# LINE 27 "Exts.hsc" #-}

  ) where

import Foreign.C ( CInt )
import System.Posix.Signals

{-# LINE 34 "Exts.hsc" #-}

{-# LINE 35 "Exts.hsc" #-}
sigINFO   = (29)   :: CInt
{-# LINE 36 "Exts.hsc" #-}

{-# LINE 37 "Exts.hsc" #-}

{-# LINE 38 "Exts.hsc" #-}
sigWINCH  = (28)  :: CInt
{-# LINE 39 "Exts.hsc" #-}

{-# LINE 40 "Exts.hsc" #-}

{-# LINE 48 "Exts.hsc" #-}

{-# LINE 50 "Exts.hsc" #-}
infoEvent :: Signal
infoEvent = sigINFO

{-# LINE 53 "Exts.hsc" #-}

{-# LINE 55 "Exts.hsc" #-}
windowChange :: Signal
windowChange = sigWINCH

{-# LINE 58 "Exts.hsc" #-}
